 %Basiert auf Skript-Vorlage; Berechnet Gau-Transformation mit Spalten-Pivot-Suche
 %Wachstumsfaktor-Berechnung wie in GaussTot, daher Kommentare von dort kopiert
 
function [ LU, p,wachs ] = GaussSP( A )
	%Hier wird das maximale Element der Ursprungsmatrix gespeichert zwecks Wachstumsfaktor
	w0=max(max(abs(A)));
	%maximale Element der Zwischenmatrizen auf Anfangswert 0. Wird pro m-schleife berprft/neu gesetzt (siehe unten)
	wm=0;
	n = length( A );
	p = [1:n];

	for m = 1:n
		% Suche Pivot

		piv = abs( A(m,m) ); 
		pivj = m;
		for j = m+1:n
			if abs( A(j,m) ) > piv
				piv = abs( A(j,m) );
				pivj = j;
			endif
		endfor
		% Vertausche

		j = p( m ); p( m ) = p( pivj ); p( pivj ) = j;
		x = A( m,: ); A( m,: ) = A( pivj,: ); A( pivj,: ) = x;

		% Eliminiere

		w = A( m,m+1:n );
		for j = m+1:n
			A( j,m ) = A( j,m ) / A( m,m ); 
			A( j,m+1:n ) = A( j,m+1:n ) - A( j,m ) * w;
		endfor

		wp=max(max(abs(A))); %Nach der Elimination betrachten wir wieder das maximale Element (Betrag) der Matrix zwecks Wachstumsfaktor
		if wp>wm %Ist das maximale Element dieser Matrix grer als alle bisherigen maximalen Elemente der Vorgngermatrizen...
			wm=wp; %wird dieses nun zwischengespeichert
		endif

	endfor
	wachs=wm/w0; %Wachstumsfaktor=maximales maximales Element (Betrag) aller Zwischenmatrizen in der Gau-Elimination / maximales Element (Betrag) Urspungsmatrix
	LU = A;
endfunction