﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Windows.Forms;
using System.Threading;

namespace Boersenlupe
{
    static class Program
    {
        static public Form[] f1 = new Form[3]; //aufgerufene Formen, damit alle Formen einander beeinflussen können (Windows-State, Bringtofront)
        public static bool aktfocussort = false; //wird gerade automatisch fokussiert?

        [STAThread]
        public static void bringtofront(Form activ) { 
            //bringt alle Formen in den Hintergrund, wenn eine Form ausgewählt wurde.
            //Die ausgewählte Form bleibt dabei Aktiv!
            if (Program.f1[0] == null || aktfocussort) return; //Formen noch nicht zugeteilt/Alle geladen oder wird gerade automatisch fokussiert?
            aktfocussort = true; //automatisches Fokussieren an!
            foreach (Form f in Program.f1) //Alle Formen nach forne!
                f.BringToFront();
             activ.BringToFront(); //aktuelle muss weiter nach forne (erste Stelle!) zum fokussieren!
             activ.Activate(); //Aktivieren (sonst wird aktuelles als nicht aktiv/anderes der 2 formen als aktiv angezeigt)
             aktfocussort = false; //automatisches Fokussieren aus!
        }
        static void Main()
        {
            Application.EnableVisualStyles(); //Standard-AnzeigeOptionen
            Application.SetCompatibleTextRenderingDefault(false);

            ShareEvaluation subject = new ShareEvaluation(); 
            //"Globale" ShareEvaluation-Objekt für Shares und Indices.
            //wird den Konstruktoren der Formen übergeben, damit diese Zugriff darauf haben
            if (subject.evaluate())
            { //Lade aktuelle Werte in subjekt, bei Verbindungsfehler, schließe

                ThreadStart t1 = new ThreadStart(subject.updatePeriodically); //Update-Thread, ruft alle update() der observer (3 Formen) alle 10s auf
                Thread thread1 = new Thread(t1);
                thread1.Start();

                TableView w1 = new TableView(subject); //Tabellenanzeige-Formular
                w1.registerUpdateThread(thread1); //Stelle den Thread zur Verfügung, um bei Ende der Form nicht 10s bis auf Ende der Anwendung warten zu müssen
                w1.Show(); //Anzeigen Tabellenanzeige-Formular

                ChartView c1 = new ChartView(subject);//Zeit-Diagramm (30 Tage)
                c1.registerUpdateThread(thread1);//s.o.
                c1.Show();//s.o.

                PieView p1 = new PieView(subject);//Torten-Diagramm (Share/Indices)
                p1.registerUpdateThread(thread1);//s.o.
                p1.Show();//s.o.

                f1[0] = w1; //Speicher die Formen in Array übergeordneten Typs zur gemeinsamen WindowState- und Fokus-Kontrolle
                f1[1] = c1;
                f1[2] = p1;

                //Zentrierung der 3 Formen nebeneinander auf dem Bildschirm
                p1.Left = Convert.ToInt16((Screen.PrimaryScreen.Bounds.Width - p1.Width - w1.Width - c1.Width - 20) / 2);
                //Linker ABstand zum Bildschirm ist halber Bildschirm - halbe Breite der Formen und Abstand dazwischen
                c1.Left = p1.Right + 10; //nebeneinander, 10px Abstand
                w1.Left = c1.Right + 10;
                int[] tops = { p1.Height, w1.Height, c1.Height }; //Vertikal Zentrieren
                int top = Convert.ToInt16((Screen.PrimaryScreen.Bounds.Height - tops.Max()) / 2);
                //Zentriert wird das höchste Formular, die anderen werden  mit oberer Kante bündig daneben gesetzt.
                p1.Top = top;
                c1.Top = top;
                w1.Top = top;

                Application.Run(); //START!
            }
        }
    }
}
