﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Data;
using System.Windows.Forms;

namespace Boersenlupe
{
    public class ShareEvaluation : AbstractShareEvaluation
    {
        Evaluation evaluation; //allgemeine evaluation-objekt für Share und Indices, wird hier gefüllt
        bool sharesSet; //Shares wurden bereits eingelesen?
        bool running; //updatePeriodically wird ausgeführt: aktualisiere alle "interval" ms die Shares!
        int interval; //Interval für updatePeriodically in ms.
        public int indiceCount; //Anzahl der Indizes für ShareEvaluation. => getIndice(int Index) lässt alle Indices laden
        public int shareCount; //Anzahl der Shares für ShareEvaluation. => getShareByIndex(int Index) lässt alle Shares laden
        public DataTable dt; //DataTable für Anzeige in datagridview
        List<List<Share>> ringbuffershar = new List<List<Share>>(); //Ringbuffer, siehe PushEvalToRing() für Größe/Verhalten
        SharesDatabase db; //Datenbank Klassenweit, um beim Update auch Veränderungen schreiben zu können.
        List<MonthShare> allmonths;//Daten von Allen Monaten, Liste fasst Shares, Array fasst Monate

        public ShareEvaluation() //Konstruktor: Standard-Werte
        {
            evaluation = new Evaluation();
            sharesSet = false;
            running = true;
            interval = 10000;
            indiceCount = 0;
            shareCount = 0;
        }

        public Share getShareByName(string name) //Durchsucht evaluation.shares nach angegebenen Namen (Case Sensitiv, bricht nach erstem Fund ab)
        {
            for (int i = 0; i < evaluation.shares.Count; i++)
            {
                if (evaluation.shares[i].name == name)
                {
                    return evaluation.shares[i];
                }
            }
            return null;
        }


        public Share getShareByID(int ID)//Durchsucht evaluation.id nach angegebene ID (bricht nach erstem Fund ab)
        {
            for (int i = 0; i < evaluation.shares.Count; i++)
            {
                if (evaluation.shares[i].id == ID)
                {
                    return evaluation.shares[i];
                }
            }
            return null;
        }
        public Index getIndice(int i){ //Gibt i-tes Element aus evaluation.indices zurück
            if (evaluation.indices.Count <= i) return null;
            return evaluation.indices[i];

        }
        public Share getShareByIndex(int index) //gibt index-tes Elemente aus evalutation.shares zurück
        {
            if (evaluation.shares.Count <= index) return null;
            return evaluation.shares[index];
        }
        public List<Share> getSharesByIIndex(int index) {  //Gibt alle MonthShare, die zu einem Index gehören, welcher an index-ter stelle in evaluation.indices ist, zurück
            string indstr=getIndice(index).name; //Name des Index an index-ter Stelle in evaluation.indices
            List<Share> aus=new List<Share>(); //Rückgabe-Liste gefundener Shares
            foreach (Share s in evaluation.shares) //Suche in Shares nach Index-Namen, bei Fund: Add zu RückgabeListe
                if (s.shareindex == indstr) aus.Add(s);
            return aus;
        }
        public List<MonthShare> getmonthsShares(int monthid) //Gibt alle Shares-Indizes zu einem Monat (ID, 0 bis 11)
        {
            if(monthid<0||monthid>11)return null; //Falsche MonatsID => Gebe Null zurück
            if (allmonths == null) getallmonths(); //Falls Monate noch nicht geladen: Lade Monate

            List<MonthShare> ruck = new List<MonthShare>(); //Rückgabeliste
            for (int i = 0; i < allmonths.Count; i++) { //getallmonths: MonthShare-Liste mit Monatsdaten => gehe jede MonthShare durch und hole den Monatswert
                ruck.Add(new MonthShare(allmonths[i].name, new float[] { allmonths[i].werte[monthid] },ruck.Count));
            }
            return ruck;
        }
        public float getMeanShare(int monthid) //DurchschnittsWert aller Shares im Monat
        {
            if (monthid < 0 || monthid > 11) return -1; //Falsche MonatsID => Gebe Null zurück
            if (allmonths == null) getallmonths(); //Falls Monate noch nicht geladen: Lade Monate

            float ruck = 0;
            for (int i = 0; i < allmonths.Count; i++) //Wie getmonthsShares, nur += statt Add()
            {
                ruck += allmonths[i].werte[monthid];
            }
            return (ruck / allmonths.Count); //Durchschnitt über allmonths.Count Shares
        }
        public float getMeanMonth(int shareid) //DurchschnittsWert aller Monate eines Shares
        {
            if (shareid < 0 || shareid > allmonths.Count-1) return -1; //Falsche ShareID => Gebe Null zurück
            if (allmonths == null) getallmonths(); //Falls Monate noch nicht geladen: Lade Monate

            float ruck = 0;
            for (int i = 0; i < 12; i++) //Wie getMeanShare, nur jetzt über Zeile Summieren, nicht Spalte in allmonths.
            {
                ruck += allmonths[shareid].werte[i];
            }
            return (ruck / 12); //Durchschnitt über 12 Monate
        }
        private void getallmonths() //Lädt Monatsdaten aus Datenbank in allmonths-Vairable
        { 
            db.open();
                allmonths = db.getMonthlyShares();
            db.close();
        }
        public bool evaluate() //aktualisiere evaluation 
        {
            try
            {
                db = new SharesDatabase(); //Datenbank-Verbindung
                if (db.open()) //Verbidnung öffnen/gültig?
                {
                    evaluation.shares = db.getAllShares(); //hole Alle Shares aus der Datenbank
                    db.close(); //Verbindung schließen
                    sharesSet = true; //evaluation.shares ist nun gesetzt.
                }
                else return false;
                if (sharesSet) computeIndices(); //Gibt es Shares, so können auch Indices berechnet werden.
                return true;
            }
            catch (Exception e) { //Datenbank-Probleme? eigentlich unnötigt, da Funktionen alle eigene try-catch haben.
                MessageOutput.show(e.Message); 
                MessageOutput.writeError(e.ToString());
                return false;
            }
        }
        private double[] multiplus(double[] d1, double[] d2, double weight) { //addiert gewichtet Double-Arrays Komponentenweise
            try
            {
                if (d1.Length != d2.Length) return new double[] { 0 };
                double[] dr = new double[d1.Length]; //neues Array, damit altes nicht überschrieben wird.
                for (int i = 0; i < d1.Length; i++)
                    dr[i] = d1[i] + d2[i] * weight; //Addiere Array1 mit Array2 * Gewicht => summierte Share-price*weight => Index
                return dr;
            }
            catch (Exception e) { //Falls Arrays unterschiedliche Dimenstion haben etc.
                MessageOutput.show(e.Message);
                MessageOutput.writeError(e.ToString());
                return null;
            }
        }
        private void computeIndices() //Berechne Indices-Punkte aus Shares in evaluation
        {
            try
            {
                List<string> indix = new List<string>(); //Namen der Indizes, IndexOf auch als Index der anderen benutzt. => Art von Dictionary mit 3 Listen als Wert und Name als Key
                List<double[]> pasts = new List<double[]>(); //letzten 30 Tage der Indices aus 30 Tagen der Shares
                List<double> indics = new List<double>(); //GesamtPunkte des Index
                List<double> unweight = new List<double>(); //ungewichtete Summe der Punkte der Shares für den Indices
                int curid = 0;
           
                for (int i = 0; i < evaluation.shares.Count; i++) //Alle Shares durchgehen
                {
                    curid = indix.IndexOf(evaluation.shares[i].shareindex); //Index bereits bekannt? Dann Indexof !=-1, sonst ==-1
                    if (curid != -1)
                    { //Index-Name bereits erfasst: entsprechende Einträge in Gesamt-Punkte, verg 30 t und ungewichtete Gesamt-Punkte addieren.
                        indics[curid] += evaluation.shares[i].price * evaluation.shares[i].indexweighting; //Gesamtpunkte
                        pasts[curid] = multiplus(pasts[curid], evaluation.shares[i].past30, evaluation.shares[i].indexweighting);//30t: addiere letzte 30 t Punkte der Share mit Gewicht zum bisherigen Ergebnis
                        unweight[curid] += evaluation.shares[i].price; //ungewichtete Punkte, für PieView (Tortendiagram)
                    }
                    else
                    {//Falls noch nicht vorhanden, füge hinzu ans Ende der Liste.
                        indix.Add(evaluation.shares[i].shareindex);
                        indics.Add(evaluation.shares[i].price * evaluation.shares[i].indexweighting);
                        pasts.Add(evaluation.shares[i].past30);
                        unweight.Add(evaluation.shares[i].price);
                    }
                
                }
                shareCount = evaluation.shares.Count; //Anzahl Shares, in Verbindung mit getShareById() sind alle Shares verfügbar.
                indiceCount = indics.Count(); //Anzahl Indices (getIndice(int id))

                evaluation.indices = new List<Index>(); //Fasse Ergebnisse zu Index-Objekten zusammen
                Index ind;
                for (int i = 0; i < indics.Count; i++) //Zusammenfassung der Eigenschaften in Index-Liste
                {
                    ind = new Index();
                    ind.name = indix[i];
                    ind.points = indics[i];
                    ind.past = pasts[i];
                    ind.unweightedPoints = unweight[i];
                    evaluation.indices.Add(ind);
                }
            }
            catch (Exception e) { //eigentlich unnötig hier, da keine Fehler an dieser Stelle auftreten sollten.
                MessageOutput.show(e.Message);
                MessageOutput.writeError(e.ToString());
            }
        }
        public void updatePeriodically() { //Update alle interval ms während running=true
            while (running)
            {
                evaluate(); //evaluation füllen
                PushEvalToRing(); //evaluation.shares in Ringbuffer schicken und letztes Element dort löschen
                broadcast(); //Alle Formen aktualisieren
                Thread.Sleep(interval); //"interval" ms warten
            }
        }
        public void stop() { //updatePeriodically stoppen
            running = false;
        }
        public void terminate() { //Alles abbrechen
            Application.Exit();
        }
        public void PushEvalToRing() //evaluation.shares in Ringbuffer schicken und letztes Element dort löschen
        {
            ringbuffershar.Add(evaluation.shares); //aktuelle shares ans Ende anfügen
            if (ringbuffershar.Count == 5) ringbuffershar.RemoveAt(0); //bei mehr als 5 Elementen im Ringbuffer 1. Löschen.
            //Ringbuffer nicht weiter benutzt als vorletztes Element für Veränderung in Dabelle Δprice.
            //Mögliche Ankopplung an Graph, jedoch nicht in Aufgabentabelle vorgesehen 
            //Anzahl beliebig erhöhbar (hier), Zeitunterschied zwischen shares in ringbuffer ist "interval"
        }
        public void update() { //Aktualisiere Datentabelle aus Datenbank für Datagridview in TableView
            DataTable table = new DataTable(); //Tabelle mit gewünschten Spalten. Format in TableView.Datagridview1-Eigenschaften festgelegt.
            table.Columns.Add("name", typeof(string));
            table.Columns.Add("branche", typeof(string));
            table.Columns.Add("kurs", typeof(double));
            table.Columns.Add("Δkurs", typeof(double));
            table.Columns.Add("indexgewicht", typeof(double));            
            table.Columns.Add("aktienindex", typeof(string));

            Share s;
            double delta=0;
            if (db.open()) //Öffne Datenbank für Schreibzugriff wenn Δprice!=0.
            {
                for (int i = 0; i < evaluation.shares.Count; i++) //Alle Shares durchsuchen
                {
                    s = evaluation.shares[i]; //aktuelles Share
                    if (ringbuffershar.Count > 1) delta = s.price - ringbuffershar[ringbuffershar.Count - 2][i].price;
                    //Gibt es einen vorherigen Wert für diesen Share? (da ringbuffer.Last()==evaluation, muss Count>1 und ringbuffer[count-2] benutzt werden)
                    if (delta != 0) db.writelastchange(i); //gibt es einen Unterschied zwischen letztem und aktuellen Wert, wird das aktuelle Datum und die Share-ID in die DB geschrieben
                    //Sollte später Index-spezifisch oder allgemein der letzte geforder sein, kann dies über "Select max(aktuell) from ..." geschehen.
                    table.Rows.Add(s.name, s.sector, s.price, Math.Round(delta,2), s.indexweighting, s.shareindex); //Datensatz an Tabelle anfügen
                }
                this.dt = table; //Tabelle verfügbar machen
                db.close(); //Datenbank schließen
            }

            getallmonths();//Updatete Monatliche Statistik
        }
    }
}
