﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Npgsql;
using System.Data;


namespace Boersenlupe
{
    class SharesDatabase
    {
        string connection_string; //Connectionstring stellt Authentifizierung zur Datenbank zur Verfügung
        NpgsqlConnection conn; //Datenbankdverbindung zu einer postgres-Datenbank

        public SharesDatabase()
        {
            //*###### ###### ###### ###### ###### ###### ###### ###### ######* 
            //###### Bitte wieder anpassen: localhost zu 134.176.28.79! ###### 
            //*###### ###### ###### ###### ###### ###### ###### ###### ######* 


            connection_string = "Server=134.176.28.79; Port=5432;" +
                        "User Id=student1; Password=1qay2wsx; Database=postgres;";
            //connection_string = "Server=localhost; Port=5432;" +
             //          "User Id=student1; Password=1qay2wsx; Database=postgres;";
        }
        
        public bool open() //Öffne eine Verbindung zur Datenbank
        {
            try
            {
                conn = new NpgsqlConnection(connection_string);
                conn.Open(); //Öffne eine Verbindung zur Postgres-Datenbank mit connectionstring (siehe Konstruktor)

                if (conn.State == System.Data.ConnectionState.Open) //Nach öffnen offen? Ja => Öffnen erfolgreich
                {
                    return true;
                }
                else return false; //Nein => Öffnen fehlgeschlagen

            }
            catch(Exception e) //Fehler: Verbindung schon offen? Connectionstring fehlerhaft? Server unerreichbar?
            {
                MessageOutput.show(e.Message);
                MessageOutput.writeError(e.ToString()); //Schreibe Fehler in Protokoll!
                return false;
            }
        }

        public void writelastchange(int id) { //Letzte Änderung einer Share (id) in Datenbank schreiben

            //Anzahl der Zeilen für letzte Änderung zu dieser ID: 0 oder 1.
            NpgsqlCommand com = new NpgsqlCommand("select Count(*) from student1.lastakt where id=" + Convert.ToString(id), conn);
            
            try //Falls Tabelle nciht existiert, gibt es Fehler bei ExecuteScalar
            {               
                if(Convert.ToInt16(com.ExecuteScalar())==1) //Es gibt bereits einen Eintrag? Überschreibte entsprechenden Timestamp mit Update.
                    com = new NpgsqlCommand("Update student1.lastakt set aktuell='" + DateTime.Now.ToString("yyyy-MM-dd hh:mm:ss") + "' where id=" + Convert.ToString(id), conn);
                    //Setze aktuell für letzte Änderung auf aktuellen Zeitwert wo id=id (dieses Share)
                else //Es gab noch keine Änderungen: Update ergäbe Fehler => Insert Into
                    com = new NpgsqlCommand("Insert Into student1.lastakt (id,aktuell) values (" + Convert.ToString(id) + ",'" + DateTime.Now.ToString("yyyy-MM-dd hh:mm:ss") + "')", conn);
                
                com.ExecuteNonQuery();//Führe Befehl für Datenbank aus. Anzahl betroffene Zeilen egal                
            }
            catch (Exception e) //Fehler evtl. fehlende Tabelle?
            {
                try
                {
                    //Erzeuge Tabelle mit id für Share und aktuell als timestamp mit letzter Änderung
                    com = new NpgsqlCommand("Create Table student1.lastakt (id integer PRIMARY KEY,aktuell timestamp  NOT NULL)", conn);
                    com.ExecuteNonQuery();
                    writelastchange(id); //Kein Fehler bis hier: Datenbank/Tabelle existiert, Verbindung steht, also neuer Versuch.
                }
                catch (Exception es) { //Fehler bei fehlendem Schema oder Verbindung? offene Fehler?
                    MessageOutput.show(e.Message); //Messagebox, ursprünglicher Fehler, da es nicht an fehlender Datenbank lag
                    MessageOutput.writeError(e.ToString()); //Report-Datei.                
                }

            }

        }
        public List<MonthShare> getMonthlyShares() {
            List<MonthShare> ruck=new List<MonthShare>();

            NpgsqlCommand com = new NpgsqlCommand("select s.name,j.januar,j.februar,j.maerz,j.april,j.mai,j.juni,j.juli,j.august,j.september,j.oktober,j.november,j.dezember,j.id from student1.jahtesschnitt as j, student1.stammdaten as s where s.id=j.id Order by s.id;", conn);
            NpgsqlDataReader red=com.ExecuteReader();
            while(red.Read()){
                ruck.Add(new MonthShare(red.GetString(0),new float[] { red.GetFloat(1), red.GetFloat(2), red.GetFloat(3), red.GetFloat(4), red.GetFloat(5), red.GetFloat(6), red.GetFloat(7), red.GetFloat(8), red.GetFloat(9), red.GetFloat(10), red.GetFloat(11), red.GetFloat(12) },red.GetInt32(13)));
            }
            return ruck;
            
        }
        public List<Share> getAllShares() //Gibt alle Shares aus der Datenbank, Tabelle Stammdaten als Share-Liste zurück
        {
            DataSet ds = new DataSet();  //Dataset als Verbdingung von Table tu Datenbank
            DataTable dt = new DataTable(); //Tabelle zur Anzeige im datagridview der Datenbank

            List<Share> shares = new List<Share>(); //Rückgabe-Objekt
            //Anzahl der Shares muss für dynamische Listen nicht bekannt sein. Listen sind auch schneller als Arrays.

            try
            {
                //Hole alle gewünschten Daten aus "stammdaten". Für den Graph auch entsprechende Daten aus "dreissigtagedurchschnitt" über id=id-Inner join
                string sql = "select s.name,s.branche,s.kurs,s.indexgewicht,s.aktienindex,d.* from student1.stammdaten as s inner join student1.dreissigtagedurchschnitt as d on s.id=d.id Order by s.id;";

                NpgsqlDataAdapter da = new NpgsqlDataAdapter(sql, conn); //Hole daten in dataset => datatable
                da.Fill(ds);
                dt = ds.Tables[0];

                Share s;
                foreach (DataRow row in dt.Rows) //Fülle Datensätze (Zeilen) aus DataTable in Share-Liste um.
                {
                    s = new Share(); //Initialisierung neues Share
                    s.id = Convert.ToInt32(row["id"]); //Übertragung der Daten aus Datensatz in Share-Objekt
                    s.name = row["name"].ToString();
                    s.sector = row["branche"].ToString();
                    s.price = Convert.ToDouble(row["kurs"]);
                    s.indexweighting = Convert.ToDouble(row["indexgewicht"]);
                    s.shareindex = row["aktienindex"].ToString();

                    s.past30 = new double[30]; //Übertragung der letzten 30Tage-price-Werte in double-Array
                    for (int j = 0; j < 30; j++)
                        s.past30[j] = Convert.ToDouble(row["wert" + (j + 1)]);

                    shares.Add(s); //Anhängen Share in Liste
                }

                return shares; //Rückgabe Share-Liste
            }
            catch (Exception e) {//etwaige Fehler, Verbindung/Datenbank/Schema?
                MessageOutput.show(e.Message); //MessageBox anzeigen
                MessageOutput.writeError(e.ToString()); //report
                return null;
            }
        }

        public bool close() //Datenbankverbindung schließen.
        {
            conn.Close();
            return true;
        }
    }
}
