﻿
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Windows.Forms;
using System.Threading;

using System.Runtime.InteropServices;


namespace Client_Server_Chat
{
    public partial class Form1 : Form
    {
        //Ganz viele Delegaten, da aus Client/Server aufgerufen und getrennte Threads benutzt werden.
        //Ein Delegat für je ein Rückgabetyp/Parameter-paar einer Funktion.
        //Für Erklärung siehe Programm.cs
        public delegate bool start(String local);
        public start startServer;
        public delegate void stop();
        public Form1.stop stopServer;

        public delegate void cstop();
        public Form1.cstop stopClient;

        public delegate void rgame();
        public Form1.rgame requestgame;
        public Form1.rgame ziehekarte;
        public Form1.rgame aufgeben;

        public delegate void resgame(bool conf);
        public Form1.resgame responsegame;

        public delegate void legekart(int index);
        public Form1.legekart legekarte;

        public delegate bool cstart(String local, String name);
        public cstart startClient;
        
        public delegate void dSend(string message);
        public Form1.dSend send;
        
        //delegaten benutzt in Invokes.
        public delegate void setText(string s);
        public delegate void setconf();
        public delegate void setlist(string[] mes);
        public delegate void kartenvi(string[] karten, string[] fremdkartenanz, string aktkart, string aktplayer);
        public delegate void initvi();

        String local,cName; //local ist IP, cName angegebener Benutzername (ClientName)
        bool stopper = false;   //Beim Beenden laufen noch einige Prozesse: stopper stoppt die meisten Invokes ab, bevor Fehler wegen zerstörter Objekte kommen
        bool textautoscroll = true; //soll das textfeld mitscrollen?
        List<string> aktplayers = new List<string>(); //Liste aktueller Maumau-Spieler

        public Form1()
        {
            InitializeComponent();
            local = "127.0.0.1"; //Standard: localhost
        }

        private void button1_Click(object sender, EventArgs e) //verbinden!
        {
            //Benutzername auswählen und Oberfläche setzen.
            cName = textBox4.Text;
            stopper = false;
            if (cName == "") { showMessage("Benutzername erforderlich!" + Convert.ToChar(13) + Convert.ToChar(10)); return; }
            panel1.Visible = false;
            panel2.Enabled = true;
            this.Text = cName +": "+ local;
          new Thread(new ThreadStart(clientstart)).Start(); //Hier starten Client/Server!
        }
        public void clientstart(){// bzw. hier starten Client/Server!
            if (stopper) return; //Beenden der Form sollte irgendwann zu beenden der Anwendung führen, auch mit zusätzlichen Threads.
            if (!startClient(local, cName)) //Starte den Clienten! geht nicht? dann ist wohl kein Server da!
                //Localhost lässt nur interne Anfragen von Clients zu, benutzt man eine andere Adresse, alle. zu beachten: ein Click auf die andere Radiobox gibt die eigene IP zurück, die ebenfalls beliebige IPs zulässt!
                if (MessageBox.Show("Kein Server gefunden, Server starten?\n Akzeptierte Anfragen von Localhost->Localhost, Andere-> beliebige IP", "kein Server gefunden", MessageBoxButtons.YesNo, MessageBoxIcon.Question) == DialogResult.Yes)
                {
                    if (startServer((local == "127.0.0.1" ? local : "0.0.0.0"))) //Starte Server! Bei Erfolg: Client, für die Anzeige und um selbst zu reden/schreiben
                        startClient("127.0.0.1", cName);
                    else
                        initview();//geht der Server nicht, liegt ein anderes Problem vor (Statustext beachten!)
                }
                else {//kein Client, kein Server... dann halt nicht.
                    initview();
                }
        }

        //user32.dll gibt Möglichkeiten zur Kontrolle des Scrollbalkens einer Textbox
        [DllImport("user32.dll")]
        static extern int SetScrollPos(IntPtr hWnd, Orientation nBar, int nPos, bool bRedraw);
        [DllImport("user32.dll")]
        static extern int GetScrollPos(IntPtr hWnd, Orientation nBar);


        public void showMessage(string message) //Zeige Nachricht an!
        {
            if (textBox2.InvokeRequired) //Aufruf aus anderem Thread: client/server
            { //Dieser Teil wiederholt sich später häufig, daher wird er nur hier beschrieben
                if (stopper) return; //Programm ist bereits am beenden/Verbindungen am trennen
                setText setter = showMessage;
                try{
                this.Invoke(setter, new object[] { message });}
                catch (Exception e) { }//Programm hat gerade jetzt (nach stopper) "this" zerstört: Fehler beim Beenden: egal
            }
            else
            {
                try
                {
                    if (textautoscroll)//Autoscroll: Standard bei AppendText! (benutzt übrigens Stringbuilder, was schneller ist als Text+=.
                        textBox2.AppendText(message);
                    else
                    {//kein Autoscroll: wie? appendtext geht runter, += geht hoch!
                        //Lösung: GetScrollpos (vertikal) merken 
                        int textpos = GetScrollPos(textBox2.Handle, Orientation.Vertical);
                        textBox2.AppendText(message); //ergönze Meldung, text scrollt nach unten
                        textBox2.SelectionStart = 0; //Selectionstart wird nun in die Zeile gelegt, in die vorher gescrollt war (oberste)
                        for (int i = 0; i < textpos; i++)
                            textBox2.SelectionStart += textBox2.Lines[i].Length + 2; //carriage return und line feed=2 pro zeile
                        textBox2.SelectionLength = 0;
                        textBox2.ScrollToCaret(); //Scrolle an "alte" position! (setscroll funktioniert nicht so zuverlässig.
                    }
                }
                catch (ObjectDisposedException e) {//beende Form während Rückfrage nach neuem Server zerstört textbox2 beim scrollen, also geht's wieder um's beenden:
                    stopClient(); //stoppt Clienten ;)
                    stopServer();   //Stoppt server, führt gleichzeitig noch eine neue Clientenanfrage an den Server aus, damit dieser aufhört zu warten.
                }
            }
        }
        //aktualisiert Maumau
        public void kartenliste(string[] karten, string[] fremdkartenanz, string aktkart, string aktplayer) {
            if (listBox1.InvokeRequired)
            {
                if (stopper) return;
                kartenvi init = kartenliste;
                try{
                    this.Invoke(init, new object[] { karten, fremdkartenanz, aktkart, aktplayer });
                }
                catch (Exception e) { }
            }
            else
            {
                if (cName == aktplayer) listBox1.Enabled = true; else listBox1.Enabled = false; //Nur Karten legen, wenn dran! wird vom Server nochmal überprüft
                this.Height = 600;  //Setze Maumau sichtbar
                listBox1.Items.Clear(); //Karten leeren
                listBox2.Items.Clear(); //Spieler leeren
                listBox1.Items.AddRange(karten); //neue übermittelte Karten laden (wird bei allen veränderungen komplett neu gesendet)
                for (int i = 0; i < aktplayers.Count; i++) //Spieler neu Laden (mit Kartenanzahl)
                    listBox2.Items.Add(aktplayers[i] + " - " + fremdkartenanz[i]);
                label7.Text = aktkart;//aktuelle karte
                listBox2.SelectedIndex = aktplayers.IndexOf(aktplayer); //aktueller Spieler markiert
               
            }
        }
        public void playerdran() { //du bist dran!
            if (panel1.InvokeRequired)
            {
                if (stopper) return;
                initvi init = playerdran;
                try
                {
                    this.Invoke(init);
                }
                catch (Exception e) { }
            }
            else
            {
                listBox1.Enabled = true; //Karten legen ermöglichen (doppelklick)
            
            }
        }
        public void initview() //Anfangsanzeige: löst auch Verbindungen!
        {
            if (panel1.InvokeRequired)
            {
                if (stopper) return;
                initvi init = initview;
                try{
                this.Invoke(init);}
                catch (Exception e) { }
            }
            else
            {
                panel1.Visible = true; //Name/Server-auswahl
                stopper = true; //alles aufhören!
                stopClient(); //Verbindungen lösen
                stopServer();
                panel2.Enabled = false;
                this.Height = 415; //Maumau verstecken
            }
        }
        public void showState(string message) //Statusmelsungen
        {

            if (textBox2.InvokeRequired)
            {
                if (stopper) return;
                // setState setter = showState;
                setText setter = showState;
                try
                {
                    this.Invoke(setter, new object[] { message });
                }
                catch (Exception e) { }
            }
            else
            {
                label3.Text = message; //Meldung anzeigen
            }
        }

        private void Form1_Load(object sender, EventArgs e)
        {

        }


        private void radioButton1_CheckedChanged(object sender, EventArgs e)
        {
            textBox1.Enabled = false; //Localhost!
            local = "127.0.0.1";
        }

        private void radioButton2_CheckedChanged(object sender, EventArgs e)
        {
            textBox1.Enabled = true;

            //Hostname/IP4 ermitteln. Ist angeblich veraltet, Alternative gibt aber IP6 und die ist hässlicher
            string HostName = System.Net.Dns.GetHostName();
            System.Net.IPHostEntry hostInfo = System.Net.Dns.GetHostByName(HostName);
            string IpAdresse = hostInfo.AddressList[0].ToString();
            textBox1.Text = IpAdresse;

            local = textBox1.Text;//Anzeige und EInstellungsübernahme
        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {
            local = textBox1.Text; //IP-Eingabe übernehmen
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            initview(); //Alles stopp und beenden            
        }

        private void button2_Click(object sender, EventArgs e)
        {
            //Text mit Namen und Tab und Absatz senden
            send(textBox4.Text + ":" + Convert.ToChar(9) + textBox3.Text + Convert.ToChar(13) + Convert.ToChar(10));
        }

        private void checkBox1_CheckedChanged(object sender, EventArgs e)
        {
            textautoscroll = checkBox1.Checked; //text mitscrollen
        }

        private void linkLabel1_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            initview();  //"Verbindung trennen"
        }

        private void linkLabel2_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            requestgame(); //"Maumau?"
        }

        public void conf(string message) {

            if (panel3.InvokeRequired)
            {
                if (stopper) return;
                setText setter = conf;
                try{
                    this.Invoke(setter, new object[] { message });
                }
                catch (Exception e) { }
            }
            else
            {
                label8.Text = message; //Aktiviert Popup zur auswahl mit variablen text
                panel3.Visible = true; 
            }
        }
        public void confdis() {
            if (panel3.InvokeRequired)
            {
                if (stopper) return;
                setconf setter = confdis;
                try{
                   this.Invoke(setter);
                }
                catch (Exception e) { }
            }
            else
            {
                panel3.Visible = false; //Aktiviert Popup wegen Maumau
            } 
        }
        public void spielerliste(string[] mes) { //Aktualisiert spielerliste
            if (listBox2.InvokeRequired)
            {
                if (stopper) return; 
                setlist setter = spielerliste;
                try{
                     this.Invoke(setter, new object[] { mes });
                 }catch (Exception e) {
                 }
            }
            else
            {
                if (mes == null) //mes=null bedeutet Spielende (Maumau), die nachfolgende Nummer gibt aufschluss ob Sieg, Niederlage oder Unentschieden (siehe client)
                {
                    listBox1.Enabled = false;
                    this.Height = 415;// maumau verstecken
                }
                else
                {
                    aktplayers = new List<string>(); //neue Liste für aktuelle Spieler
                    aktplayers.AddRange(mes); //übermittelte Liste übertragen
                    listBox2.Items.Clear();
                    listBox2.Items.AddRange(mes); //Liste anzeigen
                    panel3.Visible = false; //popup für Maumau verbergen
                }
            } 
        }
        private void button3_Click(object sender, EventArgs e)
        {
            responsegame(true); //Maumau spielen!
            panel3.Visible = false; //popup für Maumau verbergen
        }

        private void button4_Click(object sender, EventArgs e)
        {
            responsegame(false);// kein maumau -,-'
            panel3.Visible = false; //popup für Maumau verbergen
        }

        private void listBox1_DoubleClick(object sender, EventArgs e)
        {
            if (listBox1.SelectedIndex == -1) return; //EIne Karte legen... KEIN Invoke nötig! wird nur vom Spieler aufgerufen!
            legekarte(listBox1.SelectedIndex); //... lege Karte... Index wird übermittelt und vom Server Anhand der Hand in eine Karte umgewandelt
            listBox1.Enabled = false; //nur eine Eingabe bitte! Server prüft ebenfalls gegen.
        }

        private void linkLabel3_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            ziehekarte(); //Karte ziehen.
            listBox1.Enabled = false; //nur eine Eingabe bitte! Server prüft ebenfalls gegen.
        }

        private void linkLabel4_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            aufgeben(); //Spiel aufgeben, "verlieren", die übrigen spielen weiter
            listBox1.Enabled = false;
            this.Height = 415;//Maumau verbergen
        }
    }
}
