﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Client_Server_Chat
{
    public class Karten 
        //Klasse beschreibt sowohl Stapel von dem gezogen wird, als auch die Spielerhände
        //Benutzung der Klasse ist zweckdienlich, aber nicht idiotensicher: einige Funktionen sind nur beim Stapel sinnvoll, andere bei Händen.
    {
        readonly static string[] KWerte = { "7", "8", "9", "10", "Bube", "Dame", "König", "Ass" }; //Angezeigte Bezeichnungen
        readonly static string[] KFarben = { "Herz", "Pik", "Karo", "Kreuz" };
        public struct Karte {   //Typ einer Karte         
            public int wert;
            public int farbe;

            public Karte(int wert, int farbe) //direkter Konstruktor für Typ
            {
                this.wert = wert;
                this.farbe = farbe;
            }
            public Karte(string wert, string farbe) //indirekter Konstruktor über Bezeichnungsnamen
            {
                this.wert = Array.IndexOf(KWerte, wert);
                this.farbe = Array.IndexOf(KFarben, farbe);
            }
            public override string ToString(){  //überschreibt ToString(), um Ergebnisse wie "Herz Dame" statt "[struct Karte]" zu erhalten
                return KFarben[this.farbe] + " " + KWerte[this.wert]; //in Bezeichnern oben nach index den Namen zusammenführen
            }
            public bool match(int wert, int farbe) //passt die angegebene Karte auf die aktuelle?
            {
                return (wert == this.wert || farbe == this.farbe || wert == 4); //passt wenn Farbe oder Wert gleich, oder Bube (Regel: Bube passt auf alles und überschreibt Farbe mit Kartenfarbe)
            }
            public bool match(Karte kart) //nochmal match mit einfacheren Aufruf
            {
                return (kart.wert == this.wert || kart.farbe == this.farbe || kart.wert==4);
            }
            public Karte parse(string kart) { //parset mit Punkt getrennte Werte (integer) in Karte. Wurde zeitweise beim austeilen der Karten gemacht.
                return new Karte(Convert.ToInt32(kart.Split('.')[0]), Convert.ToInt32(kart.Split('.')[1]));
            }
            public static bool operator ==(Karte kart, Karte kart2) //Vergleichsoperator: Farbe und Wert "UND" vergleichen
            {
                return kart.wert == kart2.wert && kart.farbe == kart2.farbe;
            }
            public static bool operator !=(Karte kart, Karte kart2) //Compiler: für == muss auch != existieren!
            {
                return kart.wert != kart2.wert || kart.farbe != kart2.farbe;
            }
        }
        private List<Karte> verfuegbarkarts; //Stapel: Alle Karten, die aktuell ziehbar (also weder aktuell, noch auf einer Hand) sind.
                                                //Hand: nicht besetzt;
        private List<Karte> belegtekarts;   //Stapel: Alle nicht verfügbaren Karten
                                                //Hand: aktuelle Hand
        private Random Rnd = new Random();  //Random für Karten-ziehen, wird später mit millisekunde gekoppelt

        public bool zweiziehen; //muss der nächste Spieler 2 Karten ziehen? (aktkarte.wert=0 ist nicht gleichbedeutend!)
        public int Anzahl;      //Anzahl der Karten des Stapels oder der Hand
        public Karte aktkart;   //Stapel: aktuell liegende Karte
        public string aktspielername; //Wird hier gespeichert, da im Server Kartenobjekt synchronisiert wird.
        
        public Karten(bool Stapel)  //Konstruktor: hand oder stapel?
        {
            for (int i = 0; i < new DateTime().Millisecond; i++) //koppel Zufall an Millisekunde
                Rnd.Next();
            verfuegbarkarts = new List<Karte>();
            belegtekarts = new List<Karte>();
            Anzahl=0;
            if(Stapel){ //Dies ist der Stapel: 32 Karten verfügbar machen
                for (int i = 0; i < 4; i++) {
                    for (int j = 0; j < 8; j++) {
                        verfuegbarkarts.Add(new Karte(j, i));
                    }
                }
                Anzahl=32;
                aktkart = ziehen(); //eine der 32 karten ziehen.
            }//Als Spieler: nur leere Listen
        }
        public Karte ElementAt(int id) { //Als Hand: Karte an Index in Hand
            if (id < 0 || id > belegtekarts.Count - 1) return new Karte(-1,-1); //Falls etwas schief läuft oder bei mogeln
            return belegtekarts[id];

        }
        public bool austeilen(Karte kart)//Als hand: Karte wird and hand ausgeteilt (meist in verbindung mit ziehen())  
        {  
            if (belegtekarts.Contains(kart)) return false; //Karte schon in Hand? Doppelt! (Client-Betrug)
            belegtekarts.Add(kart);
            Anzahl++; //erhöhe Anzahl
            return true;    //true falls hinzufügen erfolgreich
        }
        public bool legen(Karte kart)//Als hand: Hand legt Karte ab (Karte wird von Benutzer gewählt, meist in Verbindung mit ablegen(Karte)  
        {  
            if (!belegtekarts.Contains(kart)) return false; //Karte existiert nicht in Hand? Betrug!
            belegtekarts.Remove(kart);
            Anzahl--; //Anzahl anpassen
            return true;
        }
        public String getallkarts() //Alle karten aus hand als String ausgeben. Wird an nur die Clients der jeweiligen Hand geschickt. Die Anzahl kommt hingegen an alle Clienten
        { 
            string ruck = ""; //Rückgabestring
            if (Anzahl == 0) return ""; //keine Karten
            for (int i = 0; i < Anzahl; i++)
                ruck += Convert.ToChar(2)+belegtekarts[i].ToString(); //Trenne Karten mit chr(2) für späteres splitten
            return ruck.Substring(1); //führendes chr(2) entfernen
        }

        public Karte ziehen() //als stapel: ziehe eine Karte!
        {
            if (verfuegbarkarts.Count == 0) return new Karte(-1,-1); //Keine Karten mehr! => Spielende, Unentschieden^^
            int RndNr1 = Rnd.Next(0,verfuegbarkarts.Count-1); //Zufällige Karte aus den verfügbaren ziehen
            belegtekarts.Add(verfuegbarkarts[RndNr1]);  //Karte nicht mehr verfügbar
            verfuegbarkarts.RemoveAt(RndNr1);   // "
            Anzahl--; //Anzahl verfügbarer Karten anpassen
            return belegtekarts.Last(); //Add fügt ans Ende ein, also: Last() ist unsere.
        }
        public bool ablegen(Karte kart)  //Lege auf den ablagestapel (vorherige Karte wird wieder untergemischt!)
        {
            if (belegtekarts.Count == 0 || verfuegbarkarts.Contains(kart)|| aktkart==kart) return false; //Fehlen keine Karten, ist die Karte doppelt. oder ist sie schon verfügbar? in beiden Fällen Betrug.
            verfuegbarkarts.Add(aktkart); //vorherige aktuelle wird frei!
            belegtekarts.Remove(aktkart);
            aktkart = kart; //abgelegte Karte ist aktuelle!
            Anzahl++;   //Anzahl anpassen!
            return true; //Archievement: erfolgreich eine Karte abgelegt!
        }
    }
}
