﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Boersenlupe
{
    public class AbstractShareEvaluation
    {
        List<AbstractObserver> observers; //Liste der "Beobachter" (Formulare) der Datenbank

        public AbstractShareEvaluation()
        {
            observers = new List<AbstractObserver>();
        }

        public void register(AbstractObserver observer)
        {
            observers.Add(observer);
        }

        public void unregister(AbstractObserver observer) //unbenutzt, da observer konst., logische Ergänzung zu register
        {
            observers.Remove(observer);
        }

        public void broadcast()
        {
            try
            {
                foreach (AbstractObserver o in observers) //Update in allen "Beobachtern" (Formularen) der Datenbank
                {
                    o.update();
                }
            }catch(InvalidOperationException e){
                broadcast();
                //Wenn Schleife ausgeführt wird, während ein weiterer Observer dazu kommt, gibt es diesen Fehler. 
                //Kein Grund zum Report-> Schleife nochmal ausführen.
            }
        }
    }
}
