﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Threading;

namespace Boersenlupe
{
    public partial class ChartView : AbstractObserver //Diagramm-Anzeige
    {
        ShareEvaluation evaluation; //algemeines evaluation-objekt für Shares und Indices
        Thread t1; //UpdateThread: kann nun bei FormCLose direkt geschlossen werden, statt interval zu warten
        Form thisform; //Thisform für Graphis von Diagramm
        bool modusShare = true; //Shares anzeigen?
        int modusindex = 0; //Welcher Share/Index?

        public ChartView(ShareEvaluation evaluation) //Konstruktor
        {
            this.evaluation = evaluation; //hole globales evaluation zur hiesigen Verwendung
            evaluation.register(this); //Registriere das Formular zur Manipulation aus anderen Klassen
            InitializeComponent(); //Standard: Member&Events zuweisen
        }
        public void registerUpdateThread(Thread thread)
        {
            t1 = thread; //hole update-Thread zum beenden, falls FormClose
        }

        public void zeichnen() { //Zeichne Diagramm, hier zur Abwechslung als prozedur statt direkt innerhalb update()
            if (thisform == null) return; //Aufruf bevor Form geladen? Abbruch!
            Graphics g = thisform.CreateGraphics(); //Graphics zum Zeichnen direkt auf Form
            int width = 400; //Abmaße
            int height = 200;
            int offsety = 50;
            thisform.Width = width + 30;
            g.Clear(SystemColors.Control);//Lösche bisheriges Diagram
            g.DrawLine(new Pen(new SolidBrush(Color.Black)), 10, height + offsety, width + 10, height + offsety); //horiz. Achse
            g.DrawLine(new Pen(new SolidBrush(Color.Black)), 10, offsety, 10, height + offsety);//Vert. Achse
            Font nfont = new Font(FontFamily.GenericSansSerif, 12); //Schriftart Überschrift & oberster Wert
            Font nfont1 = new Font(FontFamily.GenericSansSerif, 6); //Schirftart Achsenbeschriftung
            double[] past={}; //einzutragende Werte
            if (modusShare){ //Shares?
                past= evaluation.getShareByIndex(modusindex).past30; //letzten 30 price/werte der ausgewählten Share eintragen!
            }else{ //Indices!
                past = evaluation.getIndice(modusindex).past;//letzten 30 Punkte des ausgewählten Index eintragen!
            }                
            double max = past.Max(); //Max zum Anpassen des Diagramms (obere Kannte)
            double min = past.Min(); //Min  "     "      "      "     (untere Kante)

            g.DrawString(toolStripComboBox1.Text, nfont, new SolidBrush(Color.DarkBlue), 100, offsety-20); //Schreibe Überschrift
            for (int i = 0; i < 10; i++)//Zeichnen der horizontalen Gitternetzlinien und y-Beschriftung
            {
                g.DrawLine(new Pen(new SolidBrush(Color.LightGray)), 10, offsety + height / 10 * i, width + 10, offsety + height / 10 * i);
                g.DrawString(Convert.ToString(Math.Round(min+(max-min) / 10.0 * i, 3)), nfont1, new SolidBrush(Color.Black), 10, offsety + height / 10 * (10 - i));
                //min+(max-min)/10.0*i , i=0->10 ergibt gleichmäßige Einteilung zwischen in und Max in 10 Teile (11 Linien). 
            }
            g.DrawString(Convert.ToString(Math.Round(max, 3)), nfont, new SolidBrush(Color.DarkBlue), 0, offsety - 20);//Schreibe größten Wert für oberste Linie oben and den Graphen
            
            for (int i = 1; i < 30; i++) //Zeichne Diagramm-"Kurve"
            {
                //30 Punkte ergibt 29 Striche
                //Zeichne vertikale Gitternetzlinien
                g.DrawLine(new Pen(new SolidBrush(Color.LightGray)), Convert.ToInt16(10 + width / 29.0 * i), height + offsety+5, Convert.ToInt16(10 + width / 29.0 * i), offsety);
                //Schreibe x-Achsen-Beschriftung, x=...-3px damit Zahl unter Strich steht, y=8+... für 8px unterhalb des Diagramms
                g.DrawString(Convert.ToString(i), nfont1, new SolidBrush(Color.Black), Convert.ToInt16(10 + width / 29.0 * i)-3,8+ offsety + height);
                //Zeichne Linie, x-Koord skaliert für 29 gleichmäßige Striche auf "width"
                    // y-Koord skaliert auf min bis max:
                        //offsety+height: Ursprung y-Achse: unten
                        //-height/(max-min)*(past[i - 1]-min): Anteil an height: (punkte-min)/(max-min) ergibt lineare Gewichtung mit Punkte von 0 bis 1 von punkte=min bis punkte=max. => lin. Abbildung gleichmäßig auf height.
                g.DrawLine(new Pen(new SolidBrush(Color.Red)), 10 + Convert.ToInt16(width / 29.0 * (i - 1)), Convert.ToInt16(offsety + height - height / (max-min) * (past[i - 1]-min)), 10 + Convert.ToInt16(width / 29.0 * (i)), Convert.ToInt16(offsety + height - height / (max-min) * (past[i]-min)));
            }
                   
        }
        public void fillchoice() { //Fülle die Auswahlliste mit Shares oder Indices
            toolStripComboBox1.Items.Clear(); //leeren
            if (modusShare) { //Shares?
                if (evaluation.dt == null) evaluation.update(); Thread.Sleep(100); //Aufgerufen, before datatable gefüllt? Abbbruch!
                for(int i=0;i< evaluation.dt.Rows.Count;i++){ //Fülle Share-Namen, diesmal aus dataTable, in Auswahlliste
                    toolStripComboBox1.Items.Add(Convert.ToString(evaluation.dt.Rows[i][0]));
                }
            }else{
                for (int i = 0; i < evaluation.indiceCount; i++){//Fülle Index-Namen in Auswahlliste
                    toolStripComboBox1.Items.Add(evaluation.getIndice(i).name);
                }
            }
            toolStripComboBox1.SelectedIndex = modusindex; //Zuletzt ausgewähltes erneut auswählen
        }
        public override void update() //Aktualisiere Anzeige
        {
            if (this.InvokeRequired) //Aufgerufen durch Thread?
            {
                updateCallback d = new updateCallback(update);
                this.Invoke(d);// rufe lokal erneut auf
            }
            else//Lokal aufgerufen
            {
                zeichnen();//Zeichne Diagramm
            }        
        }

        private void ChartView_FormClosed(object sender, FormClosedEventArgs e)
        {
            evaluation.stop(); //Stoppe aktualisierungsfunktion
            t1.Abort(); //Breche AktualisierungThread ab.
            Application.Exit(); //Beende Anwendung
        }

        private void ChartView_Load(object sender, EventArgs e) //Beim Laden muss die Auswahlliste gefüllt werden
        {
            fillchoice();
        }

        private void ChartView_Paint(object sender, PaintEventArgs e) //Neu-Zeichnen der Oberfläche? Aktualisiere auch Diagramm!
        {
            thisform = this; //Formular für graphics auch in zeichnen() bzw. width/height.
            update();//aktualisieren
        }

        private void indicesToolStripMenuItem_Click(object sender, EventArgs e) //Indices anzeigen!
        {
            modusShare = false; //Keine Shares aber Indices
            indicesToolStripMenuItem.Checked = true; //Haken richtig setzen
            sharesToolStripMenuItem.Checked = false;
            modusindex = 0; //Standard: 1. Index
            fillchoice(); //Fülle Auswahlliste mit Allen Indices
            update(); //Aktualisieren
        }

        private void toolStripComboBox1_SelectedIndexChanged(object sender, EventArgs e) //Welches Share/Index?
        {
            modusindex = toolStripComboBox1.SelectedIndex;//Auswahl in Klasse allgemein verfügbar machen, sonst immer auf RequireInvoke prüfen!
            if (modusindex == -1) modusindex=0; //Falls nichts ausgewählt wurde z.B. bei Initialisierung: wähle 1. Element aus.
            update();//Aktualisieren
        }

        private void sharesToolStripMenuItem_Click(object sender, EventArgs e) //Shares anzeigen!
        {
            modusShare = true;//Shares!
            indicesToolStripMenuItem.Checked = false; //Haken richtig setzen
            sharesToolStripMenuItem.Checked = true;
            modusindex = 0; //Standard: 1. Index
            fillchoice();//Fülle Auswahlliste mit Allen Shares
            update(); //Aktualisieren
        }

        private void ChartView_Activated(object sender, EventArgs e)
        {
            Program.bringtofront(this);//Bei Focus, bring alle Formen nach vorne!
        }

        private void ChartView_Resize(object sender, EventArgs e) 
        {
            foreach (Form f in Program.f1)//Alle Formen sollen gleichen Windows-State haben!
                if (f != this && f!=null) { f.WindowState = this.WindowState; f.Update();}
        }


    }
}
