﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Threading;

namespace Boersenlupe
{
    public partial class PieView : AbstractObserver  //Anzeige Tortendiagramm
    {
        ShareEvaluation evaluation; //allgemeines evaluation-Objekt für Shares und Indices
        Thread t1; //Update-Thread, sodass FormClose nicht interval warten muss bis Anwendung endet
        Form thisform; //Form zur benutzung in update() für graphics.
        bool ModusShare = false; //Shares (true) oder Indices?
        int modusindex = 0; //index Share/Indices
        
        public PieView(ShareEvaluation evaluation) //Standard Konstruktor 
        {
            this.evaluation = evaluation; //hole globales evaluation-Objekt
            evaluation.register(this); //registriere Global diese Form für Kontrolle aus anderen Klassen
            InitializeComponent(); //Standard: Member/Events
        }
        public void registerUpdateThread(Thread thread) 
        {
            t1 = thread;//Update-Thread, sodass FormClose nicht interval warten muss bis Anwendung endet
        }
        public override void update() //aktualisiere/erstelle Tortendiagram
        {
            if (this.InvokeRequired) //Aufruf aus Thread
            {
                updateCallback d = new updateCallback(update);
                this.Invoke(d); //rufe lokal erneut auf
            }
            else //Aufruf lokal
            { 
                if (thisform == null) return; //Aufruf bevor Form geladen? Abbruch!
                Graphics g = thisform.CreateGraphics(); //Graphic auf Form-Panel
                g.Clear(SystemColors.Control); //Lösche bisherige Torten
                //Benutzte Farben, werden in dieser Reihenfolge Wiederholend angewandt.
                Color[] piecolors = { Color.DarkGoldenrod, Color.Red, Color.Blue, Color.Brown, Color.Purple, Color.DarkGreen, Color.Orange, Color.Indigo };
                double anglealt = 0; //Anfang Tortenstück (Grad)
                double angle = 0; //Ende TortenStück (Grad)
                string text = ""; //Beschriftung Tortenstücke
                SizeF tsize; //TextBlockGröße zum Zentrieren des Textes in Tortenstück
                Font nfont = new Font(FontFamily.GenericSansSerif, 12); //Schriftart beschreibung Tortenstück
                double total = 0; //Gesamtzahl Punkte, punkte-Anteil an total ist WInkel-Anteil an 360°
                double[] points = { }; //Anzuzeigende Punkte
                string[] names = { }; //Anzuzeigende Namen (in Beschreibung)
                int offsetx = 80; //Rand der Torte nach links
                int offsety = 80; //Rand der Torte nach oben
                int width = thisform.Width-2*offsetx; //Breite Torte 350
                int height = thisform.Height-2*offsety; ; //Höhe Torte 350

                if (width < 0 || height < 0) 
                    return; //Falls Form gerade minimiert wurde

                if (ModusShare) { //Shares anzeigen => Share-price in points
                    if (modusindex == 0) //Alle anzeigen:
                    {
                        points = new double[evaluation.shareCount]; //Fülle points und names mit Share-Eigenschaften
                        names = new string[evaluation.shareCount];
                        for (int i = 0; i < evaluation.shareCount; i++){
                            points[i] = evaluation.getShareByIndex(i).price;
                            names[i]=evaluation.getShareByIndex(i).name;
                        }
                        total = points.Sum();//GesamtZahl ist Summe einzelner prices
                    } else{ //Share zu einem Index anzeigen:
                        List<Share> indshare = evaluation.getSharesByIIndex(modusindex - 1); //Hole alle Shares zu diesem Indice, modusindex-1, da 0:= lle Shares
                        points = new double[indshare.Count];
                        names = new string[indshare.Count];
                        for (int i = 0; i < indshare.Count; i++) //Fülle points und names mit Share-Eigenschaften
                        {
                            points[i] = indshare[i].price;
                            names[i] = indshare[i].name;
                        }
                        total = points.Sum();//GesamtZahl ist Summe einzelner prices
                    }
                } else{ //Indices anzeigen
                    points = new double[evaluation.indiceCount];   //Fülle points und names mit Indices-Eigenschaften               
                    names = new string[evaluation.indiceCount];                 
                    for (int i = 0; i < evaluation.indiceCount; i++){
                        points[i] = evaluation.getIndice(i).points;
                        names[i]=evaluation.getIndice(i).name;
                    }
                    total = points.Sum();//GesamtZahl ist Summe einzelner points (der Indices)
                }

                for (int i = 0; i < points.Length; i++) //Zeichne Alle Tortenstücke
                {
                    angle =(points[i] / total) * 360; //Berechne Winkel: ANteil von Punkte zu Gesamtzahl ist Anteil von 360°
                    g.FillPie(new SolidBrush(piecolors[i % piecolors.Length]), offsetx, offsety, width, height, -90 + Convert.ToInt16(Math.Floor(anglealt)), Convert.ToInt16(Math.Ceiling(angle)));
                    //piecolors sind TortenstückFarben, wiederholen sich nach Erreichen der letzten Farbe.
                    //Start-Winkel: -90 ist oben. Floor (Abrunden) und Ceil (Aufrunden) wird benutzt, um Löcher zu vermeiden.
                    anglealt += angle; //Tortenstück geht vom Ende des letzten Tortenstückes um Angle weiter im Uhrzeigersinn.
                }
                angle = 0; //Resette Start und End-Winkel für eine neue Runde: Nun Text
                anglealt = 0;
                for (int i = 0; i < points.Length; i++) //Text wird in neuer Schleife geschrieben, da er Tortenstücke Teilweise überdeckt. Würde das nächste Tortenstück danach gezeichnet werden, würde es den Text verdecken.
                {
                    angle = Convert.ToInt16((points[i] / total) * 360); //s.o.
                    text=names[i] + ":\n" + Convert.ToString(points[i]); //Beschreibung: "Name:[Absatz]Punkte"
                    tsize=g.MeasureString(text, nfont).ToSize(); //Textgröße, um den Text zu zentrieren.
                    g.DrawString(text, nfont, new SolidBrush((angle > 70 ? Color.White : Color.Black)), Convert.ToInt16(offsetx + width / 2 - tsize.Width / 2 + width / (angle > 70 ? 4 : 1.8) * Math.Sin((angle / 2 + anglealt) / 360.0 * 2 * Math.PI)), Convert.ToInt16(offsety + height / 2 - tsize.Height / 2 - height / (angle > 70 ? 4 : 1.8) * Math.Cos((angle / 2 + anglealt) / 360.0 * 2 * Math.PI)));
                    //solidbrush: wenn Winkel größer 70° ist Platz für Text innerhalb Torte => lesbare Textfarbe Weiß, sonst Schwarz
                    //x-Koord: offsetx+width/2 ergibt mitte Tortendiagramm. 
                        //-tsize.width/2 ergibt an dieser Stelle zentrierten Textblock. 
                        //+width/(...) ergibt bei WInkel >70° (Text innerhalb Torte) den Text auf 1/4 Radius des Kreises entfern vom Mittelpunkt.
                        //Bei <70° ist der Radius 1/1.8 fach.
                        //"angle/2+anglealt" zentriert die Position in die Winkel-Mitte des Tortenstückes
                        //360*2π => Bogenwinkel => SIN(...)*radius ergibt x-Koordinate auf Kreis mit Winkel&Radius (Winkel um 90° gedreht!)
                    //y-Koord: wie x-koord nur mit height und -cos(...) (Winkel um 90° gedreht!)
                    anglealt += angle; //Tortenstück geht vom Ende des letzten Tortenstückes um Angle weiter im Uhrzeigersinn.
                }
            }
            
        }

        private void PieView_FormClosed(object sender, FormClosedEventArgs e)
        {
            evaluation.stop(); //Form beendet => Updates beenden
            t1.Abort(); //Beende UpdateThread
            Application.Exit(); //Ende Programm
        }

        private void PieView_Paint(object sender, PaintEventArgs e)
        {
            
            if (thisform == null) //Form zwischenspeichern, falls nicht bereits geschehen (erster Start) & Update Oberfläche.
            {
                thisform = this; //Zugriff auf form auch in anderen Funktionen
                update(); //nur beim ersten paint ausführen, da Combobox-Hover mehrere Paints auslöst -> Flimmern
            }
        }

        private void radioButton1_CheckedChanged(object sender, EventArgs e) //Ich will Indices!
        {
            comboBox1.Enabled = false; //Keine Shares zur Auswahl
            ModusShare = false; //Keine Shares
            update(); //Aktualisieren

        }

        private void radioButton2_CheckedChanged(object sender, EventArgs e)//Ich will Shares!
        {
            ModusShare = true; //Shares!
            comboBox1.Enabled = true; //Shares zur Auswahl
            comboBox1.Items.Clear(); //ShareListe leeren
            comboBox1.Items.Add("Alle Shares"); //Alle Shares anzeigen
            for(int i=0;i<evaluation.indiceCount;i++)//Shareliste füllen
                comboBox1.Items.Add(evaluation.getIndice(i).name);
            comboBox1.SelectedIndex = 0;//Alle Shares
            update();//Aktualisieren
        }

        private void comboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            modusindex = comboBox1.SelectedIndex; //Welches Share soll angezeigt werden? (0=> alle)
            update();//Aktualisieren
        }

        private void PieView_SizeChanged(object sender, EventArgs e)
        {
            update();//Aktualisieren bei Änderungen in Größe (oder re-minimieren!)
        }

        private void PieView_Activated(object sender, EventArgs e)
        {
            Program.bringtofront(this); //alle 3 Formen nach Vorne!
        }

        private void PieView_Resize(object sender, EventArgs e)
        {
            foreach (Form f in Program.f1) //Alle 3 Formen gleichen Windows-State!
                if (f != this && f!=null) { f.WindowState = this.WindowState; f.Update(); }
        }

        private void PieView_Load(object sender, EventArgs e)
        {

        }


    }
}
