﻿using System;
using System.Threading;
using System.Collections.Generic;
using System.Windows.Forms;
using System.Net;
using System.IO;
using System.Net.Sockets;

namespace Client_Server_Chat
{
	public class Client
	{
		bool running; //Client läuft
        Mutex messageM = new Mutex(); //Mutex, damit ausgehende Befehle sich nicht durcheinander bringen
        Queue<string> messages = new Queue<string>(); //Chat-Nachrichten, geht ein SendRequest voraus
        Queue<string> commands = new Queue<string>(); //Befehle, gehen so heraus, dafür keine direkte Benutzereingabe möglich
        public delegate void dReceive(string message); //für delegaten siehe Program.cs oder Form1.cs
        public dReceive received;
        public delegate void initvi();
        public initvi initview;
        public delegate void state(string message);
        public state showstate;
        public delegate void conf(string message);
        public conf confirm;
        public delegate void spielerlist(string[] Spieler);
        public spielerlist spielerliste;
        public delegate void kartenlist(string[] karten, string[] fremdkartenanz, string aktkart, string aktplayer);
        public kartenlist kartenliste;
        public delegate void confdis();
        public confdis confirmdisable;
        public confdis playerdran;

		public TcpClient client; //client-objekt für das Senden über GetStream!
        public String cName; //Name des Clienten
		public Client()//Konstruktor
		{
			running=true; //läuft per default!
			client=new TcpClient(); //leeres Verbindungsobjekt
            cName=""; //namenlos
        }
        public void send(string message) //Schicke nachrichten in Warteschlange
        {
            //Die Warteschlange wird nach Abarbeiten der Server-Antworten durchgegangen und gesendet.
            messageM.WaitOne();//keine Einmischung, sonst Reihenfolge falsch etc.
            messages.Enqueue(message);
            messageM.ReleaseMutex(); //Ab hier ist WaitOne wieder passierbar.
        }
        public void sendcom(string[] message) //Schicke Befehle. Hier überladen mit Array aus Befehlen, um Reihenfolge zu gewährleisten
        {
            messageM.WaitOne();
            for (int i = 0; i < message.Length; i++) //Alle Meldungen in die Warteschleife. Diese wird nach der nachrichten-Warteschleife durchgegangen
                commands.Enqueue(message[i]);
            messageM.ReleaseMutex();
        }
        public void sendcom(string message) //Schicke Befehle, hier einen
        {
            messageM.WaitOne();
            commands.Enqueue(message);
            messageM.ReleaseMutex();
        }
        public void aufgeben() { //Gebe maumau auf: Ein Befehl wird gesendet
            sendcom(ClientChatMessages.Gameabort);
        }
        public void stop(){ //Stoppe Client.
            messageM.WaitOne(); //keine EInmischung durch andere Threads!
            if (!running || !client.Connected) return; //CLient läuft gar nicht?
            NetworkStream stream = client.GetStream(); //Schreibe direkt Disconnect in den Stream! Damit unabhängig von Endlosschleife
            BinaryReader readClient = new BinaryReader(stream);
            BinaryWriter writeClient = new BinaryWriter(stream);
            writeClient.Write(ClientChatMessages.Disconnect);
            messageM.ReleaseMutex();
            received("Verbindung getrennt\r\n"); //Meldung über erfolg.
            running = false; //läuft nicht mehr
        }
        public void requestgame() //maumau?
        {
            sendcom(ClientChatMessages.RequestGame);
        }
        public void responsegame(bool conf) //maumau: ja/nein
        {
            if (conf) sendcom(ClientChatMessages.confirmGame); else sendcom(ClientChatMessages.denyGame);
        }
        public void legekarte(int id) //eine karte legen: übergebe ID aus Hand
        {
            sendcom(new string[] { ClientChatMessages.Gamelaycard, Convert.ToString(id) });
        }
        public void ziehekarte() //ziehe eine karte vom Stapel: zufällige von verbliebenden
        {
            sendcom( ClientChatMessages.Gamedrawcard);
        }
		public bool start(String local, string name){ //starte Clienten
			try{
                running = true; //client läuft
                cName = name; //Setze namen wie in Form1 angegeben
                client = new TcpClient(); //neues Verbindungsobjekt
				client.Connect(IPAddress.Parse(local),8000); //baue eine verbindung auf! (Port 8000)
			}catch(SocketException e){ //Port blockiert oder kein Server vorhanden: Fehler
                showstate("Status: Verbindung fehlgeschlagen");
                running=false;
				return false;//Rückgabe wird benutzt: Server starten?
			}
			try{ //Falls Client läuft
				NetworkStream stream =client.GetStream(); //Standard-Verbindungsobjekte für Lese/Schreibzugriff
				BinaryReader readClient=new BinaryReader(stream);
				BinaryWriter writeClient=new BinaryWriter(stream);
                string message; //Objekte, die weiter unten öfter Benutzt werden.
                string[] messagelist;
                string[] spielende;
                string input;
                writeClient.Write(ClientChatMessages.RequestConnect); //Server: Verbinden?
                message = readClient.ReadString(); //hole Serverantwort als String
                if (message == ServerChatMessages.AcknowledgeOK)
                { //Alles in Ordnung
                    showstate("Verbindung als Client aufgebaut");
                    writeClient.Write(cName); //Mit Namen anmelden
                    while (running) //Endlosschleife solange Client verbunden/läuft
                    {
                        Thread.Sleep(100); //Schont den prozessor, Programm verhaspelt sich nicht.
                        messagelist = readClient.ReadString().Split(Convert.ToChar(20)); //Mehrere Antworten auf einmal übertragen
                        for (int i = 0; i < messagelist.Length; i++) //jede Antwort einmal durchgehen
                            switch (messagelist[i]) //Was kam an?
                            {
                                case ClientChatMessages.RequestConnect: //Verbindung steht: gegenseitige Begrüßung
                                    break;
                                case ServerChatMessages.RequestGame: //Maumau starten?
                                    confirm("Eine Partie MauMau starten?"); //confirm löst Popup aus
                                    break;
                                case ServerChatMessages.ConfirmGame: //Server bestätigt: es wird nun Maumau gespielt! (Alle sagten ja!)
                                    received("Spielen!\r\n");
                                    sendcom(ClientChatMessages.Gamerequestplayers);
                                    break;
                                case ServerChatMessages.Gameend: //Maumau zu Ende (Für diesen Clienten)
                                    input = readClient.ReadString(); //Typ des Endes:
                                    if (Convert.ToInt16(input) == 0) //Alle anderen sind schon fertig
                                        received("Letzter...\r\n");
                                    else if (Convert.ToInt16(input) == -1) //Stapel ist Leer (bzw. -1 Karte)
                                        received("Kartenstapel zu Ende! Unentschieden!\r\n");
                                    else
                                        received("Als " + Convert.ToInt16(input) + ". gewonnen!\r\n"); //Gewonnen!
                                    spielerliste(null);//Setzt Oberfläche auf normal zurück
                                    break;
                                case ServerChatMessages.DenyGame: //Da will einer kein Maumau...
                                    confirmdisable(); //Schließt Maumau popup
                                    break;
                                case ServerChatMessages.Gamekartdenied: //Diese Karte geht nicht!
                                    received(readClient.ReadString()); //siehe Meldung hierzu. Maumau-Meldungen im Chat-Fenster, allerdings nur im betreffenden Clienten!
                                    break;
                                case ServerChatMessages.Playerdran: //Du bist dran!
                                    playerdran();
                                    break;
                                case ServerChatMessages.Gameinfosend: //Spielerliste update
                                    spielende = readClient.ReadString().Split(Convert.ToChar(2));
                                    spielerliste(spielende); //update Oberfläche
                                    break;
                                case ServerChatMessages.newcardavail: //Server: Ich hätte neuigkeiten über Spieler und Karten...
                                    sendcom(ClientChatMessages.requestcards); //Client: Ja, schick doch mal bitte!
                                    break;
                                case ServerChatMessages.Gameaktkarten: //Server: hier sind die Karten (Spielerliste oben)
                                    input = readClient.ReadString(); //input zur Kontrolle als zusätzliche Var.
                                    string[] karten = input.Split(Convert.ToChar(2)); //meine karten als Text!
                                    string[] fremdkartenanz = readClient.ReadString().Split(Convert.ToChar(2));//Anzahl Karten aller Spieler
                                    string aktkarte = readClient.ReadString(); //Aktuelle karte
                                    string aktplayer = readClient.ReadString().TrimEnd('\r', '\n'); //Welcher Spieler ist dran
                                    kartenliste(karten, fremdkartenanz, aktkarte, aktplayer); //Übertrage Werte in Oberfläche
                                    break;
                                case ServerChatMessages.authOK: //Verbindung hergestellt!
                                    received("Verbindung hergestellt mit " + local + Convert.ToChar(13) + Convert.ToChar(10));
                                    break;
                                case ServerChatMessages.nonews: //Standard-Endlosschleife: Nichts passiert. Ansonsten: Befehle oder Chat!
                                    break;
                                case ServerChatMessages.closeNow: //Server wurde ordnungsgemäß beendet! Beende nun auch Clienten!
                                    showstate("Server beendet");
                                    received("Server beendet, schließe Verbindung" + Convert.ToChar(13) + Convert.ToChar(10));
                                    running = false;
                                    initview();
                                    return true;
                                case ServerChatMessages.authFail: //Benutzername schon registiert? Eindeutig wählen!
                                    received("Verbindung verweigert: Benutzername bereits registriert" + Convert.ToChar(13) + Convert.ToChar(10));
                                    running = false;
                                    initview();
                                    return true;
                                default:
                                    received(messagelist[i]); //Weder nichts neues noch Befehle? dann Chat!
                                    break;
                            }

                        string send = "";
                        if (messages.Count > 0) //Meldungen zum Senden vorhanden:
                        {
                            messageM.WaitOne();
                            for (int i = 0; i < messages.Count; i++) //Sende alle Meldungen nacheinander ab
                            {
                                send = messages.Dequeue(); //Stapel wird abgetragen
                                writeClient.Write(ClientChatMessages.RequestSend); //Chatmeldungen benötigen RequestSend für weiterreichung an alle Clienten!
                                writeClient.Write(send); //Meldung
                            }
                            messageM.ReleaseMutex();
                        }
                        if (commands.Count > 0) //Befehle zu versenden
                        {
                            messageM.WaitOne();
                            for (int i = commands.Count; i > 0; i--) //Schleifenfolge egal, Anzahl ist wichtig.
                            {
                                send = commands.Dequeue();
                                writeClient.Write(send); //direkte Übertragung der Befehle
                            }
                            messageM.ReleaseMutex();
                        }
                        if (running) writeClient.Write(ClientChatMessages.RequestNews); //Was gibt es neues? Wenn nichts, (0.1s) was gibt es neues?
                    }
                }
                else {
                    showstate("Serververbindung abgelehnt!"); //Sollte nicht vorkommen (mit diesem Server)
                    Thread.Sleep(1000);
                    initview();
                    return true;
                }
			}catch(SocketException e){ //unerwartetes Beenden der Verbindung
				showstate("Serververbindung wurde geschlossen!");
				Thread.Sleep(1000);
                initview();
                return true;
            }
            catch (IOException e)
            { //unerwartetes Beenden des Servers
				showstate("Server unerwartet beendet!");
				Thread.Sleep(1000);
                initview();
                return true;
            }
            return true;
			
		}
	}
}
