﻿using System;
using System.Windows.Forms;
using System.Threading;

namespace Client_Server_Chat
{
    internal sealed class Program
    {
        [STAThread]
        private static void Main(string[] args)
        {
            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);
            Server server = new Server(); //Serverklasse bereitmachen
            Form1 form = new Form1();   //Oberfläche bereit machen

            form.startServer += server.start; //Server start-methode in Form verknüpfen
            form.stopServer += server.stop; //Server stop-methode in Form verknüpfen
            //ruft außerdem einen Clienten auf, der sich mit dem eigenen Server verbindet, um Wartende Code-Teile zu beenden.
            server.showstate += form.showState; //Form Statusmeldung-methode in Server verknüpfen

            Client client = new Client(); //Client bereit machen

            //Alle Aufrufe der Form-Methoden dienen Anzeige-zwecken und sind im Server-Teil zusätzlich geprüft.
            form.send += client.send;   //Sende Nachrichten
            client.received += form.showMessage; //Zeige Nachrichten an
            client.showstate += form.showState; //Zeige Statusmeldungen an
            client.confirm += form.conf;    //die Anfrage, ob man Maumau spielen möchte
            client.confirmdisable += form.confdis;  //verberge ANzeige, wenn einer NEIN wählt
            client.initview += form.initview;   //Alles auf Anfang (beinhaltet Trennen der Verbindungen)
            client.spielerliste += form.spielerliste;   //Aktualisiert maumau-Spielerliste
            client.kartenliste += form.kartenliste; //Aktualisiert Maumau-Oberfläche
            client.playerdran += form.playerdran;   //Setzt diesen Spieler aktiv!

            //Aus Form aufgerufene clientmethoden
            form.legekarte += client.legekarte;//Lege eine Karte
            form.aufgeben += client.aufgeben;//Maumau Aufgeben
            form.responsegame += client.responsegame; //Spiel: Ja/Nein?
            form.startClient += client.start;   //Starte Clienten (verbinde)
            form.stopClient += client.stop; //Stoppe clienten
            form.requestgame += client.requestgame; //linkLabel: Maumau spielen?
            form.ziehekarte +=client.ziehekarte;    //eine Karte ziehen

            Application.Run(form); //Starte Oberfläche!
        }

    }
}
