﻿using System;
using System.Net;
using System.Net.Sockets;
using System.IO;
using System.Collections;
using System.Threading;
using System.Collections.Generic;

namespace Client_Server_Chat
{
  
    //Hier geht der eigentliche Server los!
    public class Server
    {
        public struct playerstruct { //Typ für verbundenen Clienten und teilweise kopiert für Spieler
            public TcpClient client; //client für Datenverkehr
            public clientHandler handler; //clienthandler (Klasse oben)
            public string name; //Name (momentan unwichtig da in SortedList benutzt, dort ist Name "Key", da eindeutig.
            public playerstruct(TcpClient client,clientHandler handler, string name)
            {//Konstruktor
                this.client = client;
                this.handler = handler;
                this.name = name;
            }
        }
        TcpListener listener; //Verbindung zu Clienten
        TcpClient client; //aktuell angekommener client.
        bool running;   //Server läuft?
        String local;   //Akzeptierte IPs

        public delegate void state(string message);//Statusmelsungen in Oberfläche anzeigen
        public state showstate;

        //Static-Variabeln, damit alle Clienten darauf zugreifen können.

        public static Mutex messageM = new Mutex(); //Mutex, damit Clienten die anderen static-Variabeln updaten können
        public static int gewonnene = 0; //der wievielte Gewinner bist du? 1., 2., 3.? 0: verloren, -1: Stapel alle.
        public static SortedList<string, playerstruct> clients = new SortedList<string, playerstruct>(); //Clienten
        public static SortedList<string, playerstruct> spieler = new SortedList<string, playerstruct>(); //Maumau-Spielende.
        //Bei Anfrage werden alle Clienten zu spielern oder keine. Danach können Clienten unbeteiligt am Spiel dazukommen
        public static Karten Stapel; //Stapel für alle Clienten
        public static SortedList<string, Karten> Spielerhand; //Spielerhände der Clienten.
        //Hier wurde angenommen, dass class Server und class clientHandler beide den Server bilden, daher haben alle clientHandler indirekt Zugriff auf alle anderen
        //Ein modifizierter Client könnte daher so nicht mogeln

        public Server()//Konstruktor.
        {
            running = false;
            local = "127.0.0.1"; //Default: localhost
        }


        public bool gamerunning() { //läuft ein Spiel?, Wenn es Spieler gibt, ja!
            if (spieler!=null && spieler.Count > 0) return true; else return false;
        }

        public void broadcastspieler(object message) //An alle Spieler! 
        {
            if (message.GetType() == typeof(string) ) //pseudo-Überladen: string geht an alle spieler über Chat
            {
                for (int i = spieler.Count - 1; i >= 0; i--)
                {
                    spieler.Values[i].handler.recieveMessage((string)message);
                }
            }
            else if (message.GetType() == typeof(string[]))//string[] geht an alle Spieler direkt über write (Befehle etc.)
            {
                BinaryWriter writer;
                for (int i = spieler.Count - 1; i >= 0; i--)
                {
                    writer = new BinaryWriter(spieler.Values[i].client.GetStream());
                    for (int x = 0; x < ((string[])message).Length; x++)
                    {
                        writer.Write(((string[])message)[x]);
                    }
                }
            }
        }
        public void broadcast(object message) //Sende an alle Spieler (chat)!
        {
            if (message.GetType() != typeof(string)) return; //Benutzt selben delegat wie broadcastspieler, daher objekt, ist aber eigentlich egal: nur als string benutzt
            if ((string)message != "")
            {
                for (int i = clients.Count - 1; i >= 0; i--)
                {
                    clients.Values[i].handler.recieveMessage((string)message);
                }
            }
            showstate("Du bist Server: " + clients.Count + " Clienten verbunden!"); //Aktualisierung verbundene Clienten!
        }
        public void stop() { //Beendet Server
            if (!running) return;
            broadcast(ServerChatMessages.closeNow); //An alle: wir schließen jetzt!
            running = false;
            TcpClient nclient = new TcpClient();
            try
            {
                nclient.Connect(IPAddress.Parse("127.0.0.1"), 8000);  //Letzt Verbindung zu sich selbst um das warten zu beenden           
            }
            catch (Exception e) {
                showstate(e.Message);
            }//Wenn Zielcomputer Verbindung verweigert, muss sie nicht geschlossen werden.
            nclient.Close();
            listener.Stop();//Fertig

        }
        public bool start()
        {
            return start("127.0.0.1");//default: localhost
        }
        public bool start(String local)
        {
            if (!running)//läuft's schon?
            {
                running = true;
                this.local = local;
                listener = new TcpListener(IPAddress.Parse(local), 8000); //lausche auf Port 8000!

                spieler = new SortedList<string,playerstruct>(); //neue Spieler und clienten-Listen!
                clients = new SortedList<string, playerstruct>();


                try
                {
                    listener.Start(); //geht der Port?
                }
                catch (SocketException e)
                {
                    showstate("Status: Port besetzt!");
                    return false;
                }
                Thread serverRun = new Thread(new ThreadStart(handle)); //Starte eigentlichen Server/Lauscher!
                serverRun.Start();
                showstate("Status: Server gestartet:");
                Thread.Sleep(1000); //Anzeigedauer
                return true; //Server konnte gestartet werden!
            }else
            return false; //Server läuft schon!
        }
        public void handle() //Eigentlicher Server
        {
            try
            {
                while (running)
                {
                    client = listener.AcceptTcpClient(); //Hier wartet der Thread afuf's Klopfen des Clienten. Auch, wenn man das Programm beenden möchte!
                    clientHandler ch = new clientHandler(client); //Client bekommt ClientHandler
                    ch.broadcast += broadcast; //Zuweisung von Funktionen von ClientHandler zu Server
                    ch.broadcastspieler += broadcastspieler;
                    ch.gamerunning += gamerunning;
                    
                    Thread thread = new Thread(new ThreadStart(ch.handle)); //clientHandler starten!
                    thread.Start(); //clientHandler fügt client auch zu clients hinzu!

                }
            }
            catch (SocketException e) {
                showstate("Verbindung unerwartet unterbrochen");
            }
        }
    }


    public class clientHandler //Clienthandler zur interaktion mit einem Clienten.
    {
        public TcpClient client; //client hinter diesem clientHander, für direkten Datenverkehr
        string messages;    //Textmeldungen
        public delegate void sendMessage(object message);
        public sendMessage broadcast; //An alle Clienten
        public sendMessage broadcastspieler; //An Alle Maumau-Spieler

        //SortedList ist Key und Index-Aufrufbar und hat als Value einen freidefinierbaren Typ!
        public delegate SortedList<string, Karten> updatekartenlist(SortedList<string, Karten> karten);
        public delegate bool gameruni();
        public gameruni gamerunning; //läuft ein Spiel? gibt es Spieler?
        public String cName; //Aktueller Spielername
        Queue<string> commands = new Queue<string>(); //Stapel an Befehlen, die gesendet werden sollen


        //Der Unterschied zwischen sendcom() und message+= ist, dass message auf einmal ankommt und evtl noch Chat-Nachrichten beinhaltet, während direkt aufeinanderfolgende Befehle und Informationen besser mit sendcom geschickt werden.

        public void sendcom(string[] message) //Sende mehrere Befehle in genau dieser Abfolge und zusammen!
        {
            Server.messageM.WaitOne(); //Wie bei Client gibt es eine Liste, die abgearbeitet wird, allerdings hier, wenn Client nach Neuigkeiten fragt.
            for (int i = 0; i < message.Length; i++)
                commands.Enqueue(message[i]);
            Server.messageM.ReleaseMutex();
        }
        public void sendcom(string message) //Sende einen Befehl
        {
            Server.messageM.WaitOne(); //s.o und client.cs
            commands.Enqueue(message);
            Server.messageM.ReleaseMutex();
        }
        public clientHandler(TcpClient client) //Konstruktor
        {
            this.client = client; //client hinter diesem clientHander, für direkten Datenverkehr
            messages = ""; //Textmeldungen
        }
        public void recieveMessage(string message) //Schreibt mehrere Meldungen mit chr(20) getrennt aneinander. Wird versendet, wenn Client nach News fragt.
        {//messages wird zurückgesetzt, wenn es gesendet wird.
            if (!client.Connected) { return; }
            Server.messageM.WaitOne();
            if (messages != "") messages += Convert.ToChar(20); 
            messages += message;
            Server.messageM.ReleaseMutex();

        }

        public void handle() //Hauptroutine!
        {
            try
            {
                NetworkStream stream = client.GetStream(); //Verbindungsobjekte
                BinaryReader readClient = new BinaryReader(stream);
                BinaryWriter writeClient = new BinaryWriter(stream);
                string message;//Variabeln die Weiter unten öfter benutzt werden
                string[] ausgab;
                int curkartindex;
                string input;
                message = readClient.ReadString(); //Erstes Signal vom Client
                if (message == ClientChatMessages.RequestConnect) //Verbindungsuche?
                {
                    writeClient.Write(ServerChatMessages.AcknowledgeOK); //Sicher!
                    string ms = readClient.ReadString(); //namen?
                    if (!Server.clients.ContainsKey(ms)) //Name noch nicht belegt? clients ist static! Alle Zugriffe auf das selbe Objekt!
                    {
                        cName = ms; //Cname: ClientName, wird hier gesetzt
                        Server.clients.Add(cName, new Server.playerstruct(client, this, cName)); //neuer client wird hier hinzugefügt! Empfange nun auch broadcast!
                        Server.messageM.WaitOne();
                        writeClient.Write(ServerChatMessages.authOK); //"Alles in Ordnung"
                        broadcast(ms + " ist beigetreten" + Convert.ToChar(13) + Convert.ToChar(10)); //Benachrichtigung an alle: ein neues Mitglied!
                        Server.messageM.ReleaseMutex();
                    }
                    else
                    {
                        writeClient.Write(ServerChatMessages.authFail); //Name schon besetzt
                        client.Close(); //Tschüss
                        return;
                    }
                    do
                    {
                        message = readClient.ReadString(); //Was will der Client
                        switch (message)
                        {
                            case ClientChatMessages.RequestConnect: //Standard-Begrüßung
                                break;
                            case ClientChatMessages.Gamerequestplayers: //Maumau fängt an!

                                Server.messageM.WaitOne(); //Ein Client nach dem anderen!
                                if (Server.Stapel == null) //Hier soll nur einer durchkommen!
                                {
                                    Server.Stapel = new Karten(true); //32 neue Karten, eine offen!
                                    Server.Spielerhand = new SortedList<string, Karten>(); //0 Karten auf der hand
                                    Server.Stapel.aktspielername = cName; //Erster der akzeptiert!
                                    Karten.Karte auskart; //Zwischenvariable: Spielfehler? zu wenige Karten?
                                    for (int i = 0; i < Server.spieler.Count; i++) //teile Karten an alle aus
                                    {
                                        Server.Spielerhand.Add(Server.spieler.Keys[i], new Karten(false));
                                        for (int j = 0; j < 5; j++) //5 karten für jeden zu Beginn
                                        {
                                            auskart = Server.Stapel.ziehen(); //ziehe eine Karte aus dem Deck
                                            if (auskart.wert == -1) //keine karten mehr?
                                            {
                                                //Server.messageM.WaitOne();
                                                broadcastspieler(new string[] { ServerChatMessages.Gameend, "-1" }); //Spiel beenden: Unentschieden!
                                                Server.messageM.ReleaseMutex();
                                                Server.gewonnene = 0; //reset der Spielvariablen
                                                Server.Spielerhand.Clear();
                                                Server.spieler.Clear();
                                                break;
                                            }
                                            Server.Spielerhand[Server.spieler.Keys[i]].austeilen(auskart); //Gebe gezogene Karte an Spieler
                                        }
                                    }
                                }

                                ausgab = new string[Server.spieler.Count]; //Conversion IList in String[] zwecks string.join(char,string[])
                                Server.spieler.Keys.CopyTo(ausgab, 0);//Sendet Spielernamen an alle
                                sendcom(new string[] { ServerChatMessages.Gameinfosend, string.Join(Convert.ToChar(2).ToString(), ausgab) });

                                //auch möglich: direktes schreiben. Allerdings gab es hier seltsame Fehler: Befehle geraten durcheinander oder verschwanden
                                //Da aber auch funktionial, bleiben die Zeilen mal drin, wenn auch auskommentiert
                                //writeClient.Write(ServerChatMessages.Gameinfosend);
                                //writeClient.Write(string.Join(Convert.ToChar(2).ToString(), ausgab));

                                Server.messageM.ReleaseMutex();


                                if (Server.Spielerhand.Count == Server.spieler.Count) //Haben jetzt alle Spieler Karten?
                                {
                                    //messageM.WaitOne(); //Waitone hier nicht notwendig, da sendcom selbst eines hat
                                    string ubertrag = "";

                                    for (int j = 0; j < Server.Spielerhand.Count; j++)
                                        ubertrag += Convert.ToChar(2) + "" + Server.Spielerhand.Values[j].Anzahl;

                                    sendcom(new string[] { ServerChatMessages.Gameaktkarten, //sende Spielinformationen
                                        Server.Spielerhand[cName].getallkarts(), //Karten zum aktuellen Clienten
                                        ubertrag.Substring(1), //Anzahl der Karten von allen
                                        Server.Stapel.aktkart.ToString(),//aktuelle karte
                                        Server.Stapel.aktspielername });//aktueller Spieler (dran)

                                    //writeClient.Write(ServerChatMessages.Gameaktkarten);
                                    //writeClient.Write(Server.Spielerhand[cName].getallkarts());
                                    //writeClient.Write(ubertrag.Substring(1));
                                    //writeClient.Write(Server.Stapel.aktkart.ToString());
                                    //writeClient.Write(Server.Stapel.aktspielername);

                                    //messageM.ReleaseMutex();
                                }
                                break;
                            case ClientChatMessages.RequestNews: //Standard: wird alle 100ms aufgerufen, wenn nichts passiert
                                string send = "";
                                if (commands.Count > 0) //gibt es Befehle?
                                {
                                    Server.messageM.WaitOne(); 
                                    for (int i = commands.Count; i > 0; i--)
                                    {
                                        send = commands.Dequeue();
                                        writeClient.Write(send); //Schicke alle Befehle an Clienten Weg
                                    }
                                    Server.messageM.ReleaseMutex();
                                }
                                //Danach
                                if (messages == "") //keine neuen Nachrichten?
                                {
                                    writeClient.Write(ServerChatMessages.nonews); // "
                                }
                                else //Ansonsten
                                {
                                    Server.messageM.WaitOne();
                                    writeClient.Write(messages); //Schreibe Nachrichten an Client. Hier mit chr(20) getrennt, falls mehrere. s.o. für details
                                    messages = "";
                                    Server.messageM.ReleaseMutex();
                                }


                                break;
                            case ClientChatMessages.denyGame: //Jemand will nicht spielen
                                Server.messageM.WaitOne();
                                broadcast(cName + " hat das Spielen abgelehnt\r\n"); //Alle sollen erfahren wer! .\/.
                                broadcast(ServerChatMessages.DenyGame); //Popup in Clienten-Oberflächen deaktivieren
                                Server.messageM.ReleaseMutex();
                                Server.spieler.Clear();//spiel-reset
                                Server.Stapel = null;
                                Server.Spielerhand = null;
                                Server.gewonnene = 0;
                                break;
                            case ClientChatMessages.confirmGame://Jemand möchte spielen!^^
                                Server.messageM.WaitOne();
                                broadcast(cName + " möchte spielen.\r\n"); //Informationsfreiheit!
                                Server.spieler.Add(cName, new Server.playerstruct(client, this, cName)); //client wird zu spielern hinzugefügt. Wieder: da static keine große Synchronisation notwendig! aber Mutex beachten!
                                Server.messageM.ReleaseMutex();
                                if (Server.spieler.Count == Server.clients.Count)
                                {
                                    Server.Stapel = null; //Gamereset
                                    Server.Spielerhand = null;
                                    Server.messageM.WaitOne();
                                    broadcast(ServerChatMessages.ConfirmGame); //An aLle: Spiel fängt an!
                                    Server.messageM.ReleaseMutex();
                                }
                                break;
                            case ClientChatMessages.Gamedrawcard: //EIne karte ziehen
                                if (cName != Server.Stapel.aktspielername) //Spieler ist nicht dran!
                                {
                                    //messageM.WaitOne();
                                    sendcom(new string[] { ServerChatMessages.Gamekartdenied, "Du bist nicht dran!\r\n", ServerChatMessages.Playerdran });
                                    //writeClient.Write(ServerChatMessages.Gamekartdenied);
                                    //writeClient.Write("Du bist nicht dran!\r\n");
                                    //writeClient.Write(ServerChatMessages.Playerdran);
                                    //messageM.ReleaseMutex();
                                    break;
                                }
                                curkartindex = Server.spieler.IndexOfKey(cName); //Index in Spielerliste, welcher Spieler dran ist (dieser)
                                if (curkartindex == Server.spieler.Count - 1) curkartindex = 0; else curkartindex++; //nächster Spieler in der Runde
                                if (Server.Stapel.zweiziehen) //Muss der Spieler 2 Karten ziehen?
                                {
                                    Karten.Karte kart = Server.Stapel.ziehen(); //ziehe 2 mal
                                    Karten.Karte kart2 = Server.Stapel.ziehen();
                                    if (kart.wert == -1 || kart2.wert == -1) //Stapel leer?
                                    {
                                        Server.messageM.WaitOne();
                                        broadcastspieler(new string[] { ServerChatMessages.Gameend, "-1" });//Unentschieden (s.o. oder client.cs)
                                        Server.messageM.ReleaseMutex();
                                        Server.gewonnene = 0;
                                        Server.Spielerhand.Clear();
                                        Server.spieler.Clear();
                                        break;
                                    }
                                    //Austeilen an Spielerhände: oder gibt es doppelte Karten? (Betrug!)
                                    if (!Server.Spielerhand[cName].austeilen(kart) || !Server.Spielerhand[cName].austeilen(kart2))
                                    {
                                        Server.Stapel.ablegen(kart); //Zurücklegen der karten
                                        Server.Stapel.ablegen(kart2); //Zurücklegen der karten
                                        sendcom(new string[] { ServerChatMessages.Gamekartdenied, "Karte doppelt!\r\n", ServerChatMessages.Playerdran }); //Player nochmal dran... Rausschmeißen ginge auch... aber wir wollen ja mal nicht so sein
                                        //writeClient.Write(ServerChatMessages.Gamekartdenied);
                                        //writeClient.Write("Karte doppelt!\r\n");
                                        //writeClient.Write(ServerChatMessages.Playerdran);
                                    }
                                    Server.Stapel.zweiziehen = false; //nächster braucht keine 2 mehr ziehen!
                                }
                                else //nur 1 ziehen.
                                {
                                    Karten.Karte kart = Server.Stapel.ziehen(); //alles wie oben.
                                    if (kart.wert == -1)
                                    {
                                        Server.messageM.WaitOne();
                                        broadcastspieler(new string[] { ServerChatMessages.Gameend, "-1" });
                                        Server.messageM.ReleaseMutex();
                                        Server.gewonnene = 0;
                                        Server.Spielerhand.Clear();
                                        Server.spieler.Clear();
                                        break;
                                    }
                                    if (!Server.Spielerhand[cName].austeilen(kart))
                                    {
                                        Server.Stapel.ablegen(kart);
                                        sendcom(new string[] { ServerChatMessages.Gamekartdenied, "Karte doppelt!\r\n", ServerChatMessages.Playerdran });
                                        //writeClient.Write(ServerChatMessages.Gamekartdenied);
                                        //writeClient.Write("Karte doppelt!\r\n");
                                        //writeClient.Write(ServerChatMessages.Playerdran);
                                    }
                                }
                                //Aktueller Spielername mit dem oben geänderten Index des Spielernamens
                                Server.Stapel.aktspielername = Server.spieler.Keys[curkartindex];
                                broadcastspieler(ServerChatMessages.newcardavail); //Kartensatz hat sich geändert. Um den normalen Ablauf zu wahren (Client fragt zuerst nach News) werden hier Kartenaktualisierungen angekündigt. Auch möglich wären aktive Direktverbindungen zu allen Clienten, allerdings auch Fehleranfälliger bzw. mehr Mutex nötig
                                break;
                            case ClientChatMessages.Gameabort: //Client gibt Maumau auf
                                if (!Server.spieler.ContainsKey(cName)) //Spielt der überhaupt mit?
                                {
                                    sendcom("Nicht am Spiel beteiligt!\r\n");
                                    break;
                                }

                                if (Server.Stapel.aktspielername == cName)//aufgebender war dran?
                                {
                                    curkartindex = Server.spieler.Keys.IndexOf(cName); //Index Spieler?
                                    Server.spieler.Remove(cName); //entferne Spieler aus Liste
                                    if (curkartindex >= Server.spieler.Count - 1) { Server.Stapel.aktspielername =Server.spieler.Keys[0]; } //Liste nun zu klein? fange vorne an! sonst kein Index-Verändern=> nachfolgender Spieler
                                }
                                else
                                {
                                    Server.spieler.Remove(cName);
                                }
                                Server.Spielerhand.Remove(cName); //spieler entfernen
                                sendcom(new string[] { ServerChatMessages.Gameend, "0" }); //"Sie haben verloren!"
                                
                                Server.messageM.WaitOne();
                                broadcastspieler(ServerChatMessages.newcardavail);//neue karten verfügbar! siehe "case ClientChatMessages.Gamedrawcard:" für details
                                Server.messageM.ReleaseMutex();

                                if (Server.Spielerhand.Count == 1) //nur noch ein verbleibender Spieler?
                                {
                                    Server.messageM.WaitOne();
                                    Server.gewonnene++; //Dann hat der natürlich gewonnen! 
                                    broadcastspieler(new string[] { ServerChatMessages.Gameend, Convert.ToString(Server.gewonnene) });
                                    Server.messageM.ReleaseMutex();
                                    Server.gewonnene = 0;//Gamereset
                                    Server.Spielerhand.Clear();
                                    Server.spieler.Clear();
                                }
                                break;
                            case ClientChatMessages.Gamelaycard: //Eine karte legen
                                input = readClient.ReadString(); //Welche? (Index aus Hand)
                                if (cName != Server.Stapel.aktspielername) //Ist der überhaupt dran?
                                {
                                    sendcom(new string[] { ServerChatMessages.Gamekartdenied, "Du bist nicht dran!\r\n"});
                                    break;
                                }
                                else
                                {
                                    //Welche Karte entspricht denn nun dem index?
                                    Karten.Karte neuplkart = Server.Spielerhand[cName].ElementAt(Convert.ToInt16(input));
                                    if (neuplkart.wert == -1)//Falscher index: Betrug/Spielfehler
                                    {
                                        sendcom(new string[] { ServerChatMessages.Gamekartdenied, "Spielfehler: Karte nicht vorhanden!\r\n", ServerChatMessages.Playerdran });
                                        break;
                                    }
                                    else
                                        if (Server.Stapel.zweiziehen && neuplkart.wert > 0) //man muss 2 ziehen oder 7 legen, legt aber etwas anderes?
                                        {
                                            sendcom(new string[] { ServerChatMessages.Gamekartdenied, "7 legen oder 2 karten ziehen!\r\n", ServerChatMessages.Playerdran });
                                            break;
                                        }
                                        else //keine Sonderbeschränkungen
                                            if (!Server.Stapel.aktkart.match(neuplkart)) //passt die Karte überhaupt? (Bube passt immer)
                                            {
                                                sendcom(new string[] { ServerChatMessages.Gamekartdenied, "Karte passt nicht!\r\n", ServerChatMessages.Playerdran });
                                                break;
                                            }
                                            else //wenn sie passt (übrigens könnte man die else auch weg lassen wegen dem break, das Einrücken macht's allerdings auch übersichtlicher
                                            {
                                                if (!Server.Spielerhand[cName].legen(neuplkart))//Lege die Karte aus der Hand (Wenn vorhanden ;) )
                                                {
                                                    sendcom(new string[] { ServerChatMessages.Gamekartdenied, "Spielfehler: Karte nicht vorhanden!\r\n", ServerChatMessages.Playerdran });
                                                    break;
                                                }
                                               
                                                if (!Server.Stapel.ablegen(neuplkart))//Nun die Karte auf den Stapel legen => aktkarte und aktkarte wird frei
                                                {//da ist was schief gegangen... Karte schon im Stapel vorhanden? Betrug!
                                                    Server.Spielerhand[cName].austeilen(neuplkart);
                                                    sendcom(new string[] { ServerChatMessages.Gamekartdenied, "Spielfehler: Karte doppelt!\r\n", ServerChatMessages.Playerdran });
                                                    break;
                                                }
                                                if (neuplkart.wert == 0) Server.Stapel.zweiziehen = true; // 7 gelegt: nächter 2 ziehen oder 7 legen.
                                                if (Server.Spielerhand[cName].Anzahl == 0) //Hat dieser Spieler noch karten?
                                                {
                                                    Server.Spielerhand.Remove(cName); //nein? dann gewonnen!
                                                    Server.spieler.Remove(cName);
                                                    Server.gewonnene++; //1. Gewinner, 2. Gewinner etc. 0: verloren, -1: Stapel leer-> unentschieden
                                                    sendcom(new string[] { ServerChatMessages.Gameend, Convert.ToString(Server.gewonnene) });

                                                    if (Server.Spielerhand.Count == 1) //nur noch ein Spieler übrig?
                                                    {
                                                        Server.messageM.WaitOne(); //tja... verloren... oder "Letzer" Gewinner^^
                                                        broadcastspieler(new string[] { ServerChatMessages.Gameend, "0" });
                                                        Server.messageM.ReleaseMutex();
                                                        Server.Spielerhand.Clear();
                                                        Server.spieler.Clear();
                                                    }
                                                }
                                                if (Server.spieler.Count > 0) //gibt's noch Spieler? hier wird der nächste ausgewählt
                                                {
                                                    curkartindex = Server.spieler.IndexOfKey(cName); //Index des aktuellen Spielers
                                                    if (curkartindex == Server.spieler.Count - 1) curkartindex = 0; else curkartindex++; //setze Index auf nächsten Spieler in der Runde
                                                    if (neuplkart.wert == 1) //8 gelegt (und an dieser Stelle sind Karten passend)? dann index nochmal eins vor! 
                                                    {
                                                        if (curkartindex == Server.spieler.Count - 1) curkartindex = 0; else curkartindex++;
                                                    }
                                                    Server.Stapel.aktspielername = Server.spieler.Keys[curkartindex]; //nun ist der dran, auf den wir den index vorhin geschoben haben
                                                }

                                                Server.messageM.WaitOne();
                                                broadcastspieler(ServerChatMessages.newcardavail);//neue karten verfügbar! siehe "case ClientChatMessages.Gamedrawcard:" für details
                                                Server.messageM.ReleaseMutex();
                                            }
                                }
                                break;
                            case ClientChatMessages.requestcards: //neue Karteninfos beantragen
                                //Server.messageM.WaitOne();
                                string ubertrag2 = "";
                                if (Server.spieler.Count == 0) break; //Keine Spieler mehr da...

                                for (int j = 0; j < Server.Spielerhand.Count; j++) //Kartenanzahl aller Spieler
                                    ubertrag2 += Convert.ToChar(2) + "" + Server.Spielerhand.Values[j].Anzahl;

                                ausgab = new string[Server.spieler.Count]; //Spielernamen, s.o. (ClientChatMessages.Gamerequestplayers) wegen Algorithmus
                                Server.spieler.Keys.CopyTo(ausgab, 0);

                                sendcom(new string[] { ServerChatMessages.Gameinfosend,//Hier sind Spielerinfos
                                    string.Join(Convert.ToChar(2).ToString(), ausgab),//Spielerliste
                                    ServerChatMessages.Gameaktkarten, //Hier sind Karteninfos
                                    Server.Spielerhand[cName].getallkarts(), //deine karten
                                    ubertrag2.Substring(1), //Anzahl Karten anderer Spieler
                                    Server.Stapel.aktkart.ToString(), //Aktuelle Karte des Stapels
                                    Server.Stapel.aktspielername}); //Aktueller Spieler (Dran!)

                                //writeClient.Write(ServerChatMessages.Gameinfosend);
                                //writeClient.Write(string.Join(Convert.ToChar(2).ToString(), ausgab));

                                //writeClient.Write(ServerChatMessages.Gameaktkarten);
                                //writeClient.Write(Server.Spielerhand[cName].getallkarts());
                                //writeClient.Write(ubertrag2.Substring(1));
                                //writeClient.Write(Server.Stapel.aktkart.ToString());
                                //writeClient.Write(Server.Stapel.aktspielername);

                                //Server.messageM.ReleaseMutex();

                                break;
                            case ClientChatMessages.RequestGame: //Mitspielen!
                                if (gamerunning()) //Nur, wenn noch kein Spiel läuft
                                {
                                    //messageM.WaitOne();
                                    sendcom(new string[] { "Server: Spiel läuft bereits!\r\n", ServerChatMessages.DenyGame });
                                    //writeClient.Write("Server: Spiel läuft bereits!\r\n");
                                    //writeClient.Write(ServerChatMessages.DenyGame);
                                    //messageM.ReleaseMutex();
                                    break;
                                }
                                Server.spieler.Clear(); //Gamereset
                                //messageM.WaitOne();
                                if (Server.clients.Count > 1&& Server.clients.Count<6) //min 2 Mitspieler! max 4, da 5*5=25 und 32 max. karten
                                {
                                    broadcast(ServerChatMessages.RequestGame);
                                }
                                else if (Server.clients.Count == 1)
                                {
                                    sendcom(new string[] { "Server: keine Mitspieler (min 1)!\r\n", ServerChatMessages.DenyGame });
                                    //writeClient.Write("Server: keine Mitspieler!\r\n");
                                    //writeClient.Write(ServerChatMessages.DenyGame);
                                }
                                else {
                                    sendcom(new string[] { "Server: zu viele Mitspieler (max 4)!\r\n", ServerChatMessages.DenyGame });
                                    //writeClient.Write("Server: keine Mitspieler!\r\n");
                                    //writeClient.Write(ServerChatMessages.DenyGame);
                                }
                                //messageM.ReleaseMutex();
                                break;
                            case ClientChatMessages.RequestSend: //Chat
                                string m = readClient.ReadString();
                                Server.messageM.WaitOne();
                                broadcast(m); //An alle was ankam!
                                Server.messageM.ReleaseMutex();
                                break;
                            case ClientChatMessages.Disconnect: //Client beendet sich
                                client.Close(); //client schließen
                                Server.messageM.WaitOne();
                                broadcast(cName + " hat den Chat verlassen" + Convert.ToChar(13) + Convert.ToChar(10)); //Wieder an alle
                                Server.clients.Remove(cName); //client entfernen
                                broadcast(""); //wegen Client-Anzahl!
                                Server.messageM.ReleaseMutex();
                                break;
                            default:
                                break;
                        }
                    } while (message != ClientChatMessages.Disconnect); //Endlosschleife, bis Client sich beendet (Erinnerung: diese Klasse ist je einem Clienten zugeordnet)
                }
                else {
                    writeClient.Write(ServerChatMessages.authFail); //Nicht die gewünschte Begrüßung. 
                }
            }
            catch (IOException e) { } //Verbindungsprobleme mit CLienten: Client zeigt Probleme an...
            catch (SocketException e) { }
        }
    }


}
