(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     32039,       1024]
NotebookOptionsPosition[     28772,        923]
NotebookOutlinePosition[     29180,        940]
CellTagsIndexPosition[     29137,        937]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Computer\[UDoubleDot]bungen", "Title"],

Cell["Quantenmechanik", "Subtitle"],

Cell["\[CapitalUDoubleDot]bung 2: Potentialtopf in 1D", "Subsubtitle",
 CellChangeTimes->{{3.5116788003161774`*^9, 3.5116788008361783`*^9}}],

Cell[CellGroupData[{

Cell["Definitionen", "Section"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], "\n", 
 RowBox[{
  RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetCoordinates", "[", 
   RowBox[{"Cartesian", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}], "]"}], ";", 
  RowBox[{"bed", "=", 
   RowBox[{
    RowBox[{"\[HBar]", ">", "0"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}], " ", "&&", " ", 
    RowBox[{"x", "\[Element]", " ", "Reals"}], " ", "&&", " ", 
    RowBox[{"a", ">", "0"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Needs", "[", "\"\<NumericalMath`IntervalRoots`\>\"", "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.5116831355612173`*^9, 3.5116831397812233`*^9}, {
  3.51505110291501*^9, 3.5150511039550114`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["L\[ODoubleDot]sung der SGL", "Section"],

Cell[TextData[{
 "das Potential hat die folgende Form :\n",
 Cell[BoxData[
  RowBox[{"V", "=", 
   TagBox[
    RowBox[{
     StyleBox["{",
      ShowAutoStyles->False], 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Vl", 
         StyleBox["                 ",
          ShowAutoStyles->True], 
         StyleBox["f\[UDoubleDot]r",
          ShowAutoStyles->True], 
         StyleBox[" ",
          ShowAutoStyles->True], 
         StyleBox["x",
          ShowAutoStyles->True]}], 
        StyleBox[" ",
         ShowAutoStyles->True], 
        StyleBox["<",
         ShowAutoStyles->True], 
        StyleBox[
         RowBox[{"-", "a"}],
         ShowAutoStyles->True]}], 
       StyleBox["   ",
        ShowAutoStyles->True], 
       StyleBox["\[IndentingNewLine]",
        ShowAutoStyles->True], 
       StyleBox[
        RowBox[{
         RowBox[{
          RowBox[{"0", "               ", "f\[UDoubleDot]r"}], " ", "-", 
          "a"}], "<", "x", "<", "a"}],
        ShowAutoStyles->True], "\[IndentingNewLine]", "Vr", "         ", 
       "f\[UDoubleDot]r", " ", "x"}], ">", "a"}]}],
    #& ]}]]]
}], "Text"],

Cell["\<\
L\[ODoubleDot]sung der Schr\[ODoubleDot]dingergleichung f\[UDoubleDot]r die \
einzelnen 3 Teilbereiche hat die Form:\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SGL", ":=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"\[Psi]", "''"}], "[", "x", "]"}], " ", "+", 
     RowBox[{
      SuperscriptBox["k", "2"], " ", 
      RowBox[{"\[Psi]", "[", "x", "]"}]}]}], "==", "0"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"DSolve", "[", 
  RowBox[{"SGL", ",", "\[Psi]", ",", "x"}], "]"}]}], "Input"],

Cell["\<\
L\[ODoubleDot]sungen in den drei Bereichen unter Ber\[UDoubleDot]cksichtigung \
physikalischer Gesichtspunkte:\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]a", "[", "x_", "]"}], ":=", 
   RowBox[{"Al", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"kl", " ", "x"}]]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]b", "[", "x_", "]"}], ":=", 
   RowBox[{
    RowBox[{"A", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[ImaginaryI]", " ", "k", " ", "x"}]]}], "+", 
    RowBox[{"B", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", "k", " ", "x"}]]}]}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]c", "[", "x_", "]"}], ":=", 
   RowBox[{"Ar", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "kr"}], " ", "x"}]]}]}], ";"}]}], "Input"],

Cell["\<\
Definition von kl, k und kr unter Ber\[UDoubleDot]cksichtigung von \
Ee<min(Vr,Vl) und Ee>0 -> nur gebundene Zust\[ADoubleDot]nde :\
\>", "Text"],

Cell[BoxData[
 RowBox[{"krule", ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"kl", "->", 
     FractionBox[
      SqrtBox[
       RowBox[{"2", " ", "m", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "Ee"}], "+", "Vl"}], ")"}]}]], "\[HBar]"]}], " ", ",", 
    RowBox[{"k", "->", 
     FractionBox[
      SqrtBox[
       RowBox[{"2", " ", "m", " ", "Ee"}]], "\[HBar]"]}], ",", 
    RowBox[{"kr", "->", 
     FractionBox[
      SqrtBox[
       RowBox[{"2", " ", "m", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "Ee"}], "+", "Vr"}], ")"}]}]], "\[HBar]"]}]}], 
   "}"}]}]], "Input"],

Cell["Festlegung der Bedingungen an kl, k und kr", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"bed", "=", 
   RowBox[{"bed", " ", "&&", " ", 
    RowBox[{"kl", ">", "0"}], "  ", "&&", " ", 
    RowBox[{"kr", ">", "0"}], " ", "&&", " ", 
    RowBox[{"k", ">", "0"}]}]}], ";"}]], "Input"],

Cell["\<\
L\[ODoubleDot]sung der Anschlu\[SZ]bedingung bei x=-a und x=a :\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Anschlu\[SZ]", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"\[Phi]a", "[", 
       RowBox[{"-", "a"}], "]"}], "==", 
      RowBox[{"\[Phi]b", "[", 
       RowBox[{"-", "a"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        SubscriptBox["\[PartialD]", "x"], 
        RowBox[{"\[Phi]a", "[", "x", "]"}]}], "==", 
       RowBox[{
        SubscriptBox["\[PartialD]", "x"], 
        RowBox[{"\[Phi]b", "[", "x", "]"}]}]}], "/.", 
      RowBox[{"x", "\[Rule]", 
       RowBox[{"-", "a"}]}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[Phi]b", "[", "a", "]"}], "==", 
      RowBox[{"\[Phi]c", "[", "a", "]"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        SubscriptBox["\[PartialD]", "x"], 
        RowBox[{"\[Phi]b", "[", "x", "]"}]}], "==", 
       RowBox[{
        SubscriptBox["\[PartialD]", "x"], 
        RowBox[{"\[Phi]c", "[", "x", "]"}]}]}], "/.", 
      RowBox[{"x", "\[Rule]", "a"}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Parameter2", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{"Anschlu\[SZ]", ",", 
     RowBox[{"{", 
      RowBox[{"Al", ",", "A", ",", "B", ",", "Ar"}], "}"}]}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{3.451725301515625*^9}],

Cell["\<\
Solve gibt nur die triviale L\[ODoubleDot]sung aus \[Rule] Untersuchung der \
Koeffizientendeterminante\
\>", "Text"],

Cell[BoxData[
 RowBox[{"Anschlu\[SZ]", "//", " ", "MatrixForm"}]], "Input"],

Cell[BoxData[
 RowBox[{"KoeffMatrix", "=", 
  RowBox[{"(", GridBox[{
     {
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "a"}], " ", "kl"}]], 
      RowBox[{"-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "\[ImaginaryI]"}], " ", "a", " ", "k"}]]}], 
      RowBox[{"-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"\[ImaginaryI]", " ", "a", " ", "k"}]]}], "0"},
     {
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "a"}], " ", "kl"}]], " ", "kl"}], 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "\[ImaginaryI]"}], " ", "a", " ", "k"}]], " ", "k"}], 
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"\[ImaginaryI]", " ", "a", " ", "k"}]], " ", "k"}], "0"},
     {"0", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "a", " ", "k"}]], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "a", " ", "k"}]], 
      RowBox[{"-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "a"}], " ", "kr"}]]}]},
     {"0", 
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"\[ImaginaryI]", " ", "a", " ", "k"}]], " ", "k"}], 
      RowBox[{
       RowBox[{"-", " ", "\[ImaginaryI]"}], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "\[ImaginaryI]"}], " ", "a", " ", "k"}]], " ", "k"}], 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "a"}], " ", "kr"}]], " ", "kr", " "}]}
    }], ")"}], " "}]], "Input"],

Cell["\<\
Eigenwertbedingung: Determinante der Koeffizientenmatrix mu\[SZ] 0 sein\
\>", "Text"],

Cell[BoxData[
 RowBox[{"bedingung", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"ComplexExpand", "[", 
     RowBox[{
      RowBox[{"Det", "[", "KoeffMatrix", "]"}], "\[Equal]", "0"}], "]"}], ",",
     "bed"}], "]"}]}]], "Input"],

Cell["\<\
Diese Bedingung kann nicht weiter aufgel\[ODoubleDot]st werden \[Rule] \
numerische Berechnung der Eigenwerte\
\>", "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Numerische Bestimmung der Energieeigenwerte", "Section"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"bedingung", "/.", "krule"}], ",", "bed"}], "]"}]], "Input"],

Cell["Einsetzen atomarer Einheiten und numerischer Werte", "Text"],

Cell[BoxData[
 RowBox[{"numval", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"m", "\[Rule]", "1"}], ",", 
    RowBox[{"\[HBar]", "\[Rule]", "1"}], ",", 
    RowBox[{"Vl", "\[Rule]", "5"}], ",", 
    RowBox[{"Vr", "\[Rule]", "5"}], ",", 
    RowBox[{"a", "\[Rule]", "4"}]}], "}"}]}]], "Input"],

Cell["numerische Eigenwertgleichung:", "Text"],

Cell[BoxData[
 RowBox[{"pgl", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"bedingung", "/.", "krule"}], " ", "/.", " ", "numval"}], ",", 
    "bed"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"pgl", "=", 
  RowBox[{
   RowBox[{"pgl", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "-", 
   RowBox[{"pgl", "[", 
    RowBox[{"[", "2", "]"}], "]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", "pgl", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Ee", ",", "0.0", ",", "10.0"}], "}"}]}], "]"}]], "Input"],

Cell["\<\
Bestimmung aller Nullstellen und damit der Energieeigenwerte:\
\>", "Text"],

Cell[BoxData[
 RowBox[{"eigenwerteinterval", "=", 
  RowBox[{"IntervalNewton", "[", 
   RowBox[{"pgl", ",", "Ee", ",", 
    RowBox[{"Interval", "[", 
     RowBox[{"{", 
      RowBox[{"0.001", ",", "4.999"}], "}"}], "]"}], ",", "0.0001", ",", 
    RowBox[{"MaxRecursion", "\[Rule]", "50"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"eigenwerte", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"eigenwerteinterval", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "1"}], "]"}], "]"}], "+", 
       RowBox[{"eigenwerteinterval", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "2"}], "]"}], "]"}]}], ")"}], "/", "2"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{"Length", "[", "eigenwerteinterval", "]"}]}], "}"}]}], 
   "]"}]}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Bestimmung der Wellenfunktionen", "Section"],

Cell["\<\
Bestimmung der Parameter in den Wellenfunktionen zu den jeweiligen \
Energieeigenwerten:\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Anschlu\[SZ]liste", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Anschlu\[SZ]", "  ", "/.", "krule"}], " ", "/.", "numval"}], 
      " ", "/.", " ", 
      RowBox[{"Ee", "\[Rule]", 
       RowBox[{"eigenwerte", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "eigenwerte", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"parameterliste", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Anschlu\[SZ]liste", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "2"}], "]"}], "]"}], ",", 
         RowBox[{"Anschlu\[SZ]liste", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "4"}], "]"}], "]"}], ",", 
         RowBox[{"Anschlu\[SZ]liste", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "1"}], "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"A", ",", "B", ",", "Ar"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "eigenwerte", "]"}]}], "}"}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.4517258053125*^9, 3.45172582315625*^9}, {
  3.451725888734375*^9, 3.4517258935625*^9}}],

Cell["\<\
Bestimmung des 4. Parameter \[UDoubleDot]ber Normierung\
\>", "Text"],

Cell["Normierung der Wellenfunktion:", "Text"],

Cell[BoxData[
 RowBox[{"Norm2", "=", 
  RowBox[{
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Integrate", "[", 
       RowBox[{
        RowBox[{"FullSimplify", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"\[Phi]a", "[", "x", "]"}], " ", 
           RowBox[{"Conjugate", "[", 
            RowBox[{"\[Phi]a", "[", "x", "]"}], "]"}]}], ",", "bed"}], "]"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "\[Infinity]"}], ",", 
          RowBox[{"-", "a"}]}], "}"}]}], "]"}], "+", 
      RowBox[{"Integrate", "[", 
       RowBox[{
        RowBox[{"FullSimplify", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"\[Phi]b", "[", "x", "]"}], " ", 
           RowBox[{"Conjugate", "[", 
            RowBox[{"\[Phi]b", "[", "x", "]"}], "]"}]}], ",", "bed"}], "]"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "a"}], ",", "a"}], "}"}]}], "]"}], "+", 
      RowBox[{"Integrate", "[", 
       RowBox[{
        RowBox[{"FullSimplify", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"\[Phi]c", "[", "x", "]"}], " ", 
           RowBox[{"Conjugate", "[", 
            RowBox[{"\[Phi]c", "[", "x", "]"}], "]"}]}], ",", "bed"}], "]"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "a", ",", "\[Infinity]"}], "}"}]}], "]"}]}], ",", 
     "bed"}], "]"}], "\[Equal]", "1"}]}]], "Input",
 CellChangeTimes->{
  3.45172536365625*^9, {3.451725695375*^9, 3.451725702734375*^9}, {
   3.451725837953125*^9, 3.451725842765625*^9}}],

Cell["Einsetzen der Parameter mit numerischen Werten", "Text",
 CellChangeTimes->{{3.455867456273875*^9, 3.45586747044575*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Norm2", " ", "/.", 
     RowBox[{"parameterliste", "[", 
      RowBox[{"[", 
       RowBox[{"2", ",", "1"}], "]"}], "]"}]}], " ", "/.", "  ", "krule"}], 
   " ", "/.", " ", "numval"}], " ", "/.", " ", 
  RowBox[{"Ee", "->", 
   RowBox[{"eigenwerte", "[", 
    RowBox[{"[", "2", "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.451725920828125*^9, 3.451725928828125*^9}}],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Norm2", " ", "/.", 
       RowBox[{"parameterliste", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "1"}], "]"}], "]"}]}], " ", "/.", "  ", "krule"}], 
     " ", "/.", " ", "numval"}], " ", "/.", " ", 
    RowBox[{"Ee", "->", 
     RowBox[{"eigenwerte", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}]}], ",", 
   RowBox[{"Al", "\[Element]", "Reals"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.45172594865625*^9, 3.451725959046875*^9}}],

Cell["\<\
Problem : da Werte nur numerisch sind, kann die Gleichung nicht exakt erf\
\[UDoubleDot]llt werden => Al wird von Hand rein reell gew\[ADoubleDot]hlt\
\>", "Text",
 CellChangeTimes->{{3.4558674885395*^9, 3.455867559617625*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Norm2", " ", "/.", 
      RowBox[{"parameterliste", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "1"}], "]"}], "]"}]}], " ", "/.", "  ", "krule"}], 
    " ", "/.", " ", "numval"}], " ", "/.", " ", 
   RowBox[{"Ee", "->", 
    RowBox[{"eigenwerte", "[", 
     RowBox[{"[", "2", "]"}], "]"}]}]}], " ", "/.", 
  RowBox[{
   RowBox[{"Conjugate", "[", "Al", "]"}], "\[Rule]", "Al"}]}]], "Input",
 CellChangeTimes->{{3.451725972671875*^9, 3.451725984421875*^9}}],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"%", ",", "Al"}], "]"}]], "Input",
 CellChangeTimes->{{3.451725993578125*^9, 3.4517259979375*^9}}],

Cell["\<\
Dies zeigt, dass obwohl Al formal rein reell gew\[ADoubleDot]hlt wurde, ein \
sehr kleiner Imagin\[ADoubleDot]rteil vorliegt. Dieser ist daf\[UDoubleDot]r \
verantwortlich, dass die Gleichung oben nicht nach Al aufgel\[ODoubleDot]st \
werden konnte und ist eine Absch\[ADoubleDot]tzung des numerischen Fehlers.\
\>", "Text",
 CellChangeTimes->{{3.455867568711375*^9, 3.455867653805125*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Alrule", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"Norm2", " ", "/.", 
            RowBox[{"parameterliste", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "1"}], "]"}], "]"}]}], " ", "/.", "  ", 
           "krule"}], " ", "/.", " ", "numval"}], " ", "/.", " ", 
         RowBox[{"Ee", "->", 
          RowBox[{"eigenwerte", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}]}], "/.", 
        RowBox[{
         RowBox[{"Conjugate", "[", "Al", "]"}], "\[Rule]", "Al"}]}], ",", 
       "Al"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "eigenwerte", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"parameterliste2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"parameterliste", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "1"}], "]"}], "]"}], "/.", 
        RowBox[{"Alrule", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "1"}], "]"}], "]"}]}], ",", 
       RowBox[{"Alrule", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "1"}], "]"}], "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "eigenwerte", "]"}]}], "}"}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{
  3.451725373125*^9, {3.45172601484375*^9, 3.451726044171875*^9}}],

Cell[BoxData["Alrule"], "Input",
 CellChangeTimes->{{3.451725450796875*^9, 3.45172545259375*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Graphische Darstellung der Wellenfunktion", "Section"],

Cell["Definition der Gesamtwellenfunktion:", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]", "[", 
    RowBox[{"x_", ",", "i_"}], "]"}], ":=", 
   RowBox[{"Piecewise", "[", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"\[Phi]a", "[", "x", "]"}], "/.", "krule"}], "/.", 
           "numval"}], "/.", 
          RowBox[{"parameterliste2", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], "/.", 
         RowBox[{"Ee", "\[Rule]", 
          RowBox[{"eigenwerte", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}]}], ",", 
        RowBox[{
         RowBox[{"x", "\[LessEqual]", 
          RowBox[{"-", "a"}]}], "/.", "numval"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"\[Phi]b", "[", "x", "]"}], "/.", "krule"}], "/.", 
           "numval"}], "/.", 
          RowBox[{"parameterliste2", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], "/.", 
         RowBox[{"Ee", "\[Rule]", 
          RowBox[{"eigenwerte", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "a"}], "<", "x", "<", "a"}], "/.", "numval"}]}], "}"}],
       ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"\[Phi]c", "[", "x", "]"}], "/.", "krule"}], "/.", 
           "numval"}], "/.", 
          RowBox[{"parameterliste2", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], "/.", 
         RowBox[{"Ee", "\[Rule]", 
          RowBox[{"eigenwerte", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}]}], ",", 
        RowBox[{
         RowBox[{"a", "\[LessEqual]", "x"}], "/.", "numval"}]}], "}"}]}], 
     "\[IndentingNewLine]", "}"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.515741057202015*^9, 3.5157412202446527`*^9}}],

Cell["Darstellung der Wellenfunktion:", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"test", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"Re", "[", 
            RowBox[{"\[Psi]", "[", 
             RowBox[{"x", ",", "i"}], "]"}], "]"}], "/", "2"}], "+", 
          RowBox[{"eigenwerte", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], ",", 
         RowBox[{"eigenwerte", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "7"}], ",", "7"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.2"}], ",", "5.2"}], "}"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "eigenwerte", "]"}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.45172625215625*^9, 3.4517262635625*^9}, {
   3.4517269290490465`*^9, 3.4517269308771715`*^9}, 3.4517269952677965`*^9}],

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"test", ",", 
   RowBox[{"AspectRatio", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.45172619484375*^9, 3.451726233578125*^9}, {
  3.451726271765625*^9, 3.451726273734375*^9}}],

Cell["Definition der Gesamtdichte:", "Text",
 CellChangeTimes->{{3.4517263004375*^9, 3.451726304875*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"n", "[", 
    RowBox[{"x_", ",", "i_"}], "]"}], ":=", 
   RowBox[{"Piecewise", "[", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"Abs", "[", 
              RowBox[{"\[Phi]a", "[", "x", "]"}], "]"}], "^", "2"}], "/.", 
            "krule"}], "/.", "numval"}], "/.", 
          RowBox[{"parameterliste2", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], "/.", 
         RowBox[{"Ee", "\[Rule]", 
          RowBox[{"eigenwerte", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}]}], ",", 
        RowBox[{
         RowBox[{"x", "\[LessEqual]", 
          RowBox[{"-", "a"}]}], "/.", "numval"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"Abs", "[", 
              RowBox[{"\[Phi]b", "[", "x", "]"}], "]"}], "^", "2"}], "/.", 
            "krule"}], "/.", "numval"}], "/.", 
          RowBox[{"parameterliste2", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], "/.", 
         RowBox[{"Ee", "\[Rule]", 
          RowBox[{"eigenwerte", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "a"}], "<", "x", "<", "a"}], "/.", "numval"}]}], "}"}],
       ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"Abs", "[", 
              RowBox[{"\[Phi]c", "[", "x", "]"}], "]"}], "^", "2"}], "/.", 
            "krule"}], "/.", "numval"}], "/.", 
          RowBox[{"parameterliste2", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], "/.", 
         RowBox[{"Ee", "\[Rule]", 
          RowBox[{"eigenwerte", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}]}], ",", 
        RowBox[{
         RowBox[{"a", "\[LessEqual]", "x"}], "/.", "numval"}]}], "}"}]}], 
     "\[IndentingNewLine]", "}"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.515741245923489*^9, 3.5157412628935127`*^9}}],

Cell["Darstellung der Dichte:", "Text",
 CellChangeTimes->{{3.451726420921875*^9, 3.4517264259375*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"test", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"n", "[", 
            RowBox[{"x", ",", "i"}], "]"}], "/", "2"}], "+", 
          RowBox[{"eigenwerte", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], ",", 
         RowBox[{"eigenwerte", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "7"}], ",", "7"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"0", ",", "5.2"}], "}"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "eigenwerte", "]"}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.45172625215625*^9, 3.4517262635625*^9}, {
   3.45172639534375*^9, 3.45172641209375*^9}, 3.4517265385021715`*^9, {
   3.4517266169552965`*^9, 3.4517266220802965`*^9}, {3.4517266528302965`*^9, 
   3.4517266598459215`*^9}, {3.4517268945646715`*^9, 3.4517268962209215`*^9}}],

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"test", ",", 
   RowBox[{"AspectRatio", "\[Rule]", "2"}]}], "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Graphische Darstellung der Energieeigenwerte", "Section"],

Cell[BoxData[
 RowBox[{"energieplot", "=", 
  RowBox[{"ListPlot", "[", 
   RowBox[{"eigenwerte", ",", 
    RowBox[{"PlotStyle", "->", 
     RowBox[{"PointSize", "[", "0.02", "]"}]}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"energiefit", "=", 
  RowBox[{"Fit", "[", 
   RowBox[{"eigenwerte", ",", 
    SuperscriptBox["n", "2"], ",", "n"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"energiefitplot", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{"energiefit", ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "0", ",", 
      RowBox[{"Length", "[", "eigenwerte", "]"}]}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"infinitewell", "=", 
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"\[HBar]", "^", "2"}], "*", 
        RowBox[{"\[Pi]", "^", "2"}], "*", 
        RowBox[{
         RowBox[{"n", "^", "2"}], "/", 
         RowBox[{"(", 
          RowBox[{"2", "*", "m", "*", 
           RowBox[{"a", "^", "2"}]}], ")"}]}]}], "/.", "numval"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "0", ",", "8"}], "}"}]}], "]"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Red", ",", 
       RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.515676447708988*^9, 3.51567646600782*^9}, {
  3.515676532486337*^9, 3.515676624183298*^9}, {3.5156766612489634`*^9, 
  3.515676697113426*^9}}],

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"energiefitplot", ",", "energieplot", ",", "infinitewell"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.515676700358232*^9, 3.5156767053502407`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Aufgaben", "Section",
 CellChangeTimes->{3.455867716211375*^9}],

Cell["Was passiert bei einem nicht symmetrischem Potentialverlauf?", "Text",
 CellChangeTimes->{3.455867716211375*^9}],

Cell["\<\
Wie verhalten sich die WF und die Energie bei \[CapitalADoubleDot]nderung der \
Potentialbreite?\
\>", "Text",
 CellChangeTimes->{
  3.455867716211375*^9, {3.5116794040872345`*^9, 3.511679404147235*^9}}],

Cell["\<\
Was passiert bei sehr hohen Potentialen und bei sehr niedrigen? \[Rule] Gibt \
es immer einen gebundenen Zustund, egal wie flach der Potentialtopf ist?\
\>", "Text",
 CellChangeTimes->{3.455867716211375*^9}],

Cell["\<\
Grenzwert von a\[Rule]0 bei V a=const? (delta-Potential)\
\>", "Text",
 CellChangeTimes->{
  3.455867716211375*^9, {3.5116794142772493`*^9, 3.5116794278272676`*^9}}]
}, Closed]]
}, Open  ]]
},
WindowSize->{1350, 730},
WindowMargins->{{3, Automatic}, {Automatic, -30}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (November 13, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 44, 0, 83, "Title"],
Cell[626, 24, 35, 0, 49, "Subtitle"],
Cell[664, 26, 140, 1, 28, "Subsubtitle"],
Cell[CellGroupData[{
Cell[829, 31, 31, 0, 71, "Section"],
Cell[863, 33, 789, 19, 92, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[1689, 57, 45, 0, 41, "Section"],
Cell[1737, 59, 1131, 39, 83, "Text"],
Cell[2871, 100, 140, 3, 29, "Text"],
Cell[3014, 105, 380, 12, 52, "Input"],
Cell[3397, 119, 134, 3, 29, "Text"],
Cell[3534, 124, 768, 25, 75, "Input"],
Cell[4305, 151, 155, 3, 29, "Text"],
Cell[4463, 156, 627, 22, 51, "Input"],
Cell[5093, 180, 58, 0, 29, "Text"],
Cell[5154, 182, 226, 6, 31, "Input"],
Cell[5383, 190, 87, 2, 29, "Text"],
Cell[5473, 194, 1327, 40, 72, "Input"],
Cell[6803, 236, 127, 3, 29, "Text"],
Cell[6933, 241, 75, 1, 31, "Input"],
Cell[7011, 244, 1817, 50, 88, "Input"],
Cell[8831, 296, 95, 2, 29, "Text"],
Cell[8929, 300, 246, 7, 31, "Input"],
Cell[9178, 309, 133, 3, 29, "Text"]
}, Closed]],
Cell[CellGroupData[{
Cell[9348, 317, 62, 0, 41, "Section"],
Cell[9413, 319, 127, 3, 31, "Input"],
Cell[9543, 324, 66, 0, 29, "Text"],
Cell[9612, 326, 294, 8, 31, "Input"],
Cell[9909, 336, 46, 0, 29, "Text"],
Cell[9958, 338, 201, 6, 31, "Input"],
Cell[10162, 346, 186, 6, 31, "Input"],
Cell[10351, 354, 171, 5, 31, "Input"],
Cell[10525, 361, 85, 2, 29, "Text"],
Cell[10613, 365, 310, 7, 31, "Input"],
Cell[10926, 374, 529, 16, 31, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[11492, 395, 50, 0, 41, "Section"],
Cell[11545, 397, 112, 3, 29, "Text"],
Cell[11660, 402, 1394, 40, 52, "Input"],
Cell[13057, 444, 79, 2, 29, "Text"],
Cell[13139, 448, 46, 0, 29, "Text"],
Cell[13188, 450, 1581, 45, 72, "Input"],
Cell[14772, 497, 127, 1, 29, "Text"],
Cell[14902, 500, 431, 12, 31, "Input"],
Cell[15336, 514, 547, 15, 31, "Input"],
Cell[15886, 531, 237, 4, 29, "Text"],
Cell[16126, 537, 538, 15, 31, "Input"],
Cell[16667, 554, 146, 3, 31, "Input"],
Cell[16816, 559, 400, 6, 29, "Text"],
Cell[17219, 567, 1576, 47, 52, "Input"],
Cell[18798, 616, 97, 1, 31, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[18932, 622, 60, 0, 41, "Section"],
Cell[18995, 624, 52, 0, 29, "Text"],
Cell[19050, 626, 2012, 58, 112, "Input"],
Cell[21065, 686, 47, 0, 29, "Text"],
Cell[21115, 688, 1061, 30, 31, "Input"],
Cell[22179, 720, 237, 5, 31, "Input"],
Cell[22419, 727, 105, 1, 29, "Text"],
Cell[22527, 730, 2238, 64, 112, "Input"],
Cell[24768, 796, 103, 1, 29, "Text"],
Cell[24874, 799, 1140, 30, 31, "Input"],
Cell[26017, 831, 123, 3, 31, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[26177, 839, 63, 0, 41, "Section"],
Cell[26243, 841, 203, 5, 31, "Input"],
Cell[26449, 848, 157, 4, 33, "Input"],
Cell[26609, 854, 233, 6, 31, "Input"],
Cell[26845, 862, 860, 23, 31, "Input"],
Cell[27708, 887, 195, 4, 31, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[27940, 896, 69, 1, 41, "Section"],
Cell[28012, 899, 118, 1, 29, "Text"],
Cell[28133, 902, 213, 5, 29, "Text"],
Cell[28349, 909, 217, 4, 29, "Text"],
Cell[28569, 915, 175, 4, 29, "Text"]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
