(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    134396,       2730]
NotebookOptionsPosition[    131126,       2616]
NotebookOutlinePosition[    131473,       2631]
CellTagsIndexPosition[    131430,       2628]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Computer\[UDoubleDot]bungen", "Title"],

Cell["Quantenmechanik", "Subtitle"],

Cell["\<\
\[CapitalUDoubleDot]bung 3: freies Wellenpaket in 1D\
\>", "Subsubtitle",
 CellChangeTimes->{{3.5116789271084404`*^9, 3.5116789275284414`*^9}, {
  3.5156760991225624`*^9, 3.5156760992317624`*^9}}],

Cell[CellGroupData[{

Cell["Definitionen", "Section"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], "\n", 
 RowBox[{
  RowBox[{"bed", "=", 
   RowBox[{
    RowBox[{"\[HBar]", ">", "0"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}], " ", "&&", " ", 
    RowBox[{"x", "\[Element]", " ", "Reals"}], " ", "&&", " ", 
    RowBox[{"a", ">", "0"}], " ", "&&", " ", 
    RowBox[{"b", ">", "0"}], " ", "&&", " ", 
    RowBox[{"k0", ">", "0"}], " ", "&&", " ", 
    RowBox[{"En", ">", "0"}], " ", "&&", " ", 
    RowBox[{"t", ">", "0"}], " ", "&&", " ", 
    RowBox[{"k", ">", "0"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.511683185349395*^9, 3.5116831926214514`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Darstellung des Wellenpaketes", "Section"],

Cell["\<\
freies Teilchen -> \[CapitalUDoubleDot]berlagerung von ebenen Wellen :\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Psi]", "[", 
   RowBox[{"x_", ",", "t_"}], "]"}], ":=", 
  RowBox[{
   SubsuperscriptBox["\[Integral]", 
    RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
   RowBox[{
    RowBox[{"\[Psi]f", "[", "k", "]"}], 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[ImaginaryI]", 
      RowBox[{"(", " ", 
       RowBox[{
        RowBox[{"k", " ", "x"}], "-", 
        RowBox[{
         FractionBox[
          RowBox[{"En", "[", "k", "]"}], "\[HBar]"], "t"}]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", "k"}]}]}]}]], "Input"],

Cell["\<\
Abh\[ADoubleDot]ngigkeit der Energie von k:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Erule", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"En", "[", "k", "]"}], "\[Rule]", 
    FractionBox[
     RowBox[{
      SuperscriptBox["\[HBar]", "2"], 
      SuperscriptBox["k", "2"]}], 
     RowBox[{"2", " ", "m"}]]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"En", "[", "k", "]"}], "\[Rule]", 
   FractionBox[
    RowBox[{
     SuperscriptBox["k", "2"], " ", 
     SuperscriptBox["\[HBar]", "2"]}], 
    RowBox[{"2", " ", "m"}]]}], "}"}]], "Output",
 CellChangeTimes->{
  3.51998813584375*^9, {3.519990805265625*^9, 3.519990832546875*^9}}]
}, Open  ]],

Cell["\<\
Vorgabe einer Anfagnsverteilung zum Zeitpunkt t=0 (Gau\[SZ]):\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Psi]0", "[", "x_", "]"}], "=", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"\[Pi]", " ", 
      SuperscriptBox["b", "2"]}], ")"}], 
    FractionBox[
     RowBox[{"-", "1"}], "4"]], 
   SuperscriptBox["\[ExponentialE]", 
    FractionBox[
     RowBox[{"-", 
      SuperscriptBox["x", "2"]}], 
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"]}]]], 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"\[ImaginaryI]", " ", "k0", " ", "x"}]]}]}]], "Input"],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"\[ImaginaryI]", " ", "k0", " ", "x"}], "-", 
    FractionBox[
     SuperscriptBox["x", "2"], 
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"]}]]}]], 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox["b", "2"], ")"}], 
    RowBox[{"1", "/", "4"}]], " ", 
   SuperscriptBox["\[Pi]", 
    RowBox[{"1", "/", "4"}]]}]]], "Output",
 CellChangeTimes->{
  3.519988135890625*^9, {3.519990808484375*^9, 3.519990833984375*^9}}]
}, Open  ]],

Cell["Vorgabe numerischer Werte zur Darstellung:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"numval", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[HBar]", "\[Rule]", "1"}], ",", 
    RowBox[{"m", "\[Rule]", "1"}], ",", 
    RowBox[{"k0", "\[Rule]", "10"}], ",", 
    RowBox[{"a", "\[Rule]", "1"}], ",", 
    RowBox[{"b", "\[Rule]", "1"}]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[HBar]", "\[Rule]", "1"}], ",", 
   RowBox[{"m", "\[Rule]", "1"}], ",", 
   RowBox[{"k0", "\[Rule]", "10"}], ",", 
   RowBox[{"a", "\[Rule]", "1"}], ",", 
   RowBox[{"b", "\[Rule]", "1"}]}], "}"}]], "Output",
 CellChangeTimes->{3.519988135921875*^9, 3.519990836078125*^9, 
  3.519990895796875*^9}]
}, Open  ]],

Cell["graphische Darstellung der Anfangsverteilung:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Re", "[", 
     RowBox[{"\[Psi]0", "[", "x", "]"}], "]"}], "/.", "numval"}], " ", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwUV3c8198XNj72TINKfZGQlciocM2KMipKdiXJXiFJyMxIopAQZWdEGcm5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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-4, 4}, {-0.7153042973849572, 0.7511111642002679}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.5199881360625*^9, 3.519990837484375*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"\[Psi]0", "[", "x", "]"}], "*", 
     RowBox[{"Conjugate", "[", 
      RowBox[{"\[Psi]0", "[", "x", "]"}], "]"}]}], "/.", "numval"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw1m3c8Vm/4xx/b8+B5pDSVEYooM1HOdRIlvnZRZFVGyE7ZI0lkJCtl762Q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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-4, 4}, {0., 0.5641893696582927}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.51998813621875*^9}]
}, Open  ]],

Cell["\<\
Bestimmung der Entwicklungskoeffizienten aus der Anfangsverteilung:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Psi]0", "[", "x", "]"}], "\[Equal]", 
  RowBox[{"\[Psi]", "[", 
   RowBox[{"x", ",", "0"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"\[ImaginaryI]", " ", "k0", " ", "x"}], "-", 
     FractionBox[
      SuperscriptBox["x", "2"], 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"]}]]}]], 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox["b", "2"], ")"}], 
     RowBox[{"1", "/", "4"}]], " ", 
    SuperscriptBox["\[Pi]", 
     RowBox[{"1", "/", "4"}]]}]], "\[Equal]", 
  RowBox[{
   SubsuperscriptBox["\[Integral]", 
    RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[ImaginaryI]", " ", "k", " ", "x"}]], " ", 
     RowBox[{"\[Psi]f", "[", "k", "]"}]}], 
    RowBox[{"\[DifferentialD]", "k"}]}]}]}]], "Output",
 CellChangeTimes->{3.519988136375*^9, 3.51999088765625*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Psi]f", "[", "k_", "]"}], "=", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", " ", "\[Pi]"}]], 
   RowBox[{
    SubsuperscriptBox["\[Integral]", 
     RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", "k", " ", "x"}]], " ", 
     RowBox[{"\[Psi]0", "[", "x", "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Re", "[", 
      SuperscriptBox["b", "2"], "]"}], ">", "0"}], ",", 
    FractionBox[
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], " ", 
        SuperscriptBox["b", "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"k", "-", "k0"}], ")"}], "2"]}]], " ", 
      SqrtBox[
       RowBox[{"2", " ", "\[Pi]"}]]}], 
     SqrtBox[
      FractionBox["1", 
       SuperscriptBox["b", "2"]]]], ",", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "\[ImaginaryI]", " ", 
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"k", "-", "k0"}], ")"}]}], "+", "x"}], ")"}]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"]}]]}]], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"Re", "[", 
         SuperscriptBox["b", "2"], "]"}], "\[LessEqual]", "0"}]}]}], "]"}]}], 
   "]"}], 
  RowBox[{"2", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox["b", "2"], ")"}], 
    RowBox[{"1", "/", "4"}]], " ", 
   SuperscriptBox["\[Pi]", 
    RowBox[{"5", "/", "4"}]]}]]], "Output",
 CellChangeTimes->{3.51998814290625*^9, 3.519990895515625*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Psi]f", "[", "k_", "]"}], "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{
     FractionBox["1", 
      RowBox[{"2", " ", "\[Pi]"}]], 
     RowBox[{
      SubsuperscriptBox["\[Integral]", 
       RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "\[ImaginaryI]"}], " ", "k", " ", "x"}]], " ", 
       RowBox[{"\[Psi]0", "[", "x", "]"}], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}], ",", "bed"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.4547485520625*^9, 3.454748557578125*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox["b"], " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "2"]}], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"k", "-", "k0"}], ")"}], "2"]}]]}], 
  RowBox[{
   SqrtBox["2"], " ", 
   SuperscriptBox["\[Pi]", 
    RowBox[{"3", "/", "4"}]]}]]], "Output",
 CellChangeTimes->{3.519988145359375*^9, 3.51999090403125*^9}]
}, Open  ]],

Cell["graphische Darstellung der Entwicklungskoeffizienten:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Conjugate", "[", 
      RowBox[{"\[Psi]f", "[", "k", "]"}], "]"}], " ", 
     RowBox[{"\[Psi]f", "[", "k", "]"}]}], " ", "/.", "numval"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "30"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "30"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0.1"}], "}"}]}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVV3c4lt8bFyUK2Xt7rXci2/s8z01CKEpkjyIzOzMrsmeEkCRJicgIFUIq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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 30}, {0, 0.1}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.51998814553125*^9, 3.519990910375*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Darstellung der Zeitabh\[ADoubleDot]ngigkeit\
\>", "Section"],

Cell["Dichte:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Rho]", "[", 
   RowBox[{"x_", ",", "t_"}], "]"}], "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"\[Psi]", "[", 
       RowBox[{"x", ",", "t"}], "]"}], " ", 
      RowBox[{"Conjugate", "[", 
       RowBox[{"\[Psi]", "[", 
        RowBox[{"x", ",", "t"}], "]"}], "]"}]}], " ", "/.", "Erule"}], " ", 
    ",", "bed"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.454748595578125*^9, 3.454748607703125*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"b", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"m", " ", "x"}], "-", 
          RowBox[{"k0", " ", "t", " ", "\[HBar]"}]}], ")"}], "2"]}], 
      RowBox[{
       RowBox[{
        SuperscriptBox["b", "4"], " ", 
        SuperscriptBox["m", "2"]}], "+", 
       RowBox[{
        SuperscriptBox["t", "2"], " ", 
        SuperscriptBox["\[HBar]", "2"]}]}]]}]], " ", 
   RowBox[{"Conjugate", "[", 
    FractionBox["1", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["b", "2"], "+", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "t", " ", "\[HBar]"}], "m"]}]]], 
    "]"}]}], 
  RowBox[{
   SqrtBox["\[Pi]"], " ", 
   SqrtBox[
    RowBox[{
     SuperscriptBox["b", "2"], "+", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "t", " ", "\[HBar]"}], 
      "m"]}]]}]]], "Output",
 CellChangeTimes->{3.519988170890625*^9, 3.519991134296875*^9}]
}, Open  ]],

Cell["\<\
Test, ob die Anfangsverteilung  f\[UDoubleDot]r t=0 erf\[UDoubleDot]llt ist:\
\>", "Text",
 CellChangeTimes->{{3.4558681105395*^9, 3.455868111492625*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"\[Rho]", "[", 
       RowBox[{"x", ",", "0"}], "]"}], " ", "/.", "numval"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"\[Psi]0", "[", "x", "]"}], "*", 
       RowBox[{"Conjugate", "[", 
        RowBox[{"\[Psi]0", "[", "x", "]"}], "]"}]}], "/.", "numval"}]}], 
    "}"}], " ", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0.6"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"RGBColor", "[", 
       RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", 
      RowBox[{"RGBColor", "[", 
       RowBox[{"0", ",", "1", ",", "0"}], "]"}]}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[1, 0, 0], LineBox[CompressedData["
1:eJw12nk0Fm+8AHDeNURFiApRiJTQir5jy1IkO0l2WbKUECJL9q0oa9ayhyzZ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     "]]}, 
   {RGBColor[0, 1, 0], LineBox[CompressedData["
1:eJw12nk0Fm+8AHDeNURFiApRiJTQir5jy1IkO0l2WbKUECJL9q0oa9ayhyzZ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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-3, 3}, {0, 0.6}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.519988171046875*^9}]
}, Open  ]],

Cell["\<\
Animation zur Zeitabh\[ADoubleDot]ngigkeit erstellen:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"\[Rho]", "[", 
       RowBox[{"x", ",", "t"}], "]"}], "/.", "numval"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "4"}], ",", "20"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "4"}], ",", "20"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.05"}], ",", "1.2"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1.5", ",", "0.05"}], "}"}], ",", 
   RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.454748617078125*^9, {3.5116806072819734`*^9, 3.511680623953998*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`t$$ = 0.2, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`t$$], 0, 1.5, 0.05}}, Typeset`size$$ = {
    360., {109., 113.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`t$49267$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`t$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`t$$, $CellContext`t$49267$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        ReplaceAll[
         $CellContext`\[Rho][$CellContext`x, $CellContext`t$$], \
$CellContext`numval], {$CellContext`x, -4, 20}, 
        PlotRange -> {{-4, 20}, {-0.05, 1.2}}, Axes -> False], 
      "Specifications" :> {{$CellContext`t$$, 0, 1.5, 0.05, AnimationRunning -> 
         False, AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{407., {148., 153.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.519988171890625*^9, 3.519988191765625*^9}, {
  3.5199910999375*^9, 3.519991105015625*^9}, {3.5199912825*^9, 
  3.5199912841875*^9}}]
}, Open  ]],

Cell["zus\[ADoubleDot]tzliches Wellenpaket:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Rho]", "[", 
         RowBox[{"x", ",", "t"}], "]"}], "/.", "numval"}], " ", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"\[Rho]", "[", 
          RowBox[{"x", ",", "t"}], "]"}], " ", "/.", 
         RowBox[{"b", "\[Rule]", "0.5"}]}], "/.", "numval"}]}], " ", "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "4"}], ",", "20"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "4"}], ",", "20"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.05"}], ",", "1.2"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"RGBColor", "[", 
         RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", 
        RowBox[{"RGBColor", "[", 
         RowBox[{"0", ",", "1", ",", "0"}], "]"}]}], "}"}]}], ",", 
     RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1.5", ",", "0.05"}], "}"}], ",", 
   RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.454748622734375*^9, {3.5116807299601517`*^9, 3.5116807341601577`*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`t$$ = 0.9, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`t$$], 0, 1.5, 0.05}}, Typeset`size$$ = {
    360., {109., 113.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`t$51208$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`t$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`t$$, $CellContext`t$51208$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[{
         ReplaceAll[
          $CellContext`\[Rho][$CellContext`x, $CellContext`t$$], \
$CellContext`numval], 
         ReplaceAll[
          ReplaceAll[
           $CellContext`\[Rho][$CellContext`x, $CellContext`t$$], \
$CellContext`b -> 0.5], $CellContext`numval]}, {$CellContext`x, -4, 20}, 
        PlotRange -> {{-4, 20}, {-0.05, 1.2}}, PlotStyle -> {
          RGBColor[1, 0, 0], 
          RGBColor[0, 1, 0]}, Axes -> False], 
      "Specifications" :> {{$CellContext`t$$, 0, 1.5, 0.05, AnimationRunning -> 
         False, AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{407., {148., 153.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.519988172078125*^9, 3.51998818459375*^9}, {
  3.51999130734375*^9, 3.519991332828125*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Darstellung im Teilchenbild", "Section"],

Cell["Bewegung des klassischen Teilchens:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"xk", "[", "t_", "]"}], "=", 
  RowBox[{
   FractionBox["\[HBar]", "m"], "k0", " ", "t"}]}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{"k0", " ", "t", " ", "\[HBar]"}], "m"]], "Output",
 CellChangeTimes->{3.51998817225*^9, 3.519991353359375*^9}]
}, Open  ]],

Cell["Statistischer Erwartungswert des Wellenpaketes:", "Text"],

Cell["Normierung :", "Text",
 CellChangeTimes->{{3.454748651078125*^9, 3.454748654671875*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"norm", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{
     SubsuperscriptBox["\[Integral]", 
      RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
     RowBox[{
      RowBox[{"\[Rho]", "[", 
       RowBox[{"x", ",", "t"}], "]"}], 
      RowBox[{"\[DifferentialD]", "x"}]}]}], " ", ",", "bed"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.45474866353125*^9, 3.454748690640625*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox[
    RowBox[{"m", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["b", "2"], " ", "m"}], "-", 
       RowBox[{"\[ImaginaryI]", " ", "t", " ", "\[HBar]"}]}], ")"}]}]], " ", 
   RowBox[{"Conjugate", "[", 
    FractionBox["1", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["b", "2"], "+", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "t", " ", "\[HBar]"}], "m"]}]]], 
    "]"}]}], "m"]], "Output",
 CellChangeTimes->{3.51998818803125*^9, 3.519991370078125*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"xs", "[", "t_", "]"}], "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{
     SubsuperscriptBox["\[Integral]", 
      RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
     RowBox[{
      RowBox[{"FullSimplify", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Conjugate", "[", 
           RowBox[{"\[Psi]", "[", 
            RowBox[{"x", ",", "t"}], "]"}], "]"}], "x", " ", 
          RowBox[{"\[Psi]", "[", 
           RowBox[{"x", ",", "t"}], "]"}]}], " ", "/.", "Erule"}], ",", 
        "bed"}], "]"}], 
      RowBox[{"\[DifferentialD]", "x"}]}]}], " ", ",", "bed"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.454748875953125*^9, 3.454748882171875*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"k0", " ", "t", " ", "\[HBar]", " ", 
   SqrtBox[
    RowBox[{"m", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["b", "2"], " ", "m"}], "-", 
       RowBox[{"\[ImaginaryI]", " ", "t", " ", "\[HBar]"}]}], ")"}]}]], " ", 
   RowBox[{"Conjugate", "[", 
    FractionBox["1", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["b", "2"], "+", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "t", " ", "\[HBar]"}], "m"]}]]], 
    "]"}]}], 
  SuperscriptBox["m", "2"]]], "Output",
 CellChangeTimes->{3.51998823075*^9, 3.519991408703125*^9}]
}, Open  ]],

Cell["Darstellung des Zeitverhaltens mit Teilchenbild", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Show", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Plot", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"\[Rho]", "[", 
           RowBox[{"x", ",", "t"}], "]"}], "/.", "numval"}], " ", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"\[Rho]", "[", 
            RowBox[{"x", ",", "t"}], "]"}], "/.", 
           RowBox[{"b", "\[Rule]", "0.5"}]}], "/.", "numval"}]}], " ", "}"}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "4"}], ",", "20"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "4"}], ",", "20"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "0.05"}], ",", "1.2"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"RGBColor", "[", 
           RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", 
          RowBox[{"RGBColor", "[", 
           RowBox[{"0", ",", "1", ",", "0"}], "]"}]}], "}"}]}], ",", 
       RowBox[{"Axes", "\[Rule]", "False"}]}], "\[IndentingNewLine]", "]"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"ListPlot", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"xk", "[", "t", "]"}], " ", "/.", "numval"}], ",", "0"}], 
         " ", "}"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"PointSize", "[", "0.02", "]"}]}]}], "]"}]}], 
    "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1.5", ",", "0.05"}], "}"}], ",", 
   RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.4547489381875*^9, {3.511680747440176*^9, 3.5116807509201884`*^9}, {
   3.5116836131243973`*^9, 3.511683638774433*^9}, {3.511683670644478*^9, 
   3.511683677814488*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`t$$ = 0.35000000000000003`, Typeset`show$$ =
     True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`t$$], 0, 1.5, 0.05}}, Typeset`size$$ = {
    360., {109., 113.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`t$70855$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`t$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`t$$, $CellContext`t$70855$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Show[
        Plot[{
          ReplaceAll[
           $CellContext`\[Rho][$CellContext`x, $CellContext`t$$], \
$CellContext`numval], 
          ReplaceAll[
           ReplaceAll[
            $CellContext`\[Rho][$CellContext`x, $CellContext`t$$], \
$CellContext`b -> 0.5], $CellContext`numval]}, {$CellContext`x, -4, 20}, 
         PlotRange -> {{-4, 20}, {-0.05, 1.2}}, PlotStyle -> {
           RGBColor[1, 0, 0], 
           RGBColor[0, 1, 0]}, Axes -> False], 
        ListPlot[{{
           ReplaceAll[
            $CellContext`xk[$CellContext`t$$], $CellContext`numval], 0}}, 
         PlotStyle -> PointSize[0.02]]], 
      "Specifications" :> {{$CellContext`t$$, 0, 1.5, 0.05, AnimationRunning -> 
         False, AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{407., {148., 153.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.519988230765625*^9, {3.5199883003125*^9, 3.519988306359375*^9}, 
   3.51999140871875*^9, {3.5199915020625*^9, 3.519991508328125*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{803, 634},
WindowMargins->{{166, Automatic}, {Automatic, 100}},
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (November 10, 2008)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 44, 0, 83, "Title"],
Cell[626, 24, 35, 0, 49, "Subtitle"],
Cell[664, 26, 206, 4, 28, "Subsubtitle"],
Cell[CellGroupData[{
Cell[895, 34, 31, 0, 71, "Section"],
Cell[929, 36, 629, 14, 52, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1595, 55, 48, 0, 71, "Section"],
Cell[1646, 57, 94, 2, 29, "Text"],
Cell[1743, 61, 562, 17, 48, "Input"],
Cell[2308, 80, 67, 2, 29, "Text"],
Cell[CellGroupData[{
Cell[2400, 86, 269, 9, 51, "Input"],
Cell[2672, 97, 331, 10, 51, "Output"]
}, Open  ]],
Cell[3018, 110, 85, 2, 29, "Text"],
Cell[CellGroupData[{
Cell[3128, 116, 511, 17, 50, "Input"],
Cell[3642, 135, 532, 17, 73, "Output"]
}, Open  ]],
Cell[4189, 155, 58, 0, 29, "Text"],
Cell[CellGroupData[{
Cell[4272, 159, 294, 8, 31, "Input"],
Cell[4569, 169, 350, 9, 30, "Output"]
}, Open  ]],
Cell[4934, 181, 61, 0, 29, "Text"],
Cell[CellGroupData[{
Cell[5020, 185, 263, 8, 31, "Input"],
Cell[5286, 195, 38851, 642, 238, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[44174, 842, 329, 10, 31, "Input"],
Cell[44506, 854, 18647, 312, 248, "Output"]
}, Open  ]],
Cell[63168, 1169, 91, 2, 29, "Text"],
Cell[CellGroupData[{
Cell[63284, 1175, 147, 4, 31, "Input"],
Cell[63434, 1181, 852, 26, 73, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[64323, 1212, 473, 14, 48, "Input"],
Cell[64799, 1228, 1620, 51, 98, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[66456, 1284, 630, 18, 48, "Input"],
Cell[67089, 1304, 467, 16, 61, "Output"]
}, Open  ]],
Cell[67571, 1323, 69, 0, 29, "Text"],
Cell[CellGroupData[{
Cell[67665, 1327, 526, 16, 31, "Input"],
Cell[68194, 1345, 19992, 332, 243, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[88235, 1683, 71, 2, 71, "Section"],
Cell[88309, 1687, 23, 0, 29, "Text"],
Cell[CellGroupData[{
Cell[88357, 1691, 482, 14, 31, "Input"],
Cell[88842, 1707, 1070, 36, 115, "Output"]
}, Open  ]],
Cell[89927, 1746, 164, 3, 29, "Text"],
Cell[CellGroupData[{
Cell[90116, 1753, 988, 31, 52, "Input"],
Cell[91107, 1786, 25248, 420, 254, "Output"]
}, Open  ]],
Cell[116370, 2209, 77, 2, 29, "Text"],
Cell[CellGroupData[{
Cell[116472, 2215, 880, 25, 52, "Input"],
Cell[117355, 2242, 2082, 43, 318, "Output"]
}, Open  ]],
Cell[119452, 2288, 53, 0, 29, "Text"],
Cell[CellGroupData[{
Cell[119530, 2292, 1402, 40, 72, "Input"],
Cell[120935, 2334, 2277, 48, 318, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[123261, 2388, 46, 0, 71, "Section"],
Cell[123310, 2390, 51, 0, 29, "Text"],
Cell[CellGroupData[{
Cell[123386, 2394, 136, 4, 47, "Input"],
Cell[123525, 2400, 148, 3, 47, "Output"]
}, Open  ]],
Cell[123688, 2406, 63, 0, 29, "Text"],
Cell[123754, 2408, 94, 1, 29, "Text"],
Cell[CellGroupData[{
Cell[123873, 2413, 421, 12, 44, "Input"],
Cell[124297, 2427, 558, 18, 76, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[124892, 2450, 732, 21, 44, "Input"],
Cell[125627, 2473, 616, 19, 78, "Output"]
}, Open  ]],
Cell[126258, 2495, 63, 0, 29, "Text"],
Cell[CellGroupData[{
Cell[126346, 2499, 2216, 56, 272, "Input"],
Cell[128565, 2557, 2521, 54, 318, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
