(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     22959,        774]
NotebookOptionsPosition[     20319,        691]
NotebookOutlinePosition[     20727,        708]
CellTagsIndexPosition[     20684,        705]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Computer\[UDoubleDot]bungen", "Title"],

Cell["Quantenmechanik", "Subtitle"],

Cell["\<\
\[CapitalUDoubleDot]bung 4: Wellenpaket im unendlich tiefem 1D Potentialtopf\
\>", "Subsubtitle",
 CellChangeTimes->{{3.5116789411804733`*^9, 3.5116789415604734`*^9}, {
  3.5156761367810287`*^9, 3.5156761368434286`*^9}}],

Cell[CellGroupData[{

Cell["Definitionen", "Section"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], "\n", 
 RowBox[{
  RowBox[{"bed", "=", 
   RowBox[{
    RowBox[{"\[HBar]", ">", "0"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}], " ", "&&", " ", 
    RowBox[{"x", "\[Element]", " ", "Reals"}], " ", "&&", " ", 
    RowBox[{"a", ">", "0"}], " ", "&&", " ", 
    RowBox[{"b", ">", "0"}], " ", "&&", " ", 
    RowBox[{"k0", ">", "0"}], " ", "&&", " ", 
    RowBox[{"En", ">", "0"}], " ", "&&", " ", 
    RowBox[{"t", ">", "0"}], " ", "&&", " ", 
    RowBox[{"k", ">", "0"}], " ", "&&", " ", 
    RowBox[{"n", "\[Element]", " ", "Integers"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.5116832170734973`*^9, 3.5116832236995587`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Darstellung des Wellenpaketes", "Section"],

Cell["\<\
Ansatz f\[UDoubleDot]r Wellenpaket: Entwicklung nach den Eigenfunktionen des \
Potentialtopfes\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Psi]", "[", 
   RowBox[{"x_", ",", "t_"}], "]"}], "=", 
  RowBox[{
   UnderoverscriptBox["\[Sum]", 
    RowBox[{"n", "=", "1"}], "Nn"], 
   RowBox[{
    RowBox[{"c", "[", "n", "]"}], 
    RowBox[{"\[Phi]", "[", 
     RowBox[{"x", ",", "n"}], "]"}], 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", 
      FractionBox[
       RowBox[{"En", "[", "n", "]"}], "\[HBar]"], "t"}]]}]}]}]], "Input"],

Cell["Eigenfunktionen des Potentialtopfes:", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Phi]", "[", 
   RowBox[{"x_", ",", "n_"}], "]"}], "=", 
  RowBox[{
   SqrtBox[
    FractionBox["1", "a"]], 
   FractionBox["1", "2"], 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[ImaginaryI]", " ", 
       FractionBox["\[Pi]", 
        RowBox[{"2", " ", "a"}]], "n", " ", "x"}]], "+", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], 
       RowBox[{" ", 
        RowBox[{"n", "+", "1"}]}]], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", 
        FractionBox["\[Pi]", 
         RowBox[{"2", " ", "a"}]], "n", " ", "x"}]]}]}], ")"}]}]}]], "Input"],

Cell["Energieeigenwerte:", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"En", "[", "n_", "]"}], "=", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["\[HBar]", "2"], 
     SuperscriptBox["\[Pi]", "2"]}], 
    RowBox[{"8", " ", "m", " ", 
     SuperscriptBox["a", "2"]}]], 
   SuperscriptBox["n", "2"]}]}]], "Input"],

Cell["Vorgabe numerischer Werte zur Darstellung:", "Text"],

Cell[BoxData[
 RowBox[{"numval", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[HBar]", "\[Rule]", "1"}], ",", 
    RowBox[{"m", "\[Rule]", "1"}], ",", 
    RowBox[{"k0", "\[Rule]", "100"}], ",", 
    RowBox[{"a", "\[Rule]", "1"}], ",", 
    RowBox[{"b", "\[Rule]", "0.05"}], ",", 
    RowBox[{"x0", "\[Rule]", 
     RowBox[{
      FractionBox[
       RowBox[{"-", "3"}], "4"], "1"}]}]}], "}"}]}]], "Input"],

Cell["Test der WF:", "Text"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{
     RowBox[{"\[Phi]", "[", 
      RowBox[{"x", ",", "3"}], "]"}], "/.", "numval"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"-", "a"}], " ", "/.", "numval"}], ",", 
     RowBox[{"a", " ", "/.", "numval"}]}], "}"}]}], "]"}]], "Input"],

Cell["\<\
Vorgabe einer Anfagnsverteilung zum Zeitpunkt t=0 (Gau\[SZ]) am Ort x0:\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Psi]0", "[", "x_", "]"}], "=", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"\[Pi]", " ", 
      SuperscriptBox["b", "2"]}], ")"}], 
    FractionBox[
     RowBox[{"-", "1"}], "4"]], 
   SuperscriptBox["\[ExponentialE]", 
    FractionBox[
     RowBox[{"-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "-", "x0"}], ")"}], "2"]}], 
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"]}]]], 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"\[ImaginaryI]", " ", "k0", " ", 
     RowBox[{"(", 
      RowBox[{"x", "-", "x0"}], ")"}]}]]}]}]], "Input"],

Cell["graphische Darstellung der Anfangsverteilung:", "Text"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Re", "[", 
     RowBox[{"\[Psi]0", "[", "x", "]"}], "]"}], "/.", "numval"}], " ", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "4"}], "}"}]}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"\[Psi]0", "[", "x", "]"}], "*", 
     RowBox[{"Conjugate", "[", 
      RowBox[{"\[Psi]0", "[", "x", "]"}], "]"}]}], "/.", "numval"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "12"}], "}"}]}], "}"}]}]}], "]"}]], "Input"],

Cell["\<\
Bestimmung der Entwicklungskoeffizienten aus der Anfangsverteilung:\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Psi]0", "[", "x", "]"}], "\[Equal]", 
  RowBox[{"\[Psi]", "[", 
   RowBox[{"x", ",", "0"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"c", "[", "n_", "]"}], "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{
     SubsuperscriptBox["\[Integral]", 
      RowBox[{"-", "a"}], "a"], 
     RowBox[{
      RowBox[{"FullSimplify", "[", 
       RowBox[{
        RowBox[{"Conjugate", "[", 
         RowBox[{"\[Phi]", "[", 
          RowBox[{"x", ",", "n"}], "]"}], "]"}], ",", "bed"}], "]"}], 
      RowBox[{"\[Psi]0", "[", "x", "]"}], 
      RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "bed"}], "]"}]}]], "Input"],

Cell["graphische Darstellung der Entwicklungskoeffizienten:", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ver", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"c", "[", "n", "]"}], "*", 
        RowBox[{"Conjugate", "[", 
         RowBox[{"c", "[", "n", "]"}], "]"}]}], "/.", "numval"}], " ", "]"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "100"}], "}"}]}], "]"}]}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{"BarChart", "[", 
  RowBox[{
   RowBox[{"Re", "[", "ver", "]"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "100"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", ".1"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5174604687064047`*^9, 3.517460471327209*^9}}],

Cell["Bis zu welchem Nn ist Summation notwendig?", "Text"],

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Sum]", 
   RowBox[{"n", "=", "0"}], "100"], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"c", "[", "n", "]"}], "*", 
     RowBox[{"Conjugate", "[", 
      RowBox[{"c", "[", "n", "]"}], "]"}]}], " ", "/.", "numval"}], " ", 
   ")"}]}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Darstellung der Zeitabh\[ADoubleDot]ngigkeit\
\>", "Section"],

Cell["Dichte:", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"\[Rho]", "[", 
     RowBox[{"x_", ",", "t_"}], "]"}], "=", 
    RowBox[{"N", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"\[Psi]", "[", 
         RowBox[{"x", ",", "t"}], "]"}], " ", 
        RowBox[{"Conjugate", "[", 
         RowBox[{"\[Psi]", "[", 
          RowBox[{"x", ",", "t"}], "]"}], "]"}]}], " ", "/.", 
       RowBox[{"Nn", "\[Rule]", "100"}]}], "/.", "numval"}], "]"}]}], ";"}], 
  " "}]], "Input"],

Cell["\<\
Test, ob die Anfagnsverteilung  f\[UDoubleDot]r t=0 erf\[UDoubleDot]llt ist:\
\>", "Text"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"\[Rho]", "[", 
       RowBox[{"x", ",", "0"}], "]"}], " ", "/.", "numval"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"\[Psi]0", "[", "x", "]"}], "*", 
       RowBox[{"Conjugate", "[", 
        RowBox[{"\[Psi]0", "[", "x", "]"}], "]"}]}], "/.", "numval"}]}], 
    "}"}], " ", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "12"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"RGBColor", "[", 
       RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", 
      RowBox[{"RGBColor", "[", 
       RowBox[{"0", ",", "1", ",", "0"}], "]"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5116809246834564`*^9, 3.5116809289934626`*^9}}],

Cell["\<\
Animation zur Zeitabh\[ADoubleDot]ngigkeit erstellen:\
\>", "Text"],

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Rho]", "[", 
        RowBox[{"x", ",", "t"}], "]"}], " ", ",", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"\[Psi]0", "[", "x", "]"}], "*", 
         RowBox[{"Conjugate", "[", 
          RowBox[{"\[Psi]0", "[", "x", "]"}], "]"}]}], "/.", "numval"}]}], 
      " ", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "12"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"RGBColor", "[", 
         RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", 
        RowBox[{"RGBColor", "[", 
         RowBox[{"0", ",", "1", ",", "0"}], "]"}]}], "}"}]}], ",", 
     RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "0.05", ",", "0.0003"}], "}"}], ",", 
   RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4547491735625*^9, 3.454749179171875*^9}, {
  3.454749269515625*^9, 3.454749273484375*^9}, {3.45474930965625*^9, 
  3.45474934175*^9}, {3.511680937133474*^9, 3.5116809449154863`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Priodizit\[ADoubleDot]t der Wellenfunktion", "Section",
 CellChangeTimes->{{3.5116802664172964`*^9, 3.511680268037298*^9}}],

Cell["\<\
da alle Eigenwerte vielfaches von E1 sind, ist Zeit, die zum Grundzustand geh\
\[ODoubleDot]rt die Periode der WF\
\>", "Text"],

Cell[BoxData[
 RowBox[{"T1", "=", 
  FractionBox[
   RowBox[{"2", " ", "\[Pi]"}], "\[Omega]1"]}]], "Input"],

Cell[BoxData[
 RowBox[{"\[Omega]1", "=", 
  FractionBox[
   RowBox[{"En", "[", "1", "]"}], "\[HBar]"]}]], "Input"],

Cell["\<\
Animation zur Zeitabh\[ADoubleDot]ngigkeit erstellen unter \
Ber\[UDoubleDot]cksichtigung der Periodizit\[ADoubleDot]t:\
\>", "Text"],

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Rho]", "[", 
        RowBox[{"x", ",", "t"}], "]"}], " ", ",", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"\[Psi]0", "[", "x", "]"}], "*", 
         RowBox[{"Conjugate", "[", 
          RowBox[{"\[Psi]0", "[", "x", "]"}], "]"}]}], "/.", "numval"}]}], 
      " ", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "12"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"RGBColor", "[", 
         RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", 
        RowBox[{"RGBColor", "[", 
         RowBox[{"0", ",", "1", ",", "0"}], "]"}]}], "}"}]}], ",", 
     RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"T1", " ", "/.", "numval"}], ",", 
     RowBox[{
      RowBox[{"T1", " ", "/", "100"}], " ", "/.", "numval"}]}], "}"}], ",", 
   RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5116809624985275`*^9, 3.511680966318533*^9}, {
  3.517461004320945*^9, 3.517461014102162*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Darstellung im Teilchenbild", "Section"],

Cell["Bewegung des klassischen Teilchens:", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"xk", "[", "t_", "]"}], "=", 
  RowBox[{
   RowBox[{
    FractionBox["\[HBar]", "m"], "k0", " ", "t"}], "+", "x0"}]}]], "Input"],

Cell["Teilchen wird an Potentialwand reflektiert:", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"xk2", "[", "t_", "]"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], 
       RowBox[{"IntegerPart", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"xk", "[", "t", "]"}], "+", "a"}], ")"}], "/", "2"}], 
         "a"}], " ", "]"}]], 
      RowBox[{"xk", "[", "t", "]"}]}], "-", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], 
       RowBox[{"IntegerPart", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"xk", "[", "t", "]"}], "+", "a"}], ")"}], "/", "2"}], 
         "a"}], " ", "]"}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"IntegerPart", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"xk", "[", "t", "]"}], "+", "a"}], ")"}], "/", "2"}], 
          "a"}], " ", "]"}], "+", "0"}], ")"}], " ", "2", " ", "a"}]}], " ", "/.",
     "numval"}]}], ";"}]], "Input"],

Cell["graphische Darstellung diese Verlaufes:", "Text"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"xk2", "[", "t", "]"}], ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "0.4"}], "}"}]}], "]"}]], "Input"],

Cell["Statistischer Erwartungswert des Wellenpaketes:", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"xs", "[", "t_", "]"}], "=", 
  FractionBox[
   RowBox[{"FullSimplify", "[", 
    RowBox[{
     RowBox[{
      SubsuperscriptBox["\[Integral]", 
       RowBox[{"-", "a"}], "a"], 
      RowBox[{
       RowBox[{"FullSimplify", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"Conjugate", "[", 
            RowBox[{"\[Psi]", "[", 
             RowBox[{"x", ",", "t"}], "]"}], "]"}], "x", " ", 
           RowBox[{"\[Psi]", "[", 
            RowBox[{"x", ",", "t"}], "]"}]}], " ", "/.", "Erule"}], ",", 
         "bed"}], "]"}], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], " ", ",", "bed"}], "]"}], 
   RowBox[{"FullSimplify", "[", 
    RowBox[{
     RowBox[{
      SubsuperscriptBox["\[Integral]", 
       RowBox[{"-", "a"}], "a"], 
      RowBox[{
       RowBox[{"FullSimplify", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"Conjugate", "[", 
            RowBox[{"\[Psi]", "[", 
             RowBox[{"x", ",", "t"}], "]"}], "]"}], 
           RowBox[{"\[Psi]", "[", 
            RowBox[{"x", ",", "t"}], "]"}]}], "/.", "Erule"}], ",", "bed"}], 
        "]"}], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], " ", ",", "bed"}], 
    "]"}]]}]], "Text"],

Cell["\<\
Problem: sehr aufwendig, da nur numerisch berechenbar \[Rule] \
\[CapitalUDoubleDot]berpr\[UDoubleDot]fung auf Normierung f\[UDoubleDot]r \
ausgew\[ADoubleDot]hlte t: \
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "[", 
   RowBox[{
    RowBox[{"\[Rho]", "[", 
     RowBox[{"x", ",", "100.1"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{
       RowBox[{"-", "a"}], " ", "/.", "numval"}], ",", 
      RowBox[{"a", " ", "/.", "numval"}]}], "}"}]}], "]"}], " "}]], "Input"],

Cell["Erwartungswert:", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"xs", "[", "t_", "]"}], ":=", 
  RowBox[{"NIntegrate", "[", 
   RowBox[{
    RowBox[{"x", " ", 
     RowBox[{"\[Rho]", "[", 
      RowBox[{"x", ",", "t"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{
       RowBox[{"-", "a"}], " ", "/.", "numval"}], ",", 
      RowBox[{"a", " ", "/.", "numval"}]}], "}"}]}], "]"}], " "}]], "Input"],

Cell["Darstellung des Zeitverhaltens mit Teilchenbild", "Text"],

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\[Rho]", "[", 
          RowBox[{"x", ",", "t"}], "]"}], " ", ",", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"\[Psi]0", "[", "x", "]"}], "*", 
           RowBox[{"Conjugate", "[", 
            RowBox[{"\[Psi]0", "[", "x", "]"}], "]"}]}], "/.", "numval"}]}], 
        " ", "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "0.5"}], ",", "12"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"RGBColor", "[", 
           RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", 
          RowBox[{"RGBColor", "[", 
           RowBox[{"0", ",", "1", ",", "0"}], "]"}]}], "}"}]}], ",", 
       RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"ListPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"xk2", "[", "t", "]"}], " ", "/.", "numval"}], ",", "0"}], 
         " ", "}"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"PointSize", "[", "0.04", "]"}]}]}], "]"}], ",", 
     RowBox[{"ListPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"xs", "[", "t", "]"}], " ", "/.", "numval"}], ",", "0"}], 
         " ", "}"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"PointSize", "[", "0.03", "]"}], ",", 
          RowBox[{"RGBColor", "[", 
           RowBox[{"1", ",", "0", ",", "0"}], "]"}]}], "}"}]}]}], "]"}]}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{
      RowBox[{"T1", " ", "/", "60"}], "/.", "numval"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"T1", " ", "/", "60"}], " ", "/", "16"}], " ", "/.", 
      "numval"}]}], "}"}], ",", 
   RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.511680998538578*^9, 3.511681003218584*^9}}]
}, Closed]]
}, Open  ]]
},
WindowSize->{1350, 636},
WindowMargins->{{-2, Automatic}, {Automatic, -1}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (November 13, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 44, 0, 83, "Title"],
Cell[626, 24, 35, 0, 49, "Subtitle"],
Cell[664, 26, 230, 4, 28, "Subsubtitle"],
Cell[CellGroupData[{
Cell[919, 34, 31, 0, 71, "Section"],
Cell[953, 36, 698, 15, 52, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[1688, 56, 48, 0, 41, "Section"],
Cell[1739, 58, 118, 3, 29, "Text"],
Cell[1860, 63, 476, 15, 55, "Input"],
Cell[2339, 80, 52, 0, 29, "Text"],
Cell[2394, 82, 727, 24, 54, "Input"],
Cell[3124, 108, 34, 0, 29, "Text"],
Cell[3161, 110, 290, 10, 51, "Input"],
Cell[3454, 122, 58, 0, 29, "Text"],
Cell[3515, 124, 409, 12, 47, "Input"],
Cell[3927, 138, 28, 0, 29, "Text"],
Cell[3958, 140, 359, 11, 31, "Input"],
Cell[4320, 153, 95, 2, 29, "Text"],
Cell[4418, 157, 623, 21, 50, "Input"],
Cell[5044, 180, 61, 0, 29, "Text"],
Cell[5108, 182, 496, 16, 31, "Input"],
Cell[5607, 200, 563, 18, 31, "Input"],
Cell[6173, 220, 91, 2, 29, "Text"],
Cell[6267, 224, 147, 4, 31, "Input"],
Cell[6417, 230, 517, 15, 44, "Input"],
Cell[6937, 247, 69, 0, 29, "Text"],
Cell[7009, 249, 413, 13, 31, "Input"],
Cell[7425, 264, 386, 11, 31, "Input"],
Cell[7814, 277, 58, 0, 29, "Text"],
Cell[7875, 279, 302, 10, 55, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[8214, 294, 71, 2, 41, "Section"],
Cell[8288, 298, 23, 0, 29, "Text"],
Cell[8314, 300, 494, 16, 31, "Input"],
Cell[8811, 318, 100, 2, 29, "Text"],
Cell[8914, 322, 1057, 32, 31, "Input"],
Cell[9974, 356, 77, 2, 29, "Text"],
Cell[10054, 360, 1464, 39, 52, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[11555, 404, 129, 1, 41, "Section"],
Cell[11687, 407, 137, 3, 29, "Text"],
Cell[11827, 412, 107, 3, 47, "Input"],
Cell[11937, 417, 114, 3, 47, "Input"],
Cell[12054, 422, 143, 3, 29, "Text"],
Cell[12200, 427, 1478, 41, 52, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[13715, 473, 46, 0, 41, "Section"],
Cell[13764, 475, 51, 0, 29, "Text"],
Cell[13818, 477, 162, 5, 47, "Input"],
Cell[13983, 484, 59, 0, 29, "Text"],
Cell[14045, 486, 1123, 38, 31, "Input"],
Cell[15171, 526, 55, 0, 29, "Text"],
Cell[15229, 528, 244, 8, 31, "Input"],
Cell[15476, 538, 63, 0, 29, "Text"],
Cell[15542, 540, 1248, 38, 57, "Text"],
Cell[16793, 580, 191, 4, 29, "Text"],
Cell[16987, 586, 330, 10, 31, "Input"],
Cell[17320, 598, 31, 0, 29, "Text"],
Cell[17354, 600, 394, 12, 31, "Input"],
Cell[17751, 614, 63, 0, 29, "Text"],
Cell[17817, 616, 2474, 71, 72, "Input"]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
