(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     32644,       1052]
NotebookOptionsPosition[     30073,        972]
NotebookOutlinePosition[     30480,        989]
CellTagsIndexPosition[     30437,        986]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Computer\[UDoubleDot]bungen", "Title"],

Cell["Quantenmechanik", "Subtitle"],

Cell["\[CapitalUDoubleDot]bung 5: Kronig-Penney-Modell", "Subsubtitle",
 CellChangeTimes->{{3.5116789085264006`*^9, 3.5116789089964013`*^9}, {
  3.5156761725518913`*^9, 3.5156761726298914`*^9}}],

Cell[CellGroupData[{

Cell["Definitionen", "Section"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], "\n", 
 RowBox[{
  RowBox[{"bed", "=", 
   RowBox[{
    RowBox[{"\[HBar]", ">", "0"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}], " ", "&&", " ", 
    RowBox[{"x", "\[Element]", " ", "Reals"}], " ", "&&", " ", 
    RowBox[{"a", ">", "0"}], "&&", 
    RowBox[{"n", "\[Element]", "Integers"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Needs", "[", "\"\<NumericalMath`IntervalRoots`\>\"", "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.511683161497346*^9, 3.511683162697348*^9}, {
  3.5174614628433504`*^9, 3.517461463248951*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["L\[ODoubleDot]sung der SGL", "Section"],

Cell[TextData[{
 "das Potential hat die folgende Form :\n",
 Cell[BoxData[
  RowBox[{"V", "=", 
   TagBox[
    RowBox[{"D", " ", 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"n", "=", 
        RowBox[{"-", "\[Infinity]"}]}], "\[Infinity]"], 
      RowBox[{"\[Delta]", 
       RowBox[{"(", 
        RowBox[{"x", "-", "na"}], ")"}]}]}]}],
    #& ]}]]]
}], "Text"],

Cell["\<\
L\[ODoubleDot]sung der Schr\[ODoubleDot]dingergleichung zwischen 2 \
Delta-Potentialen:\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SGL", ":=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"\[Psi]", "''"}], "[", "x", "]"}], " ", "+", 
     RowBox[{
      SuperscriptBox["k", "2"], " ", 
      RowBox[{"\[Psi]", "[", "x", "]"}]}]}], "==", "0"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"DSolve", "[", 
  RowBox[{"SGL", ",", "\[Psi]", ",", "x"}], "]"}]}], "Input"],

Cell["\<\
L\[ODoubleDot]sungen zwischen den Bereichen:\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]", "[", 
    RowBox[{"x_", ",", "n_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"A", "[", "n", "]"}], " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[ImaginaryI]", " ", "k", " ", 
       RowBox[{"(", 
        RowBox[{"x", "-", 
         RowBox[{"n", " ", "a"}]}], ")"}]}]]}], "+", 
    RowBox[{
     RowBox[{"B", "[", "n", "]"}], " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", "k", " ", 
       RowBox[{"(", 
        RowBox[{"x", "-", 
         RowBox[{"n", " ", "a"}]}], ")"}]}]]}]}]}], ";"}]], "Input"],

Cell["Definition von k:", "Text"],

Cell[BoxData[
 RowBox[{"krule", ":=", 
  RowBox[{"{", 
   RowBox[{"k", "->", 
    FractionBox[
     SqrtBox[
      RowBox[{"2", " ", "m", " ", "Ee"}]], "\[HBar]"]}], " ", 
   "}"}]}]], "Input"],

Cell["Festlegung der Bedingungen an k ", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"bed", "=", 
   RowBox[{"bed", " ", "&&", " ", 
    RowBox[{"k", ">", "0"}]}]}], ";"}]], "Input"],

Cell["Anschlu\[SZ]bedingung bei x=n a :", "Text"],

Cell[BoxData[
 RowBox[{"bed1", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"\[Phi]", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"n", " ", "a"}], "+", "\[Eta]"}], ",", "n"}], "]"}], 
      "\[Equal]", 
      RowBox[{"\[Phi]", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"n", " ", "a"}], "-", "\[Eta]"}], ",", 
        RowBox[{"n", "-", "1"}]}], "]"}]}], " ", "/.", 
     RowBox[{"\[Eta]", "\[Rule]", "0"}]}], ",", "bed"}], "]"}]}]], "Input"],

Cell["\<\
2. Bedingung aus Integration der SGL\[Rule]Sprung der 1. Ableitung:\
\>", "Text"],

Cell[BoxData[
 RowBox[{"bed2", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"\[Phi]", "[", 
            RowBox[{"x", ",", "n"}], "]"}], ",", "x"}], "]"}], "-", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"\[Phi]", "[", 
            RowBox[{"x", ",", 
             RowBox[{"n", "-", "1"}]}], "]"}], ",", "x"}], "]"}]}], ")"}], "/.", 
       RowBox[{"x", "\[Rule]", 
        RowBox[{"n", " ", "a"}]}]}], " ", ")"}], "\[Equal]", 
     RowBox[{
      FractionBox[
       RowBox[{"2", " ", "m"}], 
       SuperscriptBox["\[HBar]", "2"]], "V", " ", 
      RowBox[{"\[Phi]", "[", 
       RowBox[{
        RowBox[{"n", " ", "a"}], ",", "n"}], "]"}]}]}], ",", "bed"}], 
   "]"}]}]], "Input"],

Cell["\<\
Verwendung der Periodizit\[ADoubleDot]t des Potentials (Wellenfunktion ist \
Blochfunktion):\
\>", "Text",
 CellChangeTimes->{{3.4558678075395*^9, 3.4558678377895*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"A", "[", "n_", "]"}], "=", 
   RowBox[{"A0", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[ImaginaryI]", " ", "K", " ", "n", " ", "a"}]]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"B", "[", "n_", "]"}], "=", 
   RowBox[{"B0", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[ImaginaryI]", " ", "K", " ", "n", " ", "a"}]]}]}], 
  ";"}]}], "Input"],

Cell[BoxData["bed1"], "Input"],

Cell[BoxData["bed2"], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Anschluss", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"bed1", ",", "bed2"}], "}"}], "/.", 
    RowBox[{"n", "\[Rule]", "1"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", 
  RowBox[{"Anschluss", ",", 
   RowBox[{"{", 
    RowBox[{"A0", ",", "B0"}], "}"}]}], "]"}]}], "Input"],

Cell[BoxData[{
 RowBox[{"bed12", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"bed1", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "-", 
    RowBox[{"bed1", "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], " ", "/.", 
   RowBox[{"n", "\[Rule]", "1"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"bed22", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"bed2", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "-", 
    RowBox[{"bed2", "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], " ", "/.", 
   RowBox[{"n", " ", "\[Rule]", "1"}]}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"Koeff", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Coefficient", "[", 
       RowBox[{"bed12", ",", "A0"}], "]"}], ",", 
      RowBox[{"Coefficient", "[", 
       RowBox[{"bed12", ",", "B0"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Coefficient", "[", 
       RowBox[{"bed22", ",", "A0"}], "]"}], ",", 
      RowBox[{"Coefficient", "[", 
       RowBox[{"bed22", ",", "B0"}], "]"}]}], "}"}]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"%", "//", "MatrixForm"}]], "Input"],

Cell[BoxData[
 RowBox[{"eigen", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ExpToTrig", "[", 
       RowBox[{"Det", "[", "Koeff", "]"}], "]"}], "*", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "a", " ", "K"}]]}], "\[Equal]", 
     "0"}], ",", "bed"}], " ", "]"}]}]], "Input",
 CellChangeTimes->{{3.5181418702302885`*^9, 3.5181418891219215`*^9}}],

Cell["\<\
numerische Werte setzen < = > einf\[UDoubleDot]hren von neuen Variablen \
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"numval", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[HBar]", "\[Rule]", "1"}], ",", 
     RowBox[{"m", "\[Rule]", "1"}], ",", 
     RowBox[{"a", "\[Rule]", "1"}], ",", 
     RowBox[{"V", "\[Rule]", "5"}]}], "}"}]}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{"eigen2", "=", 
  RowBox[{
   RowBox[{"eigen", " ", "/.", " ", "krule"}], " ", "/.", 
   "numval"}]}]], "Input"],

Cell["\<\
Untersuchung auf m\[ODoubleDot]gliche Werte\
\>", "Text"],

Cell[BoxData[
 RowBox[{"ersetz", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{"eigen2", ",", 
    RowBox[{"Cos", "[", "K", "]"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Cos", "[", "K", "]"}], "/.", "ersetz"}], ",", "1", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Ee", ",", "0", ",", " ", "300"}], "}"}], ",", 
   RowBox[{"PlotPoints", "\[Rule]", "1000"}]}], "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Bandstruktur", "Section"],

Cell["\<\
Berechnung ausgew\[ADoubleDot]hlter Werte von K:\
\>", "Text"],

Cell[BoxData[
 RowBox[{"eigenwerteinterval", "=", 
  RowBox[{"IntervalNewton", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"eigen2", "[", 
       RowBox[{"[", "1", "]"}], "]"}], " ", "/.", 
      RowBox[{"K", "\[Rule]", "0.1"}]}], " ", "/.", "numval"}], ",", "Ee", 
    ",", 
    RowBox[{"Interval", "[", 
     RowBox[{"{", 
      RowBox[{"0.0001", ",", "125"}], "}"}], "]"}], ",", "0.0001", ",", 
    RowBox[{"MaxRecursion", "\[Rule]", "50"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"eigenwerte", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"eigenwerteinterval", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "1"}], "]"}], "]"}], "+", 
       RowBox[{"eigenwerteinterval", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "2"}], "]"}], "]"}]}], ")"}], "/", "2"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{"Length", "[", "eigenwerteinterval", "]"}]}], "}"}]}], 
   "]"}]}]], "Input"],

Cell["komplette Bandstruktur:", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"band", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Nn", "=", "200"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"m2", "=", 
    RowBox[{
     RowBox[{"-", "Nn"}], "/", "2"}]}], ",", 
   RowBox[{"m2", "\[LessEqual]", 
    RowBox[{"Nn", "/", "2"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eigenwerteinterval", "=", 
     RowBox[{"IntervalNewton", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"eigen2", "[", 
          RowBox[{"[", "1", "]"}], "]"}], " ", "/.", 
         RowBox[{"K", "\[Rule]", 
          RowBox[{
           FractionBox[
            RowBox[{"2", " ", "\[Pi]"}], 
            RowBox[{"Nn", " ", "a"}]], "m2"}]}]}], " ", "/.", "numval"}], ",",
        "Ee", ",", 
       RowBox[{"Interval", "[", 
        RowBox[{"{", 
         RowBox[{"0.0001", ",", "125"}], "}"}], "]"}], ",", "0.0001", ",", 
       RowBox[{"MaxRecursion", "\[Rule]", "50"}]}], "]"}]}], ";", 
    RowBox[{"eigenwerte", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"eigenwerteinterval", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "1"}], "]"}], "]"}], "+", 
          RowBox[{"eigenwerteinterval", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "2"}], "]"}], "]"}]}], ")"}], "/", "2"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", 
         RowBox[{"Length", "[", "eigenwerteinterval", "]"}]}], "}"}]}], 
      "]"}]}], ";", 
    RowBox[{"band", "=", 
     RowBox[{"Join", "[", 
      RowBox[{"band", ",", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{
             FractionBox[
              RowBox[{"2", " ", "\[Pi]"}], 
              RowBox[{"Nn", " ", "a"}]], "m2"}], " ", "/.", "numval"}], ",", 
           RowBox[{"eigenwerte", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "eigenwerte", "]"}]}], "}"}]}], "]"}]}], 
      "]"}]}], ";", 
    RowBox[{"m2", "++"}]}]}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"band", ",", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"PointSize", "[", "0.001", "]"}]}]}], "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Darstellung der Wellenfunktionen", "Section"],

Cell["\<\
Wellenfunktion f\[UDoubleDot]r K=0 plotten:\
\>", "Text"],

Cell["Realteil der Gesamtwellenfunktion:", "Text"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "\[Psi]", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Psi]", "[", 
   RowBox[{
    RowBox[{"x_", "/;", 
     RowBox[{
      RowBox[{"x", "\[GreaterEqual]", 
       RowBox[{
        RowBox[{"-", "6"}], " ", "a"}]}], "&&", 
      RowBox[{"x", "<", 
       RowBox[{
        RowBox[{"-", "5"}], "a"}]}]}]}], "/.", "numval"}], "]"}], ":=", 
  RowBox[{"\[Phi]", "[", 
   RowBox[{"x", ",", 
    RowBox[{"-", "6"}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"\[Psi]", "[", 
   RowBox[{
    RowBox[{"x_", "/;", 
     RowBox[{
      RowBox[{"x", "\[GreaterEqual]", 
       RowBox[{
        RowBox[{"-", "5"}], "a"}]}], "&&", 
      RowBox[{"x", "<", 
       RowBox[{
        RowBox[{"-", "4"}], " ", "a"}]}]}]}], "/.", "numval"}], "]"}], ":=", 
  RowBox[{"\[Phi]", "[", 
   RowBox[{"x", ",", 
    RowBox[{"-", "5"}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"\[Psi]", "[", 
   RowBox[{
    RowBox[{"x_", "/;", 
     RowBox[{
      RowBox[{"x", "\[GreaterEqual]", 
       RowBox[{
        RowBox[{"-", "4"}], "a"}]}], "&&", 
      RowBox[{"x", "<", 
       RowBox[{
        RowBox[{"-", "3"}], " ", "a"}]}]}]}], "/.", "numval"}], "]"}], ":=", 
  RowBox[{"\[Phi]", "[", 
   RowBox[{"x", ",", 
    RowBox[{"-", "4"}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]", "[", 
    RowBox[{
     RowBox[{"x_", "/;", 
      RowBox[{
       RowBox[{"x", "\[GreaterEqual]", 
        RowBox[{
         RowBox[{"-", "3"}], " ", "a"}]}], " ", "&&", " ", 
       RowBox[{"x", "<", " ", 
        RowBox[{
         RowBox[{"-", "2"}], "a"}]}]}]}], " ", "/.", "numval"}], " ", "]"}], ":=", 
   RowBox[{"\[Phi]", "[", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}]}], "]"}]}], " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]", "[", 
    RowBox[{
     RowBox[{"x_", "/;", 
      RowBox[{
       RowBox[{"x", "\[GreaterEqual]", 
        RowBox[{
         RowBox[{"-", "2"}], " ", "a"}]}], " ", "&&", " ", 
       RowBox[{"x", "<", " ", 
        RowBox[{"-", "a"}]}]}]}], " ", "/.", "numval"}], " ", "]"}], ":=", 
   RowBox[{"\[Phi]", "[", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}]}], "]"}]}], "  "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]", "[", 
    RowBox[{
     RowBox[{"x_", "/;", 
      RowBox[{
       RowBox[{"x", "\[GreaterEqual]", 
        RowBox[{"-", "a"}]}], " ", "&&", " ", 
       RowBox[{"x", "<", " ", "0"}]}]}], " ", "/.", "numval"}], " ", "]"}], ":=", 
   RowBox[{"\[Phi]", "[", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}]}], "]"}]}], " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]", "[", 
    RowBox[{
     RowBox[{"x_", "/;", 
      RowBox[{
       RowBox[{"x", "\[GreaterEqual]", "0"}], " ", "&&", " ", 
       RowBox[{"x", "<", " ", "a"}]}]}], " ", "/.", "numval"}], " ", "]"}], ":=", 
   RowBox[{"\[Phi]", "[", 
    RowBox[{"x", ",", "0"}], "]"}]}], " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]", "[", 
    RowBox[{
     RowBox[{"x_", "/;", 
      RowBox[{
       RowBox[{"x", "\[GreaterEqual]", "a"}], " ", "&&", " ", 
       RowBox[{"x", "<", " ", 
        RowBox[{"2", "a"}]}]}]}], " ", "/.", "numval"}], " ", "]"}], ":=", 
   RowBox[{"\[Phi]", "[", 
    RowBox[{"x", ",", "1"}], "]"}]}], "  "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]", "[", 
    RowBox[{
     RowBox[{"x_", "/;", 
      RowBox[{
       RowBox[{"x", "\[GreaterEqual]", 
        RowBox[{"2", "a"}]}], " ", "&&", " ", 
       RowBox[{"x", "<", " ", 
        RowBox[{"3", "a"}]}]}]}], " ", "/.", "numval"}], " ", "]"}], ":=", 
   RowBox[{"\[Phi]", "[", 
    RowBox[{"x", ",", "2"}], "]"}]}], " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Psi]", "[", 
   RowBox[{
    RowBox[{"x_", "/;", 
     RowBox[{
      RowBox[{"x", "\[GreaterEqual]", 
       RowBox[{"3", " ", "a"}]}], "&&", 
      RowBox[{"x", "<", 
       RowBox[{"4", "a"}]}]}]}], "/.", "numval"}], "]"}], ":=", 
  RowBox[{"\[Phi]", "[", 
   RowBox[{"x", ",", "3"}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"\[Psi]", "[", 
   RowBox[{
    RowBox[{"x_", "/;", 
     RowBox[{
      RowBox[{"x", "\[GreaterEqual]", 
       RowBox[{"4", "a"}]}], "&&", 
      RowBox[{"x", "<", 
       RowBox[{"5", "a"}]}]}]}], "/.", "numval"}], "]"}], ":=", 
  RowBox[{"\[Phi]", "[", 
   RowBox[{"x", ",", "4"}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"\[Psi]", "[", 
   RowBox[{
    RowBox[{"x_", "/;", 
     RowBox[{
      RowBox[{"x", "\[GreaterEqual]", 
       RowBox[{"5", "a"}]}], "&&", 
      RowBox[{"x", "<", 
       RowBox[{"6", "a"}]}]}]}], "/.", "numval"}], "]"}], ":=", 
  RowBox[{"\[Phi]", "[", 
   RowBox[{"x", ",", "5"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.4529397895209126`*^9, 3.4529398178177876`*^9}}],

Cell["Graphische Darstellung:", "Text"],

Cell["f\[UDoubleDot]r eine ausgew\[ADoubleDot]hlte WF:", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"B0rule", "=", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"bed1", "/.", "krule"}], " ", "/.", 
           RowBox[{"K", "\[Rule]", 
            RowBox[{"band", "[", 
             RowBox[{"[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"Nn", "/", "2"}], ")"}], "*", "5"}], "+", "3"}], 
               ",", "1"}], "]"}], "]"}]}]}], " ", "/.", 
          RowBox[{"Ee", "\[Rule]", 
           RowBox[{"band", "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"Nn", "/", "2"}], ")"}], "*", "5"}], "+", "3"}], ",",
               "2"}], "]"}], "]"}]}]}], " ", "/.", "numval"}], " ", "/.", 
        RowBox[{"A0", "\[Rule]", "1"}]}], " ", "/.", 
       RowBox[{"n", "\[Rule]", "1"}]}], ",", "B0"}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Re", "[", 
          RowBox[{"\[Psi]", "[", "x", "]"}], "]"}], "/.", "B0rule"}], " ", "/.",
         "krule"}], " ", "/.", 
       RowBox[{"K", "\[Rule]", 
        RowBox[{"band", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"Nn", "/", "2"}], ")"}], "*", "5"}], "+", "3"}], ",", 
           "1"}], "]"}], "]"}]}]}], " ", "/.", 
      RowBox[{"Ee", "\[Rule]", 
       RowBox[{"band", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"Nn", "/", "2"}], ")"}], "*", "5"}], "+", "3"}], ",", 
          "2"}], "]"}], "]"}]}]}], " ", "/.", "numval"}], " ", "/.", 
    RowBox[{"A0", "\[Rule]", "1"}]}], " ", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
   RowBox[{"PlotPoints", "\[Rule]", "500"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "0.2"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4529398274896626`*^9, 3.4529398299584126`*^9}}],

Cell["f\[UDoubleDot]r alle WF:", "Text"],

Cell[BoxData[
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i3", "=", "3"}], ",", 
   RowBox[{"i3", "\[LessEqual]", "1005"}], ",", 
   RowBox[{
    RowBox[{"B0rule", "=", 
     RowBox[{
      RowBox[{"Solve", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"bed1", "/.", "krule"}], " ", "/.", 
             RowBox[{"K", "\[Rule]", 
              RowBox[{"band", "[", 
               RowBox[{"[", 
                RowBox[{"i3", ",", "1"}], "]"}], "]"}]}]}], " ", "/.", 
            RowBox[{"Ee", "\[Rule]", 
             RowBox[{"band", "[", 
              RowBox[{"[", 
               RowBox[{"i3", ",", "2"}], "]"}], "]"}]}]}], " ", "/.", 
           "numval"}], " ", "/.", 
          RowBox[{"A0", "\[Rule]", "1"}]}], " ", "/.", 
         RowBox[{"n", "\[Rule]", "1"}]}], ",", "B0"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";", 
    RowBox[{"Print", "[", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"Re", "[", 
              RowBox[{"\[Psi]", "[", "x", "]"}], "]"}], "/.", "B0rule"}], " ",
             "/.", "krule"}], " ", "/.", 
           RowBox[{"K", "\[Rule]", 
            RowBox[{"band", "[", 
             RowBox[{"[", 
              RowBox[{"i3", ",", "1"}], "]"}], "]"}]}]}], " ", "/.", 
          RowBox[{"Ee", "\[Rule]", 
           RowBox[{"band", "[", 
            RowBox[{"[", 
             RowBox[{"i3", ",", "2"}], "]"}], "]"}]}]}], " ", "/.", 
         "numval"}], " ", "/.", 
        RowBox[{"A0", "\[Rule]", "1"}]}], " ", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
       RowBox[{"PlotPoints", "\[Rule]", "500"}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", "0.2"}]}], "]"}], "]"}], ";", 
    RowBox[{"i3", "=", 
     RowBox[{"i3", "+", 
      RowBox[{"5", "*", "20"}]}]}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4529398398334126`*^9, 3.4529398423802876`*^9}, {
  3.453449380942625*^9, 3.453449387677*^9}, {3.453449525286375*^9, 
  3.45344953702075*^9}, {3.45344980458325*^9, 3.453449814802*^9}, {
  3.453449895817625*^9, 3.453449896380125*^9}}],

Cell[BoxData[
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i3", "=", "51"}], ",", 
   RowBox[{"i3", "\[LessEqual]", "55"}], ",", 
   RowBox[{
    RowBox[{"B0rule", "=", 
     RowBox[{
      RowBox[{"Solve", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"bed1", "/.", "krule"}], " ", "/.", 
             RowBox[{"K", "\[Rule]", 
              RowBox[{"band", "[", 
               RowBox[{"[", 
                RowBox[{"i3", ",", "1"}], "]"}], "]"}]}]}], " ", "/.", 
            RowBox[{"Ee", "\[Rule]", 
             RowBox[{"band", "[", 
              RowBox[{"[", 
               RowBox[{"i3", ",", "2"}], "]"}], "]"}]}]}], " ", "/.", 
           "numval"}], " ", "/.", 
          RowBox[{"A0", "\[Rule]", "1"}]}], " ", "/.", 
         RowBox[{"n", "\[Rule]", "1"}]}], ",", "B0"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";", 
    RowBox[{"Print", "[", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"Re", "[", 
              RowBox[{"\[Psi]", "[", "x", "]"}], "]"}], "/.", "B0rule"}], " ",
             "/.", "krule"}], " ", "/.", 
           RowBox[{"K", "\[Rule]", 
            RowBox[{"band", "[", 
             RowBox[{"[", 
              RowBox[{"i3", ",", "1"}], "]"}], "]"}]}]}], " ", "/.", 
          RowBox[{"Ee", "\[Rule]", 
           RowBox[{"band", "[", 
            RowBox[{"[", 
             RowBox[{"i3", ",", "2"}], "]"}], "]"}]}]}], " ", "/.", 
         "numval"}], " ", "/.", 
        RowBox[{"A0", "\[Rule]", "1"}]}], " ", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
       RowBox[{"PlotPoints", "\[Rule]", "500"}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", "0.2"}]}], "]"}], "]"}], ";", 
    RowBox[{"i3", "=", 
     RowBox[{"i3", "+", "1"}]}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4529398398334126`*^9, 3.4529398423802876`*^9}, {
  3.453449380942625*^9, 3.453449387677*^9}, {3.453449525286375*^9, 
  3.45344953702075*^9}, {3.45344980458325*^9, 3.453449814802*^9}, {
  3.453449895817625*^9, 3.453449896380125*^9}, {3.453449949411375*^9, 
  3.453449960817625*^9}}],

Cell["Dichte:", "Text",
 CellChangeTimes->{{3.4558679456645*^9, 3.45586795619575*^9}}],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Abs", "[", 
           RowBox[{"\[Psi]", "[", "x", "]"}], "]"}], "^", "2"}], "/.", 
         "B0rule"}], " ", "/.", "krule"}], " ", "/.", 
       RowBox[{"K", "\[Rule]", 
        RowBox[{"band", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"Nn", "/", "2"}], ")"}], "*", "5"}], "+", "3"}], ",", 
           "1"}], "]"}], "]"}]}]}], " ", "/.", 
      RowBox[{"Ee", "\[Rule]", 
       RowBox[{"band", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"Nn", "/", "2"}], ")"}], "*", "5"}], "+", "3"}], ",", 
          "2"}], "]"}], "]"}]}]}], " ", "/.", "numval"}], " ", "/.", 
    RowBox[{"A0", "\[Rule]", "1"}]}], " ", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
   RowBox[{"PlotPoints", "\[Rule]", "500"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "0.2"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4529398632240376`*^9, 3.4529398731146626`*^9}}],

Cell[BoxData[
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i3", "=", "3"}], ",", 
   RowBox[{"i3", "\[LessEqual]", "1005"}], ",", 
   RowBox[{
    RowBox[{"B0rule", "=", 
     RowBox[{
      RowBox[{"Solve", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"bed1", "/.", "krule"}], " ", "/.", 
             RowBox[{"K", "\[Rule]", 
              RowBox[{"band", "[", 
               RowBox[{"[", 
                RowBox[{"i3", ",", "1"}], "]"}], "]"}]}]}], " ", "/.", 
            RowBox[{"Ee", "\[Rule]", 
             RowBox[{"band", "[", 
              RowBox[{"[", 
               RowBox[{"i3", ",", "2"}], "]"}], "]"}]}]}], " ", "/.", 
           "numval"}], " ", "/.", 
          RowBox[{"A0", "\[Rule]", "1"}]}], " ", "/.", 
         RowBox[{"n", "\[Rule]", "1"}]}], ",", "B0"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";", 
    RowBox[{"Print", "[", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"Abs", "[", 
               RowBox[{"\[Psi]", "[", "x", "]"}], "]"}], "^", "2"}], "/.", 
             "B0rule"}], " ", "/.", "krule"}], " ", "/.", 
           RowBox[{"K", "\[Rule]", 
            RowBox[{"band", "[", 
             RowBox[{"[", 
              RowBox[{"i3", ",", "1"}], "]"}], "]"}]}]}], " ", "/.", 
          RowBox[{"Ee", "\[Rule]", 
           RowBox[{"band", "[", 
            RowBox[{"[", 
             RowBox[{"i3", ",", "2"}], "]"}], "]"}]}]}], " ", "/.", 
         "numval"}], " ", "/.", 
        RowBox[{"A0", "\[Rule]", "1"}]}], " ", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
       RowBox[{"PlotPoints", "\[Rule]", "500"}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", "0.2"}]}], "]"}], "]"}], ";", 
    RowBox[{"i3", "=", 
     RowBox[{"i3", "+", 
      RowBox[{"5", "*", "20"}]}]}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.453449992192625*^9, 3.453450029427*^9}}],

Cell[BoxData[
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i3", "=", "51"}], ",", 
   RowBox[{"i3", "\[LessEqual]", "55"}], ",", 
   RowBox[{
    RowBox[{"B0rule", "=", 
     RowBox[{
      RowBox[{"Solve", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"bed1", "/.", "krule"}], " ", "/.", 
             RowBox[{"K", "\[Rule]", 
              RowBox[{"band", "[", 
               RowBox[{"[", 
                RowBox[{"i3", ",", "1"}], "]"}], "]"}]}]}], " ", "/.", 
            RowBox[{"Ee", "\[Rule]", 
             RowBox[{"band", "[", 
              RowBox[{"[", 
               RowBox[{"i3", ",", "2"}], "]"}], "]"}]}]}], " ", "/.", 
           "numval"}], " ", "/.", 
          RowBox[{"A0", "\[Rule]", "1"}]}], " ", "/.", 
         RowBox[{"n", "\[Rule]", "1"}]}], ",", "B0"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";", 
    RowBox[{"Print", "[", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"Abs", "[", 
               RowBox[{"\[Psi]", "[", "x", "]"}], "]"}], "^", "2"}], "/.", 
             "B0rule"}], " ", "/.", "krule"}], " ", "/.", 
           RowBox[{"K", "\[Rule]", 
            RowBox[{"band", "[", 
             RowBox[{"[", 
              RowBox[{"i3", ",", "1"}], "]"}], "]"}]}]}], " ", "/.", 
          RowBox[{"Ee", "\[Rule]", 
           RowBox[{"band", "[", 
            RowBox[{"[", 
             RowBox[{"i3", ",", "2"}], "]"}], "]"}]}]}], " ", "/.", 
         "numval"}], " ", "/.", 
        RowBox[{"A0", "\[Rule]", "1"}]}], " ", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
       RowBox[{"PlotPoints", "\[Rule]", "500"}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", "0.2"}]}], "]"}], "]"}], ";", 
    RowBox[{"i3", "=", 
     RowBox[{"i3", "+", "1"}]}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.453449992192625*^9, 3.453450029427*^9}, {
  3.453450196848875*^9, 3.45345020927075*^9}, {3.45345028464575*^9, 
  3.453450286927*^9}}]
}, Closed]]
}, Open  ]]
},
WindowSize->{1657, 962},
WindowMargins->{{Automatic, 1}, {Automatic, -2}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (November 13, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 44, 0, 83, "Title"],
Cell[626, 24, 35, 0, 49, "Subtitle"],
Cell[664, 26, 194, 2, 28, "Subsubtitle"],
Cell[CellGroupData[{
Cell[883, 32, 31, 0, 71, "Section"],
Cell[917, 34, 613, 14, 72, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[1567, 53, 45, 0, 41, "Section"],
Cell[1615, 55, 382, 14, 59, "Text"],
Cell[2000, 71, 111, 3, 29, "Text"],
Cell[2114, 76, 380, 12, 52, "Input"],
Cell[2497, 90, 68, 2, 29, "Text"],
Cell[2568, 94, 642, 20, 33, "Input"],
Cell[3213, 116, 33, 0, 29, "Text"],
Cell[3249, 118, 193, 7, 51, "Input"],
Cell[3445, 127, 48, 0, 29, "Text"],
Cell[3496, 129, 131, 4, 31, "Input"],
Cell[3630, 135, 49, 0, 29, "Text"],
Cell[3682, 137, 512, 16, 31, "Input"],
Cell[4197, 155, 91, 2, 29, "Text"],
Cell[4291, 159, 861, 27, 47, "Input"],
Cell[5155, 188, 178, 4, 29, "Text"],
Cell[5336, 194, 449, 14, 56, "Input"],
Cell[5788, 210, 30, 0, 31, "Input"],
Cell[5821, 212, 30, 0, 31, "Input"],
Cell[5854, 214, 331, 10, 52, "Input"],
Cell[6188, 226, 516, 16, 52, "Input"],
Cell[6707, 244, 502, 15, 31, "Input"],
Cell[7212, 261, 59, 1, 31, "Input"],
Cell[7274, 264, 452, 12, 38, "Input"],
Cell[7729, 278, 96, 2, 29, "Text"],
Cell[7828, 282, 275, 8, 31, "Input"],
Cell[8106, 292, 135, 4, 31, "Input"],
Cell[8244, 298, 67, 2, 29, "Text"],
Cell[8314, 302, 147, 4, 31, "Input"],
Cell[8464, 308, 345, 10, 31, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[8846, 323, 31, 0, 41, "Section"],
Cell[8880, 325, 72, 2, 29, "Text"],
Cell[8955, 329, 480, 13, 31, "Input"],
Cell[9438, 344, 529, 16, 31, "Input"],
Cell[9970, 362, 39, 0, 29, "Text"],
Cell[10012, 364, 2249, 65, 172, "Input"],
Cell[12264, 431, 162, 4, 31, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[12463, 440, 51, 0, 41, "Section"],
Cell[12517, 442, 67, 2, 29, "Text"],
Cell[12587, 446, 50, 0, 29, "Text"],
Cell[12640, 448, 4714, 151, 272, "Input"],
Cell[17357, 601, 39, 0, 29, "Text"],
Cell[17399, 603, 64, 0, 29, "Text"],
Cell[17466, 605, 1099, 32, 31, "Input"],
Cell[18568, 639, 1210, 36, 52, "Input"],
Cell[19781, 677, 40, 0, 29, "Text"],
Cell[19824, 679, 2275, 61, 72, "Input"],
Cell[22102, 742, 2295, 61, 72, "Input"],
Cell[24400, 805, 86, 1, 29, "Text"],
Cell[24489, 808, 1244, 37, 52, "Input"],
Cell[25736, 847, 2121, 59, 72, "Input"],
Cell[27860, 908, 2185, 60, 72, "Input"]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
