(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     19203,        638]
NotebookOptionsPosition[     16914,        565]
NotebookOutlinePosition[     17320,        582]
CellTagsIndexPosition[     17277,        579]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Computer\[UDoubleDot]bungen", "Title"],

Cell["Quantenmechanik", "Subtitle"],

Cell["\[CapitalUDoubleDot]bung 6: Spin im Magnetfeld", "Subsubtitle",
 CellChangeTimes->{{3.5116789569465103`*^9, 3.5116789576465116`*^9}}],

Cell[CellGroupData[{

Cell["Definitionen", "Section"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], "\n", 
 RowBox[{
  RowBox[{"bed", "=", 
   RowBox[{
    RowBox[{"\[HBar]", ">", "0"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}], " ", "&&", " ", 
    RowBox[{"x", "\[Element]", " ", "Reals"}], " ", "&&", " ", 
    RowBox[{"a", ">", "0"}], " ", "&&", " ", 
    RowBox[{"b", ">", "0"}], " ", "&&", " ", 
    RowBox[{"k0", ">", "0"}], " ", "&&", " ", 
    RowBox[{"En", ">", "0"}], " ", "&&", " ", 
    RowBox[{"t", ">", "0"}], " ", "&&", " ", 
    RowBox[{"k", ">", "0"}], "&&", 
    RowBox[{"\[Theta]", " ", "\[Element]", " ", "Reals"}], " ", "&&", " ", 
    RowBox[{"\[Phi]", " ", "\[Element]", " ", "Reals"}], " ", "&&", " ", 
    RowBox[{"\[CapitalOmega]", " ", "\[Element]", " ", "Reals"}], " ", "&&", 
    " ", 
    RowBox[{"\[Theta]0", " ", "\[Element]", " ", "Reals"}], " ", "&&", " ", 
    RowBox[{"\[Phi]0", " ", "\[Element]", " ", "Reals"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.519295899733737*^9, 3.519295906207749*^9}, {
  3.5192960822384577`*^9, 3.5192960824724584`*^9}, {3.5192961529377823`*^9, 
  3.519296165417804*^9}}],

Cell["Definition der Spinzust\[ADoubleDot]nde:", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Sp", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Sm", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], ";"}]}], "Input"],

Cell["Pauli-Matrizen:", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Pauli", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Sigma]1", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"\[Sigma]2", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"-", "I"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"I", ",", "0"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"\[Sigma]3", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "}"}]}]}], "}"}]}], ";"}]], "Input"],

Cell["Spin-Operator:", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"S", "=", 
   RowBox[{
    FractionBox["\[HBar]", "2"], 
    RowBox[{"{", 
     RowBox[{"\[Sigma]1", ",", "\[Sigma]2", ",", "\[Sigma]3"}], "}"}]}]}], 
  ";"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Darstellung eines allgemeinen Spinzustandes", "Section"],

Cell["\<\
allgemeiner Spinzustand: Linearkombination der Einzelzust\[ADoubleDot]nde:\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Chi]o", "[", 
   RowBox[{"\[Theta]_", ",", "\[Phi]_"}], "]"}], "=", 
  RowBox[{
   RowBox[{
    SuperscriptBox["E", 
     RowBox[{
      RowBox[{"-", "I"}], " ", 
      FractionBox["\[Phi]", "2"]}]], 
    RowBox[{"Cos", "[", 
     FractionBox["\[Theta]", "2"], "]"}], "Sp"}], "+", 
   RowBox[{
    SuperscriptBox["E", 
     RowBox[{"I", " ", 
      FractionBox["\[Phi]", "2"]}]], 
    RowBox[{"Sin", "[", 
     FractionBox["\[Theta]", "2"], "]"}], "Sm"}]}]}]], "Input"],

Cell["Erwartungswert:", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Conjugate", "[", 
         RowBox[{"\[Chi]o", "[", 
          RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], "]"}], ".", 
        RowBox[{"S", "[", 
         RowBox[{"[", "1", "]"}], "]"}], ".", 
        RowBox[{"\[Chi]o", "[", 
         RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"Conjugate", "[", 
         RowBox[{"\[Chi]o", "[", 
          RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], "]"}], ".", 
        RowBox[{"S", "[", 
         RowBox[{"[", "2", "]"}], "]"}], ".", 
        RowBox[{"\[Chi]o", "[", 
         RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"Conjugate", "[", 
         RowBox[{"\[Chi]o", "[", 
          RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], "]"}], ".", 
        RowBox[{"S", "[", 
         RowBox[{"[", "3", "]"}], "]"}], ".", 
        RowBox[{"\[Chi]o", "[", 
         RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}]}], "}"}], " ", "/.", 
     "Pauli"}], ",", "bed"}], "]"}], " ", "//", " ", "MatrixForm"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"=", 
   RowBox[{
    FractionBox["\[HBar]", "2"], "n"}]}], " ", ";", " ", 
  RowBox[{"n", ":", " ", "Einheitsvektor"}]}]], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Projektion", " ", "in", " ", "Richtung", " ", "Sp", " ", 
   RowBox[{"bzw", ".", " ", "Sm"}]}], " ", "\[Rule]", " ", 
  RowBox[{"Wahrscheinlichkeit", " ", "den", " ", "Spin", " ", 
   FractionBox["\[HBar]", "2"], "n", " ", "im", " ", "Zustand", " ", "Sp", 
   " ", "oder", " ", "Sm", " ", "zu", " ", 
   RowBox[{"messen", ":"}]}]}]], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"wktsp", "[", 
   RowBox[{"\[Theta]_", ",", "\[Phi]_"}], "]"}], "=", 
  SuperscriptBox[
   RowBox[{"Abs", "[", 
    RowBox[{
     RowBox[{"\[Chi]o", "[", 
      RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ".", "Sp"}], "]"}], 
   "2"]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"wktsm", "[", 
   RowBox[{"\[Theta]_", ",", "\[Phi]_"}], "]"}], "=", 
  SuperscriptBox[
   RowBox[{"Abs", "[", 
    RowBox[{
     RowBox[{"\[Chi]o", "[", 
      RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ".", "Sm"}], "]"}], 
   "2"]}]], "Input"],

Cell["Darstellung dieser Wahrscheinlichkeiten:", "Text"],

Cell[BoxData[
 RowBox[{"wktspplot", "=", 
  RowBox[{"SphericalPlot3D", "[", 
   RowBox[{
    RowBox[{"wktsp", "[", 
     RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Theta]", ",", "0", ",", "\[Pi]"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Phi]", ",", 
      RowBox[{"\[Pi]", "/", "2"}], ",", 
      RowBox[{
       RowBox[{"3", "/", "2"}], "\[Pi]"}]}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"wktsmplot", "=", 
  RowBox[{"SphericalPlot3D", "[", 
   RowBox[{
    RowBox[{"wktsm", "[", 
     RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Theta]", ",", "0", ",", "\[Pi]"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Phi]", ",", 
      RowBox[{"\[Pi]", "/", "2"}], ",", 
      RowBox[{
       RowBox[{"3", "/", "2"}], "\[Pi]"}]}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"wktspplot", ",", "wktsmplot", ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4423016357296247`*^9, 3.4423016484796247`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Zeitabh\[ADoubleDot]ngigkeit im Magnetfeld", "Section"],

Cell["magnetisches Moment:", "Text"],

Cell[BoxData[
 RowBox[{"\[Mu]", "=", 
  RowBox[{
   RowBox[{"-", "\[Gamma]"}], " ", "S"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"mit", " ", "\[Gamma]"}], "=", 
  RowBox[{"gs", " ", 
   FractionBox["e", 
    RowBox[{"2", " ", "M"}]]}]}]], "Text"],

Cell["Magnetfeld in Richtung z:", "Text"],

Cell[BoxData[
 RowBox[{"B", "=", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", "B0"}], "}"}]}]], "Input"],

Cell["Hamilton-Operator:", "Text"],

Cell[BoxData[
 RowBox[{"H", "=", 
  RowBox[{"-", 
   RowBox[{"\[Mu]", ".", "B"}]}]}]], "Input"],

Cell["\<\
zeitabh\[ADoubleDot]ngigige Gleichung f\[UDoubleDot]r \
Spinzust\[ADoubleDot]nde \[Chi](t):\
\>", "Text"],

Cell[BoxData[
 RowBox[{"dgl", "=", 
  RowBox[{
   RowBox[{"I", " ", "\[HBar]", " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", "t"], " ", 
     RowBox[{"\[Chi]", "[", "t", "]"}]}]}], "==", 
   RowBox[{"H", " ", 
    RowBox[{"\[Chi]", "[", "t", "]"}]}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{"dgl", ",", 
   RowBox[{"\[Chi]", "[", "t", "]"}], ",", "t"}], "]"}]], "Input"],

Cell["\[CapitalOmega]=\[Gamma] B0 ; Matrix als Exponent:", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Chi]", "[", "t_", "]"}], "=", 
  RowBox[{
   RowBox[{
    RowBox[{"MatrixExp", "[", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], " ", "\[ImaginaryI]", " ", "t", " ", 
      "\[Sigma]3", " ", "\[CapitalOmega]"}], "]"}], ".", " ", 
    RowBox[{"\[Chi]o", "[", 
     RowBox[{"\[Theta]0", ",", "\[Phi]0"}], "]"}]}], " ", "/.", " ", 
   "Pauli"}]}]], "Input"],

Cell["\<\
zeitabh\[ADoubleDot]ngiger Erwartungswert des Spins:\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"s", "[", "t_", "]"}], "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Conjugate", "[", 
         RowBox[{"\[Chi]", "[", "t", "]"}], "]"}], ".", 
        RowBox[{"S", "[", 
         RowBox[{"[", "1", "]"}], "]"}], ".", 
        RowBox[{"\[Chi]", "[", "t", "]"}]}], ",", 
       RowBox[{
        RowBox[{"Conjugate", "[", 
         RowBox[{"\[Chi]", "[", "t", "]"}], "]"}], ".", 
        RowBox[{"S", "[", 
         RowBox[{"[", "2", "]"}], "]"}], ".", 
        RowBox[{"\[Chi]", "[", "t", "]"}]}], ",", 
       RowBox[{
        RowBox[{"Conjugate", "[", 
         RowBox[{"\[Chi]", "[", "t", "]"}], "]"}], ".", 
        RowBox[{"S", "[", 
         RowBox[{"[", "3", "]"}], "]"}], ".", 
        RowBox[{"\[Chi]", "[", "t", "]"}]}]}], "}"}], " ", "/.", "Pauli"}], 
    ",", "bed"}], "]"}], " "}]], "Input"],

Cell["\<\
\[Rule] Pr\[ADoubleDot]zession des Spinerwartungswertes\
\>", "Text",
 CellChangeTimes->{{3.519351963470123*^9, 3.5193519637821236`*^9}}],

Cell["Animation:", "Text"],

Cell[BoxData[
 RowBox[{"numval", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[HBar]", "\[Rule]", "1"}], ",", 
    RowBox[{"\[Theta]0", "\[Rule]", 
     RowBox[{"\[Pi]", "/", "4"}]}], ",", 
    RowBox[{"\[CapitalOmega]", "\[Rule]", 
     RowBox[{"\[Pi]", "/", "30"}]}], ",", 
    RowBox[{"\[Phi]0", "\[Rule]", 
     RowBox[{"\[Pi]", "/", "8"}]}]}], "}"}]}]], "Input"],

Cell["Erwartungswert:", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"pl1", "[", "t_", "]"}], ":=", 
  RowBox[{"Graphics3D", "[", 
   RowBox[{
    RowBox[{"Line", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{
        RowBox[{"2", "*", 
         RowBox[{"s", "[", "t", "]"}]}], " ", "/.", "numval"}]}], "}"}], 
     "]"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4423017290421247`*^9, 3.4423017547764997`*^9}}],

Cell["Wellenfunktion:", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"pl2", "[", "t_", "]"}], ":=", 
  RowBox[{"Graphics", "[", 
   RowBox[{
    RowBox[{"Line", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"Im", "[", 
            RowBox[{"\[Chi]", "[", "t", "]"}], "]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", 
          RowBox[{"Re", "[", 
           RowBox[{
            RowBox[{"\[Chi]", "[", "t", "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "}"}], " ", "/.", 
        "numval"}]}], "}"}], "]"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4423017330889997`*^9, 3.4423017587608747`*^9}}],

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Grid", "[", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"pl1", "[", "t", "]"}], ",", 
       RowBox[{"pl2", "[", "t", "]"}]}], "}"}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "160", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4423017847452497`*^9, 3.4423017878077497`*^9}, 
   3.4423018230264997`*^9, {3.519291128440866*^9, 3.519291156288162*^9}}],

Cell[CellGroupData[{

Cell["andere Form der Animation", "Subsection",
 CellChangeTimes->{{3.5192920339203663`*^9, 3.5192920377203712`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Spin", "[", "t_", "]"}], ":=", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Darker", "[", "Blue", "]"}], ",", 
       RowBox[{"Arrowheads", "[", ".08", "]"}], ",", 
       RowBox[{"Arrow", "[", 
        RowBox[{"Tube", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
            RowBox[{
             RowBox[{"2", "*", 
              RowBox[{"s", "[", "t", "]"}]}], "/.", "numval"}]}], "}"}], ",", 
          ".02"}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"BFeld", ":=", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"Black", ",", 
      RowBox[{"Arrowheads", "[", ".08", "]"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"Tube", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", 
             RowBox[{"-", "1"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", ".01"}], 
        "]"}], "]"}]}], "}"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"strvec", "[", "r_", "]"}], ":=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"\[Phi]0", "+", 
        RowBox[{"r", " ", "\[CapitalOmega]"}]}], "]"}], "*", 
      RowBox[{"Sin", "[", "\[Theta]0", "]"}]}], ",", 
     RowBox[{
      RowBox[{"Sin", "[", "\[Theta]0", "]"}], "*", 
      RowBox[{"Sin", "[", 
       RowBox[{"\[Phi]0", "+", 
        RowBox[{"r", " ", "\[CapitalOmega]"}]}], "]"}]}], ",", 
     RowBox[{"Cos", "[", "\[Theta]0", "]"}]}], "}"}], "/.", 
   "numval"}]}], "\n", 
 RowBox[{
  RowBox[{"Quiet", "[", 
   RowBox[{"<<", "Graphics`ParametricPlot3D`"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"kurve", "[", "t_", "]"}], ":=", 
   RowBox[{"PointParametricPlot3D", "[", 
    RowBox[{
     RowBox[{"strvec", "[", "r", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"r", ",", "0", ",", "t", ",", "1"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Show", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"kurve", "[", "t", "]"}], ",", 
      RowBox[{"Spin", "[", "t", "]"}], ",", "BFeld"}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "60", ",", "2"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.4423019352139997`*^9, 3.4423019364327497`*^9}, {
   3.5192917672599926`*^9, 3.519291830990082*^9}, {3.519291985900299*^9, 
   3.51929199371031*^9}, 3.519296135777752*^9, {3.5192961723598166`*^9, 
   3.5192961741070194`*^9}}]
}, Open  ]]
}, Closed]]
}, Open  ]]
},
WindowSize->{1350, 634},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (November 13, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 44, 0, 83, "Title"],
Cell[626, 24, 35, 0, 49, "Subtitle"],
Cell[664, 26, 139, 1, 28, "Subsubtitle"],
Cell[CellGroupData[{
Cell[828, 31, 31, 0, 71, "Section"],
Cell[862, 33, 1111, 22, 52, "Input"],
Cell[1976, 57, 56, 0, 29, "Text"],
Cell[2035, 59, 237, 8, 52, "Input"],
Cell[2275, 69, 31, 0, 29, "Text"],
Cell[2309, 71, 821, 27, 31, "Input"],
Cell[3133, 100, 30, 0, 29, "Text"],
Cell[3166, 102, 203, 7, 47, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[3406, 114, 62, 0, 41, "Section"],
Cell[3471, 116, 98, 2, 29, "Text"],
Cell[3572, 120, 506, 17, 48, "Input"],
Cell[4081, 139, 31, 0, 29, "Text"],
Cell[4115, 141, 1168, 31, 31, "Input"],
Cell[5286, 174, 165, 5, 46, "Text"],
Cell[5454, 181, 376, 7, 46, "Text"],
Cell[5833, 190, 280, 9, 31, "Input"],
Cell[6116, 201, 280, 9, 31, "Input"],
Cell[6399, 212, 56, 0, 29, "Text"],
Cell[6458, 214, 428, 12, 31, "Input"],
Cell[6889, 228, 428, 12, 31, "Input"],
Cell[7320, 242, 292, 7, 31, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[7649, 254, 61, 0, 41, "Section"],
Cell[7713, 256, 36, 0, 29, "Text"],
Cell[7752, 258, 102, 3, 31, "Input"],
Cell[7857, 263, 151, 5, 45, "Text"],
Cell[8011, 270, 41, 0, 29, "Text"],
Cell[8055, 272, 107, 3, 31, "Input"],
Cell[8165, 277, 34, 0, 29, "Text"],
Cell[8202, 279, 95, 3, 31, "Input"],
Cell[8300, 284, 115, 3, 29, "Text"],
Cell[8418, 289, 270, 8, 31, "Input"],
Cell[8691, 299, 128, 3, 31, "Input"],
Cell[8822, 304, 66, 0, 29, "Text"],
Cell[8891, 306, 413, 12, 47, "Input"],
Cell[9307, 320, 76, 2, 29, "Text"],
Cell[9386, 324, 920, 26, 31, "Input"],
Cell[10309, 352, 147, 3, 29, "Text"],
Cell[10459, 357, 26, 0, 29, "Text"],
Cell[10488, 359, 370, 10, 31, "Input"],
Cell[10861, 371, 31, 0, 29, "Text"],
Cell[10895, 373, 822, 26, 31, "Input"],
Cell[11720, 401, 31, 0, 29, "Text"],
Cell[11754, 403, 1015, 31, 31, "Input"],
Cell[12772, 436, 478, 12, 31, "Input"],
Cell[CellGroupData[{
Cell[13275, 452, 117, 1, 36, "Subsection"],
Cell[13395, 455, 3479, 105, 132, "Input"]
}, Open  ]]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
