(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    730349,      13389]
NotebookOptionsPosition[    724401,      13215]
NotebookOutlinePosition[    724746,      13230]
CellTagsIndexPosition[    724703,      13227]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.55058922040625*^9, 3.550589221421875*^9}, 
   3.550589251484375*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "SetDirectory", "[", 
   "\"\<D:\\\\Dokumente und Einstellungen\\\\Sword\\\\Eigene Dateien\\\\Uni\\\
\\F-Praktikum\\\\Protokolle\\\\alpha\\\\20120625\>\"", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.55058278246875*^9, 3.550582794984375*^9}, {
  3.550583258984375*^9, 3.5505832611875*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"testexport", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"\"\<testexport.dat\>\"", ",", "\"\<Table\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"leer", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"\"\<leer.dat\>\"", ",", "\"\<Table\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"luft500", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"\"\<luft500.dat\>\"", ",", "\"\<Table\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"luft650", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"\"\<luft650.dat\>\"", ",", "\"\<Table\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"D1", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"\"\<1d.dat\>\"", ",", "\"\<Table\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"D2", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"\"\<2d.dat\>\"", ",", "\"\<Table\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"F1", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"\"\<1f.dat\>\"", ",", "\"\<Table\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"F2", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"\"\<2f.dat\>\"", ",", "\"\<Table\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"F3", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"\"\<3f.dat\>\"", ",", "\"\<Table\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"F4", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"\"\<4f.dat\>\"", ",", "\"\<Table\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"D2F1", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"\"\<2d1f.dat\>\"", ",", "\"\<Table\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"alu", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"\"\<alu.dat\>\"", ",", "\"\<Table\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kali1", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"\"\<kalibriermessung.dat\>\"", ",", "\"\<Table\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kali2", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"\"\<kalibrier2.dat\>\"", ",", "\"\<Table\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kali1gaus1", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"\"\<kali1_1.dat\>\"", ",", "\"\<Table\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kali1gaus2", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"\"\<kali1_2.dat\>\"", ",", "\"\<Table\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kali1gaus3", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"\"\<kali1_3.dat\>\"", ",", "\"\<Table\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kali2gaus1", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"\"\<kali2_1.dat\>\"", ",", "\"\<Table\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kali2gaus2", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"\"\<kali2_2.dat\>\"", ",", "\"\<Table\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kali2gaus3", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"\"\<kali2_3.dat\>\"", ",", "\"\<Table\>\""}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.55058280503125*^9, 3.550582812703125*^9}, {
   3.5505828450625*^9, 3.5505829088125*^9}, {3.55058323478125*^9, 
   3.55058340728125*^9}, 3.5505861158125*^9, 3.55058648025*^9, {
   3.5505898611875*^9, 3.550590015171875*^9}, {3.550590054359375*^9, 
   3.55059007309375*^9}, {3.550590140046875*^9, 3.550590175109375*^9}, {
   3.5506970809375*^9, 3.550697157921875*^9}, {3.55069719075*^9, 
   3.55069722309375*^9}, {3.5506972660625*^9, 3.5506972985625*^9}, 
   3.55069734459375*^9, 3.550697543171875*^9}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Gibt", " ", "Kanal", " ", 
   RowBox[{"zur\[UDoubleDot]ck", ":", " ", 
    RowBox[{"{", 
     RowBox[{"peak", ",", " ", 
      RowBox[{"linke", " ", "flanke"}], ",", " ", 
      RowBox[{"rechte", " ", "flanke"}], ",", " ", 
      RowBox[{"rechnerisch", " ", "linke", " ", "flanke"}], ",", " ", 
      "halbwertsh\[ODoubleDot]he"}], "}"}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.550586302953125*^9, 3.550586334921875*^9}, {
  3.550586413171875*^9, 3.55058641959375*^9}, {3.55058806596875*^9, 
  3.5505880685625*^9}, {3.550588172703125*^9, 3.550588191625*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"daten", "[", 
   RowBox[{"werte_", ",", "schwelle_", ",", 
    RowBox[{"peak_:", "0"}]}], "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"bpek", "=", "0"}], ";", "\[IndentingNewLine]", 
    RowBox[{"ruck", "=", 
     RowBox[{"{", 
      RowBox[{"peak", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"max", "=", 
     RowBox[{"Max", "[", "werte", "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"For", "[", 
     RowBox[{
      RowBox[{"i", "=", "1"}], ",", 
      RowBox[{"i", "<=", 
       RowBox[{"Length", "[", "werte", "]"}]}], ",", 
      RowBox[{"i", "++"}], ",", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"max", "/", "2"}], ">", 
             RowBox[{
              RowBox[{"werte", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "-", "schwelle"}]}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"max", "/", "2"}], "<", 
             RowBox[{
              RowBox[{"werte", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "+", "schwelle"}]}], ")"}]}], 
          ",", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"bpek", "\[Equal]", "0"}], ",", 
            RowBox[{
             RowBox[{"ruck", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "=", "i"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"ruck", "[", 
                RowBox[{"[", "3", "]"}], "]"}], "=", "i"}], ";", 
              RowBox[{
               RowBox[{"ruck", "[", 
                RowBox[{"[", "5", "]"}], "]"}], "=", 
               RowBox[{
                RowBox[{"werte", "[", 
                 RowBox[{"[", "i", "]"}], "]"}], "*", "2"}]}], ";"}], ")"}]}],
            "]"}]}], "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"peak", "==", "0"}], "&&", 
           RowBox[{"max", "\[Equal]", 
            RowBox[{"werte", "[", 
             RowBox[{"[", "i", "]"}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"ruck", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "=", "i"}]}], "]"}], 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"max", "\[Equal]", 
           RowBox[{"werte", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}], ",", 
          RowBox[{"bpek", "=", "1"}]}], "]"}]}], "\[IndentingNewLine]", 
       ")"}]}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"ruck", "[", 
      RowBox[{"[", "4", "]"}], "]"}], "=", 
     RowBox[{
      RowBox[{"ruck", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"ruck", "[", 
         RowBox[{"[", "3", "]"}], "]"}], "-", 
        RowBox[{"ruck", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], ")"}]}]}], ";", 
    "\[IndentingNewLine]", "ruck"}], ")"}]}]], "Input",
 CellChangeTimes->{{3.5505834545*^9, 3.55058363175*^9}, {3.550585579703125*^9,
    3.550585684453125*^9}, {3.55058584496875*^9, 3.550585861921875*^9}, 
   3.5505859315625*^9, {3.550585970265625*^9, 3.550586044046875*^9}, {
   3.55058608159375*^9, 3.550586092234375*^9}, {3.550586147421875*^9, 
   3.550586193546875*^9}, {3.55058623671875*^9, 3.5505862515625*^9}, {
   3.550586352578125*^9, 3.550586401546875*^9}, {3.550588064140625*^9, 
   3.55058810634375*^9}, {3.5505881958125*^9, 3.55058820459375*^9}, {
   3.550588238484375*^9, 3.550588283984375*^9}, {3.550588321828125*^9, 
   3.55058851378125*^9}, {3.550588581296875*^9, 3.55058864046875*^9}, {
   3.55058943446875*^9, 3.55058953803125*^9}, {3.55058961971875*^9, 
   3.55058962040625*^9}, {3.550589735109375*^9, 3.5505897524375*^9}, {
   3.55059512771875*^9, 3.550595127953125*^9}, {3.550696815828125*^9, 
   3.550696883484375*^9}, 3.55069698971875*^9, {3.550697063609375*^9, 
   3.55069706578125*^9}, {3.5507504351875*^9, 3.55075053228125*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"testdaten", "=", 
  RowBox[{"daten", "[", 
   RowBox[{
    RowBox[{"testexport", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", "2"}], "]"}], "]"}], ",", "150", ",", "3218"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"leerdaten", "=", 
  RowBox[{"daten", "[", 
   RowBox[{
    RowBox[{"leer", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", "2"}], "]"}], "]"}], ",", "150"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"luft500daten", "=", 
  RowBox[{"daten", "[", 
   RowBox[{
    RowBox[{"luft500", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", "2"}], "]"}], "]"}], ",", "10", ",", "1566"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"luft650daten", "=", 
   RowBox[{"daten", "[", 
    RowBox[{
     RowBox[{"luft650", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "2"}], "]"}], "]"}], ",", "10", ",", "788"}], 
    "]"}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"D1daten", "=", 
  RowBox[{"daten", "[", 
   RowBox[{
    RowBox[{"D1", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", "2"}], "]"}], "]"}], ",", "50", ",", "2386"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"D2daten", "=", 
  RowBox[{"daten", "[", 
   RowBox[{
    RowBox[{"D2", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", "2"}], "]"}], "]"}], ",", "10"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"F1daten", "=", 
  RowBox[{"daten", "[", 
   RowBox[{
    RowBox[{"F1", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", "2"}], "]"}], "]"}], ",", "50", ",", "3083"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"F2daten", "=", 
  RowBox[{"daten", "[", 
   RowBox[{
    RowBox[{"F2", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", "2"}], "]"}], "]"}], ",", "70", ",", "2931"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"F3daten", "=", 
  RowBox[{"daten", "[", 
   RowBox[{
    RowBox[{"F3", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", "2"}], "]"}], "]"}], ",", "50"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"F4daten", "=", 
  RowBox[{"daten", "[", 
   RowBox[{
    RowBox[{"F4", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", "2"}], "]"}], "]"}], ",", "50"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"D2F1daten", "=", 
  RowBox[{"daten", "[", 
   RowBox[{
    RowBox[{"D2F1", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", "2"}], "]"}], "]"}], ",", "10", ",", "1048"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"aludaten", "=", 
   RowBox[{"daten", "[", 
    RowBox[{
     RowBox[{"alu", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "2"}], "]"}], "]"}], ",", "20"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"kali1gaus1daten", "=", 
  RowBox[{"daten", "[", 
   RowBox[{
    RowBox[{"kali1gaus1", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", "2"}], "]"}], "]"}], ",", "10"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"kali1gaus2daten", "=", 
  RowBox[{"daten", "[", 
   RowBox[{
    RowBox[{"kali1gaus2", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", "2"}], "]"}], "]"}], ",", "20"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"kali1gaus3daten", "=", 
  RowBox[{"daten", "[", 
   RowBox[{
    RowBox[{"kali1gaus3", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", "2"}], "]"}], "]"}], ",", "20"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"kali2gaus1daten", "=", 
  RowBox[{"daten", "[", 
   RowBox[{
    RowBox[{"kali2gaus1", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", "2"}], "]"}], "]"}], ",", "50"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"kali2gaus2daten", "=", 
  RowBox[{"daten", "[", 
   RowBox[{
    RowBox[{"kali2gaus2", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", "2"}], "]"}], "]"}], ",", "40"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"kali2gaus3daten", "=", 
  RowBox[{"daten", "[", 
   RowBox[{
    RowBox[{"kali2gaus3", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", "2"}], "]"}], "]"}], ",", "10"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.550585877421875*^9, 3.5505858970625*^9}, {
   3.550586260078125*^9, 3.5505862656875*^9}, {3.55058644203125*^9, 
   3.550586466421875*^9}, {3.550587116734375*^9, 3.550587137421875*^9}, {
   3.550589115078125*^9, 3.55058916396875*^9}, {3.55058920940625*^9, 
   3.55058921125*^9}, {3.550589277484375*^9, 3.5505893144375*^9}, {
   3.55058940171875*^9, 3.55058941546875*^9}, {3.550589560078125*^9, 
   3.550589569875*^9}, 3.55058967215625*^9, {3.550589796609375*^9, 
   3.550589819578125*^9}, {3.55059521796875*^9, 3.55059529203125*^9}, {
   3.550595350546875*^9, 3.5505954085625*^9}, {3.55059578509375*^9, 
   3.550595786140625*^9}, {3.55059583225*^9, 3.550595834265625*^9}, {
   3.55059586559375*^9, 3.55059586684375*^9}, {3.55059592634375*^9, 
   3.550595928484375*^9}, {3.55059598715625*^9, 3.550595999296875*^9}, {
   3.5505960449375*^9, 3.550596046265625*^9}, {3.550598657875*^9, 
   3.550598732234375*^9}, {3.5506973565*^9, 3.550697362453125*^9}, 
   3.55069739828125*^9, {3.550697461703125*^9, 3.550697476234375*^9}, {
   3.55069755953125*^9, 3.550697559578125*^9}, 3.5507527416875*^9, {
   3.550753227671875*^9, 3.550753253671875*^9}, {3.55075331853125*^9, 
   3.55075331890625*^9}, {3.5507537074375*^9, 3.550753707515625*^9}, {
   3.550753875140625*^9, 3.5507538795625*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3218", ",", "3210", ",", "3228", ",", "3208", ",", "958"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.5505894046875*^9, 3.550589416375*^9}, 
   3.550589540171875*^9, 3.55058957046875*^9, 3.550589622640625*^9, 
   3.550589673*^9, {3.550589740921875*^9, 3.550589754078125*^9}, {
   3.55058979815625*^9, 3.55058982078125*^9}, 3.550595050828125*^9, 
   3.55059512953125*^9, 3.550595299890625*^9, {3.550595355515625*^9, 
   3.550595409015625*^9}, 3.55059549746875*^9, 3.550595787*^9, 
   3.550595835203125*^9, 3.55059586775*^9, 3.550595929328125*^9, {
   3.550595988015625*^9, 3.5505959999375*^9}, 3.550596046765625*^9, 
   3.5505980496875*^9, {3.550598700125*^9, 3.550598732875*^9}, 
   3.550658191046875*^9, 3.550658880703125*^9, 3.550670913921875*^9, 
   3.55069688665625*^9, 3.55069699196875*^9, {3.5506971653125*^9, 
   3.550697180390625*^9}, {3.550697215171875*^9, 3.550697217703125*^9}, 
   3.550697303546875*^9, {3.550697351609375*^9, 3.55069736403125*^9}, 
   3.550697399578125*^9, {3.55069746284375*^9, 3.550697477328125*^9}, 
   3.5506975796875*^9, {3.55075047953125*^9, 3.550750499640625*^9}, 
   3.55075053390625*^9, 3.550752743234375*^9, {3.550753229375*^9, 
   3.5507532555*^9}, 3.550753319421875*^9, 3.55075370846875*^9, 
   3.550753846609375*^9, 3.55075388046875*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3218", ",", "3209", ",", "3227", ",", "3209", ",", "2478"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.5505894046875*^9, 3.550589416375*^9}, 
   3.550589540171875*^9, 3.55058957046875*^9, 3.550589622640625*^9, 
   3.550589673*^9, {3.550589740921875*^9, 3.550589754078125*^9}, {
   3.55058979815625*^9, 3.55058982078125*^9}, 3.550595050828125*^9, 
   3.55059512953125*^9, 3.550595299890625*^9, {3.550595355515625*^9, 
   3.550595409015625*^9}, 3.55059549746875*^9, 3.550595787*^9, 
   3.550595835203125*^9, 3.55059586775*^9, 3.550595929328125*^9, {
   3.550595988015625*^9, 3.5505959999375*^9}, 3.550596046765625*^9, 
   3.5505980496875*^9, {3.550598700125*^9, 3.550598732875*^9}, 
   3.550658191046875*^9, 3.550658880703125*^9, 3.550670913921875*^9, 
   3.55069688665625*^9, 3.55069699196875*^9, {3.5506971653125*^9, 
   3.550697180390625*^9}, {3.550697215171875*^9, 3.550697217703125*^9}, 
   3.550697303546875*^9, {3.550697351609375*^9, 3.55069736403125*^9}, 
   3.550697399578125*^9, {3.55069746284375*^9, 3.550697477328125*^9}, 
   3.5506975796875*^9, {3.55075047953125*^9, 3.550750499640625*^9}, 
   3.55075053390625*^9, 3.550752743234375*^9, {3.550753229375*^9, 
   3.5507532555*^9}, 3.550753319421875*^9, 3.55075370846875*^9, 
   3.550753846609375*^9, 3.550753880515625*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1566", ",", "1519", ",", "1605", ",", "1527", ",", "924"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.5505894046875*^9, 3.550589416375*^9}, 
   3.550589540171875*^9, 3.55058957046875*^9, 3.550589622640625*^9, 
   3.550589673*^9, {3.550589740921875*^9, 3.550589754078125*^9}, {
   3.55058979815625*^9, 3.55058982078125*^9}, 3.550595050828125*^9, 
   3.55059512953125*^9, 3.550595299890625*^9, {3.550595355515625*^9, 
   3.550595409015625*^9}, 3.55059549746875*^9, 3.550595787*^9, 
   3.550595835203125*^9, 3.55059586775*^9, 3.550595929328125*^9, {
   3.550595988015625*^9, 3.5505959999375*^9}, 3.550596046765625*^9, 
   3.5505980496875*^9, {3.550598700125*^9, 3.550598732875*^9}, 
   3.550658191046875*^9, 3.550658880703125*^9, 3.550670913921875*^9, 
   3.55069688665625*^9, 3.55069699196875*^9, {3.5506971653125*^9, 
   3.550697180390625*^9}, {3.550697215171875*^9, 3.550697217703125*^9}, 
   3.550697303546875*^9, {3.550697351609375*^9, 3.55069736403125*^9}, 
   3.550697399578125*^9, {3.55069746284375*^9, 3.550697477328125*^9}, 
   3.5506975796875*^9, {3.55075047953125*^9, 3.550750499640625*^9}, 
   3.55075053390625*^9, 3.550752743234375*^9, {3.550753229375*^9, 
   3.5507532555*^9}, 3.550753319421875*^9, 3.55075370846875*^9, 
   3.550753846609375*^9, 3.5507538805625*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"788", ",", "717", ",", "852", ",", "724", ",", "650"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.5505894046875*^9, 3.550589416375*^9}, 
   3.550589540171875*^9, 3.55058957046875*^9, 3.550589622640625*^9, 
   3.550589673*^9, {3.550589740921875*^9, 3.550589754078125*^9}, {
   3.55058979815625*^9, 3.55058982078125*^9}, 3.550595050828125*^9, 
   3.55059512953125*^9, 3.550595299890625*^9, {3.550595355515625*^9, 
   3.550595409015625*^9}, 3.55059549746875*^9, 3.550595787*^9, 
   3.550595835203125*^9, 3.55059586775*^9, 3.550595929328125*^9, {
   3.550595988015625*^9, 3.5505959999375*^9}, 3.550596046765625*^9, 
   3.5505980496875*^9, {3.550598700125*^9, 3.550598732875*^9}, 
   3.550658191046875*^9, 3.550658880703125*^9, 3.550670913921875*^9, 
   3.55069688665625*^9, 3.55069699196875*^9, {3.5506971653125*^9, 
   3.550697180390625*^9}, {3.550697215171875*^9, 3.550697217703125*^9}, 
   3.550697303546875*^9, {3.550697351609375*^9, 3.55069736403125*^9}, 
   3.550697399578125*^9, {3.55069746284375*^9, 3.550697477328125*^9}, 
   3.5506975796875*^9, {3.55075047953125*^9, 3.550750499640625*^9}, 
   3.55075053390625*^9, 3.550752743234375*^9, {3.550753229375*^9, 
   3.5507532555*^9}, 3.550753319421875*^9, 3.55075370846875*^9, 
   3.550753846609375*^9, 3.550753880609375*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2386", ",", "2348", ",", "2408", ",", "2364", ",", "898"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.5505894046875*^9, 3.550589416375*^9}, 
   3.550589540171875*^9, 3.55058957046875*^9, 3.550589622640625*^9, 
   3.550589673*^9, {3.550589740921875*^9, 3.550589754078125*^9}, {
   3.55058979815625*^9, 3.55058982078125*^9}, 3.550595050828125*^9, 
   3.55059512953125*^9, 3.550595299890625*^9, {3.550595355515625*^9, 
   3.550595409015625*^9}, 3.55059549746875*^9, 3.550595787*^9, 
   3.550595835203125*^9, 3.55059586775*^9, 3.550595929328125*^9, {
   3.550595988015625*^9, 3.5505959999375*^9}, 3.550596046765625*^9, 
   3.5505980496875*^9, {3.550598700125*^9, 3.550598732875*^9}, 
   3.550658191046875*^9, 3.550658880703125*^9, 3.550670913921875*^9, 
   3.55069688665625*^9, 3.55069699196875*^9, {3.5506971653125*^9, 
   3.550697180390625*^9}, {3.550697215171875*^9, 3.550697217703125*^9}, 
   3.550697303546875*^9, {3.550697351609375*^9, 3.55069736403125*^9}, 
   3.550697399578125*^9, {3.55069746284375*^9, 3.550697477328125*^9}, 
   3.5506975796875*^9, {3.55075047953125*^9, 3.550750499640625*^9}, 
   3.55075053390625*^9, 3.550752743234375*^9, {3.550753229375*^9, 
   3.5507532555*^9}, 3.550753319421875*^9, 3.55075370846875*^9, 
   3.550753846609375*^9, 3.550753880671875*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1296", ",", "1238", ",", "1347", ",", "1245", ",", "628"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.5505894046875*^9, 3.550589416375*^9}, 
   3.550589540171875*^9, 3.55058957046875*^9, 3.550589622640625*^9, 
   3.550589673*^9, {3.550589740921875*^9, 3.550589754078125*^9}, {
   3.55058979815625*^9, 3.55058982078125*^9}, 3.550595050828125*^9, 
   3.55059512953125*^9, 3.550595299890625*^9, {3.550595355515625*^9, 
   3.550595409015625*^9}, 3.55059549746875*^9, 3.550595787*^9, 
   3.550595835203125*^9, 3.55059586775*^9, 3.550595929328125*^9, {
   3.550595988015625*^9, 3.5505959999375*^9}, 3.550596046765625*^9, 
   3.5505980496875*^9, {3.550598700125*^9, 3.550598732875*^9}, 
   3.550658191046875*^9, 3.550658880703125*^9, 3.550670913921875*^9, 
   3.55069688665625*^9, 3.55069699196875*^9, {3.5506971653125*^9, 
   3.550697180390625*^9}, {3.550697215171875*^9, 3.550697217703125*^9}, 
   3.550697303546875*^9, {3.550697351609375*^9, 3.55069736403125*^9}, 
   3.550697399578125*^9, {3.55069746284375*^9, 3.550697477328125*^9}, 
   3.5506975796875*^9, {3.55075047953125*^9, 3.550750499640625*^9}, 
   3.55075053390625*^9, 3.550752743234375*^9, {3.550753229375*^9, 
   3.5507532555*^9}, 3.550753319421875*^9, 3.55075370846875*^9, 
   3.550753846609375*^9, 3.55075388071875*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3083", ",", "3068", ",", "3096", ",", "3070", ",", "2054"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.5505894046875*^9, 3.550589416375*^9}, 
   3.550589540171875*^9, 3.55058957046875*^9, 3.550589622640625*^9, 
   3.550589673*^9, {3.550589740921875*^9, 3.550589754078125*^9}, {
   3.55058979815625*^9, 3.55058982078125*^9}, 3.550595050828125*^9, 
   3.55059512953125*^9, 3.550595299890625*^9, {3.550595355515625*^9, 
   3.550595409015625*^9}, 3.55059549746875*^9, 3.550595787*^9, 
   3.550595835203125*^9, 3.55059586775*^9, 3.550595929328125*^9, {
   3.550595988015625*^9, 3.5505959999375*^9}, 3.550596046765625*^9, 
   3.5505980496875*^9, {3.550598700125*^9, 3.550598732875*^9}, 
   3.550658191046875*^9, 3.550658880703125*^9, 3.550670913921875*^9, 
   3.55069688665625*^9, 3.55069699196875*^9, {3.5506971653125*^9, 
   3.550697180390625*^9}, {3.550697215171875*^9, 3.550697217703125*^9}, 
   3.550697303546875*^9, {3.550697351609375*^9, 3.55069736403125*^9}, 
   3.550697399578125*^9, {3.55069746284375*^9, 3.550697477328125*^9}, 
   3.5506975796875*^9, {3.55075047953125*^9, 3.550750499640625*^9}, 
   3.55075053390625*^9, 3.550752743234375*^9, {3.550753229375*^9, 
   3.5507532555*^9}, 3.550753319421875*^9, 3.55075370846875*^9, 
   3.550753846609375*^9, 3.550753880765625*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2931", ",", "2914", ",", "2949", ",", "2913", ",", "1944"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.5505894046875*^9, 3.550589416375*^9}, 
   3.550589540171875*^9, 3.55058957046875*^9, 3.550589622640625*^9, 
   3.550589673*^9, {3.550589740921875*^9, 3.550589754078125*^9}, {
   3.55058979815625*^9, 3.55058982078125*^9}, 3.550595050828125*^9, 
   3.55059512953125*^9, 3.550595299890625*^9, {3.550595355515625*^9, 
   3.550595409015625*^9}, 3.55059549746875*^9, 3.550595787*^9, 
   3.550595835203125*^9, 3.55059586775*^9, 3.550595929328125*^9, {
   3.550595988015625*^9, 3.5505959999375*^9}, 3.550596046765625*^9, 
   3.5505980496875*^9, {3.550598700125*^9, 3.550598732875*^9}, 
   3.550658191046875*^9, 3.550658880703125*^9, 3.550670913921875*^9, 
   3.55069688665625*^9, 3.55069699196875*^9, {3.5506971653125*^9, 
   3.550697180390625*^9}, {3.550697215171875*^9, 3.550697217703125*^9}, 
   3.550697303546875*^9, {3.550697351609375*^9, 3.55069736403125*^9}, 
   3.550697399578125*^9, {3.55069746284375*^9, 3.550697477328125*^9}, 
   3.5506975796875*^9, {3.55075047953125*^9, 3.550750499640625*^9}, 
   3.55075053390625*^9, 3.550752743234375*^9, {3.550753229375*^9, 
   3.5507532555*^9}, 3.550753319421875*^9, 3.55075370846875*^9, 
   3.550753846609375*^9, 3.5507538808125*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2788", ",", "2762", ",", "2805", ",", "2771", ",", "1296"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.5505894046875*^9, 3.550589416375*^9}, 
   3.550589540171875*^9, 3.55058957046875*^9, 3.550589622640625*^9, 
   3.550589673*^9, {3.550589740921875*^9, 3.550589754078125*^9}, {
   3.55058979815625*^9, 3.55058982078125*^9}, 3.550595050828125*^9, 
   3.55059512953125*^9, 3.550595299890625*^9, {3.550595355515625*^9, 
   3.550595409015625*^9}, 3.55059549746875*^9, 3.550595787*^9, 
   3.550595835203125*^9, 3.55059586775*^9, 3.550595929328125*^9, {
   3.550595988015625*^9, 3.5505959999375*^9}, 3.550596046765625*^9, 
   3.5505980496875*^9, {3.550598700125*^9, 3.550598732875*^9}, 
   3.550658191046875*^9, 3.550658880703125*^9, 3.550670913921875*^9, 
   3.55069688665625*^9, 3.55069699196875*^9, {3.5506971653125*^9, 
   3.550697180390625*^9}, {3.550697215171875*^9, 3.550697217703125*^9}, 
   3.550697303546875*^9, {3.550697351609375*^9, 3.55069736403125*^9}, 
   3.550697399578125*^9, {3.55069746284375*^9, 3.550697477328125*^9}, 
   3.5506975796875*^9, {3.55075047953125*^9, 3.550750499640625*^9}, 
   3.55075053390625*^9, 3.550752743234375*^9, {3.550753229375*^9, 
   3.5507532555*^9}, 3.550753319421875*^9, 3.55075370846875*^9, 
   3.550753846609375*^9, 3.550753880875*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2643", ",", "2617", ",", "2665", ",", "2621", ",", "1054"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.5505894046875*^9, 3.550589416375*^9}, 
   3.550589540171875*^9, 3.55058957046875*^9, 3.550589622640625*^9, 
   3.550589673*^9, {3.550589740921875*^9, 3.550589754078125*^9}, {
   3.55058979815625*^9, 3.55058982078125*^9}, 3.550595050828125*^9, 
   3.55059512953125*^9, 3.550595299890625*^9, {3.550595355515625*^9, 
   3.550595409015625*^9}, 3.55059549746875*^9, 3.550595787*^9, 
   3.550595835203125*^9, 3.55059586775*^9, 3.550595929328125*^9, {
   3.550595988015625*^9, 3.5505959999375*^9}, 3.550596046765625*^9, 
   3.5505980496875*^9, {3.550598700125*^9, 3.550598732875*^9}, 
   3.550658191046875*^9, 3.550658880703125*^9, 3.550670913921875*^9, 
   3.55069688665625*^9, 3.55069699196875*^9, {3.5506971653125*^9, 
   3.550697180390625*^9}, {3.550697215171875*^9, 3.550697217703125*^9}, 
   3.550697303546875*^9, {3.550697351609375*^9, 3.55069736403125*^9}, 
   3.550697399578125*^9, {3.55069746284375*^9, 3.550697477328125*^9}, 
   3.5506975796875*^9, {3.55075047953125*^9, 3.550750499640625*^9}, 
   3.55075053390625*^9, 3.550752743234375*^9, {3.550753229375*^9, 
   3.5507532555*^9}, 3.550753319421875*^9, 3.55075370846875*^9, 
   3.550753846609375*^9, 3.550753880921875*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1048", ",", "970", ",", "1100", ",", "996", ",", "498"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.5505894046875*^9, 3.550589416375*^9}, 
   3.550589540171875*^9, 3.55058957046875*^9, 3.550589622640625*^9, 
   3.550589673*^9, {3.550589740921875*^9, 3.550589754078125*^9}, {
   3.55058979815625*^9, 3.55058982078125*^9}, 3.550595050828125*^9, 
   3.55059512953125*^9, 3.550595299890625*^9, {3.550595355515625*^9, 
   3.550595409015625*^9}, 3.55059549746875*^9, 3.550595787*^9, 
   3.550595835203125*^9, 3.55059586775*^9, 3.550595929328125*^9, {
   3.550595988015625*^9, 3.5505959999375*^9}, 3.550596046765625*^9, 
   3.5505980496875*^9, {3.550598700125*^9, 3.550598732875*^9}, 
   3.550658191046875*^9, 3.550658880703125*^9, 3.550670913921875*^9, 
   3.55069688665625*^9, 3.55069699196875*^9, {3.5506971653125*^9, 
   3.550697180390625*^9}, {3.550697215171875*^9, 3.550697217703125*^9}, 
   3.550697303546875*^9, {3.550697351609375*^9, 3.55069736403125*^9}, 
   3.550697399578125*^9, {3.55069746284375*^9, 3.550697477328125*^9}, 
   3.5506975796875*^9, {3.55075047953125*^9, 3.550750499640625*^9}, 
   3.55075053390625*^9, 3.550752743234375*^9, {3.550753229375*^9, 
   3.5507532555*^9}, 3.550753319421875*^9, 3.55075370846875*^9, 
   3.550753846609375*^9, 3.550753880984375*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2547", ",", "2503", ",", "2596", ",", "2498", ",", "686"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.5505894046875*^9, 3.550589416375*^9}, 
   3.550589540171875*^9, 3.55058957046875*^9, 3.550589622640625*^9, 
   3.550589673*^9, {3.550589740921875*^9, 3.550589754078125*^9}, {
   3.55058979815625*^9, 3.55058982078125*^9}, 3.550595050828125*^9, 
   3.55059512953125*^9, 3.550595299890625*^9, {3.550595355515625*^9, 
   3.550595409015625*^9}, 3.55059549746875*^9, 3.550595787*^9, 
   3.550595835203125*^9, 3.55059586775*^9, 3.550595929328125*^9, {
   3.550595988015625*^9, 3.5505959999375*^9}, 3.550596046765625*^9, 
   3.5505980496875*^9, {3.550598700125*^9, 3.550598732875*^9}, 
   3.550658191046875*^9, 3.550658880703125*^9, 3.550670913921875*^9, 
   3.55069688665625*^9, 3.55069699196875*^9, {3.5506971653125*^9, 
   3.550697180390625*^9}, {3.550697215171875*^9, 3.550697217703125*^9}, 
   3.550697303546875*^9, {3.550697351609375*^9, 3.55069736403125*^9}, 
   3.550697399578125*^9, {3.55069746284375*^9, 3.550697477328125*^9}, 
   3.5506975796875*^9, {3.55075047953125*^9, 3.550750499640625*^9}, 
   3.55075053390625*^9, 3.550752743234375*^9, {3.550753229375*^9, 
   3.5507532555*^9}, 3.550753319421875*^9, 3.55075370846875*^9, 
   3.550753846609375*^9, 3.55075388103125*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3026", ",", "955", ",", "0", ",", "6052", ",", "0"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.5505894046875*^9, 3.550589416375*^9}, 
   3.550589540171875*^9, 3.55058957046875*^9, 3.550589622640625*^9, 
   3.550589673*^9, {3.550589740921875*^9, 3.550589754078125*^9}, {
   3.55058979815625*^9, 3.55058982078125*^9}, 3.550595050828125*^9, 
   3.55059512953125*^9, 3.550595299890625*^9, {3.550595355515625*^9, 
   3.550595409015625*^9}, 3.55059549746875*^9, 3.550595787*^9, 
   3.550595835203125*^9, 3.55059586775*^9, 3.550595929328125*^9, {
   3.550595988015625*^9, 3.5505959999375*^9}, 3.550596046765625*^9, 
   3.5505980496875*^9, {3.550598700125*^9, 3.550598732875*^9}, 
   3.550658191046875*^9, 3.550658880703125*^9, 3.550670913921875*^9, 
   3.55069688665625*^9, 3.55069699196875*^9, {3.5506971653125*^9, 
   3.550697180390625*^9}, {3.550697215171875*^9, 3.550697217703125*^9}, 
   3.550697303546875*^9, {3.550697351609375*^9, 3.55069736403125*^9}, 
   3.550697399578125*^9, {3.55069746284375*^9, 3.550697477328125*^9}, 
   3.5506975796875*^9, {3.55075047953125*^9, 3.550750499640625*^9}, 
   3.55075053390625*^9, 3.550752743234375*^9, {3.550753229375*^9, 
   3.5507532555*^9}, 3.550753319421875*^9, 3.55075370846875*^9, 
   3.550753846609375*^9, 3.550753881078125*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3223", ",", "3215", ",", "0", ",", "6446", ",", "0"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.5505894046875*^9, 3.550589416375*^9}, 
   3.550589540171875*^9, 3.55058957046875*^9, 3.550589622640625*^9, 
   3.550589673*^9, {3.550589740921875*^9, 3.550589754078125*^9}, {
   3.55058979815625*^9, 3.55058982078125*^9}, 3.550595050828125*^9, 
   3.55059512953125*^9, 3.550595299890625*^9, {3.550595355515625*^9, 
   3.550595409015625*^9}, 3.55059549746875*^9, 3.550595787*^9, 
   3.550595835203125*^9, 3.55059586775*^9, 3.550595929328125*^9, {
   3.550595988015625*^9, 3.5505959999375*^9}, 3.550596046765625*^9, 
   3.5505980496875*^9, {3.550598700125*^9, 3.550598732875*^9}, 
   3.550658191046875*^9, 3.550658880703125*^9, 3.550670913921875*^9, 
   3.55069688665625*^9, 3.55069699196875*^9, {3.5506971653125*^9, 
   3.550697180390625*^9}, {3.550697215171875*^9, 3.550697217703125*^9}, 
   3.550697303546875*^9, {3.550697351609375*^9, 3.55069736403125*^9}, 
   3.550697399578125*^9, {3.55069746284375*^9, 3.550697477328125*^9}, 
   3.5506975796875*^9, {3.55075047953125*^9, 3.550750499640625*^9}, 
   3.55075053390625*^9, 3.550752743234375*^9, {3.550753229375*^9, 
   3.5507532555*^9}, 3.550753319421875*^9, 3.55075370846875*^9, 
   3.550753846609375*^9, 3.550753881140625*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3411", ",", "3404", ",", "3419", ",", "3403", ",", "335.76`"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.5505894046875*^9, 3.550589416375*^9}, 
   3.550589540171875*^9, 3.55058957046875*^9, 3.550589622640625*^9, 
   3.550589673*^9, {3.550589740921875*^9, 3.550589754078125*^9}, {
   3.55058979815625*^9, 3.55058982078125*^9}, 3.550595050828125*^9, 
   3.55059512953125*^9, 3.550595299890625*^9, {3.550595355515625*^9, 
   3.550595409015625*^9}, 3.55059549746875*^9, 3.550595787*^9, 
   3.550595835203125*^9, 3.55059586775*^9, 3.550595929328125*^9, {
   3.550595988015625*^9, 3.5505959999375*^9}, 3.550596046765625*^9, 
   3.5505980496875*^9, {3.550598700125*^9, 3.550598732875*^9}, 
   3.550658191046875*^9, 3.550658880703125*^9, 3.550670913921875*^9, 
   3.55069688665625*^9, 3.55069699196875*^9, {3.5506971653125*^9, 
   3.550697180390625*^9}, {3.550697215171875*^9, 3.550697217703125*^9}, 
   3.550697303546875*^9, {3.550697351609375*^9, 3.55069736403125*^9}, 
   3.550697399578125*^9, {3.55069746284375*^9, 3.550697477328125*^9}, 
   3.5506975796875*^9, {3.55075047953125*^9, 3.550750499640625*^9}, 
   3.55075053390625*^9, 3.550752743234375*^9, {3.550753229375*^9, 
   3.5507532555*^9}, 3.550753319421875*^9, 3.55075370846875*^9, 
   3.550753846609375*^9, 3.5507538811875*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3026", ",", "3017", ",", "3034", ",", "3018", ",", "1703.942`"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.5505894046875*^9, 3.550589416375*^9}, 
   3.550589540171875*^9, 3.55058957046875*^9, 3.550589622640625*^9, 
   3.550589673*^9, {3.550589740921875*^9, 3.550589754078125*^9}, {
   3.55058979815625*^9, 3.55058982078125*^9}, 3.550595050828125*^9, 
   3.55059512953125*^9, 3.550595299890625*^9, {3.550595355515625*^9, 
   3.550595409015625*^9}, 3.55059549746875*^9, 3.550595787*^9, 
   3.550595835203125*^9, 3.55059586775*^9, 3.550595929328125*^9, {
   3.550595988015625*^9, 3.5505959999375*^9}, 3.550596046765625*^9, 
   3.5505980496875*^9, {3.550598700125*^9, 3.550598732875*^9}, 
   3.550658191046875*^9, 3.550658880703125*^9, 3.550670913921875*^9, 
   3.55069688665625*^9, 3.55069699196875*^9, {3.5506971653125*^9, 
   3.550697180390625*^9}, {3.550697215171875*^9, 3.550697217703125*^9}, 
   3.550697303546875*^9, {3.550697351609375*^9, 3.55069736403125*^9}, 
   3.550697399578125*^9, {3.55069746284375*^9, 3.550697477328125*^9}, 
   3.5506975796875*^9, {3.55075047953125*^9, 3.550750499640625*^9}, 
   3.55075053390625*^9, 3.550752743234375*^9, {3.550753229375*^9, 
   3.5507532555*^9}, 3.550753319421875*^9, 3.55075370846875*^9, 
   3.550753846609375*^9, 3.55075388125*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3223", ",", "3214", ",", "3231", ",", "3215", ",", "1345.164`"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.5505894046875*^9, 3.550589416375*^9}, 
   3.550589540171875*^9, 3.55058957046875*^9, 3.550589622640625*^9, 
   3.550589673*^9, {3.550589740921875*^9, 3.550589754078125*^9}, {
   3.55058979815625*^9, 3.55058982078125*^9}, 3.550595050828125*^9, 
   3.55059512953125*^9, 3.550595299890625*^9, {3.550595355515625*^9, 
   3.550595409015625*^9}, 3.55059549746875*^9, 3.550595787*^9, 
   3.550595835203125*^9, 3.55059586775*^9, 3.550595929328125*^9, {
   3.550595988015625*^9, 3.5505959999375*^9}, 3.550596046765625*^9, 
   3.5505980496875*^9, {3.550598700125*^9, 3.550598732875*^9}, 
   3.550658191046875*^9, 3.550658880703125*^9, 3.550670913921875*^9, 
   3.55069688665625*^9, 3.55069699196875*^9, {3.5506971653125*^9, 
   3.550697180390625*^9}, {3.550697215171875*^9, 3.550697217703125*^9}, 
   3.550697303546875*^9, {3.550697351609375*^9, 3.55069736403125*^9}, 
   3.550697399578125*^9, {3.55069746284375*^9, 3.550697477328125*^9}, 
   3.5506975796875*^9, {3.55075047953125*^9, 3.550750499640625*^9}, 
   3.55075053390625*^9, 3.550752743234375*^9, {3.550753229375*^9, 
   3.5507532555*^9}, 3.550753319421875*^9, 3.55075370846875*^9, 
   3.550753846609375*^9, 3.550753881296875*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3411", ",", "3404", ",", "3419", ",", "3403", ",", "341.424`"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.5505894046875*^9, 3.550589416375*^9}, 
   3.550589540171875*^9, 3.55058957046875*^9, 3.550589622640625*^9, 
   3.550589673*^9, {3.550589740921875*^9, 3.550589754078125*^9}, {
   3.55058979815625*^9, 3.55058982078125*^9}, 3.550595050828125*^9, 
   3.55059512953125*^9, 3.550595299890625*^9, {3.550595355515625*^9, 
   3.550595409015625*^9}, 3.55059549746875*^9, 3.550595787*^9, 
   3.550595835203125*^9, 3.55059586775*^9, 3.550595929328125*^9, {
   3.550595988015625*^9, 3.5505959999375*^9}, 3.550596046765625*^9, 
   3.5505980496875*^9, {3.550598700125*^9, 3.550598732875*^9}, 
   3.550658191046875*^9, 3.550658880703125*^9, 3.550670913921875*^9, 
   3.55069688665625*^9, 3.55069699196875*^9, {3.5506971653125*^9, 
   3.550697180390625*^9}, {3.550697215171875*^9, 3.550697217703125*^9}, 
   3.550697303546875*^9, {3.550697351609375*^9, 3.55069736403125*^9}, 
   3.550697399578125*^9, {3.55069746284375*^9, 3.550697477328125*^9}, 
   3.5506975796875*^9, {3.55075047953125*^9, 3.550750499640625*^9}, 
   3.55075053390625*^9, 3.550752743234375*^9, {3.550753229375*^9, 
   3.5507532555*^9}, 3.550753319421875*^9, 3.55075370846875*^9, 
   3.550753846609375*^9, 3.550753881359375*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"datplot", "[", 
   RowBox[{"dat_", ",", "tab_", ",", "rang_", ",", 
    RowBox[{"name_:", "\"\<\>\""}], ",", 
    RowBox[{"zusatz_:", 
     RowBox[{"{", "}"}]}]}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"asd", "=", 
     RowBox[{"ListLinePlot", "[", 
      RowBox[{"dat", ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"rang", ",", "All"}], "}"}]}], ",", "zusatz", ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
         "\"\<Energie\\n(Kanal)\>\"", ",", "\"\<Ereignisse\\n(Anzahl)\>\""}], 
         "}"}]}], ",", 
       RowBox[{"AxesStyle", "\[Rule]", 
        RowBox[{"Arrowheads", "[", "0.03", "]"}]}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "600"}], ",", 
       RowBox[{"Epilog", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"FontSize", "\[Rule]", "16"}], ",", 
          RowBox[{"{", 
           RowBox[{"Red", ",", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"tab", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"tab", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", "3000"}], "}"}]}], 
              "}"}], "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Blue", ",", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"tab", "[", 
                  RowBox[{"[", "2", "]"}], "]"}], ",", 
                 RowBox[{
                  RowBox[{"tab", "[", 
                   RowBox[{"[", "5", "]"}], "]"}], "/", "2"}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"tab", "[", 
                  RowBox[{"[", "3", "]"}], "]"}], ",", 
                 RowBox[{
                  RowBox[{"tab", "[", 
                   RowBox[{"[", "5", "]"}], "]"}], "/", "2"}]}], "}"}]}], 
              "}"}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Inset", "[", 
           RowBox[{
            RowBox[{"tab", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"tab", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{
               RowBox[{"tab", "[", 
                RowBox[{"[", "5", "]"}], "]"}], "/", "10"}]}], "}"}], ",", 
            RowBox[{"BaseStyle", "\[Rule]", "Red"}]}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Inset", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"tab", "[", 
               RowBox[{"[", "3", "]"}], "]"}], "-", 
              RowBox[{"tab", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], ")"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"tab", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{
               RowBox[{"tab", "[", 
                RowBox[{"[", "5", "]"}], "]"}], "/", "2.3"}]}], "}"}], ",", 
            RowBox[{"BaseStyle", "\[Rule]", "Blue"}]}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Inset", "[", 
           RowBox[{
            RowBox[{"Framed", "[", 
             RowBox[{"name", ",", 
              RowBox[{"RoundingRadius", "\[Rule]", "5"}]}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"rang", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"rang", "[", 
                   RowBox[{"[", "2", "]"}], "]"}], "-", 
                  RowBox[{"rang", "[", 
                   RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "/", "8"}]}], ",", 
              RowBox[{
               RowBox[{"tab", "[", 
                RowBox[{"[", "5", "]"}], "]"}], "/", "1.2"}]}], "}"}], ",", 
            RowBox[{"BaseStyle", "\[Rule]", "Black"}]}], "]"}]}], "}"}]}]}], 
      "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Export", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"StringReplace", "[", 
        RowBox[{"name", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\"\<\\n\>\"", "->", "\"\<_\>\""}], ",", 
           RowBox[{"\"\< \>\"", "\[Rule]", "\"\<-\>\""}]}], "}"}]}], "]"}], 
       "<>", "\"\<.pdf\>\""}], ",", "asd"}], "]"}], ";", 
    "\[IndentingNewLine]", "asd"}], "\[IndentingNewLine]", ")"}]}]], "Input",
 CellChangeTimes->{{3.55058868834375*^9, 3.550588754640625*^9}, 
   3.55058879809375*^9, {3.550588835953125*^9, 3.550588838515625*^9}, 
   3.550589706890625*^9, {3.550589830546875*^9, 3.550589830953125*^9}, {
   3.550590441671875*^9, 3.550590450421875*^9}, {3.550595152046875*^9, 
   3.55059517578125*^9}, {3.550596520796875*^9, 3.55059666765625*^9}, {
   3.55059670034375*^9, 3.550596704609375*^9}, {3.550596768875*^9, 
   3.55059683540625*^9}, {3.550596878921875*^9, 3.55059687925*^9}, {
   3.550596950046875*^9, 3.5505970286875*^9}, {3.550597068640625*^9, 
   3.550597114515625*^9}, {3.550597155796875*^9, 3.550597175296875*^9}, {
   3.55059720665625*^9, 3.550597207703125*^9}, {3.55059727275*^9, 
   3.550597325828125*^9}, {3.55059736359375*^9, 3.55059746809375*^9}, {
   3.55059779940625*^9, 3.550597847140625*^9}, {3.55059788721875*^9, 
   3.550597907703125*^9}, {3.5505979975*^9, 3.5505980021875*^9}, {
   3.5505980944375*^9, 3.550598110453125*^9}, {3.5505982183125*^9, 
   3.55059824828125*^9}, {3.550598288875*^9, 3.550598331640625*^9}, {
   3.55059839925*^9, 3.550598439859375*^9}, 3.5505985350625*^9, {
   3.550658229875*^9, 3.550658305125*^9}, {3.55065835428125*^9, 
   3.550658354578125*^9}, {3.550658442328125*^9, 3.55065845334375*^9}, {
   3.550658486828125*^9, 3.5506585221875*^9}, {3.550658784625*^9, 
   3.550658812296875*^9}, {3.550658945296875*^9, 3.550658951828125*^9}, 
   3.550659016234375*^9, {3.550659054671875*^9, 3.55065905915625*^9}, {
   3.550659115078125*^9, 3.550659172*^9}, {3.550659260296875*^9, 
   3.550659286578125*^9}, {3.550659325296875*^9, 3.550659327625*^9}, {
   3.550659360515625*^9, 3.550659367984375*^9}, {3.55065940903125*^9, 
   3.550659424265625*^9}, {3.550670413*^9, 3.55067043990625*^9}, {
   3.5506707179375*^9, 3.550670747765625*^9}, 3.550670890953125*^9, {
   3.550670938390625*^9, 3.55067094534375*^9}, {3.550671001859375*^9, 
   3.550671015203125*^9}, {3.55075066834375*^9, 3.55075067175*^9}, {
   3.55075071965625*^9, 3.55075071975*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"datplot", "[", 
  RowBox[{"luft500", ",", "luft500daten", ",", 
   RowBox[{"{", 
    RowBox[{"1200", ",", "1800"}], "}"}], ",", 
   "\"\<ohne\\nFolie\\n500Torr\>\""}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"datplot", "[", 
   RowBox[{"luft650", ",", "luft650daten", ",", 
    RowBox[{"{", 
     RowBox[{"400", ",", "1000"}], "}"}], ",", 
    "\"\<ohne\\nFolie\\n650Torr\>\""}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"datplot", "[", 
  RowBox[{"D1", ",", "D1daten", ",", 
   RowBox[{"{", 
    RowBox[{"2100", ",", "2500"}], "}"}], ",", "\"\<Mylar D1\>\""}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"datplot", "[", 
  RowBox[{"D2", ",", "D2daten", ",", 
   RowBox[{"{", 
    RowBox[{"1000", ",", "1500"}], "}"}], ",", "\"\<Mylar D2\>\""}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"datplot", "[", 
  RowBox[{"F1", ",", "F1daten", ",", 
   RowBox[{"{", 
    RowBox[{"2900", ",", "3200"}], "}"}], ",", "\"\<Mylar F1\>\""}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"datplot", "[", 
  RowBox[{"F2", ",", "F2daten", ",", 
   RowBox[{"{", 
    RowBox[{"2800", ",", "3000"}], "}"}], ",", "\"\<Mylar F2\>\""}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"datplot", "[", 
  RowBox[{"F3", ",", "F3daten", ",", 
   RowBox[{"{", 
    RowBox[{"2600", ",", "2900"}], "}"}], ",", "\"\<Mylar F3\>\""}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"datplot", "[", 
  RowBox[{"F4", ",", "F4daten", ",", 
   RowBox[{"{", 
    RowBox[{"2500", ",", "2800"}], "}"}], ",", "\"\<Mylar F4\>\""}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"datplot", "[", 
  RowBox[{"D2F1", ",", "D2F1daten", ",", 
   RowBox[{"{", 
    RowBox[{"600", ",", "1200"}], "}"}], ",", "\"\<Mylar D2F1\>\""}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"datplot", "[", 
  RowBox[{"alu", ",", "aludaten", ",", 
   RowBox[{"{", 
    RowBox[{"2300", ",", "2700"}], "}"}], ",", "\"\<Aluminium\>\""}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"datplot", "[", 
  RowBox[{"leer", ",", "leerdaten", ",", 
   RowBox[{"{", 
    RowBox[{"3100", ",", "3300"}], "}"}], ",", "\"\<Luft1\>\""}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"datplot", "[", 
  RowBox[{"testexport", ",", "testdaten", ",", 
   RowBox[{"{", 
    RowBox[{"3100", ",", "3300"}], "}"}], ",", "\"\<Luft2\>\""}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.55058649309375*^9, 3.550586521515625*^9}, {
   3.550587288046875*^9, 3.550587295890625*^9}, {3.55058774759375*^9, 
   3.55058775121875*^9}, {3.550587969578125*^9, 3.55058806075*^9}, {
   3.550588129078125*^9, 3.550588150703125*^9}, {3.55058867990625*^9, 
   3.550588682453125*^9}, {3.550588759109375*^9, 3.550588786171875*^9}, {
   3.550588844125*^9, 3.550588910203125*^9}, {3.550589061390625*^9, 
   3.55058906509375*^9}, {3.550589102859375*^9, 3.55058910603125*^9}, 
   3.550589182359375*^9, {3.5505902035*^9, 3.55059041640625*^9}, {
   3.550590460296875*^9, 3.5505906326875*^9}, {3.550590681671875*^9, 
   3.550590723703125*^9}, {3.550595198484375*^9, 3.550595208890625*^9}, {
   3.55059541709375*^9, 3.550595517359375*^9}, {3.550595552921875*^9, 
   3.550595726875*^9}, {3.550596924515625*^9, 3.550596932875*^9}, {
   3.550597914984375*^9, 3.550597928328125*^9}, {3.55059802603125*^9, 
   3.550598030265625*^9}, {3.550598132078125*^9, 3.5505981614375*^9}, {
   3.550598460296875*^9, 3.5505985054375*^9}, {3.550598746703125*^9, 
   3.5505987870625*^9}, {3.5505988236875*^9, 3.550598824375*^9}, {
   3.550598886828125*^9, 3.55059890375*^9}, {3.5506975001875*^9, 
   3.5506975200625*^9}, {3.550697559609375*^9, 3.5506975596875*^9}, {
   3.55069762240625*^9, 3.55069765484375*^9}, {3.550771948390625*^9, 
   3.550772036453125*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxt3X9o1W+8EPCDiAwRGSIyZMhJhgwZsmzZsmUnW7Zs13Zt2bJl59qyZcuW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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"Energie\\n(Kanal)\"", TraditionalForm], 
    FormBox["\"Ereignisse\\n(Anzahl)\"", TraditionalForm]},
  AxesOrigin->{1200., 0},
  AxesStyle->Arrowheads[0.03],
  Epilog->{FontSize -> 16, {
     RGBColor[1, 0, 0], 
     LineBox[{{1566, 0}, {1566, 3000}}]}, {
     RGBColor[0, 0, 1], 
     LineBox[{{1519, 462}, {1605, 462}}]}, 
    InsetBox[
     BoxData[
      FormBox["1566", TraditionalForm]], 
     NCache[{1566, 
       Rational[462, 5]}, {1566, 92.4}], BaseStyle -> RGBColor[1, 0, 0]], 
    InsetBox[
     BoxData[
      FormBox["86", TraditionalForm]], {1566, 401.7391304347826}, BaseStyle -> 
     RGBColor[0, 0, 1]], 
    InsetBox[
     BoxData[
      FormBox[
       FrameBox[
       "\"ohne\\nFolie\\n500Torr\"", RoundingRadius -> 5, StripOnInput -> 
        False], TraditionalForm]], {1275, 770.}, BaseStyle -> GrayLevel[0]]},
  ImageSize->600,
  PlotRange->{{1200, 1800}, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.550671018109375*^9, 3.5506970015625*^9, 3.5506974828125*^9, 
   3.5506975213125*^9, 3.55069758559375*^9, {3.550697628359375*^9, 
   3.55069765621875*^9}, 3.550750538*^9, 3.550750673390625*^9, 
   3.5507507230625*^9, 3.550752747328125*^9, {3.550753232328125*^9, 
   3.55075325703125*^9}, 3.5507533226875*^9, 3.55075371053125*^9, {
   3.55075385484375*^9, 3.55075388275*^9}, {3.550771976796875*^9, 
   3.550772037234375*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxt239oldH/EPCLiAwRuciQIUOWDBkyZNmyZcvvzZYtW7Zs2b62ry3b15Yt
W7Zs2bKb7et32bJly5Ytu9myZcuGiAwRuciQISJDhgwRuYjIkCFDhgwRKfK8
P3Ff5D8PL9/nvM85z/Pc58c5z/7Amb9z4nc3Zf7Pv2wm83+3/99/a7/Ff+TK
WYGzuBJX4Wpcg/fgWrwX1+F9uB7vxw34D+ID+A/hRvyH8UH8R3AT/qP4EP5j
uBn/cXwY/xbOlTuPM3+COM4cIY4zf5I4zrQQx5k/RRxnjhLHmT9NHGdaiePM
nyEejt/JseT0O8iH4zz6s+n/07jzyb8ZV1vapnHn2yj355LTuPLJvxn38VxZ
v/Phv5Difz5tj6T/D0f99rRN+yUXTv3Lt5ePq0g8E+2k8y4Xjv4kx3EthqP+
ieR03uXC6TzLJ8d5WwzHefgX0zbq/8XyeD6cfgdFymc6yuO5cNQPp/EVw/E7
/Etpm36HueTfHO+Ip+tCMRzXjZNpeyTVD6frVP5kefliONr/y2mbriu5cLqu
5MNRPxz1O9M2XXdy4XTdyofTdbZIPPPbaZuuo7nfLo/nw+k6XAzH+E+Vx3Ph
6P+p8vLFcLT/V8rL58Jpf+fD6fdYDMd1vStt030lF079yRMvhuO+8zvl/cv9
Tnn5fDjaD8d96nTaxv4Lp/tePhz7Pxz3wb9K/8PpPpUPx/4P70nb7vL2a8Kp
vVx3efnucIwvnO7jhXC0h0vhuD7+tfL8NeF0/udwdzj1Nx9O+6sQjv0VTse7
RPnMmbRN1++acOpPLpyea7rDcX5QvhBOzz3FcNpfJZz56+X5a8Lp/MiFU3+7
w3G/oX4hnI5HEZfC8VzUk7bpuawmnPLnwntS++E0vjzxAvmK4dT/Ujie+343
bdPxqgmnfLnfLS/fHY7zL5z6WwjH+RdOz62lcDyHni2vXxNO48uFo32cD6f+
FMIx/nA6PqVwXD/+Rnn9mnDs/3C0H0718+HUXiGc9neReAlnesvL1+BcONoP
70ntEy+E4/wPR/vUz/zNtE3ne0045cuF4/wPx/EnXiBfMRzHPxzvLefSNr3n
1ITT8cqF03i6w2k8eeIF8hXDcf6H4/f/t8pdE075c+G4/oTj9xfek9qnfpH8
pXD86yvvb0045cuFY/zh1J888QIukq8UjvPvb6dtnH9/uzyeC6f+dYdj/OH4
/YdT/4qULxHPnC9vr+Z8eTxHvDscv3/KF8KpP0XiJfJl/k55/2rC6f6YC8fx
p3w+HL8/XAyn/pTIl+kvdzac6tfghnBcn8JpPO3hOF+I9+N8OP0+x8hfCO/5
tZ0lf5H4Iv0tkX+N+pm/W95eNhznYzjtn4ZwXJ/Cqf123E35fpzHY7RXCKf+
z9LfYjiNZxGX8Br9y1wobz+La8Kp/QbiOdwejuMfjuNP+Xw4jWcsnO5vBfLN
4iL5FsNxvaP/a/Qn8/fK28+G4/f498rLN4RTvhzl23F3OPWnPxzP97Q/RrwQ
TufDLPFiOMYf3vNrW6L+Wjjm9QbK28+G4/wPp/E0UD4Xjt8/5bvDcf5TPk++
MeIF6s+SvxhOx2OR+iXia7SX+ftpu+fXNhuO53HiDeF4PgzH+HE3+frD8fxO
+THiBeKz4TSeYjjNRy2G43mD9tcYT+ZiubPheB4Lx/U/HPdn4u3h1L9u4v3E
83gsHM8TxGdpv0h8kfZK4bQ/18if+Qflzobj+ocbwvH7D+/5tW0Px/NqOK5/
xPPkG6M/hXD8/ulPES/SnxL51mg/M1iePxuO58Fw2n8NOBeO6184zn/K9xPP
Ex8jXsCztFcMx/HHJca3Fo73z39YHs+G43kQN4Rj/OG0P9vD8b6E+8Nx/tP+
GO0Vwun+MUu8SL5F4qVwHH/imUvl8Ww45ash3hCO3z/x9nCMP5zu5/3hOP/D
e35tx4gXyD8bTvM/Reov0r8S/VkjnvlH5c6GY/zh+P2H4/pP/fZwOl7dxPuJ
58Op/2PhGD/xWfIV8SIu0f+1cNz/hsqdDcf9P5zabwjH+MNx/Q+n+0d3OMYf
jvdH2hsLx3wK+Wfpb5H+LRIvhdP84RrxzD8uH082HOMPp/40EM/h9nC8r5G/
PxzPv+G4/1O+QPuz4T2/tsVw/P4pXyLfGvUzl8v7kw3HfFw4fv/h+P3j9nDM
15KvPxzzp9QfC8fxp/1Z+luk/iL5S+G4/pM/80/Sds+vbRbX/JPy8g3hmB8n
3h6O+1849ac/HNe/cLqejREvkH+W/hXxIv0rkX+N/Jl82qbjVRFO9bPh1P+q
cDwfhlP+OuIN4TT/3hSO6wftt4bT+kU79TvDcX2lv73hPb+2/eF0PAbJn6f9
kXCafxmjvQnKF8g3TXw2nNaH5hhPkfILeDGc1rOW6V+J+Ar7f43jt0H5zD8t
719FOOXPhlN/qsJpvDXE68JpPbIhnM6PpnCsV4XT/mil/fZwWu/rpL/d4bSe
2RtO64H99HeQeB6P0J8x6k/gAuOdDqf9O4vnGE+R+ALjWaQ/y+G03lyi/Arx
tXAcf9rLXEnbtL5dEU77IxtO+arCqX5NOK0f11G+gXhTOPU3F07r+63J8T1A
O/3ppHx3OK3X95K/P5zyDUb+WJ+P+JFf25Fwio9F+ZR/gnyFcNp/09SfpX9z
4fgeIpy+61ig/CLtL1O/hFfozxr92QjHdy7/LG2P/NpWhNP3INnk+C6lKuLp
+42acPqepC6cvkNpwE2RL31Pkot46k8r7bcnx3cnnRFP37F0E++N/Gl/9ofT
dyODUT+1n494qj+SHN/BjJFvgvEUIp6+K5mm/myUT+3PRX/TdyTFqJ++i1mg
vcWon74bWQ6n9krRXsq/QntrEU/1N6L9+A5mOG1TfyqS4zubbMRT/apw+g6k
Jjm+06gLp3hD5EvtNSXHdy65yJe+i2iN8uk7jfZw+m6lM+qn/N3hFO+lfD/9
GaS/+eT4bmEk6qf+jEX+9N3KRDjVL0T/U/3pyJ++05gNp/HMJcd3DsWon77L
WIj+pPhicnx3sUy8FPWTV/BajOfMr+1G5EvO/F55vorkWNfPJsc6elVyrOPX
RP0Ur0uO7wgakmOduSniqXzu98r700q+9iif1q07I19ax+2O/iX3Jse6eX/U
T+ueg/QnH/G0LjgS40/lxyJ/WrediPGneCH6n9Y1p6N+8my0l/LPRf20Dlik
/kLEU/nF5FiXWY78KV6K/qX6KzGetM6zFvszrXttRH9iHejqr22sa1UkxzpZ
NpziVcmxrlaTHOsWdcmxLtSQHPPyTeFUPhf1U/nW5Jgnb0+OdYTOcJrH7U6O
dYTe5FjX6I94Kj8Y7aX8+Rhf8kiML80TjkX9NG86kRzz0IXkmIeejvbTPMts
jDfVn0uOedJi7K/khehPKr8Y+yPNWywnxzxdKZzaW4n9k7wW/UnlN2L8MQ/0
+8kpf0VyzLNlf7+8/arkeG+vifrJdcnxXt6QHPNoTckxD5VLjvfM1oin+u3J
8d7dmRzvtd1RPtXvTY730H76P5gc75355HguHkmO9+Cx5HhPmoj+JheS47l/
Ojmek2eT47lzLjmec4tRPt2XF5LjuXYx+p+8HPFUvpQcz60ryfEesYY3KJ8Z
+bWN5+qK5HhPyibHc2zVSHn/a5LjubMuOd4bGpLjObGJfLnkeG5qTY7n3vbk
eC/pTI77cHdyPNf2xnhSvv7ob/Jgcjx35yNf8khyPDeORf9TexPR31S+EONN
8enkeK+aTY7nvrmIx32Z8S/EeJMXY38lL0c81S9F/1J7K8nxnrAW7SdvJP/m
veef/9rG+VaRHMcnmxzvJVURj+eY5HgPrkuO94CG5NjfTcnxXp1Ljt9fK+23
J8d7SmdyvId3U7432kvx/uT4vQ8mxzxGPjnmUUbIN5Yc80gTyfEeXoh8KT6d
HPMos8kxrzEX+dP1rZgc83YLyTHvuBj9i+t/cszjlcIpvhLjTV6L9tL1diPa
i3nwa2kcKV6RHOsw2eRYt6hKjnWWmuS4X9UlxzpiQ3KskzVF+VQ/F07x1uS4
v7Ynxzp6Z3KsM3cnx7p0b/Qv7v/R/+TByJecj/6l55GR6E9qbyzypeeTiWg/
1S8kx3cy05E/fWc1G07xuehPep4qxv5PXgin56vFaD95Ofk3z3/J8Xy5EvXT
8+pa9C89H2/EeOM7uH+RnOIVyfGdYjY5np+rIp6er2uS47vXusiX6jdE/Xj+
T47vnnPJ8V1xK25PjveXzuT47ro78qf3o96on+L9UT693wxGvvQ+l4/+xvtf
lE/va2MRj/e/iKf34UKMJ8WnI57eP2fxXDiVL0b+FF+IfOl9fDH6G+//UT65
FPni/T/qp/fttYin+YWNiMff6Yym/Kl8RXL8XVIWVyXH3xHVhFO8LsrH/E/E
Y/4nHH9vFE7zSa3hNB/UHvnSfFYn7g6n+a/ecJof7A+nv6MbDKf52nw4zReO
4DHKT5CvEE7zk9PhmP8Np/niuXB8nx5O8+ML4TT/vRhO6zXL4TS/Xwqn9Y8V
4mvU3wjH+te/LHdFONXPhlP+qnB8H4PrwvG9RDitTzaFY/0nnNbnWnE77gzH
9zXk66W9/nBa7x0Mp+9b8uQfof5YOH1fNUF7BfJPk3+W+nPEi8QXfhP/9W8R
L1O+RHwFrzGeDdrPXC/PV4GzuCqc/tUQryPeEI7jTzyHW8nXTrwTd+Ne6vfj
Qcrn8Qgeo/4E8QLxaeKzeA4X8QJexMu4hFfwGv3bIJ75V+WuwFlcFU75aojX
4QbcRP0c8VbcjjtxN+7F/XgQ5/EIHsMTuICn8Syew0W8gBfxMi7hFbyGN9j/
mbHy+GZcgbfhLK7EVbg6HOcP8VpcR/l64g24ETfhZpzDLbgVt9GfduIduBN3
4W7cQ/5e4n24Hw/gQTyE83gYj+BRPIbH8QSexAU8hafxDJ7FD/EcfoKLeB4v
4Jd4ES/hZfwOl/BHvIJX8RrnyzrxDfwDZ/51uTfjCrwNZ3ElrsLVuAbX4jpc
jxtwI27CzTiHW3ArbsPtuAN34i7cjXtwL+7D/XgAD+IhnMfDeASP4jE8jifw
JC7gKTyNZ/Asfojn8BNcxPN4Ab/Ei3gJL+N3uIQ/4hW8itfwOt7AP3DmRrk3
4wq8DWdxJa7C1bgG1+I6XI8bcCNuws04h1twK27D7eF0/e0g3om7cDfuwb3k
7yPejwfwIB7CeTyMR/AoHsPjeAJP4gKeYrzTxGfwLH6I5/ATXMTzeAG/xIt4
CS/jd7iEP+IVvIrX8DrewD9w5t+UezOuwNtwFlfiKlyNa3AtrsP1uAE34qZw
Op+aiedwC27Fbbgdd+BO3IW7cQ/uxX24Hw/gQTyE83gYj+BRPIbH8QSexAU8
hafxDJ7FD/EcfoKLeB4v4Jd4ES/hZfwOl/BHvIJX8Rpexxv4B86Ml3szrsDb
cBZX4ipcjWtwLa7D9bgBN+Im3IxzuAW34jbcjjtwJ+7C3bgH9+I+3I8HwjHf
SXwI5/EwHsGjeAyP4wk8iQt4Ck/jGTyLH+I5/AQX8TxewC/xIl7Cy/gdLuGP
eAWv4jW8jjfwD5z5t+XejCvwNpzFlbgKV+MaXIvrcD1uwI24CTfjHG7BrbgN
t+MO3Im7cDfuwb24D/fjATyIh3AeD+MRPIrH8DiewJO4gKfwNJ7Bs/ghnsNP
cBHP4wX8Ei/iJbyM3+HSb/xr+5H4Cl7Fa3gdb4TT/eAH8czNcm/GFXgbzuJK
XIWrcU049a+WeB2uxw24ETeRv5l4DrfgVtyG23EH7sRduBv34F7ch/vxAB7E
QziPh/EIHmV/jhEfxxN4kvoF4lN4Gs/gWfI9JD6Hn+AinscL5H9JfBEv4WX8
DpfwR9pbIb6K1/A63sA/cObflXszrsDbwvF9AK6kfBWuxjW4FtfhetyAG3ET
bsY53IJbcRtuxx24E3fhbtyDe3Ef7scDeBAP4TwexiN4FI/hcTyBJ3EBT+Fp
PINn8UM8x/n5hHgRz+MF/BIv4iW8jN/hEv6IV/AqXsPreIPx/yCemSiPb54o
j1fgbTiLK3EVrqa9GuK1xOuI1+MG3IibcDP5c8RbcCtuw+24A3fiLtyNe3Av
7sP9eAAP4iGcx8N4BI/iMTyOJ/AkLuApjs808Rk8ix/iOfwEF/E8XsAv8SJe
wsv4HeMrEf+IVyi/SnwNr+MN/ANn/n25N+MKvA1ncSWuwtW4BtfiOlyPG3Aj
bsLNOIdbcCtuw+24A3fiLtyNe3Av7sP9eAAP4iGcx8N4BI/iMTyOJ/AkLuAp
PI1n8Cx+iOfwE1zE83gBv8SLeAkv43e4hD/iFbyK1/A63sA/cOZWuTfjCrwN
Z3ElrsLVuAbX4jpcjxtwYzhdL5uIN+McbsGtuA234w7cibtwN+7BvbgP9+MB
PIiHcB4P4xE8isfwOJ7Ak7iAp/A0nsGz+CGew09wEc/jBfwSL+IlvIzf4RL+
iFfwKl7D63gD/8CZ/1DuzbgCb8NZXImrcDWuwbW4DtfjBtyIm3AzzuEW3Irb
cDvuwJ24C3fjHtyL+3A/HsCDeAjn8TAewaN4DI/jCTyJC3gKT+MZPIsf4jn8
BBfxPF7AL/EiXsLL+B0u4Y94Ba/iNbyON/APnJks92ZcgbfhLK7EVbga1+Ba
XIfrcQNuxE24GedwC27Fbbgdd+BO3IW7cQ/uxX24Hw/gQTyE83gYj+BRPIbH
8QSexAU8hafxDJ7FD/EcfoKLeB4v4Jd4ES/hZfwOl/BHvIJX8Rpexxv4B878
x3JvxhV4G87iSlyFq3ENrsV1uB434EbchJtxDrfgVtyG23EH7sRduBv34F7c
h/vxAB7EQziPh/EIHsVjeBxP4ElcwFN4Gs/gWfwQz+EnuIjn8QJ+iRfxEl7G
73AJf8QreBWv4XW8gX/gzO1yb8YVeBvO4kpchatxDa7FdbgeN+BG3ISbcQ63
4FbchttxB+7EXbgb9+Be3If78QAexEM4j4fxCB7FY3gcT+BJXMBTeBrP4Fn8
EM/hJ7iI5/ECfokX8RJexu9wCX/EK3gVr+F1vIF/4Mx/KvdmXIG34SyuxFW4
GtfgWlyH63EDbsRNuBnncAtuxW24HXfgTtyFu3EP7sV9uB8P4EE8hPN4GI/g
UTyGx/EEnsQFPIWn8QyexQ/xHH6Ci3geL+CXeBEv4WX8DpfwR7yCV/EaXscb
+AfOFMq9CW/GW3AF3oq34e04i3fgSrwTV+FduBrvxjV4D67Fe3Ed3ofr8X7c
gA/gRnwQN+FDuBkfxjl8BLfgo7gVH8Nt+DhuxydwBz6JO/Ep3IVP4258Bvfg
s7gXn8N9+DzuxxfwAL6IB/ElPIQv4zy+gofxVTyCr+FRfB2P4Rt4HN/EE/gW
nsS3cQHfwVP4Lp7G9/AMvo9n8QP8ED/Cc/gxfoKf4iJ+hufxc7yAX+CX+BVe
xK/xEn6Dl/Fb/A6/xyX8AX/En/AK/oxX8Re8hr/idfwNb+Dv+Af+iTP/udyb
8Ga8BVfgrXgb3o6zeAeuxDtxFd6Fq/FuXIP34Fq8F9fhfbge78cN+ABuxAdx
Ez6Em/FhnMNHcAs+ilvxMdyGj+N2fAJ34JO4E5/CXfg07sZncA8+i3vxOdyH
z+N+fAEP4It4EF/CQ/gyzuMreBhfxSP4Gh7F1/EYvoHH8U08gW/hSXwbF/Ad
PIXv4ml8D8/g+3gWP8AP8SM8hx/jJ/gpLuJneB4/xwv4BX6JX+FF/Bov4Td4
Gb/F7/B7XMIf8Ef8Ca/gz3gVf8Fr+Ctex9/wBv6Of+CfOHOn3JvwZrwFV+Ct
eBvejrN4B67EO3EV3oWr8W5cg/fgWrwX1+F9uB7vxw34AG7EB3ETPoSb8WGc
w0dwCz6KW/Ex3IaP43Z8Anfgk7gTn8Jd+DTuxmdwDz6Le/E53IfP4358AQ/g
i3gQX8JD+DLO4yt4GF/FI/gaHsXX8Ri+gcfxTTyBb+FJfBsX8B08he/iaXwP
z+D7eBY/wA/xIzyHH+Mn+Cku4md4Hj/HC/gFfolf4UX8Gi/hN3gZv8Xv8Htc
wh/wR/wJr+DPeBV/wWv4K17H3/AG/o5/4J8481/KvQlvxltwBd6Kt+HtOIt3
4Eq8E1fhXbga78Y1eA+uxXtxHd6H6/F+3IAP4EZ8EDfhQ7gZH8Y5fAS34KO4
FR/Dbfg4bscncAc+iTvxKdyFT+NufAb34LO4F5/Dffg87scX8AC+iAfxJTyE
L+M8voKH8VU8gq/hUXwdj+EbeBzfxBP4Fp7Et3EB38FT+C6exvfwDL6PZ/ED
/BA/wnP4MX6Cn+Iifobn8XO8gF/gl/gVXsSv8RJ+g5fxW/wOv8cl/AF/xJ/w
Cv6MV/EXvIa/4nX8DW/g7/gH/okzU+XehDfjLbgCb8Xb8HacxTtwJd6Jq/Au
XI134xq8B9fivbgO78P1eD9uwAdwIz6Im/Ah3IwP4xw+glvwUdyKj+E2fBy3
4xO4A5/EnfgU7sKncTc+g3vwWdyLz+E+fB734wt4AF/Eg/gSHsKXcR5fwcP4
Kh7B1/Aovo7H8A08jm/iCXwLT+LbuIDv4Cl8F0/je3gG38ez+AF+iB/hOfwY
P8FPcRE/w/P4OV7AL/BL/Aov4td4Cb/By/gtfoff4xL+gD/iT3gFf8ar+Ate
w1/xOv6GN/B3/AP/xJn/Wu5NeDPegivwVrwNb8dZvANX4p24Cu/C1Xg3rsF7
cC3ei+vwPlyP9+MGfAA34oO4CR/CzfgwzuEjuAUfxa34GG7Dx3E7PoE78Enc
iU/hLnwad+MzuAefxb34HO7D53E/voAH8EU8iC/hIXwZ5/EVPIyv4hF8DY/i
63gM38Dj+CaewLfwJL6NC/gOnsJ38TS+h2fwfTyLH+CH+BGew4/xE/wUF/Ez
PI+f4wX8Ar/Er/Aifo2X8Bu8jN/id/g9LuEP+CP+hFfwZ7yKv+A1/BWv4294
A3/HP/BPnLlb7k14M96CK/BWvA1vx1m8A1finbgK78LVeDeuwXtwLd6L6/A+
XI/34wZ8ADfig7gJH8LN+DDO4SO4BR/FrfgYbsPHcTs+gTvwSdyJT+EufBp3
4zO4B5/Fvfgc7sPncT++gAfwRTyIL+EhfBnn8RU8jK/iEXwNj+LreAzfwOP4
Jp7At/Akvo0L+A6ewnfxNL6HZ/B9PIsf4If4EZ7Dj/ET/BQX8TM8j5/jBfwC
v8Sv8CJ+jZfwG7yM3+J3+D0u4Q/4I/6EV/BnvIq/4DX8Fa/jb3gDf8c/8E+c
+W/l3oQ34y24Am/F2/B2nMU7cCXeiavwLlyNd+MavAfX4r24Du/D9Xg/bsAH
cCM+iJvwIdyMD+McPoJb8FHcio/hNnwct+MTuAOfxJ34FO7Cp3E3PoN78Fnc
i8/hPnwe9+MLeABfxIP4Eh7Cl3EeX8HD+CoewdfwKL6Ox/ANPI5v4gl8C0/i
27iA7+ApfBdP43t4Bt/Hs/gBfogf4Tn8GD/BT3ERP8Pz+DlewC/wS/wKL+LX
eAm/wcv4LX6H3+MS/oA/4k94BX/Gq/gLXsNf8Tr+hjfwd/wD/8SZ6XJvwpvx
FlyBt+JteDvO4h24Eu/EVXgXrsa7cQ3eg2vxXlyH9+F6vB834AO4ER/ETfgQ
bsaHcQ4fwS34KG7Fx3AbPo7b8QncgU/iTnwKd+HTuBufwT34LO7F53AfPo/7
8QU8gC/iQXwJD+HLOI+v4GF8FY/ga3gUX8dj+AYexzfxBL6FJ/FtXMB38BS+
i6fxPTyD7+NZ/AA/xI/wHH6Mn+CnuIif4Xn8HC/gF/glfoUX8Wu8hN/gZfwW
v8PvcQl/wB/xJ7yCP+NV/AWv4a94HX/DG/g7/oF/4sx/L/cmvBlvwRV4K96G
t+Ms3oEr8U5chXfharwb1+A9uBbvxXV4H67H+3EDPoAb8UHchA/hZnwY5/AR
3IKP4lZ8DLfh47gdn8Ad+CTuxKdwFz6Nu/EZ3IPP4l58Dvfh87gfX8AD+CIe
xJfwEL6M8/gKHsZX8Qi+hkfxdTyGb+BxfBNP4Ft4Et/GBXwHT+G7eBrfwzP4
Pp7FD/BD/AjP4cf4CX6Ki/gZnsfP8QJ+gV/iV3gRv8ZL+A1exm/xO/wel/AH
/BF/wiv4M17FX/Aa/orX8Te8gb/jH/gnztwr9ya8GW/BFXgr3oa34yzegSvx
TlyFd+FqvBvX4D24Fu/FdXgfrsf7cQM+gBvxQdyED+FmfBjn8BHcgo/iVnwM
t+HjuB2fwB34JO7Ep3AXPo278Rncg8/iXnwO9+HzuB9fwAP4Ih7El/AQvozz
+AoexlfxCL6GR/F1PIZv4HF8E0/gW3gS38YFfAdP4bt4Gt/DM/g+nsUP8EP8
CM/hx/gJfoqL+Bmex8/xAn6BX+JXeBG/xkv4DV7Gb/E7/B6X8Af8EX/CK/gz
XsVf8Br+itfxN7yBv+Mf+CfO/I9yb8Kb8RZcgbfibXg7zuIduBLvxFV4F67G
u3EN3oNr8V5ch/fherwfN+ADuBEfxE34EG7Gh3EOH8Et+ChuxcdwGz6O2/EJ
3IFP4k58Cnfh07gbn8E9+CzuxedwHz6P+/EFPIAv4kF8CQ/hyziPr+BhfBWP
4Gt4FF/HY/gGHsc38QS+hSfxbVzAd/AUvoun8T08g+/jWfwAP8SP8Bx+jJ/g
p7iIn+F5/Bwv4Bf4JX6FF/FrvITf4GX8Fr/D73EJf8Af8Se8gj/jVfwFr+Gv
eB1/wxv4O/6Bf+LMTLk34c14C67AW/E2vB1n8Q5ciXfiKrwLV+PduAbvwbV4
L67D+3A93o8b8AHciA/iJnwIN+PDOIeP4BZ8FLfiY7gNH8ft+ATuwCdxJz6F
u/Bp3I3P4B58Fvfic7gPn8f9+AIewBfxIL6Eh/BlnMdX8DC+ikfwNTyKr+Mx
fAOP45t4At/Ck/g2LuA7eArfxdP4Hp7B9/EsfoAf4kd4Dj/GT/BTXMTP8Dx+
jhfwC/wSv8KL+DVewm/wMn6L3+H3uIQ/4I/4E17Bn/Eq/oLX8Fe8jr/hDfwd
/8A/ceZ/lnsT3oy34Aq8FW/D23EW78CVeCeuwrtwNd6Na/AeXIv34jq8D9fj
/bgBH8CN+CBuwodwMz6Mc/gIbsFHcSs+htvwcdyOT+AOfBJ34lO4C5/G3fgM
7sFncS8+h/vwedyPL+ABfBEP4kt4CF/GeXwFD+OreARfw6P4Oh7DN/A4vokn
8C08iW/jAr6Dp/BdPI3v4Rl8H8/iB/ghfoTn8GP8BD/FRfwMz+PneAG/wC/x
K7yIX+Ml/AYv47f4HX6PS/gD/og/4RX8Ga/iL3gNf8Xr+BvewN/xD/wTZ+6X
exPejLfgCrwVb8PbcRbvwJV4J67Cu3A13o1r8B5ci/fiOrwP1+P9uAEfwI34
IG7Ch3AzPoxz+AhuwUdxKz6G2/Bx3I5P4A58EnfiU7gLn8bd+AzuwWdxLz6H
+/B53I8v4AF8EQ/iS3gIX8Z5fAUP46t4BF/Do/g6HsM38Di+iSfwLTyJb+MC
voOn8F08je/hGXwfz+IH+CF+hOfwY/wEP8VF/AzP4+d4Ab/AL/ErvIhf4yX8
Bi/jt/gdfo9L+AP+iD/hFfwZr+IveA1/xev4G97A3/EP/BNn/le5N+HNeAuu
wFvxNrwdZ/EOXIl34iq8C1fj3bgG78G1eC+uw/twPd6PG/AB3IgP4iZ8CDfj
wziHj+AWfBS34mO4DR/H7fgE7sAncSc+hbvwadyNz+AefBb34nO4D5/H/fgC
HsAX8SC+hIfwZZzHV/AwvopH8DU8iq/jMXwDj+ObeALfwpP4Ni7gO3gK38XT
+B6ewffxLH6AH+JHeA4/xk/wU1zEz/A8fo4X8Av8Er/Ci/g1XsJv8DJ+i9/h
97iEP+CP+BNewZ/xKv6C1/BXvI6/4Q38Hf/AP/+f/zfKx6qP
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"Energie\\n(Kanal)\"", TraditionalForm], 
    FormBox["\"Ereignisse\\n(Anzahl)\"", TraditionalForm]},
  AxesOrigin->{400., 0},
  AxesStyle->Arrowheads[0.03],
  Epilog->{FontSize -> 16, {
     RGBColor[1, 0, 0], 
     LineBox[{{788, 0}, {788, 3000}}]}, {
     RGBColor[0, 0, 1], 
     LineBox[{{717, 325}, {852, 325}}]}, 
    InsetBox[
     BoxData[
      FormBox["788", TraditionalForm]], {788, 65}, BaseStyle -> 
     RGBColor[1, 0, 0]], 
    InsetBox[
     BoxData[
      FormBox["135", TraditionalForm]], {788, 282.60869565217394`}, BaseStyle -> 
     RGBColor[0, 0, 1]], 
    InsetBox[
     BoxData[
      FormBox[
       FrameBox[
       "\"ohne\\nFolie\\n650Torr\"", RoundingRadius -> 5, StripOnInput -> 
        False], TraditionalForm]], {475, 541.6666666666667}, BaseStyle -> 
     GrayLevel[0]]},
  ImageSize->600,
  PlotRange->{{400, 1000}, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.550671018109375*^9, 3.5506970015625*^9, 3.5506974828125*^9, 
   3.5506975213125*^9, 3.55069758559375*^9, {3.550697628359375*^9, 
   3.55069765621875*^9}, 3.550750538*^9, 3.550750673390625*^9, 
   3.5507507230625*^9, 3.550752747328125*^9, {3.550753232328125*^9, 
   3.55075325703125*^9}, 3.5507533226875*^9, 3.55075371053125*^9, {
   3.55075385484375*^9, 3.55075388275*^9}, {3.550771976796875*^9, 
   3.550772037421875*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxt3X9o1H98H/BD5EsQkSDyJYhIJkGCiGQuc5nL7NWmNrWZTW1mU5u5q01d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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"Energie\\n(Kanal)\"", TraditionalForm], 
    FormBox["\"Ereignisse\\n(Anzahl)\"", TraditionalForm]},
  AxesOrigin->{2100., 0},
  AxesStyle->Arrowheads[0.03],
  Epilog->{FontSize -> 16, {
     RGBColor[1, 0, 0], 
     LineBox[{{2386, 0}, {2386, 3000}}]}, {
     RGBColor[0, 0, 1], 
     LineBox[{{2348, 449}, {2408, 449}}]}, 
    InsetBox[
     BoxData[
      FormBox["2386", TraditionalForm]], 
     NCache[{2386, 
       Rational[449, 5]}, {2386, 89.8}], BaseStyle -> RGBColor[1, 0, 0]], 
    InsetBox[
     BoxData[
      FormBox["60", TraditionalForm]], {2386, 390.4347826086957}, BaseStyle -> 
     RGBColor[0, 0, 1]], 
    InsetBox[
     BoxData[
      FormBox[
       FrameBox["\"Mylar D1\"", RoundingRadius -> 5, StripOnInput -> False], 
       TraditionalForm]], {2150, 748.3333333333334}, BaseStyle -> 
     GrayLevel[0]]},
  ImageSize->600,
  PlotRange->{{2100, 2500}, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.550671018109375*^9, 3.5506970015625*^9, 3.5506974828125*^9, 
   3.5506975213125*^9, 3.55069758559375*^9, {3.550697628359375*^9, 
   3.55069765621875*^9}, 3.550750538*^9, 3.550750673390625*^9, 
   3.5507507230625*^9, 3.550752747328125*^9, {3.550753232328125*^9, 
   3.55075325703125*^9}, 3.5507533226875*^9, 3.55075371053125*^9, {
   3.55075385484375*^9, 3.55075388275*^9}, {3.550771976796875*^9, 
   3.55077203759375*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxt3X9olX+8EPDDF5EhIkOGDBmyZMgQkWXLli3vyZYtW7Zs17vr3fWebNe7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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"Energie\\n(Kanal)\"", TraditionalForm], 
    FormBox["\"Ereignisse\\n(Anzahl)\"", TraditionalForm]},
  AxesOrigin->{1000., 0},
  AxesStyle->Arrowheads[0.03],
  Epilog->{FontSize -> 16, {
     RGBColor[1, 0, 0], 
     LineBox[{{1296, 0}, {1296, 3000}}]}, {
     RGBColor[0, 0, 1], 
     LineBox[{{1238, 314}, {1347, 314}}]}, 
    InsetBox[
     BoxData[
      FormBox["1296", TraditionalForm]], 
     NCache[{1296, 
       Rational[314, 5]}, {1296, 62.8}], BaseStyle -> RGBColor[1, 0, 0]], 
    InsetBox[
     BoxData[
      FormBox["109", TraditionalForm]], {1296, 273.0434782608696}, BaseStyle -> 
     RGBColor[0, 0, 1]], 
    InsetBox[
     BoxData[
      FormBox[
       FrameBox["\"Mylar D2\"", RoundingRadius -> 5, StripOnInput -> False], 
       TraditionalForm]], 
     NCache[{
       Rational[2125, 2], 523.3333333333334}, {1062.5, 523.3333333333334}], 
     BaseStyle -> GrayLevel[0]]},
  ImageSize->600,
  PlotRange->{{1000, 1500}, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.550671018109375*^9, 3.5506970015625*^9, 3.5506974828125*^9, 
   3.5506975213125*^9, 3.55069758559375*^9, {3.550697628359375*^9, 
   3.55069765621875*^9}, 3.550750538*^9, 3.550750673390625*^9, 
   3.5507507230625*^9, 3.550752747328125*^9, {3.550753232328125*^9, 
   3.55075325703125*^9}, 3.5507533226875*^9, 3.55075371053125*^9, {
   3.55075385484375*^9, 3.55075388275*^9}, {3.550771976796875*^9, 
   3.55077203778125*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxt3X9olPl/IPBBZAmLLEFkCYssc0EkiEjOy9nUpnZqrU1tzpva1OZsaqc2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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"Energie\\n(Kanal)\"", TraditionalForm], 
    FormBox["\"Ereignisse\\n(Anzahl)\"", TraditionalForm]},
  AxesOrigin->{2900., 0},
  AxesStyle->Arrowheads[0.03],
  Epilog->{FontSize -> 16, {
     RGBColor[1, 0, 0], 
     LineBox[{{3083, 0}, {3083, 3000}}]}, {
     RGBColor[0, 0, 1], 
     LineBox[{{3068, 1027}, {3096, 1027}}]}, 
    InsetBox[
     BoxData[
      FormBox["3083", TraditionalForm]], 
     NCache[{3083, 
       Rational[1027, 5]}, {3083, 205.4}], BaseStyle -> RGBColor[1, 0, 0]], 
    InsetBox[
     BoxData[
      FormBox["28", TraditionalForm]], {3083, 893.0434782608696}, BaseStyle -> 
     RGBColor[0, 0, 1]], 
    InsetBox[
     BoxData[
      FormBox[
       FrameBox["\"Mylar F1\"", RoundingRadius -> 5, StripOnInput -> False], 
       TraditionalForm]], 
     NCache[{
       Rational[5875, 2], 1711.6666666666667`}, {2937.5, 
      1711.6666666666667`}], BaseStyle -> GrayLevel[0]]},
  ImageSize->600,
  PlotRange->{{2900, 3200}, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.550671018109375*^9, 3.5506970015625*^9, 3.5506974828125*^9, 
   3.5506975213125*^9, 3.55069758559375*^9, {3.550697628359375*^9, 
   3.55069765621875*^9}, 3.550750538*^9, 3.550750673390625*^9, 
   3.5507507230625*^9, 3.550752747328125*^9, {3.550753232328125*^9, 
   3.55075325703125*^9}, 3.5507533226875*^9, 3.55075371053125*^9, {
   3.55075385484375*^9, 3.55075388275*^9}, {3.550771976796875*^9, 
   3.55077203796875*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxt3X9ok39/7/ELKVKkSJAiQYrklCJBimSuc5nrvDPXuczT48lc53K7zmVd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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"Energie\\n(Kanal)\"", TraditionalForm], 
    FormBox["\"Ereignisse\\n(Anzahl)\"", TraditionalForm]},
  AxesOrigin->{2800., 0},
  AxesStyle->Arrowheads[0.03],
  Epilog->{FontSize -> 16, {
     RGBColor[1, 0, 0], 
     LineBox[{{2931, 0}, {2931, 3000}}]}, {
     RGBColor[0, 0, 1], 
     LineBox[{{2914, 972}, {2949, 972}}]}, 
    InsetBox[
     BoxData[
      FormBox["2931", TraditionalForm]], 
     NCache[{2931, 
       Rational[972, 5]}, {2931, 194.4}], BaseStyle -> RGBColor[1, 0, 0]], 
    InsetBox[
     BoxData[
      FormBox["35", TraditionalForm]], {2931, 845.2173913043479}, BaseStyle -> 
     RGBColor[0, 0, 1]], 
    InsetBox[
     BoxData[
      FormBox[
       FrameBox["\"Mylar F2\"", RoundingRadius -> 5, StripOnInput -> False], 
       TraditionalForm]], {2825, 1620.}, BaseStyle -> GrayLevel[0]]},
  ImageSize->600,
  PlotRange->{{2800, 3000}, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.550671018109375*^9, 3.5506970015625*^9, 3.5506974828125*^9, 
   3.5506975213125*^9, 3.55069758559375*^9, {3.550697628359375*^9, 
   3.55069765621875*^9}, 3.550750538*^9, 3.550750673390625*^9, 
   3.5507507230625*^9, 3.550752747328125*^9, {3.550753232328125*^9, 
   3.55075325703125*^9}, 3.5507533226875*^9, 3.55075371053125*^9, {
   3.55075385484375*^9, 3.55075388275*^9}, {3.550771976796875*^9, 
   3.550772038125*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxt3X9ok39/7/ELKVKkSJAiRYrklCJBimSuc5nrvDPXeWfevV3mOk9u17nM
u3OZ6/HOXG/vHO8ed811LnOdJ/N0nhzXeTLXucz1uCBFghQJUiRIkSBFghQJ
UiRIkSBFghQ5h3O9Xz1cT07/uXh8X+/3+/O5rvxoEv2a/3D+R6d/f4fzf34C
jvN/j//fn9Z38B+ifnbCAbgb7oF74SDcB/fDB+AQfBAegA/BYfhn4MPwz8KD
8M/BR+CfhyPwL8BH4V+Eh+Bfgo/B34Gjfruw88vIYec4ctj5FeSwM4wcdn4V
OeycQA4730UOOzHksPNryGHnJHJZj6PvIf8e8hG/XVmPu++j//v+eucU+mHn
1832OHVlzY/b0R7X0bg/d2WbV4Gd3/DvLwq72/aOFVnPI6fRL+t84Iqs/t9E
P+zK6oedUf/+oqP+3IUrsPNbWB92ZfXDzhm/o7L6kVdg5z+iH3bhiqyfBPoT
/txFXkHu/ED2jtEf+OvdH/jrK8ids+g/66934Yqs/t/251HYhSuwM+afFx3z
5y5cQb3zO1gfdmVdP9g5h/5te0cXrqDe+V30b9v6Za2P3En6+4NwVLb+JOzC
BdkenxXkDcx3fg/ry7o94CTqXbiwbVtfttclDVnPH+ex/ra9Y1TW+qh3ZZtX
QH8FeQPznB/68+AP/XlUtufvJOpduID6imz7aSB3xv0OwlHZXrclYVfW+rLO
H/MayJ3ft6Odb1DW7yPkSdleF7qyzSvAFVm3P+Y7F/wOypoia33Yle38CrK9
7q1sz7P1sZ7zB1hftv6obPtPInfRX5B1+6O/gXonhfXhqKzbX7Z5rqzzl3X9
Ud+AnT/09wdlrQ8nZa0v6/kH8yrIG+h3LvrPLyjr+sNJWc+vss0ryHq+RX0D
85w/8udB2eZFZT3+ZT3+UF+Q9fwLN2Q9/0z486Bs86NwUtb9D/0F5BXkDVnX
/z/564Oy1oeTsm5/uc/Wx7yKrOcf9DuX/PODsr0vjcJJWevLOn9Ztz/mN2Dn
R/79BmU9/8t6/MOubPMKcEW258uGrOf/tL8+AAdlO/+wbO+bo7K9L4/L2q9s
78vTyF3Z9pdDfQF5CfuroL6GvCHb+bZkfW7wx/79B+Q+7xiEw7LuH+iPoz4p
2+2blu36uejPyTp/rFeS7XOMimznV4Mbsl2/lqz732X/+gHZ1gvKdnuFUR+V
+7xjXLb9JWW73mlZv78xLwcX0F/C/ipwTbbPXRqY10K98yd21P1f1u8jWecv
6/xlu73icp93TMo6f9nWdzEvh3kFWfd/Wbc/9leT7XOvBs6vhdyZ9M8PyLaf
IByW7Xyisp1PHPOSsq2flu1zNBd5DusVML8k2/4rcp93rGF/DeynhfnOj/31
gR/764OyzQ+jPirr/FGflO3xnoZd2W6/HOYVZNtvSdb5I6/Jdv9pyHr+k/U5
5xV/f0C28wvKuv/Len0m2/WKy33eMSnr+U/W/R/1OcwroL6E/VbQX0N9A/Ut
1Ds/8e8vIOv8f+KvD8t6fYI8Luv+jzwNu5iXgwuYV5J1/rJ+/6G/gbyFeU7G
Py+Q8edB5GHkUVn3f+RJWfd/Wa9fUZ9DXpDt/l6S7Xwqst1+NcxrYH8t9Dv/
2Z8H4KBs88LIo7LtN448iTwt2/qubI+nnKznP/SXML+C+hrckPX4l/X++6p/
PwHZHu9B5GFZ749k3f6y3q8gT2O+K9vvgxz6C7Lu/3Kfd6zIdj41rNeQ9fsP
+3d+ake7fwV+6q8Pynb7hGV9PiTbvLhs+0siT8s6f+Q5WecPl1BfgWuY38B+
WrAz5e8PwEE4LOv5T7b3K3FZ79dlWy8t6/xlPf4xv4C8hP1UML+GvCHr/g87
/8XvgKzzl/X+R9b5oz8u6/zhtKzPD9CfQ15AXpLt+lWwnxr225D7vGMLuXPN
Pz8g6/yv+evDsn7/yzY/jjwp6/kP67mYn8P6BdSXML8i2/2jJuv5D/0t9Dt/
ake73gFZz39wWNbvP1m3v6znf1mPf1m//5Dn4ALWL2G/FeQ17KeB/bRkff7j
+vNOWfcH2fbbg/qgbNczJOv1AvojcBTzYrKdXxzzE7I+j8O8lNznHdOYl0G9
C2dlvR7H9chj/QJchEtwGfMrmF9FXsP1qSNvYH4T81qobyN3/szf3wkHZFu/
B3lQtusbku16htEfkfX5JubFZLu947LdXxOoT2L9FPK0bK/nM7I+f8B+slg/
h/XzWK+A/iLWL6G+DFfQX8X6NdTXsZ8G8ib6W8jb2J9z3e9OWY9/2fbXI/d5
xyDqQ5gXlm0/EdRHZbu/xGQ9/jEvgfWTyFOYn4YzWM9Ffxb1OdnOP4+8INvt
UYRL6C/L+v2F/VSR1+Q+71hHfQP7b8ItzGtjf86f+/NOWbe/bPN6UB+U7fxC
yMOy3Z4RzItivZiszxOQJ7bneT9JrJ/CemnZnn8yqHcxL4v95TAvj/MrYF4R
/SW4jPOpyLr9kdfgOtzA/CbyFvI2cmfa707Zzi8g6/aX9edVsm5/OCzb/S2C
9aKYF0N/XLbrk8C8JJzCftPIM1jPxflmsb8c5uXRX8D8IvZfQl7GehXkVaxX
w7w66hvYTxP7b8FtzHf+wr+fTtnmB2Q9/8v6fFzW73/MC8MR9EeRxzAvDiew
nyT6U5iflu18M+h3Zb3+w7wc1s9jfkG255ci6kuoL2/n3k8F+6vi+tfgOuob
mNfE/ltwG+fv3PC7U9btL9v+e2Q9/8u6/eHwtr2fiKznf6wfw3px7CeB+Uk4
hfo09pvBfBf9WfTn0J9HfQF5EedbgstYv4LzryKvYT911DewfhP9LazfRr3z
l353yno/jLwHeVDW67/t3PsJoz+C+ijmxWR9noR5CfQn0Z9CfxrOwC7mZeEc
5ueRF5AXcb4l5GX0V1BfhWvor8u6/ZE3cX4tuI16J+vPO+FA1l/fs23vJ4g8
JOv1P/IIHJX1+g+OY72ErM+XsN8U5qeRZ5C7mJdFnkOeR15AXoRLcBn9FbiK
/daQ12Xd/sibWK+FeW3UO3/lr+/8K38ekPX7X9bf10N9CA6jP4L1onBM1u2P
9RKYn4RT6E+jP4N6F3kW/TnkeZxPAfOKOJ8S8vK2vZ8K5ldRX8O8uqzPd1Hf
xP5bsr2+aWP/zk1/fycckG1/PciDcAgOy7afCPIo5sdkff6DPLHd7/0kUZ+S
9fof62Vkvf7DvCzm5bB+HnkB84twCS6jv4LrU8V+asjrmNfA/pqob2FeG+s7
f+2f1/nX/jyAvGfb3k8QeQgOoz6CPIr1YsjjyBNwUtb7f/SnsX4G9S7qs7Je
/6E/j/ULqC/K+vMK9JdRX0F9FfU17K+O/gbcxP5a6G8jd2b8eaesz39kPf7h
IPpD6A9v595PBI7Kev2P+XFZtz/yJJyC05ifwf5czM/ifHKYl4cLcBHnV8K8
MvIK1q/CNfTXcT4NrN9EfQt5G+s7f+PPO+HA3/jre7btHYPIQ7Je/6E+Akdl
vf5DHocTsh7/yFNwGs7ALpzF/BycR30BLuJ8SsjLsv78B3kV69WQ13G9G6hv
Yn4LeRu3r3PLP78TDsh6/Sfr/b+s93+yzQ+jPoI8ivViyOPoTyBPwik4DWdg
F+tnkeeQ55EXsL8i8hJcxrwKXIVrmF/H9W5gfhNubc/zftqY5/xXf965be8Y
kPX8jzyIPCTr8z/UR1AfRX0M+4mjPwEnMS8Fp+EM7MJZzM8hz8t6/4/9FlFf
wrwyzreCvIq8hnl15A3kTeyvhf21YSfnX78D7oS7ZL0+hLtl3V/gXtQHMb8f
DsEDmBfezr2fQeQR9A/BUfQPI49h3gjyODwq68+rkI9hXhIeR30K+QTyNNab
xPXNoH8K/S7yaeRZeAbOYb1ZzMujfg77LaB+HvOK6F9AfQnzFuEybt8l9FeQ
LyOvYv0V5DX0r8J1nM8a8gbydcxvon4D9S3sbxP1beRbuD7O3/rrO/7WX98p
2366UB9A3i3r82LM64WDsn0+0Y/+EDyA/jD2M4g8Itv5DmG/UdQPwzGsP4I8
Do/CCexvDOsnkY8jT2H9CcxPo38SeQb9U7CL/mn0Z7GfGfTn0D+L+jzmzaG/
gHwe/UXMX0BeQv8i6suoX4IrqF9GXoVXUF/D+qvI6zjfNcxroH8deRPzNpC3
4E24jf4trOfc9td3wJ1wFxyQ7f1Bt6w/L5Ttpxf9we3cO/bDIdQPwGHMH0Qe
gYfgKDyMeTHkI3AcHsX5J2S7/cdwfkmsNw6nMH8C/Wnkk1gvg3wKuYv1puEs
+mfQn4Nnsb88+udwfQrI57F+EfkC5pfgRdSXkS/BFay3jPtzFfkKzreG9VZR
X4fXUN+A1+EmvIH9t5Bvwm14C3b+m98dsv48CHkXHIC7ZfvpQd67nXvHINbr
R30I9QPIw1hvEPUReAj1Uaw/jPoYPIL148hHkSeQjyFPIh9HnoIn4DQ8iXkZ
nO8U6l3k03AWnsH8HObNoj4Pz6G+AM/DRXgB65fgRdSXcfsuob6C/S2jv4p8
Rdbfz0D9qmyff9ax3hrmNZCvY79N1G+gvoX1N5G34S3Mc2b97pD1+x/uQn1A
tuvRvZ17xx7098JB1PfDIdQPIA/Dg7I+b0T/EBxF/TDyGOaPwHFcj1E4AY9h
vSTyccxPYT8TyNO4/pOYn8H8KdjFvGnkWaw/g/ocPIv6PPI55AWsNw8X4QW4
hPmLyMvwEtavoH8Z16+KfAX9NcxfRX8dt88a5jUwbx3zmvAG3MK8TbiN+i3k
zt/5846/8+edsp1Pl6zf/+jvRn8P3It5QdmuTz/mhbDeAPIwPIj1IvAQ1o/C
w1gvhnwE8+KoH8V+EsjHMC+J+nHUp1A/gfo0PIn9ZZBPwS7Wm4az8Aycw7xZ
OI/6ObgAz2P/Rdw/FpCXsN4i5pVRv4S8gnwZ86qoX0F9DfWryOvoX0PegNdx
ezeRb8AtXJ9N5G14C/XOHX/eIev3P9yF+gDcjfoe2d5P9cp6/G/3ez/9cAge
wHphzBtEfQT5EPYXhYfhmGzXawTz45g/iv4E8jH0J1E/DqfgCZx/Gvkk8gzy
KeQu9jONPIv+GVyPHPJZ9Ocxfw55AddnHvVF1C8gLyFfxH7KqF/CehX0L+P+
WkW+gnk1rLeK+XXka3AD9evIm/AG9tNCvom8jXwLdv673x1wp6zf/7L9BJB3
o78HeS8cRH0/HMJ6A8jDyAe37R0jyIfQH0X9sKy/j4L6EVn/fxL6R1GfQD6G
PInrMQ6nsP8JzEsjn8T8DDyFehfzprF+Fv0zcA79s8jzyOfgAvYzj/4ivACX
0L+I+WXkS8grmLeMvIp8BfNqqF9FfR1egxvwOtyEN3D/bCHfxP7auD23UO/k
/fUd2/aOnXCXrNf/sh7/qO9B3ov+IOr74RA8gP4wPAhHsP4Q5kVx/sPIY/AI
6uNYbxROoH8MeRL5OOankE+gPw1Poj6DfArXw0U+jTyL/cxgfg79s3Ae/XOY
X0D9POqLyBfgErwo6/+3Rr4EV3A+y3AV+1lBXsO8VbgOr8ENeB3zm7heG7Ie
/+jfhNvwFuY7/8PvDlmf/yPvQh6QbX433LPd7/30yvr/RzGvH+uFMG8A88Ko
H0QeQf8Q8ijWH0Z9DPUjcBz1o8gT2N8Y8iTyccxLIZ9Ansb+J3F9M1hvCnYx
bxrrZZHPoD+H9WZRn5ft8TiHvADPw0Wc3wL2V0K+CJcxbwmuoH4Z51dFvoK8
Bq9if3X0ryFvoH8deRP5BvbfgjdR34a3sB/nrn+9Drhz295Pl6zHP/Ju9Pcg
74WDst0/+mW9/pft/jWAPIx5g3AE9UPYXxT5MBzDvBHkcXgU9Qnsfwx5Euc/
jnkp7HcCTsOTmJ9BPoX5LjyN/WbRP4PbPwfPYl4e/XPIC/A8XMT8BcwroX4R
LuP6LiGv4Hoto76K+hW4Bq9if3Xka3AD57eO/TQxbwN5C97EvDbW28Lt6/y9
P++AO//eX98l208A7kZ/D/p7kQfh/u153jGEfAB5GB6U9ed/yIfgKOYPI48h
H0EeRz6KPIH9jOF6JFE/Dqdkuz9OYL00rv8k+jNYbwq5i/1NI8/CM1g/h/mz
yPPon0N9AfXzqC/CC3AJXsS8MvIluILru4z+Kq7PCvZfw/VfRX8dXoMb2M86
3IQ3sF4L8zbhNrwFO3P++R1z/rwT7pL1+x/93ajv2c69n17kQbgfDqF/QNb/
X4j9DGI/EcwbQh5FPox5MeQjcBzzRpEnsP8x1CfhcayfwvlOoD6NfBLrZ7D+
FOa7qJ+Gs/AM1s/Bs6jPY7051BdQP4/9FpEvwCWc/yLyMryE+RXky8ir2O8K
zqeG9VfRX8f8NbiBeevob6J+A3kL3sR+28i3YOcf/PM74M5/8Nd3IQ8g74Z7
UN8LB7frvWM/HEL9AByGB9EfQT6E/UVlvf9HfQwekfXvPWPeKNZPoH8M6yVR
P448hXxC1r9vgfmTcAaegl3sfxrzs9jPDPaTw7xZOI/+OaxXQP08XET/AvIS
9rMIl+EluIJ5y9hfFfUrcA39q7h+deRrcANeh5vwBtzCfjZxvdqo30K9c89f
3yHbT+c9f32XrMc/6rsxrwf1vZgXRN6P/hDmD6A/jHwQ8yKYNwRHUT+M+THk
I8jj8CjqE7Le/2P9JPY/jjyFfALrpZFPIs/AU9ifi/5p1GeRzyDPYd4snMf5
zMEFzJ+Hi/AC5peQL8JleAn9FXgZrsIr2H8N12MV69WRr6G/Idv7j3XUN+EN
uIX+Tey3jf1sIXf+p38/HbI+/4O7ZD3+4W64B+6Fg5jfv23vJ4R8AP1heBD1
EcwbwvlGUT+MeTF4BP1x9I+iPoH1x5An0T+O+hTyCfSn4UlZn/+jf0rWv3+D
85nG+lnMn8G8HDwL59E/h7yA9eeRF7GfBcwrwYtwGV7CehWst4z6KryC/hry
VVz/OvI1uAGvY34T57+BvIX+TZxPG97C/pyCf94OWe8HkO9E3ol8F/Iu5LuR
B+A9cLds+98L98D7sF7vdu797Mf8INyH+n7MP4D5Ifgg5g0gPyTr38dB/WHU
D8p2ex2R9X0K6D8KD+F8juF8osiPY71hzDuB/hjqT2L/I/ApzIvDp7GfUeRn
MC+B/Cw8Bp+Dkzif88jHsZ8LON8U9nMR8ybgS+hPI78MT2L+FeQZ7O8q6qew
3jX0uzjf68inkd9AnoVvyvb7ZQb7uYU8h/w28lnkd7BeHud/F4+vOez/HuYV
cH3uo38e/Q9QX8T6DzF/AefzCC7hfB7Di1jvCVzG/p5i/SX4GdavYL3nqF/G
/Beor8IvcT1W4FeYX8P815i3ivo3cB39b+E11L/D/Abq3yNfR/8HXL8m+j/C
G/AnzG/Bn+FNXL8vuP3bqP+K9baw/2/od/7R7x2yzetAvlPWvxcu23q70N+F
+t2oDyDfg/5u1O+Fe7C/fZjXi3n74SDch/n98AHMD2H9g6gfwPxDcBj9h9E/
iPojcAT1R2V93gEfQ310e573cxz5MHwC+41h/knsbwQ+BcfRfxrrjcJnZH0f
BOadxfmMof8c6pOoP4/9jON8L+D2T2HeRXgC8y4hT2N/l7HeJPqvwBnMu4r+
Kcy/hnoX+XXk0/ANzM9iPzfhGVyvW7K+XwXzb6N/Fr6D2z+P/dyF57DePZxv
Afl97Hce8x7g/lLE/h+ifgH5I6xXQv1jnO8i1nuCvIz9PkX9EuY/Q30F1+M5
9ruM9V6gv4r6l6hfQf4KeQ37ew2vov4NXIffYr013F/eIW/g/N9j3jqu5wf0
N7Hfj5i3gXmf0N+CP2PeJvq/IG9jva+Yt4X+b8id+3a023PHfX99B7wT7kT/
Llnv/5Hvlm39AObtQX838r2y/n0heB/W60W+H/OCyPvgfsw7gP2HkB9E/4Bs
979D6A+j/zDyQdmuxxHUR2R7PjmK+iHUH5P1+Sf2exz9w6g/gf3FMP8k8hHM
PwXHMf808lHZzu8M5idku75nsZ8xzD8nB71jEvPPw+OYdwHrp+CL6J9A/yVZ
7//Rf1nW57nwFTgj2/ldhacw/xpyF/u5Dk/DN2Q7nyzym7Kd/wzyW1g/h/3d
Rv0s5t1Bfx79d7G/Odlu73vIC5h3H+vNy3r/j/WK8EN4Aes/gkuyfv9jP4vY
7xPsr4z+p1h/CfOeYV4F/c+RL6P/BVyV7fH3El7Bfl5hvZps5/Ma+SrWewPX
sd5bzFvDvHdwA/t7L9vts475H5A3sZ+PyDfgT6hvYT+fsZ9N2W6PL3Ab+/uK
/i3Zrsc37Mf5J/9+dsAdsq23E3mnrPf/yLvkPu+4G3lAtv3tkfXvCcl2PntR
34P6fdhvr2znux/1QdmuXx/cj/UOwCH4IM5vAPkh7C+M9Q4jH0R+BPuPoP4o
1h9CfgzXM4r8OPqHsf4JXM8Y+k/CI+g/hesRR34a/aPYzxmcfwI+Kx/0jmOY
dw71Sfg89jcOX8C8FPZ3EetP4HpdwnppPD4uY/4k6q/I9v2oGdRfRf0U9ndN
HvCOLvLr2O807i83kGdxfW7KIe84g/wWbu8c8tuYP4v8DpzH9biLfA7z7uF8
C7h+93G+85j3AP1FXO+HOL8FXI9HWK+E58/HWG8R856gv4z1n6J/Cef/DOdX
wfk8R/0y5r3A/bUKv8R+VzDvFVzD7fca/avwG5x/HfPewmuof4fboyHb99W/
x/mu43p9wH6bctg7fsR+N+RD3vET8hb8GetvYr9fsH4b+/8Kb+H2+Yb5zrzf
O+AO2a7nTrhTtvV2yfr/hWTb/27Znh8Dsp3PHszrRv1e2W7PHtmu3z6s14v9
7pf7vGMQ7oP7sZ8DWD+E+QfRP4D8EByGD2O9Qdmer49gfgTnfxTXcwjX4xgc
Rf9xXO9hrHcC9THMO4n9j2DeKZxPHD6N+lHMP4M8gfwsrucY9nsO1ycp2+P3
PPYzjv4LuB4p1F/Efiaw3iWsl8a8y6ifRH4F/RmsfxXXZ0q2559rqHcx7zr2
P436G5iflX/GO96EZ+Bb6M9h/m3cf2ax/zvYXx79d+E51N+DC6i/j+sxDz/A
foryEe/4UP5Z77iA+kdYv4T8MfoX4SfyoHcs4/o+xfksYf4znE8F+38uH/WO
y8hfyD/nHavykHd8Kf+8d1xB/Svsv4b8tXzYO65iP2/kX/KOdeRvcX5rOP93
WL+B9d/jfNblX/SOH3B+Tfk73vEj6jdw/T5hvZZ8zDt+xvltov8L5rflYe/4
1exGveOW/Mve8Ruul/PP/v4dZvdXvGMHvBPuVL95l/Jf9Y5dyk94x93IA8p/
zTvuUW713fBe+bh37JFPesd9mNcrf9877sd+guZK3Dv2maO/6R37VR/zjgcw
LyT/unc8iHwA8w7Jo94xjPUP63xOecdBzfst73hE/We8YwQ+Cg+p39Y/pvk/
sDqtP+Ydj8u/7R2H5d/xjifks94xJp/zjie13u96xxFz8rx3PKX6pHeMm4O/
5x1Pa39WPyrb+mfkce+Y0Pn+0DuelS0fMxcsP6f9pWxfys3ntd8/8o7j2p/5
gvIJ75jS+fzIO15U/R97xwnlae94yVwzp83hP/GOl7Wfy95xEvkV5Ve8Y8ac
M1/V/n7iHad0vTLe8Zo5bXbN8Z96x+ua53rHaa0/5R1vqP9PvWNW52u+aW5a
/4y5+mfe8ZY58+e2jrl43TveNtenveOsOfsX3vGOOW/fY59Xbr6r/Wa945zO
x3zPrO/BLZj1vbH3dX3N8zo/+97EB2Z9T2VR52ffq/fQrO9JWzDre7MemfU9
VyXdH+17WR6b9b0ni2Z978kTs75HomzW90I81fU0L5n1PRjPNM/+HfiKbn/z
c7O+J2TZrO9NeGHWv3Nf1e1h9S/N+p6TFbO+l+MVzqdm1vcmvdb+zatmfS/Z
G90/7Hvs6ro97fq/1ePNvud0zazvQX2n+4vd/g3t3/xezx/2Pdnrun5/6R0/
4P7ZVL35ox4fdn/fwOPlk+6P5pbub1e942dzwB6Pm5r/Y+/4RfcXe7y39Xxi
zxdfNc+ej7Z0PS56x2/q/0M7PvCOSXu+3GF27fmyQ7bn852y/b7oNDv2+2CX
bL/fusyV095xt/rt91tA/q533CPb64NuzbPXL3tle33Uo3rL9ym31z+9sr3e
2y/b66mgbJ939Mn2erpftvcrB+CQbO/XDsr2/nNA1p//oz6M/LCsP/+X9ff/
4Yisv/+H/iHUH4Ojsn3+d1y2zzeGMf8EHEP/SeQj2M+pbXs/ceSnMW8U887A
Ccw7C4/B59CfhM/D4+i/gDyF/CLOZwK+hPo08svIJ+ErcAb9V7G/Kfga7MLX
MX8a82/AWfTfhGcw7xbyHPLbyGex3h3kefTfRT6H/B7yAnwf9fPwA7gIP8Tj
awH350c4nxL8GPtZRP4EeRnrP4WXUP8M8yrIn8PLmPcCrmLeS5z/Cua9gmvw
a8xbxXpv8PxUR/1bXO815O8wr4H136N+HfUfcH5N9H9E/wb8CfUt+DO8CX+B
29jfV6y3BX9Dv/Mvfu+Q7fp2IN8Jd8r2s2vb3rFL1v//h/4A6vfA3fBezOvB
vH2o75X19/9wfkHkfejvhw9gvRDO/yDmD2C/h9Afhg/L9npkUNaf/2NeBD4K
D8n2euQY9heV+7zjcdQPy/Z654Rsny/GUH8S80Zk+7zrlHzAO8Zle312GuuN
yvZ67AzWT6D+rGyf/43hep6T7fOvpGyfD57HeuNyxDtewH5T8EXsbwL7uwSn
ZXs9exnrTcr2evaKbJ83Zsz6vO+qbK+Hp1R/3DtewzxXts+3rssnvOO05tnr
8Ruyfd6VNevzrZvqt9f7M2a9/r+lfqvPKbf3C7eVm2c1zz7PuiP/hnfMq97y
u9qPfZ42p3rzPdV/zzsWZNvffdnen8zL9vniA82zz4eLyo97x4e43guyfX7/
CPe3kmzvBx4jX8Tj6Qnuz2U8np8iX8LzyzM8n1Xg56hfxvPbC7iK+peYt4L6
V3ANfg2vwm/gOtZ7i3wNfof9NpC/R76O/APcRP1H7GcDz8ef0N+CP2PeJuZ9
Qd5G/1d4C/6Gfqfoz3cU/XkHvBP1nfAuuAveDQcwfw/ybngv3APvg3vh/Vgv
iLwPeT/yA7LdniHkB9E/AB9CfRg+jPpB+AgcQf9ReAg+Bkcx7zg8jPoTyGPI
T27bO46g/hSuXxz5aXgUPgMnsP5ZrD+G/Bz6k9jPeXgc/RfgFOZdRD4BX4LT
6L+MfBK+gvPLyPb69SrmTaH/GnIX+XXMm8b1uIH1s8hvIp+Bb2H9HPLbyGcx
/w7q86i/i/OZg++hv4D++/A8rscDuCjb79+HyBew/0eoLyF/DC+i/gnyMvwU
XkL/M5x/BX6O/mXkL2R7vV/F+b5E/wryV9hPDfNeo39V7vOOb+A65r2V7f3F
mmx/n+CdbO8PGlj/PbyO+g9Yv4n8o2yfL2+g/pNsr/9b2N9n2V7/bcr2/ukL
1mvL9n7lK+q3sN431Dv/6p+3Q7a/39Ah2/nslH/BO3bK9n5kl2zvP7pk+/sB
u+GA2Y15xz3yiHfslu3P8/fK9v6hR/Osfp9s7x96zVF7v7Bftv6grD//N1fs
z9v7ZcsPaL69/wlpP/Z+4SDmDcCHVP9d7xjG9Tqs3K7PIK7vEVz/iGzvL47K
+vt/st7/I4/K9vg+Luv3P/ITcAw+uW3vZwTzTiGPw6fhUfSfgROoPwuPof4c
8iR8Hh6HL8Ap+CI8AV/CftLwZXgSvoJ5GfgqPAVfg13Mv458Gr4BZ9F/E/kM
fAvOwbfhWfgO1ssjv4t8Dvk9uADfR/888gdwEfUPkS/Aj+AS+h/Di6h/Apfh
p/AS/AyuwM/hZfgFXIVfwivwK7gGv4ZX4TdwHX4Lr8HvcH0byN/D6/AH9DeR
f4Q34E9wC/4Mb8Jf4Db28xX5FvwNdh7K3nHHQ3/eIev9P9yJ+l3Iu5DvhgPw
HvR3Y397kfcg34d5vfB+OAj3YX4/8gPIQ/BB1A/Ah7DfMPLDmDcIH0F9BD6K
+iGsdwz1Ufi4bK+/hzHvBBxD/0n0j8CnsJ+4bO8PTqN+FOudQX8C/Wdl/f//
yM9hfhLzz8t93nEc/ReQp2R7fXURnsB+LmFeWg55x8von8R6V2T7fDcj258P
XUU+hfO7hvVdXI/rmDeN9W+gPov6m5g/g/5bsr0/y8n6+//wrKy//y/b+5M8
5t2V7f3KHHwPLmB/92V7/zQv2/ulB1ivKNvr6Yc4/wXkj3B/KMGPcX0XMe8J
bs8yHn9P8fhYQv4MrsDP4WX4BVyFX8Ir8Cu4Br+GV+E3cB1+C6/B7+AG/B5e
hz/ATfgjvAF/glvwZ3gT/gK34a/wFvwNdv7N7x1wB7wT7oR3wV3wbjgA74G7
4b1wD7wP7pXt8bIfeRDug/vhA3AIPoj1BpAfgsPwYXgQPgJH4KPwEHwMjsLH
4WH4BByDT8Ij8Ck4Dp+GR+EzcAI+C4/B5+AkfB4ehy/AKfgiPAFfgtPwZXgS
vgJn4KvwFHwNduHr8DR8A87CN+EZ+Bacg2/Ds/AdOA/fhefge3ABvg/Pww/g
IvwQXoAfwSX4MbwIP4HL8FN4CX4GV+Dn8DL8Aq7CL+EV+BVcg1/Dq/AbuA6/
hdfgd3ADfg+vwx/gJvwR3oA/wS34M7wJf4Hb8Fd4C/4GOwt+74A74J1wJ7wL
7oJ3wwF4D9wN74V74H1wL7wfDsJ9cD98AA7BB+EB+BAchg/Dg/AROAIfhYfg
Y3AUPg4PwyfgGHwSHoFPwXH4NDwKn4ET8Fl4DD4HJ+Hz8Dh8AU7BF+EJ+BKc
hi/Dk/AVOANfhafga7ALX4en4RtwFr4Jz8C34Bx8G56F78B5+C48B9+DC/B9
eB5+ABfhh/AC/AguwY/hRfgJXIafwkvwM7gCP4eX4RdwFX4Jr8Cv4Br8Gl6F
38B1+C28Br+DG/B7eB3+ADfhj/AG/AluwZ/hTfgL3Ia/wlvwN9j5X37vgDvg
nXAnvAvugnfDAXgP3A3vhXvgfXAvvF/W3/9D3gf3wwfgEHwQHoAPwWH4MDwI
H4Ej8FF4CD4GR+Hj8DB8Ao7BJ+ER+BQch0/Do/AZOAGfhcfgc3ASPg+Pwxfg
FHwRnoAvwWn4MjwJX4Ez8FV4Cr4Gu/B1eBq+AWfhm/AMfAvOwbfhWfgOnIfv
wnPwPbgA34fn4QdwEX4IL8CP4BL8GF6En8Bl+Cm8BD+DK/BzeBl+AVfhl/AK
/Aquwa/hVfgNXIffwmvwO7gBv4fX4Q9wE/4Ib8Cf4Bb8Gd6Ev8Bt+Cu8BX+D
nUd+74A74J1wJ7wL7oJ3wwF4D9wN74V74H1wL7wfDsJ9cD98AA7BB+EB+BAc
hg/Dg/AROAIfhYfgY3AUPg4PwyfgGHwSHoFPwXH4NDwKn4ET8Fl4DD4HJ+Hz
8Dh8AU7BF+EJ+BKchi/Dk/AVOANfhafga7ALX4en4RtwFr4Jz8C34Bx8G56F
78B5+C48B9+DC/B9eB5+ABfhh/AC/AguwY/hRfgJXIafwkvwM7gCP4eX4Rdw
FX4Jr8Cv4Br8Gl6F38B1+C28Br+DG/B7eB3+ADfhj/AG/AluwZ/hTfgL3Ia/
wlvwN9j5d793wB3wTrgT3gV3wbvhALwH7ob3wj3wPrgX3g8H4T64Hz4Ah+CD
8AB8CA7Dh+FB+AgcgY/CQ/AxOAofh4fhE3AMPgmPwKfgOHwaHoXPwAn4LDwG
n4OT8Hl4HL4Ap+CL8AR8CU7Dl+FJ+Aqcga/CU/A12IWvw9PwDTgL34Rn4Ftw
Dr4Nz8J34Dx8F56D78EF+D48Dz+Ai/BDeAF+BJfgx/Ai/AQuw0/hJfgZXIGf
w8vwC7gKv4RX4FdwDX4Nr8Jv4Dr8Fl6D38EN+D28Dn+Am/BHeAP+BLfgz7L+
/3/kX+A2/BXegr/9P/9v7I+xNw==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"Energie\\n(Kanal)\"", TraditionalForm], 
    FormBox["\"Ereignisse\\n(Anzahl)\"", TraditionalForm]},
  AxesOrigin->{2600., 0},
  AxesStyle->Arrowheads[0.03],
  Epilog->{FontSize -> 16, {
     RGBColor[1, 0, 0], 
     LineBox[{{2788, 0}, {2788, 3000}}]}, {
     RGBColor[0, 0, 1], 
     LineBox[{{2762, 648}, {2805, 648}}]}, 
    InsetBox[
     BoxData[
      FormBox["2788", TraditionalForm]], 
     NCache[{2788, 
       Rational[648, 5]}, {2788, 129.6}], BaseStyle -> RGBColor[1, 0, 0]], 
    InsetBox[
     BoxData[
      FormBox["43", TraditionalForm]], {2788, 563.4782608695652}, BaseStyle -> 
     RGBColor[0, 0, 1]], 
    InsetBox[
     BoxData[
      FormBox[
       FrameBox["\"Mylar F3\"", RoundingRadius -> 5, StripOnInput -> False], 
       TraditionalForm]], 
     NCache[{
       Rational[5275, 2], 1080.}, {2637.5, 1080.}], BaseStyle -> 
     GrayLevel[0]]},
  ImageSize->600,
  PlotRange->{{2600, 2900}, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.550671018109375*^9, 3.5506970015625*^9, 3.5506974828125*^9, 
   3.5506975213125*^9, 3.55069758559375*^9, {3.550697628359375*^9, 
   3.55069765621875*^9}, 3.550750538*^9, 3.550750673390625*^9, 
   3.5507507230625*^9, 3.550752747328125*^9, {3.550753232328125*^9, 
   3.55075325703125*^9}, 3.5507533226875*^9, 3.55075371053125*^9, {
   3.55075385484375*^9, 3.55075388275*^9}, {3.550771976796875*^9, 
   3.5507720394375*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxt3X9ok39/7/ELKVKkSJAiRYrklCJBimSuc5nrXOY6l7nOZd6dd27Xuayn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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"Energie\\n(Kanal)\"", TraditionalForm], 
    FormBox["\"Ereignisse\\n(Anzahl)\"", TraditionalForm]},
  AxesOrigin->{2500., 0},
  AxesStyle->Arrowheads[0.03],
  Epilog->{FontSize -> 16, {
     RGBColor[1, 0, 0], 
     LineBox[{{2643, 0}, {2643, 3000}}]}, {
     RGBColor[0, 0, 1], 
     LineBox[{{2617, 527}, {2665, 527}}]}, 
    InsetBox[
     BoxData[
      FormBox["2643", TraditionalForm]], 
     NCache[{2643, 
       Rational[527, 5]}, {2643, 105.4}], BaseStyle -> RGBColor[1, 0, 0]], 
    InsetBox[
     BoxData[
      FormBox["48", TraditionalForm]], {2643, 458.26086956521743`}, BaseStyle -> 
     RGBColor[0, 0, 1]], 
    InsetBox[
     BoxData[
      FormBox[
       FrameBox["\"Mylar F4\"", RoundingRadius -> 5, StripOnInput -> False], 
       TraditionalForm]], 
     NCache[{
       Rational[5075, 2], 878.3333333333334}, {2537.5, 878.3333333333334}], 
     BaseStyle -> GrayLevel[0]]},
  ImageSize->600,
  PlotRange->{{2500, 2800}, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.550671018109375*^9, 3.5506970015625*^9, 3.5506974828125*^9, 
   3.5506975213125*^9, 3.55069758559375*^9, {3.550697628359375*^9, 
   3.55069765621875*^9}, 3.550750538*^9, 3.550750673390625*^9, 
   3.5507507230625*^9, 3.550752747328125*^9, {3.550753232328125*^9, 
   3.55075325703125*^9}, 3.5507533226875*^9, 3.55075371053125*^9, {
   3.55075385484375*^9, 3.55075388275*^9}, {3.550771976796875*^9, 
   3.55077204053125*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxt3X9o1W+8EPCDDBkiMmTI+DJkyZAhQ5YtW7a8J1u2zGyZ2a7tek+26122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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"Energie\\n(Kanal)\"", TraditionalForm], 
    FormBox["\"Ereignisse\\n(Anzahl)\"", TraditionalForm]},
  AxesOrigin->{600., 0},
  AxesStyle->Arrowheads[0.03],
  Epilog->{FontSize -> 16, {
     RGBColor[1, 0, 0], 
     LineBox[{{1048, 0}, {1048, 3000}}]}, {
     RGBColor[0, 0, 1], 
     LineBox[{{970, 249}, {1100, 249}}]}, 
    InsetBox[
     BoxData[
      FormBox["1048", TraditionalForm]], 
     NCache[{1048, 
       Rational[249, 5]}, {1048, 49.8}], BaseStyle -> RGBColor[1, 0, 0]], 
    InsetBox[
     BoxData[
      FormBox["130", TraditionalForm]], {1048, 216.5217391304348}, BaseStyle -> 
     RGBColor[0, 0, 1]], 
    InsetBox[
     BoxData[
      FormBox[
       FrameBox["\"Mylar D2F1\"", RoundingRadius -> 5, StripOnInput -> False],
        TraditionalForm]], {675, 415.}, BaseStyle -> GrayLevel[0]]},
  ImageSize->600,
  PlotRange->{{600, 1200}, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.550671018109375*^9, 3.5506970015625*^9, 3.5506974828125*^9, 
   3.5506975213125*^9, 3.55069758559375*^9, {3.550697628359375*^9, 
   3.55069765621875*^9}, 3.550750538*^9, 3.550750673390625*^9, 
   3.5507507230625*^9, 3.550752747328125*^9, {3.550753232328125*^9, 
   3.55075325703125*^9}, 3.5507533226875*^9, 3.55075371053125*^9, {
   3.55075385484375*^9, 3.55075388275*^9}, {3.550771976796875*^9, 
   3.550772040765625*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxt3X9oVP9+5/GDBAkSZJAgQYJMQ5BBgsy6qZ3a1Dv1pnZqc71Tb66d66Z2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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"Energie\\n(Kanal)\"", TraditionalForm], 
    FormBox["\"Ereignisse\\n(Anzahl)\"", TraditionalForm]},
  AxesOrigin->{2300., 0},
  AxesStyle->Arrowheads[0.03],
  Epilog->{FontSize -> 16, {
     RGBColor[1, 0, 0], 
     LineBox[{{2547, 0}, {2547, 3000}}]}, {
     RGBColor[0, 0, 1], 
     LineBox[{{2503, 343}, {2596, 343}}]}, 
    InsetBox[
     BoxData[
      FormBox["2547", TraditionalForm]], 
     NCache[{2547, 
       Rational[343, 5]}, {2547, 68.6}], BaseStyle -> RGBColor[1, 0, 0]], 
    InsetBox[
     BoxData[
      FormBox["93", TraditionalForm]], {2547, 298.26086956521743`}, BaseStyle -> 
     RGBColor[0, 0, 1]], 
    InsetBox[
     BoxData[
      FormBox[
       FrameBox["\"Aluminium\"", RoundingRadius -> 5, StripOnInput -> False], 
       TraditionalForm]], {2350, 571.6666666666667}, BaseStyle -> 
     GrayLevel[0]]},
  ImageSize->600,
  PlotRange->{{2300, 2700}, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.550671018109375*^9, 3.5506970015625*^9, 3.5506974828125*^9, 
   3.5506975213125*^9, 3.55069758559375*^9, {3.550697628359375*^9, 
   3.55069765621875*^9}, 3.550750538*^9, 3.550750673390625*^9, 
   3.5507507230625*^9, 3.550752747328125*^9, {3.550753232328125*^9, 
   3.55075325703125*^9}, 3.5507533226875*^9, 3.55075371053125*^9, {
   3.55075385484375*^9, 3.55075388275*^9}, {3.550771976796875*^9, 
   3.55077204103125*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxt3X9o1e17H/CDyEMQkfAgD+FB5EyCBAmS2symNrWn1trMZja1qU1dZk9t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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"Energie\\n(Kanal)\"", TraditionalForm], 
    FormBox["\"Ereignisse\\n(Anzahl)\"", TraditionalForm]},
  AxesOrigin->{3100., 0},
  AxesStyle->Arrowheads[0.03],
  Epilog->{FontSize -> 16, {
     RGBColor[1, 0, 0], 
     LineBox[{{3218, 0}, {3218, 3000}}]}, {
     RGBColor[0, 0, 1], 
     LineBox[{{3209, 1239}, {3227, 1239}}]}, 
    InsetBox[
     BoxData[
      FormBox["3218", TraditionalForm]], 
     NCache[{3218, 
       Rational[1239, 5]}, {3218, 247.8}], BaseStyle -> RGBColor[1, 0, 0]], 
    InsetBox[
     BoxData[
      FormBox["18", TraditionalForm]], {3218, 1077.3913043478262`}, BaseStyle -> 
     RGBColor[0, 0, 1]], 
    InsetBox[
     BoxData[
      FormBox[
       FrameBox["\"Luft1\"", RoundingRadius -> 5, StripOnInput -> False], 
       TraditionalForm]], {3125, 2065.}, BaseStyle -> GrayLevel[0]]},
  ImageSize->600,
  PlotRange->{{3100, 3300}, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.550671018109375*^9, 3.5506970015625*^9, 3.5506974828125*^9, 
   3.5506975213125*^9, 3.55069758559375*^9, {3.550697628359375*^9, 
   3.55069765621875*^9}, 3.550750538*^9, 3.550750673390625*^9, 
   3.5507507230625*^9, 3.550752747328125*^9, {3.550753232328125*^9, 
   3.55075325703125*^9}, 3.5507533226875*^9, 3.55075371053125*^9, {
   3.55075385484375*^9, 3.55075388275*^9}, {3.550771976796875*^9, 
   3.550772041265625*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxt3X9o1ft/H/CDiAQRCRIkSLicSZAgQVKb2cym9tRmNrWpy2xqU5vZU5va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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"Energie\\n(Kanal)\"", TraditionalForm], 
    FormBox["\"Ereignisse\\n(Anzahl)\"", TraditionalForm]},
  AxesOrigin->{3100., 0},
  AxesStyle->Arrowheads[0.03],
  Epilog->{FontSize -> 16, {
     RGBColor[1, 0, 0], 
     LineBox[{{3218, 0}, {3218, 3000}}]}, {
     RGBColor[0, 0, 1], 
     LineBox[{{3210, 479}, {3228, 479}}]}, 
    InsetBox[
     BoxData[
      FormBox["3218", TraditionalForm]], 
     NCache[{3218, 
       Rational[479, 5]}, {3218, 95.8}], BaseStyle -> RGBColor[1, 0, 0]], 
    InsetBox[
     BoxData[
      FormBox["18", TraditionalForm]], {3218, 416.5217391304348}, BaseStyle -> 
     RGBColor[0, 0, 1]], 
    InsetBox[
     BoxData[
      FormBox[
       FrameBox["\"Luft2\"", RoundingRadius -> 5, StripOnInput -> False], 
       TraditionalForm]], {3125, 798.3333333333334}, BaseStyle -> 
     GrayLevel[0]]},
  ImageSize->600,
  PlotRange->{{3100, 3300}, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.550671018109375*^9, 3.5506970015625*^9, 3.5506974828125*^9, 
   3.5506975213125*^9, 3.55069758559375*^9, {3.550697628359375*^9, 
   3.55069765621875*^9}, 3.550750538*^9, 3.550750673390625*^9, 
   3.5507507230625*^9, 3.550752747328125*^9, {3.550753232328125*^9, 
   3.55075325703125*^9}, 3.5507533226875*^9, 3.55075371053125*^9, {
   3.55075385484375*^9, 3.55075388275*^9}, {3.550771976796875*^9, 
   3.550772041765625*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxt3X9olPl/IPBBZAmLLEFkCYssc0EkiEjOy9nUpnZqrU1tzpva1OZsaqc2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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"Energie\\n(Kanal)\"", TraditionalForm], 
    FormBox["\"Ereignisse\\n(Anzahl)\"", TraditionalForm]},
  AxesOrigin->{2900., 0},
  AxesStyle->Arrowheads[0.03],
  Epilog->{FontSize -> 16, {
     RGBColor[1, 0, 0], 
     LineBox[{{3083, 0}, {3083, 3000}}]}, {
     RGBColor[0, 0, 1], 
     LineBox[{{3068, 1027}, {3096, 1027}}]}, 
    InsetBox[
     BoxData[
      FormBox["3083", TraditionalForm]], 
     NCache[{3083, 
       Rational[1027, 5]}, {3083, 205.4}], BaseStyle -> RGBColor[1, 0, 0]], 
    InsetBox[
     BoxData[
      FormBox["52", TraditionalForm]], {3083, 893.0434782608696}, BaseStyle -> 
     RGBColor[0, 0, 1]], 
    InsetBox[
     BoxData[
      FormBox[
       FrameBox["\"Mylar F1\"", RoundingRadius -> 5, StripOnInput -> False], 
       TraditionalForm]], 
     NCache[{
       Rational[5875, 2], 1711.6666666666667`}, {2937.5, 
      1711.6666666666667`}], BaseStyle -> GrayLevel[0]]},
  ImageSize->600,
  PlotRange->{{2900, 3200}, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{
  3.550671018109375*^9, 3.5506970015625*^9, 3.5506974828125*^9, 
   3.5506975213125*^9, 3.55069758559375*^9, {3.550697628359375*^9, 
   3.550697657046875*^9}, 3.550750346453125*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxt3X9ok39/7/ELKVKkSJAiQYrklCJBimSuc5nrvDPXuczT48lc53K7zmVd
b+/M9XaZ6zyZ6zyZ67xzPD2eHNe5HE/nyfHu8eR4ejxBigQpEqRIkCJBigQp
EqRIkCJBigQpcg7ner9yuJ6c/nPx+L5/fN6fz5U0adRv/9nEn5790S7n/3z5
HOf/Xv+/X60f4D9EvOyGfXAv7If74ADcDw/Ah+AgfBgehI/AIfjn4KPwz8ND
8C/Ax+BfhMPwL8HH4V+Gh+FfgU/AP4AjXmdg51cRh52TiMPOryEOOyOIw86v
Iw47pxCHnd9AHHaiiMPObyIOO6cRh51/brbnVUbW82oUcdj5F2Z73mVg54y3
X0ZW/b9Ef9iJeeeNxJDfibvXCuLOb3kdkTUvXEG+cxb1sn1fycj2VYGd30a9
rPP4bW9+Rdb5jXnjEVn778RtfuQ7v+PtF/kdbzwDV2DnnHe9yDlvPIN4BXZ+
F/Wy9o94Rdb+4978iKzz78Rtflnr/9Abj/zQG8/AFdg5j/ll+8ogXoGd30O9
rP13bPMj3xn35kfgjKzHr6z638f6cEZWvayvC15HZNV34laPuPMHmL9j9yvz
B978CuwkvPMFZPVDPIF4RrZ+BbgCNzr19vWHXgfgiGz1CTgDF+AK+jUQdybM
2v+ENx5BPCHbVwb5hU7cvVaQ34CdP/LmB+CIrPURzyBekLX/Tr6tj7gzabbn
e0DW9zPZ1kvAGeQX0K+C/Ias9X+E9X/kzY/I2j/imY7drwLiFdnehzawnnPR
rvY+NCBrfTgBZ2TrV5BtvQriDcSdH9vV3jcHfuyNR2TtX7b30RlZ68MVWeeP
uJP0rhdIeuMROCHr9R0uyLafCvo30M/5Y+9+ArLOH07AGVn7l7W+rPVlvf5d
8vYLyHr+y/b4SMh6fUR9Qdb6sq3XQD/nT+yq/cMRWecv6/sf4gW4Itt6DVnv
P6fsqvsv2/wRud/Wl7V/Wfdftvkr6NeQtf5PvPMFfuLNj8jav2zzZuAC8iuy
zdPAes5lb30AjshWn5D1+Ed+Aa7I/bY+4s6f2lXPf9l+zo3IVp+QtX/Z5isg
vyLr/qPeSXntk/V6KNt8Idl+ro7I1j+G+oRsP6enkJ+R7X7lZO1HtvMooV9F
ts8Jali/gfwW1nf+zK7av2yfIwRk229I1vNT1v7lfveagFOynWcG6+fggmzn
U5LtPCqYtwY30K8l63OOK95+PtnOMyDb/kKyfS4Ske18Y3BCtnlSWC8ja/9Y
v4B+JfSryHZ/anBD7nevLVmf+/y5t59Pts+JArJ97hOSdf9RH5Nt/gTiKVmP
f9nOI4f1CuhXkm0/FdnOp4b5G7J9v21hPWfaW++b9sYDst2fkGzzRGR7PMXg
BPqlsF5GtvPJyXb/CnBJtvOpYJ4a4g3Z7ndL7rfrX3jjPln7/wtvfkjW9z9Z
91/W64VsnwOmZN1/9M/J9vwqwCXMV8H6NcQbcEvW54xX7Wrn5ZPt/gVkO58Q
HJGtf0zW4x/5KTiD9XJwAf1Lsp1/Bf1qWL8h2/OhJetz43/ltU/W/Zf1/U/W
9z/Z1o/BCdmefynZ5snIev2T9fjH+iXZPneuyLr/6N/A/lqyPldPe/v5ZL0f
k60+JOvxL+v+wwk4hX4Zud+95uAC5inJen8la/9wQ9bzH/2dv7SrnYcPDsh6
/Zf1/kzW659sz6cE+qWQn0G/nGzzFbB+Ca7Idj412fbbQLwl689BrnnX88EB
OARHZL3/kfX8l+3PRVKy3Z+MbPvJyXY+BdnmLaG+gnlqst7vo39L1uvfX3nt
k61fQNbjH/kRWfuHE7J9v0jJNk8G/XOy7beAeUqynW9FtveTNVmPf6zXkvXz
94y3n0+29QKynWdItv4R2Z6PMdnWS8j6/of+GdnOK4d4AfOVEK9gvhr6NVDf
kvXnlH/tnd/31954QNb9l/X5iGz9Y+iXkPX6h/oM8nOyfp5GvARXsH4N8Yas
13/sx7luVzs/n6zv/7Ld75Csn89lmzeGeAL9UnAGzsl6/su6/7J+vpf73WsN
6zdk/fyD9Zx/7Z3fJ+vzSNnOLyRbfQTxmGzzJGR9/5f1859s559D/wLyS7K+
/yNek/V5O/q3kO9k7Gr77YZ9GW++X7b9BWTrH4RDsp1/WNbna4hHsV4MjmO+
hGznlZR13qhPY74M6rOI51Cfx/oF2R4/ReSX4DJcwXpVnEcN+XWs38D9aGKe
Fvq3Zb3+/Y23X7ds6/lkq/cjP4B4UNbPi+gXRjwi2/2KyrafGByX9fmSrPuP
9VKIp7F+BvlZxHPYXx7zFpBfRH4J85axXgXxKuatoV8dbuB+NNG/Bbcxr3PD
rvb9vVu29X03vPl+OCBb/6Cs5z/yw8iPID+KeAz1cbnfvSZk238S/VLIT8t6
/UF9Fvk52e5PXtbn/YgXZb1eYf4yXMG8VVnfz5Ffx/wN5Dcxf0u2/bUxn/O3
3vpuWe8HZN1/OCDb95OgrJ+XZVs/DEeQH4VjmCeO9ROIJ2W7HynZ9ptGfQbO
ol8O8+TRv4D6Is6zhP2WkV9Bv6rc715rmKeO/AbiTVmf9yHehp1Zu9r5dMt6
PzzrzfcjHpBtnqBs84dk3X9Zz3/Z5o0iP4Z4HOsl4CTqU1gvjfwM9pNFfg7O
o76A+YpYv4T6MlxBfVW290c19KvLev6jvon6FuJt2Pk77366ZX3/R9wv6/Vf
tvMLIh5CPIz+EVn3X9b3f8TjqE/I9vNCEuul0C+N+TLIzyI/h3ge51GQ7byL
qC9hvTLiFbiK/dawvzryG7J9/21inhbmb2Me56Y3v/umN+6Tdf9l/Xk14kFZ
7/8QD8v6832sF0V+TNb7fzgBJ2X9vAmnsX4G+8nCOeTnMV8B6xex/xL2V0a8
AleRX8P6dcQbWL+JeAvzthF3fuqt7/6pN9/3U2++X7bHSwD5QTiE+jDiETgK
x7BeXNafr6B/EvtJIT+N/Izc716zyM8hP4/5CogXZd1/xMuor8j6/o/6GlxH
vwbiTfRv4fzaiDtZb7xbtnl8su6/rNd/1AeRH5L1/IcjWC+KfjH0iyM/ASfR
P4V+afTLyHr+y/o8StbrP/oX4CLmKWG9MuapIF7t1LtfNaxfR/8G4k24hfvV
xrzOv/G6W9b9R9yPeEDW67+svy8i6/mP+oisn/+QH0N+HPEE1k9i/RTmT6M+
g/5Z1OdQn0e8gH5F5JfQv4z8imyPtyrqa8ivY/2GbI+nZmc9+8/o18Z5O7fs
aufXfcub75P1/Jf1+Tjyg3BItvXCst7/IT8Kx+A45knIev4jP4V507L+/lyn
3v3Kon8O9Xn0L6C+iHlKWK+M/hX0q6JfDevX0b+Bfk24hfvbRr3zb73zdct6
/wf7Zf39MFnPf8RDsq0XRr8IHIVjqI8jnsD8SayfQjyN+gz6ZxHPIZ5HvwJc
RH0JLsMV9K/CtY7dr7qs5z/ym+jfgtvId+a88W5Zn//I+vxf1v2Hg+gXknX/
kR9B/yjyY3AcTmC9JPqnkJ+W9fxHPIt5cnAe/QtYv4h4CS7DFfSvYp4a+teR
34Cb2F+r08/9aiPf+XfeeLes5z/sl3X/O/XuNYj8kGzzhOEIHJX158noH0d+
QtbPf9hPCvOm0S+D+izmz6FfHv0KmKeIeAn9ythfBfNUUV9D/zrcQH0TbiG/
jbhz27teN+yD/bJ9BTp2r0E4BIdl3X/0jyIeg+PITyCehFPIT2P+DObLwjnk
59GvIOv5j3gJ85Rlff6D/lXU1zBPXdaf/6B/E/UtuI31nH/vnb9b1vt/2C/r
53/UBxEPyfr5D/0isv78F/EY6uOduPuVQH4S66cwXxrxDJxFvxycR34B8xQR
L8Fl7LeC/lW4Juv9H+INnE8T67UQb8NOzjt/V84b75bt/HoQ93Xq3WuvbOv7
4T6sF0D/AfQPov8g+oUQH0I8jPWGZf39bdSPwFHUjyIew7xjyI/Ldv/GUZ9A
/STiSexnCk4hf1q2x1ca/WdQn4Fn0S+L+jk4h/p53M88+i0gXsD5LCK/iP5L
uH8lzLOM/DLiK7g/FXgV9VV4DfPVEF/HfurI30B+A/FNnE8T+VvIbyG+jXgb
8R2ch/MfvO6S7atb1vNftn6+Tr577UXcj/59cAD5A+gXhAfhEPoNIR6Gh7G/
COIjmCcKj8IxeAyOo/841k9g/kmcdxL1U8hPYb1pxNPwjKy/f4b4LPplkT+H
eA7185g/j/kXUF9A/SJcxHktoV8J/ZaRX8Y8K8ivYL1V9K8ifw39azifdcTr
qN+AG/Am5m3CW5i3hfptxNvYzw7izh3vvF2yPg+S7fWkp5PvXn2yzdeLuB/9
+rBeAPkDsl7/UT+IeAgeQr8w1htGfgTzj8BR1I+if0y2+z+GeeNYbxxOoN8k
6pPwFPJTiE8jnsb9m0E8g/pZOIt551Cfg+dRn8f5LCC/gP6LcBH5S+hfQnwZ
9WXEV3B/K8hfxf2uIr6GeA391zFfHfENxBvwJvKbWH8L8Rbqt+E2vIN+zt/b
1c6j6++9+d1wD+yT9frfsfvll/X6j/oA6gdk/X1C5A/CIfQfQr8w4sOoj2D/
I6iPIj6KfjF4DI6j3zjOJ4H4JJzEvFPon4KnMW8a9TPon0F8FvEsPIf8HOLz
WD+P/S7g/hZQvwgXsb8lrF9C/jJcRv6KrJ+/EV+Fq9jPGvZTw3zrqK9jng3E
G+i3iXgT9VtYr4X6bdS3Ub+Demfem981783vlu1+9SDu69jSZH1eCPfBAaw/
gH5B2c5/EPkhzDMEhzH/MOIRzDOC9aLIH8X6MXgM68XRfxz5CeRPIp6Ep+AU
5p1GPI34DPaTwfqzqM9i/jk4B8+jPg8vwAXUL8JFPB6WMH8J8WXUl+EV1Fdw
PqtwFfVrmL+G/HXE66jfQH4D8U3M18T+thBvod824m3MswM7/+Ct75L1/P8H
b34P8n3I70W+X9bzv5PvfgVQP4D6oGyPz0HEQ5hnCOuF0X8YjqDfCNaLIn8U
88cQH0N9HPnjWC+B+knEk6ifQv8U6qfhNPJncF4ZrDeL+izic3AOnsf55xFf
gAvwIuqLmGcJLqF+GfVlxFfgCs5jFf2ryF/D/aihfh2uY54N9G+g/ybcRP4W
+rUwzzbWbyN/B3bueuu7ZP15UCfuXntkvf+He2E/3AcH0H9A1s//iA/CIeQP
YT9hrDeMeATxEfSPwqNwDOuPoV8c+eM43wTyJ5GfhKfgFNafhtPIn8H+M/As
8rPwHJzD/PPol4cXkF/AvItwEestwSV4GS6j3wriFcRXEa9i/jXEa9jPOvrV
cb83UN9A/ibWa6L/Fupb8Dby21h/B3b+0ZvfJevP/2S9/0fcB/fK+vsiiPfJ
Nm8A6w904u5XEB5E/xDqh9A/jPxh5EeQP4J4FPOPYp4Y4mOoj8PjcALzTSKe
xHxTiKew/jTmS6N+BvkZ9JtFfhbzzSE/h37zqM8jvoB4Af0WES9iP0vIL2G+
ZcTL6LcCV5C/in5VzL+GeA3xdfSr4/mzgfUbsn0esYl4E96CW/A2+rUxzw7y
nbzXXbKe/3CPrPf/qO9Fvh/xPlmv/7KdzwDiQdQPon8I8SHUhxEfRjwCj8BR
zDeKeAzzjGG9ODwOJzp2vyYRT2K9KcyTwv2YRn4a/WbgDDyL+iz2N4f1cphn
Hv3y2N8C4gWst4j1iogvob4k298HWEZ9GfUrmKeC/FXsr4r8NbgGr6NfHfNu
IL+B+TaxfhP9tpDfQv9tuI36HdQ7/9HrLlk//8t6/Zf1+t/JtzTE/ejXBweQ
P4B5grI+/0N9CB7CvGF4GPkReAT7icKjmC8Gj8Fx9B/HfhOIT6I+ifgU6lOI
T8NpzD8DZ+BZrJ9FvznEc4jPY7488heQX8D6i8gvIn8JLqF+GfVl2V4PV5Bf
Qb9VuAqvwTWst454HfENuIHz2kR9E/EtzN9CfBvxNuI76O/c887Tdc8b75b1
93+Q70N+b8fulx/5fXAA9QNwULb5B1EfgodQH0Z8GPEI+o8gHoVH4Rj6jyEe
R3wc55NA/iTyk4hPwSnkT2M/aaw3A2fQbxbxLPrPwTl4Hs7DC1ivgPUWMX8R
9UuoL8HLeLyWEV9BvwrWW8U8VdSvIV5D/Tpcl+37zwbqG/Am5mui3xbiLXgb
87bhHdj5T153wd1wj6znv2yvr72I+2X9/I/8QKe/+zWA9YLwIPqFsN4Q4mHU
DyM/IuvP/5EfRf4o4jHEx7CfOOYZx/4TqJ9EfhLrTWHeFOqnUZ9GfAbOIH8W
82cRn8M8OXge/fPwAvoVZHt+LCK/iPwlnF8J+cuYpwyvIL+C+CpchddQX0N8
Ha5j/g3EG/Am+jdxP7Zw/1vI30Z+G/13MI+z4O3XJdtX94I3vwf5vk6+e+2F
/bJe/1EfQP4A1g+ifhD1IcSH4DDmH0b/COIjqI9ivlGsH5P19//QL476cdQn
MM8k8pPwFOZLwdNwGvUzWD+DeWdRn0X+HPJzyJ+H86hfgAuYbxHnUYSX4BLm
WYbLyF/BfBWsv4r8KuJrcA3rraN/HfkbcAPexOOpifPawnoteBvzt+EdrOf8
k3fern/yxrtlPf+R70N+L+J+xPsQD3Ti7tcA8oPIH4RD8BAchofhCPY3gngU
84zCMcw/hvo48sfhBOonMU8S/abglKzP/9A/jfgM1stgvVn0z6LfHJxD/jyc
R/4C1i8gfxHzFFG/hPoS8pfRr4z6FbiCfqtwFflrcA3rr2P9OryB+ga8ifwm
7t8W4i3Et9GvDe8g37mvuPvVJevzf7gH9nXq3Wsv7JdtvT44gPwBWZ//yfb+
cBD1IcwzhH5heBj5Eex/BI4ifxT9YoiPwXF4HP0TiE9if0mcxxTqU6ifxnxp
eAbOwLNwFp6Dc/A85s8jvoD9FDD/IlzEfpfQv4R+y7K9fpbRbwX1FXgV/aqY
fw39ashfR34d3kB+A/02MU8T8S054F5byN/GebWx3g76Of/ZG++S9foP98A+
Wf/+B3E/+vfJ+vu/iA+gXxDxQVn/f0HZ7vcQ1g937H4No38E8RHEo5h3FP1j
qB+D48gfR/8E5p9EfRL1UziPFPpNI55GfAb7yaD/LPKz8Bzyc+g3j/w84gvY
XwHxRcxfRHwJLmG9ZcTLiK8gXsF6q4hXUb+G/Bru3zrOp45+G6hvIL6JeBPe
wjwtrLeN/Db67yDuFLz1u+Au2dbbjXg3vKdj96tHtvX2It8n23z7ZH2eiPz9
6O+X7fvBAazXh/qDWC+A/fWjfgD1hxAPIn4Y8w0ifgT1IfgoPIT5jqF/GPnH
4WH4BOoj6H8S5zMCn8L9iSJ+WrY/jx9F/zNwDOdzFvEx+BzWi2Oe88gfx/4v
wAnkT+B8JhG/iPWTyL+E/UwhfhlOod8V1E/DV1GfRv015M9g/uuIZ+Ab6DeL
+E2sn0X/W4jP4bxvo18O692B51F/F/3ziN9D/wXMdx/9C6h/gMfTIvo9hIuY
5xH6L6H/Y9SXsN4T1C+j/1PUl9H/GeIr8HP0q6D+BdZfxfm9RH4V/V+hfg3x
16ivIf4G9evIf4v8OuLv8Hqwgf2+R34D631A/ibW+wg3Uf8J/bcQ/4z6FuJf
UL+Nx8dX3I82+n1DfAf+jvWc/+L1Ltn6dcm2/m5Z/z4A8T3o1wPv7fS3Nlhv
H/J7Ed8P+2W9/mO+PvQ7CAfQrx8ekO1+HIKDyD+M/oPwEZxXCD6K/CH0P4b9
hWV7vT2O+mHUn0B9BD6J+hHUn8L+o6g/jfxR5J9B/xgeD2dxHmOoP4f14ljv
PPqPI34B8QQePxPIn8R8F1GfxHyXkD+F/VxG/xT6XYGnkX8V66WRfw3xGcSv
o18G+TeQP4v4TdRncT9uIX8Oj8/bqM/h/O8gPg/fRf885r2H+ALi9zFvAf0f
4P4tot9D3M+iHHCvj7DeEvb3GOuXkP8E8WWs/xTzlhF/Bq9g3ufoX0H8Bfqv
Iv4S9VXkv8J+1uDXqK+h/g0eL+tY/y32V0e/d1hvA36P/AbW/4D7tYn8j3AT
/T/h8bOFfp+xXgv9vmB/29j/V6zXRv03eAf539HPeeCdZ9cDb7wL3g13y3a/
9iDeI+v1X9afH2L9fYj3on4/1vMjfgD1fZjnoKw/f8D6/agfQP4hOIj8w+g3
iPmOwCH4KDyE/sewfli27z/HUT8s2+PvBOIR9DsJjyD/FOaJyna+p+V+9zqK
9c+gX0y2+3kW64/B52Q73zjmOY95xlF/AesnEJ9A/STyL2K9JOa/BE/BlzF/
Cv2vID6Nea4inu7Y/bom6/Ne9L8u6/efIX4D/Wfhm6jPyvb4uyXr9R/1t7Fe
DvE7sv49CXwXzsu233uYb0G287+P9QqY5wHii4g/lPX5NNZ/hPol+DHmK6H/
E9l+n9My6p/CZaz/TLb9rsh6/Ud9BfEX6LeK+V4iXkX9K9n2twa/Rn4NfoP5
1uG3sn4fHuZ7h34bWP898huy3c8PiG/CH9G/ifgneEu28/qM+pZs+/mC+Db8
Ff3asn7+l/vd645sz8/vmM/5mbd+18+8+V0/8+bvlvXzP7wH7kG/vbJe/2Xb
3z6s1yvb+exH3I/4AcT7sN5BWb+/CPn9OI8B5B/CfoKy/f7Ew1hvEPVHcD4h
rH8U9UOIH8P6Ycx7HPXDyD+BfhHMdxLxEZzvKcSj2M9peBT39wzmiWH+s+g/
hvnOIR5H/Dz2P471L3TWc78S6DeBfpOY7yLiSfgS1puS+93rZZxnCr6C+mn0
v4rzTWP+a6ifQf519Msg/4YcdK+ziN+EszifW3g+zOF+3Mb6Ocx/B/nziN/F
+nmc3z14AY+3+7gfBczzAOe1iPUewkXkP4KXkP8Y85WQ/wTxZcz3FPEy+j+D
V1D/HOtVkP8C8VXUv8T9qSL/FfLX0P817mcN8Tfot479vkV+Heu9Q/4G7v97
PF4b6PcB3sTz4SPiTaz/CfEt7Ocz3MJ5fEG/bfgr+rex32+I7+D5+B3rOYt2
tfPZJevfA8i2/m7Z3p92w3tkm6cH/fbK/e7VJ+v1H+5F/n7M60f+AVmv/8g/
iHkCqO+X9fM/6g/Jdp5BzHcY/Qdle7wdwfmEMO9RnPcQ1j+G9cKY/zjyh5F/
AvNH4JOYdwTznMJ6Udz/04iPwmfQP4b+Z3EeY+h/Dvlx+Dw8jv1dwDwJzDOB
+kncz4uIJ9HvEjyF+svYX0o+7F6voH4aj5eruJ9pzHMNnsHj4TriGfmIe72B
eWdx/jcxTxb9b8FzmPc2+uUQv4PzmMc8d+E8fA/ntyCH3Ot9zF/A4+MB5l+U
7fv/Q/QvIv8R+i8h/zH2W0L+E6y3jPqnyC9j/WfyoHtdwXrP4QrO+wXiq3i8
vsT6VfgV5l9D/DXiNaz3BvF17O8tXMf9e4f1NrC/96hvIP5BPupeNzHfR7iJ
eT/h8b2F+GfM20K/L6jfxrxfUd9G/TfEdxD/jrjzX739d8m2/y7Z6nfD3bLt
bw/69ch2vnvln3OvPtn2u0+2x28v+u9HPz/qD8j2/awPPoj8APr3Y38DOI9D
mD+I+GFZr//ofwT7C8n2/ekozm9Itvt1DPVhrH8c5zOM/Z6AI1jvJPqNYL5T
mCeKfqdRP4r8M5gvJuvzf6w3hvt3DvE44uflY+51XP5F93oB55dA/QTu/yTm
vSj/vHtNov4SPIX1Lsth95rC4+MK8qcRvyofd69pnMc1nP8M+l3H+WSwvxvI
n8X9u4nHfxbr3YLnMP9txHM4zzuYZx75d5Gfl3/Bvd7D/AuI30d9AY/fBzjf
Rez3IfoVMd8j5C/hfj+Wh9xrCffvCbws/4p7fYr7V5Z/yb0+wzwreH49x/Oh
gn4v5B+411Wc10v0r2I/rzDPGvb/Gvur4bzeYJ51nPdbcybiXuvo/w7ewDzv
MW8Dz9cPiG/ivD7Kv+xem7LN8wn3awv9PqNfSz7hXr9gf9tY7yvOo41+31C/
g/v5Hf2ch975d8Fdst2P3bI9P7plO+898q+51x7Zzn+vOfOr7tWnuO1/nzzi
Xnsxz37088u2vwPqf9K99iluPijb+gHk92P+AcV/w70eUtwcVDzqXg8jf1D+
Tfd6RD7lXkPq9+vu9ah82r0OyTH3ekz1v+Vew/Koez0u2/zD5ojVn8C8Ecx7
Ev1GVG/rnTJXrF8U851W/Lfd66jqz7rXM7LFY6r/oXs9q/XPu9cx5cfd6zn1
/133GofPq9+4ex1Xv99zrxeUb/0Tilv/CdX/oXudVP4F93pR8/y+e00qPule
L5kTVj+l/hPu9bK58EfuNaV6y7+CftPmxkX3elXr/8i9ptXf4tcU/xP3OqP9
/Ni9Xle/pNWp3uI3lG/1s/Ifu9ebmu9P3WtW/abc6y31S7nXOXPMfNtc+jP3
mjOn/ty93jEHzPM6r6vu9a65Zs6rPu1e7+n8/9K9Lmj9v3Kv9zXvNetrzs24
1wda77p7XTS3M+71ofb/N+61aC7ecK+PzMm/da9L8qx7fWxO/517LanfTff6
xFz/qXtd1vpZ9/pU+eay2W+/1/2Z8s0rZv1e8+c6P/s90BWzfq/oC91v86pZ
v9fupVm/l6pq1u/JeGXW74FaM+v3MLxWvbmm87b/L/Ubs/4/wes6D/v/Vr41
6/8zWDfr/9v2zqz/j9aGWf/fhveKmxu6f+YPev7Yv5PbNOvf/X40698VN836
d46f1M/iW2b9u9zPZv07tpbOw9b/osev5W+b9f8l+ar9mNvY/zez/j+aOzo/
O9/vev7p/wP+39yrfq/SLrN+D1OXWb8Ha7dZv2e026zfw73H3LTHX485b4/X
vea4Pf596n/Dve4z5+z51muO2fNzvzlkz1+/ufUX7vWA2bniXvvkn7jXg+aI
fT8LaH77fttvDtj31wGzXi8Oqd5eT4KKj7nXw+aMvb4Nynr9l+31NqT57P3P
UdnePw7J9n7vmGzv98KyvX89Ltv76WH5kHs9Idv7+YhsP2+dRP6IbD+/nZLt
84KobD9vnUZ8VLafP85gvZhsn2+eRf6YrL//B8dRf17W5/+IX0A8Iduf90wg
fxL7vyjr7/+j3yXEp9DvMs4nhf5XEJ/G/bgq28/jaZznNfSbwXzX5X73mkH9
Daw3i/hN7CeL/rfgOax3G/c3h/O6g/7zuD93Zfvzmjzi9+CFTr77dR/xAuIP
4EX4IVyEH8FL8GO4BD+Bl+GncBl+Bq/Az+EK/AJehV/CVfgVvAa/xvnXEH8D
r8Nv4Tr8Dt6A38MN+AO8CX+Em/AneAv+DLfgL/A2/BVuw9/gHfg77BS93gV3
wbvhbngP3APvhX3wPrgX3g/74QOy/v4/4gfhANwPD8CH0D+I+GF4ED4Ch+Cj
6D+E+DE4DB+Hh+ETcAQ+CY/Ap+AofBoehc/AMez3LOJj8Dk4Dp+Hx+ELcAKe
gCfhi3ASvgRPYX+XEU/BV+Bp+Cr6pTtx93oN+TPwdTgD34Bn4ZtwFr4Fz8G3
4Rx8B57Hfu8inkf8HuILiN/HeRWQ/wD5i4g/hIvwI3gJ/R4jXoKfwMvwU7gM
P4NX4OeYp4L4C3gV5/US8Sr8Cv3XUP9a1r//Q/4b9FtH/C361ZH/Trb3kxuo
f494A/EP6Lcp2/vRj8hvYp5P6L+F+Ge4hX5fcD7bsr1f/irbzwdtzPcN6+/I
9n78O+z8d7va+/tdsv79n9zvXnfLNk+3bD8v7EG8R7afV/bK9vOiT7b97MP6
vYjvRz+/bPs9IOvf/yN+ULbzD8h2/v3wAPIPwUHkH+7E3a9B+Agcgo/CQ/Ax
OAwfh4fhE3AEPon9jCB+Co7Cp+FR+Awcg8/CY/A5zBdH/Dw8Dl+AE/AEPAlf
hJPwJXgKvoz5U4hfgafhq3AavgbPwNfhDHwDnoVvwln4FjwH34Zz8B14Hr4L
5+F78AJ8Hy7AD+BF+CFchB/BS/BjuAQ/gZfhp3AZfgavwM/hCvwCXoVfwlX4
FbwGv4Zr8Bt4HX4L1+F38Ab8Hm7AH+BN+CPchD/BW/BnuAV/gbfhr3Ab30++
Ib4Df4edR17vgrvg3XA3vAfugffCPngf3Avvh/3wAbgPPggH4H54AD4EB+HD
8CB8BA7BR+Eh+Bgcho937F6HET8h2+MlgvhJeAQ+BUfh0/Ao1jsDx+CzqB+D
zyE/jvh5xMcRvwAn4Al4Er4IJ+FL8BR8GU7hfl1BfFq2969XZf37P+z3Gupn
EL+O9TLodwPxWfgm8rPofwvzziF+G/U59L+D+edRfxfOw/fgBfg+XIAfYP1F
+CFcRP0jxJfgx3AJ9U8QX4afwmX4GbwCP4cr8At4FX4JV+FX8Br8Gq7Bb+B1
+C1ch9/BG/B7uAF/gDfhj3AT/gRvwZ/hFvwF3oa/wm34G7wDf4ed/+H1LrgL
3g13w3vgHngv7IP3wb3wftgPH4D74INwAO6HB+BDcBA+DA/CR+AQfBQego/B
Yfg4PAyfgCPwSXgEPgVH4dPwKHwGjsFn4TH4HByHz8Pj8AU4AU/Ak/BFOAlf
gqfgy3AKvgJPw1fhNHwNnoGvwxn4BjwL34Sz8C14Dr4N5+A78Dx8F87D9+AF
+D5cgB/Ai/BDuAg/gpfgx3AJfgIvw0/hMvwMXoGfwxX4BbwKv4Sr8Ct4DX4N
1+A38Dr8Fq7D7+AN+D3cgD/Am/BHuAl/grfgz3AL/gJvw1/hNvwN3oG/w86S
17vgLng33A3vgXvgvbAP3gf3wvthP3wA7oMPwgG4Hx6AD8FB+DA8CB+BQ/BR
eAg+Bofh4/AwfAKOwCfhEfgUHIVPw6PwGTgGn4XH4HNwHD4Pj8MX4AQ8AU/C
F+EkfAmegi/DKfgKPA1fhdPwNXgGvg5n4BvwLHwTzsK34Dn4NpyD78Dz8F04
D9+DF+D7cAF+AC/CD+Ei/Ahegh/DJfgJvAw/hcvwM3gFfg5X4BfwKvwSrsKv
4DX4NVyD38Dr8Fu4Dr+DN+D3cAP+AG/CH+Em/Anegj/DLfgLvA1/hdvwN3gH
/g47/9PrXXAXvBvuhvfAPfBe2Afvg3vh/bAfPgD3wQfhANwPD8CH4CB8GB6E
j8Ah+Cg8BB+Dw/BxeBg+AUfgk/AIfAqOwqfhUfgMHIPPwmPwOTgOn4fH4Qtw
Ap6AJ+GLcBK+BE/Bl+EUfAWehq/CafgaPANfhzPwDXgWvgln4VvwHHwbzsF3
4Hn4LpyH78EL8H24AD+AF+GHcBF+BC/Bj+ES/ARehp/CZfgZvAI/hyvwC3gV
fglX4VfwGvwarsFv4HX4LVyH38Eb8Hu4AX+AN+GPcBP+BG/Bn+EW/AXehr/C
bfgbvAN/h53HXu+S7c+juhDfDXfDe+AeeC/sg/fBvfB+2A8fgPvgg3AA7ocH
4ENwED4MD8JH4BB8FB6Cj8Fh+Dg8DJ+AI/BJeAQ+BUfh0/AofAaOwWfhMfgc
HIfPw+PwBTgBT8CT8EU4CV+Cp+DLcAq+Ak/DV+E0fA2ega/DGfgGPAvfhLPw
LXgO309uI56D78Dz8F04D9+DF+D7cAF+AC/CD+Ei/Ahegh/DJfgJvAw/hcvw
M3gFfg5X4BfwKvwSrsKv4DX4NVyD38Dr8Fu4Dr+DN+D3cAP+AG/CH+Em/Ane
gj/DLfgLvA1/hdvwN3gH/g47/8vrXXAXvBvuhvfAPfBe2Afvg3vh/bAfPgD3
wQfhANwPD8CH4CB8GB6Ej8Ah+Cg8BB+Dw/BxeBg+AUfgk/AIfAqOwqfhUfgM
HIPPwmPwOTgOn4fH4QtwAp6AJ+GLcBK+BE/Bl+EUfAWehq/CafgaPANfhzPw
DXgWvgln4VvwHHwbzsF34Hn4LpyH78EL8H24AD+AF+GHcBF+BC/Bj+ES/ARe
hp/CZfgZvAI/hyvwC3gVfglX4VfwGvwarsFv4HX4LVyH38Eb8Hu4AX+AN+GP
cBP+BG/Bn+EW/AXehr/CbfgbvAN//3/+378u8E0=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"Energie\\n(Kanal)\"", TraditionalForm], 
    FormBox["\"Ereignisse\\n(Anzahl)\"", TraditionalForm]},
  AxesOrigin->{2800., 0},
  AxesStyle->Arrowheads[0.03],
  Epilog->{FontSize -> 16, {
     RGBColor[1, 0, 0], 
     LineBox[{{2931, 0}, {2931, 3000}}]}, {
     RGBColor[0, 0, 1], 
     LineBox[{{2913, 972}, {2949, 972}}]}, 
    InsetBox[
     BoxData[
      FormBox["2931", TraditionalForm]], 
     NCache[{2931, 
       Rational[972, 5]}, {2931, 194.4}], BaseStyle -> RGBColor[1, 0, 0]], 
    InsetBox[
     BoxData[
      FormBox["72", TraditionalForm]], {2931, 845.2173913043479}, BaseStyle -> 
     RGBColor[0, 0, 1]], 
    InsetBox[
     BoxData[
      FormBox[
       FrameBox["\"Mylar F2\"", RoundingRadius -> 5, StripOnInput -> False], 
       TraditionalForm]], {2825, 1620.}, BaseStyle -> GrayLevel[0]]},
  ImageSize->600,
  PlotRange->{{2800, 3000}, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.550671018109375*^9, 3.5506970015625*^9, 3.5506974828125*^9, 
   3.5506975213125*^9, 3.55069758559375*^9, {3.550697628359375*^9, 
   3.5506976573125*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxt3X9ok39/7/ELKVKkSJAiRYrklCJBimSuc5nrvDPXeWfevV3mOk9u17nM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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"Energie\\n(Kanal)\"", TraditionalForm], 
    FormBox["\"Ereignisse\\n(Anzahl)\"", TraditionalForm]},
  AxesOrigin->{2600., 0},
  AxesStyle->Arrowheads[0.03],
  Epilog->{FontSize -> 16, {
     RGBColor[1, 0, 0], 
     LineBox[{{2788, 0}, {2788, 3000}}]}, {
     RGBColor[0, 0, 1], 
     LineBox[{{2760, 648}, {2805, 648}}]}, 
    InsetBox[
     BoxData[
      FormBox["2788", TraditionalForm]], 
     NCache[{2788, 
       Rational[648, 5]}, {2788, 129.6}], BaseStyle -> RGBColor[1, 0, 0]], 
    InsetBox[
     BoxData[
      FormBox["68", TraditionalForm]], {2788, 563.4782608695652}, BaseStyle -> 
     RGBColor[0, 0, 1]], 
    InsetBox[
     BoxData[
      FormBox[
       FrameBox["\"Mylar F3\"", RoundingRadius -> 5, StripOnInput -> False], 
       TraditionalForm]], 
     NCache[{
       Rational[5275, 2], 1080.}, {2637.5, 1080.}], BaseStyle -> 
     GrayLevel[0]]},
  ImageSize->600,
  PlotRange->{{2600, 2900}, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.550671018109375*^9, 3.5506970015625*^9, 3.5506974828125*^9, 
   3.5506975213125*^9, 3.55069758559375*^9, {3.550697628359375*^9, 
   3.550697657640625*^9}},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxt3X9ok39/7/ELKVKkSJAiRYrklCJBimSuc5nrXOY6l7nOZd6dd27Xuayn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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"Energie\\n(Kanal)\"", TraditionalForm], 
    FormBox["\"Ereignisse\\n(Anzahl)\"", TraditionalForm]},
  AxesOrigin->{2500., 0},
  AxesStyle->Arrowheads[0.03],
  Epilog->{FontSize -> 16, {
     RGBColor[1, 0, 0], 
     LineBox[{{2643, 0}, {2643, 3000}}]}, {
     RGBColor[0, 0, 1], 
     LineBox[{{2611, 527}, {2665, 527}}]}, 
    InsetBox[
     BoxData[
      FormBox["2643", TraditionalForm]], 
     NCache[{2643, 
       Rational[527, 5]}, {2643, 105.4}], BaseStyle -> RGBColor[1, 0, 0]], 
    InsetBox[
     BoxData[
      FormBox["88", TraditionalForm]], {2643, 458.26086956521743`}, BaseStyle -> 
     RGBColor[0, 0, 1]], 
    InsetBox[
     BoxData[
      FormBox[
       FrameBox["\"Mylar F4\"", RoundingRadius -> 5, StripOnInput -> False], 
       TraditionalForm]], 
     NCache[{
       Rational[5075, 2], 878.3333333333334}, {2537.5, 878.3333333333334}], 
     BaseStyle -> GrayLevel[0]]},
  ImageSize->600,
  PlotRange->{{2500, 2800}, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.550671018109375*^9, 3.5506970015625*^9, 3.5506974828125*^9, 
   3.5506975213125*^9, 3.55069758559375*^9, {3.550697628359375*^9, 
   3.550697657921875*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxt3X9o1W+8EPCDDBkiMmTI+DJkyZAhQ5YtW7a8J1u2zGyZ2a7tek+26122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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"Energie\\n(Kanal)\"", TraditionalForm], 
    FormBox["\"Ereignisse\\n(Anzahl)\"", TraditionalForm]},
  AxesOrigin->{600., 0},
  AxesStyle->Arrowheads[0.03],
  Epilog->{FontSize -> 16, {
     RGBColor[1, 0, 0], 
     LineBox[{{1034, 0}, {1034, 3000}}]}, {
     RGBColor[0, 0, 1], 
     LineBox[{{964, 249}, {1100, 249}}]}, 
    InsetBox[
     BoxData[
      FormBox["1034", TraditionalForm]], 
     NCache[{1034, 
       Rational[249, 5]}, {1034, 49.8}], BaseStyle -> RGBColor[1, 0, 0]], 
    InsetBox[
     BoxData[
      FormBox["264", TraditionalForm]], {1034, 216.5217391304348}, BaseStyle -> 
     RGBColor[0, 0, 1]], 
    InsetBox[
     BoxData[
      FormBox[
       FrameBox["\"Mylar D2F1\"", RoundingRadius -> 5, StripOnInput -> False],
        TraditionalForm]], {675, 415.}, BaseStyle -> GrayLevel[0]]},
  ImageSize->600,
  PlotRange->{{600, 1200}, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.550671018109375*^9, 3.5506970015625*^9, 3.5506974828125*^9, 
   3.5506975213125*^9, 3.55069758559375*^9, {3.550697628359375*^9, 
   3.550697658234375*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxt3X9oVP9+5/GDBAkSZJAgQYJMQ5BBgsy6qZ3a1Dv1pnZqc71Tb66d66Z2
rjfXztrUO7Wpd2pz3bM2a2dt1s66WTu1qZ26WXfqZu0gQQYJMkiQQYIMEmSQ
IIMEGSTIIEEGCbLLnvcry3my+efwuK/35/35Mb8T73d+6fzPTv90h/N/fgKO
83+v/9+f1nfwP0T97IQDcDfcA/fCQbgP7ocPwCH4IDwAH4LD8L+CD8P/Gh6E
fxk+Av8KHIF/FT4K/xo8BP86fAz+Dhz124Wd30AOO8eRw853kcPOMHLY+U3k
sHMCOez8FnLYiSGHnd9GDjsnkcPO75jtceXCzgjGjyD/HsZ/z1/vnEJ+Cvn3
zfa4db/vr3fifkdhV7afiqzngd/151FZ47dz71qBndOY/7Q/d+GKrPl/gPE/
8Ne727b1I3dGMX7Un7twZdv280OM/6E/d2VbbwW5cwbjz/hzF3kFufN7fkdh
F67Iuv0Tyr1rVLbnZRd5Rdb4H5ltf1FZ8//IX1+BnbN+R2WdP1yBnX+D8bLu
73AF9c6Yv18UduGKrPG/j/Gwu23vpyJr/DmMP+fPXVnrR+78AcbL9jrswpXt
evtJ+vsH4ahs45Oyva67cAH1Fdle9xvo7/zYrvY+Ivhjfx5FnpQ1P/ICXJE1
v6z3Keftavf3oKzzlG09SVm3D/ICXJFtPQ3kzk/86wnKtr/oT/z1SdiVtX/Z
9lNBfUPW42fcrnY+QVnzy5pf1v5lW39B1vnLtp4G6p2f+vsHZVtPVLb1JmXr
78rWvyDb+8aKbPtpoL9zwV8flG19UVn7lzU/6guyzVeRdf/DeOcP/fVBWfPD
SdiV7XwKyCuy7n+y9p/C/LKdRzTlr0/Kml+29+EFuc/ml+19eQP9nH/r7xeU
7faMyra+JOpd2foVZPucUJFtPw3UOxf98wUv+vOobP2SsvVz4YKs+z/yBvo5
f4T55T6bH3lS1v5l+9xRkG39FYxvyPpcNWFX3f6yrS+KPCnb7e3CBbgi2+ew
Buz8sV3t/hGUNb/cZ/PDrqzzlzU/+jVkfe67ZFf7nBeU9fwnW/+kbOt1Zftc
WZDtc2FF1v4xn/Mz//jgz/z1UdnWm0Tuyra/gtxn86N/A/2ctF3tvAJwULbx
Ydn2H5Xt/hVHfVK280jLevzIdv/Nyba+AsaXUF/Bemuybm/ZPte3sD7nT/zr
Cch6PpLtvMOyfa6PYnxc1vOFbI/HtKz7j2zrz6G+INv9pYT5Kshrsu23Abcw
v3PZrnbeAVmvh7Juf1n3T1m3v9znXZMYn0Z/V7b95mTdn2XtX9bjG+Nr6N/A
/C3Y+VN//4Bs6w/K1j8s2/iobOuNy3a+SdSnZe0f9Tm4AJdkO/+KrPu/bL+n
amB8C/M7k3bt864BWY9/2e4fYeRR2frHZVtfUrb7R1q283JlO58cXMB8JVn3
f9nu3zXUNzB/C/XOn/n7BeQ+7xpEHkYele3+EZf1/Cfb+aQx3pVtfTlZr6ey
nX8J81Uwvibr+U+257MW7FzxrydwxZ8HZesfhqOy7v+y3i/Idn9MY7wr2/nm
kBeQl2S9v0J9DftpyLr/I3d+7l9v4Of+PCjb/sKy9o/6OPKkbPe3tGy3nyvb
+/ecrMc/1leS9f4eeQ39G7KdVwv1TsZfH8j464OyzRdGHkUeh5OoT8Mu5s/J
+jyDfiVZn69ku3/U5D7v2pDt81tL1vvvP/f3C8g2f1C29YZl3f6y9Y/DSdnW
n8Z8LvrnZFt/AfUl9KvANYxvwC3sz7nqnz8AB2UbH5b1+VTW/mX7/UBStvWn
YVfW7Y+8gPlKqK/Ievwjb6BfC3b+wu+ArM9jsh7/sl7/ZT3/y/q8IPd517Ss
9+/Ic7J+n4D1lLDeimznX5P1eR/9W1ifM2VX219gyp8HZd3/Zd3/4bis9z+y
3v+inyvbfnOyrbeA8SXMV0Few/iGrNsf9c4v/PMH4OAv/PVhWb8fQR7H+CSc
lnX/l/X4l/X7RNSX4Arqa8gbcAt2rvnXH5B1/5ft8RyW+7xrVLZ+cYxPyra+
NOZz4RzGF5CX4Iqs5z+sp4F+LdQ7/87vAByEw7J+Py3b82kcTsp2f0mjnwvn
ZD3/yXr8o76C+WrIG1hvS9bvH11/fScckK1/j6zf18p2e4QwPozxEeRR2fYb
Q784xidQn0S/FNaXRp6R9f4TeRZ5DvPn4QLGF7G+EvIy8gpcle32qSGvI2/g
vJrIW8jbOB/n3/vdKev2h3tkez4IynZeIdnOJyzbeiIYH8X8MdTHMX8C9UnU
pzB/GnkG/VzZzicr23nnUJ9HvwLGF5GXML4MV1BfRV7DfuvIGzj/Jvbfgtvo
51z3u1PW+yFZj39Zz4+yrT+E+jDyCBxFvxjmj8MJjE/Kdn9KoT6N9WQwnyvb
/rPon0O/PPICxhdlPV8jL2N8BeurwjXZ9lfH+Ibc512byFuy7beN3PlLf94p
2/wB2dbfI+vzgWyvbyHZziuM+gj6RTFfDOuJI0/ASfRLwWk4A7vol5X1fgR5
Hi7IdvsUkZfgMs6jgryK9dXgOuZrIG+iXwt5G+frTPvX0wkHZLs9e2S9/svW
LyTr8Y9+EVnP/+gfw/g45ktgfBL1KTiN/hmMd5FnMV8OzsMFWc//2G8J6ylj
fAX11e1676eG8XW4gf00kbcwXxu58x/8eaes2x/ukfX6L1u/EPIw8gjyKPrH
tuu9n7hs55vAepOy3X4p5Gn0z8Au6rNwDvV5WZ/Psb8i1lPCfsvoX4Gr6FfD
fHWsp4HxTdS3kLcx3rnhn6/zhj8PIO+R9fhHHpL1/C/b/iPoH8X4GPrHMT6B
+iT6pbZz7yct2/0ng/W56J9F/5ys939YXwH1RbiE9ZUxXwX9qpivhn519Gsg
b8ItuI3zcf7KP3+nbOsL/JW/vmfb3jWI+pCs3xfJdt4R5FGMj8FxzJfAepLo
l0J9Gs5gvAtncR45jM/DBcxfxPgSXJb1/h/9qlhPDXkdeQP9m3AL49uwk/Wv
pxMOyHZ79Mi6/bft/YSQh2VbT0TW7Y/xMdTH0S+BPInxKaw3DWfQz8V6suiX
w3x5uID+RbiE+croX0F9Ff1ryOsY30D/Jm6/Fsa3Md75j/7xnXBA1vt/Wa//
yEMYH9629xOBo6iPyXr/jzyB+ZLIU8jTyDNYv4v6LJzD+DzGF+Ai9lfC+DLq
K5ivivoa6uuob6C+iflbGN9GvXPT7044APfIuv2Rh2RbXxj1ETgKxzA+vt3f
+0nI+vyP+hSclvX7P/RzUZ+Fcxifx3oLcBEuwWX0ryCvwjWcbx15A26ifwt5
G/2cv5ZtmGzjA3/tr+9BHpT1+g+HMT4CR9EvJuvxDycwPon5UthPGvUZ1LvI
s8hzcF7W7+eRF9GvhLyM9VVQX0V9DedTR95AvybyFtyGnRn//J2ybv8Zf30P
8uD2eO8nBIfRPwJH4Rj6x9EvgTwJp2T9ewOMz2A/LpxFfQ55HustwEWspwSX
UV/BfFXU1zB/HfUNuIn+LZxHG7nzn/z9O+GAbD892/auQVmv/7Le/6M+gv5R
jI8hjyNPoH8STqE+jfkzsAtnMX8OzuM8ChhfxHpKqC8jr2B8Fa5hfB1uYH1N
uIV+bdi55XenrNt/O/d+elAflHX7Iw+jXwR5FI7BcfRPIE/CKcyXRp6BXdRn
keeQ5+EC6otwCedXxvgK6qvYbw3j67I+/8v2+thEfQv92sidv/HnnX/jzwPb
9q49qA/Kev1HfRj1EfSPwjHUx+EE6pOYLwWnsb4M7MJZ9M+hXx7rKcj6/S/6
leCyrMc/+lVRX5P191+sp4F+TYxvwW3YyfndIev5AO6CA9v2frqR98C9mC8o
2/r7kYcwfkDW7xdRPyjr/obxQ8ijyIeRx+AR7DcOj2I9CfQfw36TqB9HnkI+
gfWkkU8izyCfwnpd5NMYn0X9DJzDemfRL4/9z6F/Af3m4SLqF9CvhPpF5GWM
X0J9BV6Gq+i3Iuv3s+i/ivo6zmcNbuC81jG+CW9gfS14E/Vt9N/C/M5/9td3
yHo9gLtkvT/A+O5tez89GN+L+iDyfowPybbeAdSH0W8Q9RGsdwiOwsOYP4b+
I3Ac9aNwAusdw/gkPI76FPIJrDcNT2L+DPIp9HNRPw1nUT8D5+BZOI/9zGE9
BdTPIy8iX8DtW0L/RdSX4SXsr4L5luEqxq/ANdSvon8dXsP4BvJ19GvCG9hv
C/kmzqeN+i3UO7f9ecdtf96JvEvW6z/qu2X9vRh57/Z47yeI/v3oH4IHMD6M
fBDzReAhOIr5h9E/Bo9gfBzjR+EE1jcGJ+FxzJeCJzB/Gvkk+mXgKYx34Wn0
y2L8DOpzyGex/zzyOYwvwPMYX4QXZP3/AXB/W8R8ZXgJrmC/y8ir6L+C+hrq
V+E61r+GvAGvo38T+QbcwvltYnwb+RZy57/48w5Zr/+y7b9Ltp8Axndv5961
B3kv+gdR34/+IeQDcBj9B+EIPARH4WH0j8EjWF8c40fhBOrHcJ5J5ONwCuc1
gTyNfpPIMxg/hfW5yKex3yz6z6A+h/lm0T8Pz8EFjJ+X9e+pkS9g/hLWuwiX
4SWMryBfxvqqmH8FeQ3ns4q8Dq9hvgb6ryNvov8G8hb6b2J/beRbsDPr79ch
6/GPvEvW+//t3PvpRt4D98JBWZ//MV8I6xnA+DA8iPVEkA/BUXgY88WQj2B9
ceSjGJ/AesZQn0S/ceQp9JtAvzTqJ3GeGXgK/Vx4Gs6i/wzWm0P9LNaXx/xz
6FeA59G/iHwBeQnzLSIvY/wS8grWv4y8ivErcE2256tV5HV4Df0byNfhJs5v
A/ttod8m8jb6bcHOf/XXd8Cd2/auXbIe/6jvRn0P3Cvr9V+28+tHvxDmG5D1
9yX0G0R9BB5C/yjyYaw3hnwEeRzzj6I+AY9h/UmsZxxOof8E5k8jn8R8GfSb
gl2Mn4azqJ/B/Dnks9hfHp5DfQH95uEixi9gfAlehMsYv4T9VTDfMsZXcZ4r
GF9D/Srq66hfgxtY3zryJryB+VqYbxP1bexvC+OdO/76DtnW0ylb/y5Zn//h
7m17Pz3o34s8iPH9mC+E+gHUh1E/iPkiGD+E8VHkwxgfQ/0IHMf8o3ACHkP/
JOYfR30KnoDTGD+JPANP4fZ1sZ5p1Gex3xmMz6F+FvV59J9DfQH188iL8AJc
Qv9F9CvDS3AF/ZbhKvqv4Lxr6Lcq69/ry/b3qjX0a8DrON8m1rOB+hbWs4n1
tOEt9Hf+1j++A+7ctnftQh5A3g33oL5X1us/6vtlW19I1us/HMb4QcwXQf0Q
8ijmG0a/GMaPwHF4FOMT8BjmSyIfR78UPIH6NDyJ+gz2O4V6F55GfRb9ZlCf
g2dRn0e/ObiA+nm4CC/g/lOCF7GeMsYvYf4KvIx+VfRbQX0NXoXruL3XkDfQ
fx1uYv0byFvIN5G34S3YyfvHd+T9eSfchfoA8m7kPch7t+39BJH3wyF4AP3D
sj3fDsr27zEiGD+E8VHkw8hj8Agcx/yj2F8C9WPIk5h/XNbf/+AJjE+j/yTq
M/AU5nPRbxr1WeQzmC8Hz2J8Hp7DeRWQz6NfEetdQH0JXkR9Gf2WUF9Bvizb
47WKfisYX8P4VdTXka/hPBvwOsY34Q3Ut5BvIm8j38J6nL/zu+Pv/PWdcBfq
A7KdR/d2vffTI9t59qI+iP79sv7/xJhvAA6j3yD6RbCeIeRR9BvG/DHkI5gv
jnwUTqB+DOtJIh/H+BQ8Aaexn0k4g/5TuD1c9JtGfRb5DPrnUD+L+jzq55AX
sJ559CvCC+hXwnkuon8Z+RLGV+Bl1FfRbwX1NdSvYj911K+hvoF8HXkT98cN
2V7fWhi/Cbdxfluwc9e/3g7Z9tsJd8k2PoC8W7afHrhX1n8/BOP7t+u9awj5
ANYbRj6I/hHMP4T6KOYbhmPY7wgcl4PedRT9E/AY+ifhcTiF9U+gXxr5JPIM
PIX1u5hvGs7iPGeQ5+BZOA/PYT0F2T4fz6O+iPoFuAQvYn9l9FuCK/AyxlfR
fwXnXUO+CtdRvwY3cH9ex3qaWM8G8hbm24TbmG8L/Zy/99d3/L0/70TeBQdk
vf+He9CvFw5u13s//bI+/2O+ATiM+QYxPoL5huAo+g2jXwz5CNYbR/0o5k8g
H8P8SdSPoz6F+SaQp7G+SdRn0H8K9S76TSPPIp9B/xw8i/o85p9DXsB887L+
/o/zWkB9Cf0X0b+MfkvoV0H9MvIqvIL91jB+FXkd868hb2A/63AT/TeQt7C+
TfRvw1uwM+fv3zHnzzvhLtQHZL3/l/X5H+N7UR9EfT/6h5APYHwY9YPIIxg/
hPVEkQ9jfAz1I7Ld3+LIR9EvgfWNwUnUj2P+FPIJ5Gn0m4QzWN8UxrvwNMZn
kc8gzyGfxXrzOK85rKeA+nnkRcy3gPlKyBfhMvovIa/I9vhcRv8qxq8gr2F/
q6ivw2sY30C+jrwJb8AtrH8TeRv73YKdf5C9nw64c9vetQsOwN2yHv9wr6zH
P8b3wyGsZ0DWf18U/QZlvf5j/BDWE8X4YcwfQ/0IHEf9KPIE+o/BSax3HONT
8ATmS2N/k+ifQf0U7MLTmC+L/jPIcxg/i/nz8Bz6FTB+HrdvEfMtoL6E/osY
X0b9ElyBl9GvivWu4PaqYfwq5q/L+vsf6hvwOuZvYr4NrKeF89mE21jPFuzc
88/fAXfCXbI+/8Pdsv79v6zHP+qDcP/2fN5PCPMPoD6M/oPII1jPEPpFZTuP
YYyPoX4EeRz9R+EE1jeG+ZLoNw6ncB4T6JdGv0msNwNPob+LfFrWfw8X+Qyc
Q/0s1peH53A+BfSbR78i1ruA/ZaQL8JlzL8EV+BlrK+K81/BemuoX8X8deRr
GN9A/bpszxdNrG8D/VrIN5G3Md8Wcucf/eM7/tGfd8p6/G/bylDfLdt+euBe
1AfRvx8OYb4BrDeM+kE4gvFDWE9U1uMf42OoH0Eeh0exvwTyMawniXwc41Oy
PR4mUJ/G+icxPoP6KZyfi3wa+83CM3BOtvvrLPI81jMHFzB+HnkRXsD6S1j/
IurLWM8S6ivot4y8Cq+gfw39V+E6vIZ+DXgdbmK+DeQtnN8m9tNGvoXxTkH2
fnbIej6Ad8p6fkC+C+6Sbf+7kQdku//uQf9ujN8r679HjPp92/vxrr3ovx/1
QeR9WF8/5juA/iHkB9FvAPWH4DD2dxj9BpEfQR5BfhTrH4KPYf4ozuM4+g1j
Pydkez6KIT+J9Y2g3ynMH5ftvx9+Gv1Gsb4z6JfA/s5ifWOY7xz6JdHvPDyO
/VxAvxR8EeuZQH4J/dPofxn5JNZ7Bf0yqL8KT+E8r6Gfi/rrqJ/Gfm6gPgvf
RP0M1nsL+81hPbcxfhbruYPxeYy/i/XMYfw95AWMv4/6eeQPsJ8i+j2EFzD+
EVyCH+P+u4j1PEF9GX6K+iX4GeorOM/nqF9G/gL7q+L2eon+K/ArnF9N7vOu
r9F/FX6DfnXZvr/qLda7hvHvMH8Dfi8Hves69vcB59PEej6i3wbyTxjfQv4Z
3sT94QvyNs7vK/a/hfP5hvmdf/L32yHbT4dsz887ZVtPp2znu0u2/l0Yv1vW
6z/G74G74b2Yvwfet71+79qL8fuxviD23yfb7d+P+gOoDyE/iHxA7vOuh5CH
Zbt9Dst6/cf+jiCPYL1HsZ4hzHcM/aI4r+OoH0a/Exgfw3pOon4E9adQH8f9
4zT2MyqHvOsZ9EvAZ+Ex2b6P7hzmT2K/5+Fx3H4XcH9Kod9FeAL1l3A+aaz3
MuonkV/BejKY7yrWPwVfw3gX53sd801j/A2sP4v8JtYzg/v3LewvB9/G88Ms
8juYP4/6u5h/Dveve1hvAf3uI59H/gDnV8R5PUS+gPGPsL4S6h/j/r+I8U8w
voz5nyJfwvhnOI8K9vsc/ZbhF+hXxfPHS8y/gv29Ql5D/9dY3yrq36BfHef1
FuPXsN53mK+B/u9Rv47njw/o35Tt+zw/4v66gfv/JzzeWuj3WQ57103s7wvm
a2P9X3E+W5jvG3Lnvn99O2Tr1yHb/nfKev3H+F2yXv9lff5Hv4Bs69uD+btl
O5+9sv6+INv57JP7vGsv1rsf6wtiPX2o74cPyLbfEPodxHoG0P+QbPsNo/4w
1j8IH8F6IrJ9v/ZR5EPIj2G+qGz7OS7beQ9j/hPoF5Pt+3BPyra/Ednur6cw
Xxz5acw/ivozqE9gfWexnjHZ7k/n4KRsj7fzGD8u2/d3X0Cegi/Kh73rhGzn
fUke9K5p+Ze962XZ9jcp23lfwXozsp3PVdlu/ynZ7n/XYFfW67/c512nZdvf
DawvC99E/xnkt2R93zv635bt/GZl2+8d1OflX/Oud2Xbzxzmvycf8a4F+Ve8
6330n8f8D2Q776Js+30o2/1lQbb9PMJ6SnLEuz6W7f6xKB/1rk+wvjLW/xTj
lzD/M9nuTxX5mHd9jn7Lsp3XC9nOuyrb/fcl5l+Rf9W7vsL4Gvq/lu38VrGe
N2b3N7xrXfmve9e3yqPedU0+7l3fqd7yhvLf9K7vka9j/Ad52Ls2VW/+KFv9
hup/y7t+wnwt1Vv+Wbb9bar+u971i/Lf8a5t9P+K9W7JVv8N9c5/8/ffYXZO
eNcO5TZ+p/Lf9q6dyHcpt/5d5mjcu+5W/Yh3DajevEeOeddu+bR33Yt+Pepn
3qf673vXXuWj3nU/xgeV/6537dN4c7+5csa7HsB6Qupn+UH597zrgGz1hzTe
6sPyD73rYc33I+86qNx8RP597xqRk971KOYfMid/7F2PKf8Du2r8mHc9rvM4
612HMd8J+Zx3jane+p2UbT0jms98SuNtPXFz4Sfe9bR83ruOmhuWn9F+fupd
E6o3n1We8q5jWs8fetdz5qA5qf4XvOt55TZ+XOPNF9R/wrumlF/0rhe1X/OE
1vfH3vWSbt+0d00jv6z5LZ9U/5951yvm3J9414w5YPVXdb6WT5nD5mvyZeur
/Ziva/yfetdpc8t8Q+f1Z941K1t+U/uZ9K4zOg+rv2Wu/dz2Ad82pzPeddZc
Mt/R+s157f/Pvetdnc9feNc5re+qd72n+ilbp/pbfl/9LZ9Xbn6g28e+R76o
fr/wrg+1fssXdJ42/pHOx+pLOn/7XvbH6u9610Wzvtf7ifqZy2Z9L/tT7df6
LZn1veTPzPqe64p83bs+N+t7gpdlG/9C+/tL71rVeZtfmvU9zytmfa/tK7O+
17Vm1vfivtZ6zaua3/xG+zXXtX7r91bna17TePvey3c6H8sbOm/r996s79ld
N+t7MT/o8WB5U/3MH7Uem2/DrO+t/WTW98i2tH/zZ81n/Tb1+DF/0f3T+rex
n6/aj3lLt5f5G/o5895V37u9w6zv7e0w63uwd5r1vdedyq3fLrO+h7zLrNt7
t1nfOx0w63uz95j1ve3dqrd8r1nfM99j1vfQ7zPre9V7tV67/+43p8xB5Vbf
Zw7Y46ffHLH6A1qP5SHNb883B9XP8gGdpz0fHDJHrV9Y52fPP4eVmwfNNXt+
O6LcHNF52fxHVW/Pj0Nanz0fH9N67Pk2qvVaflz19nw9rP1avxOaz/KYuWTP
/yd1/vZ6M6J68ymdrzmu/ubT5pZ51Oza6+0Z7f+Sd01ovPms1v9H3nVM69Hr
v7lhr89J9bf68+pv9eOyvT+4oHpzSudn708uan57PzKh8ZZfUm5Oaz32/uiy
+p/3rpNav70/u6J+9n4rI9v7savwlMbb+8drsKv57P3xdYyflu396g2Nt/ez
WeU2/iY8o/4/8K63dHt9z7vmZPv8cFu29++zqL8j2+eDvGyfV+5qvu961znl
9nnlnnzcuxZUb5/f7sv2+Wte9eYH6FeU7fPrQ4xfUD7kXR/J9nm7JOvzv2y/
T1iUv+Ndn8j2ebss6/O/bJ/3l2T7/cUz2X5/UJHt9xnP5T7vuox+L2T7/UVV
tt9vvUS+Itvve16hfw3zv5bt93OrGP9G1t//Mf9b5Guy/v4v6/f/8HvUr8v2
940Psv7/efBHzL+B9X/C/lqo/4z5N+EvWE8b/or6Lazv23a9/fx3f74D7pBt
fTtl/f+D4V2y/XQh341+Acy3B+O7ke/dzr1rD+r3Ie9Fvh8OYn19mK8fPoDx
IYw/iPoB+BAchg/Dg/ARzB9BfhT5EHwM9VHkx+Fh1J9AHoNP4vxHMP4U6uPw
aZznKPIzcALznUU+hvnPIU8iPw+Po/4C8hTyi/AEfAlOo99l7GcSvoLxGeRX
kU/B12AX819HPo38BvIsfBOegW/BOfS/jXwWvgPnMf4uPIf6e3ABvo/x88gf
IC8ifwgvwI/gEvwYXoSfwGX4KbyE9T5DXoGfo34Z+Qu4ivqXyFfgV3ANfg2v
wm/gOvwW61lD/g55A/l75OvIP+Dx1kT+Ed5Av09wC/Wf4U3Uf4HbqP8Kb8Hf
MN554M93PPDnHfBO1HfCu+AueDccgPfA3fBeuAfeB/di/fuRB+E+uB8+AIfg
g5hvAPkh5GH4MDyI8UeQR+CjqB+Cj8FR+Dg8DJ+AY/BJrGcE+alte9c48tPw
KHwGTsBnMf8Y8nNwEj4Pj2O9F5Cn4IvwBHwJTsOX4Uns5wryDHwV9VPIr8Eu
fB2eRr8byLPIb8Iz8C2Mz8G34Vn4DpxH/7vwHHwPLqDffXgefoDxReQP4QXU
P0Jegh/j/raI/Alchp9iviX4GVyBn6PfMvwCrmL8S+QryF9hfzXUv4ZX4Tdw
HX4Lr8HvMH8D+Xusdx35B7gJf4Q34E/o30L+Gd5E/Re4DX/F+C3k35A7/8Pv
HXAHvBPuhHfBXfBuOADv2bZ37Ua+F+6RbX/7kPfC++Eg3If5+9H/AOpD8EF4
AOMPIQ/Dh+FBjD+CPAIfRf0Q8mNwFD4OD8Mn4Bh8Eh6BT8FxrPc08lHkZ5An
cHudRf0Y6s/BSfg8PA5fgFPwRcw/gfwS8jTyy8gnkV9BnkF+FZ5C/TXkLnwd
9dPIb8BZ+CbGzyC/Befg2/As+t1BnofvwnO4f9xDXoDvw/PwA7gIP4QX4Edw
Cft7jHwRfgKX4afwEvwMrsDP4WWs7wXyKvwSXoFfwTX4NbwKv4Hr8Ft4Det/
h7wBv4fX4Q9wE/4Ib2D+T8hb8Gd4E/4Ct+Gv8Bb8DXaKfu/YtnftQL4T7oR3
wV3wbjgA74G74b1wD7wP7oX3w0G4D+6HD8Ah2W7fg8gH4ENwGD4MD8JH4Ah8
FB6Cj8FR+Dg8DJ/AfmPIT8Ij8Ck4Dp9G/1HkZ+AE6s8iH4PPoT6J/Dw8jvoL
yFPwRXgCvgSn4cuYbxL5FeQZ5FfhKfga7MLX4Wn4BpyFb8Iz8C04B9+GZ+E7
cB6+C8/B9+ACfB+ehx/ARfghvIDb6xHyEvLHyBfhJ3AZfop+S8ifwRXUP0e+
DL9AfRX5S3gFfgXX4NfwKuZ7g7wOv0X9GvJ3cAP175Gvwx9Q35Tt75UfkW9g
/Ce4BX+GN/F6/AV5G/N/xfxb8Df0c/7Z32/HP/vzDlm//0d9J+p3wV3wbjgg
278H2CPbfrox/17Z/v92Pajfh/pe9N8PB1Hfh3798AE4BB9E/wHkh5CHMf9h
eBD7PYJ+EZznUeRDmO8Ybr8ofBwexnpOII/BJ+ER+BQch0/Do/AZOAGfhcfg
c3AS+zuPfBy+AKfgi/AEfAlOw5fhSfgKnIGvwlPwNdiFr8PT8A04C9+EZ+Bb
cA6+Dc/Cd+A8fBeeg+/BBfg+PA8/gIvwQ3gBfgSX4MfwIvwELsNP4SX4GVyB
n8PL8Au4Cr+EV+BXcA1+Da/Cb+A6/BZeg9/BDfg9vA5/gJvwR3gD/gS34M/w
JvwFbsNf4S34G+w89HsH3AHvhDvhXXAXvBsOwHvgbngv3APvg3vh/XAQ7oP7
4QNwCD4ID8CH4DB8GB6Ej8AR+Cg8BB+Do/BxeBg+Acfgk/AIfAqOw6fhUfgM
nIDPwmPwOTgJn4fH4QtwCr4IT8CX4DR8GZ6Er8AZ+Co8BV+DXfg6PA3fgLPw
TXgGvgXn4NvwLHwHzsN34Tn4HlyA78Pz8AO4CD+EF+BHcAl+DC/CT+Ay/BRe
gp/BFfg5vAy/gKvwS3gFfgXX4NfwKvwGrsNv4TX4HdyA38Pr8Ae4CX+EN+BP
cAv+DG/CX+A2/BXegr/Bzv/0ewfcAe+EO+FdcBe8Gw7Ae+BueC/cA++De+H9
cBDug/vhA3AIPggPwIfgMHwYHoSPwBH4KDwEH4Oj8HF4GD4Bx+CT8Ah8Co7D
p+FR+AycgM/CY/A5OAmfh8fhC3AKvghPwJfgNHwZnoSvwBn4KjwFX4Nd+Do8
Dd+As/BNeAa+Befg2/AsfAfOw3fhOfgeXIDvw/PwA7gIP4QX4EdwCX4ML8JP
4DL8FF6Cn8EV+Dm8DL+Aq/BLeAV+Bdfg1/Aq/Aauw2/hNfgd3IDfw+vwB7gJ
f4Q3ZP39H3kL/gxvwl/gNvwV3oK/wc6C3zvgDngn3Anvgrvg3XAA3gN3w3vh
Hngf3Avvh4NwH9wPH4BD8EF4AD4Eh+HD8CB8BI7AR+Eh+BgchY/Dw/AJOAaf
hEfgU3AcPg2PwmfgBHwWHoPPwUn4PDwOX4BT8EV4Ar4Ep+HL8KSsf/+PPANf
hafga+jnIr8OT8M34Cx8E56Bb8E5+DY8C9+B8/BdeA6+Bxfg+/A8/AAuwg/h
BfgRXIIfw4vwE7gMP4WX4GdwBX4OL8Mv4Cr8El6BX8E1+DW8Cr+B6/BbeA1+
Bzfg9/A6/AFuwh/hDfgT3II/w5vwF7gNf4W34G+w87/83gF3wDvhTngX3AXv
hgPwHrgb3gv3wPvgXng/HIT74H74AByCD8ID8CE4DB+GB+EjcAQ+Cg/Bx+Ao
fBwehk/AMfgkPAKfguPwaXgUPgMn4LPwGHwOTsLn4XH4ApyCL8IT8CU4DV+G
J+ErcAa+Ck/B12AXvg5PwzfgLHwTnoFvwTn4NjwL34Hz8F14Dr4HF+D78Dz8
AC7CD+EF+BFcgh/Di/ATuAw/hZfgZ3AFfg4vwy/gKvwSXoFfwTX4NbwKv4Hr
8Ft4DX4HN+D38Dr8AW7CH+EN+BPcgj/Dm/AXuA1/hbfgb7DzyO8dcAe8E+6E
d8Fd8G44AO+Bu+G9cA+8D+6F98NBuA/uhw/AIfggPAAfgsPwYXgQPgJH4KPw
EHwMjsLH4WH4BByDT8Ij8Ck4Dp+GR+EzcAI+C4/B5+AkfB4ehy/AKfgiPAFf
gtPwZXgSvgJn4KvwFHwNduHr8DR8A87CN+EZ+Bacg2/Ds/AdOA/fhefge3AB
vg/Pww/gIvwQXoAfwSX4MbwIP4HL8FN4CX4GV+Dnsv77P/AL1Ffhl/AK/Aqu
wa/hVfgNXIffwmvwO7gBv4fX4Q9wE/4Ib8Cf4Bb8Gd6Ev8Bt+Cu8BX+DnX/x
ewfcAe+EO+FdcBe8Gw7Ae+BueC/cA++De+H9cBDug/vhA3AIPggPwIfgMHwY
HoSPwBH4KDwEH4Oj8HF4GD4Bx+CT8Ah8Co7Dp+FR+AycgM/CY/A5OAmfh8fh
C3AKvghPwJfgNHwZnoSvwBn4KjwFX4Nd+Do8Dd+As/BNeAa+Befg2/AsfAfO
w3fhOfgeXIDvw/PwA7gIP4QX4EdwCX4ML8JP4DL8FF6Cn8EV+Dm8DL+Aq/BL
eAV+Bdfg1/Aq/Aauw2/hNfgd3IDfw+vwB7gJf4Q34E9wC/4Mb8Jf4Db8Fd6C
v/0//2+frtDb
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"Energie\\n(Kanal)\"", TraditionalForm], 
    FormBox["\"Ereignisse\\n(Anzahl)\"", TraditionalForm]},
  AxesOrigin->{2300., 0},
  AxesStyle->Arrowheads[0.03],
  Epilog->{FontSize -> 16, {
     RGBColor[1, 0, 0], 
     LineBox[{{2547, 0}, {2547, 3000}}]}, {
     RGBColor[0, 0, 1], 
     LineBox[{{2500, 343}, {2596, 343}}]}, 
    InsetBox[
     BoxData[
      FormBox["2547", TraditionalForm]], 
     NCache[{2547, 
       Rational[343, 5]}, {2547, 68.6}], BaseStyle -> RGBColor[1, 0, 0]], 
    InsetBox[
     BoxData[
      FormBox["196", TraditionalForm]], {2547, 298.26086956521743`}, 
     BaseStyle -> RGBColor[0, 0, 1]], 
    InsetBox[
     BoxData[
      FormBox[
       FrameBox["\"Aluminium\"", RoundingRadius -> 5, StripOnInput -> False], 
       TraditionalForm]], {2350, 571.6666666666667}, BaseStyle -> 
     GrayLevel[0]]},
  ImageSize->600,
  PlotRange->{{2300, 2700}, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.550671018109375*^9, 3.5506970015625*^9, 
  3.5506974828125*^9, 3.5506975213125*^9, 3.55069758559375*^9, 
  3.550697628359375*^9, 3.5506976585*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"datplot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"leer", ",", "testexport"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2700"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3120", ",", "3250"}], "}"}], ",", 
   "\"\<Messung\\nohne Folie\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.550599214609375*^9, 3.55059938065625*^9}}],

Cell[BoxData[
 RowBox[{" ", 
  GraphicsBox[{{{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxt3X9o1e17H/CDyEMQkfAgD+FB5EyCBAmS2symNrWn1trMZja1qU1dZk9t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       "]]}, 
     {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJxt3X9o1ft/H/CDiAQRCRIkSLicSZAgQVKb2cym9tRmNrWpy2xqU5vZU5va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       "]]}}, {
     {Hue[0.67, 0.6, 0.6], Thickness[0.00201836636368156], StrokeForm[
      RGBColor[0.843137, 0, 0]], EdgeForm[RGBColor[0., 0., 0.]], EdgeForm[
      None], LineBox[{{3217.165600503533, 2835.2994585653487`}, {
       3217.165600503533, -4.19056379961058}}]}, 
     {Hue[0.67, 0.6, 0.6], Thickness[0.00201836636368156], StrokeForm[
      RGBColor[0.843137, 0, 0]], EdgeForm[RGBColor[0., 0., 0.]], EdgeForm[
      None], LineBox[{{3193.1873644658954`, 842.7289114177023}, {
       3193.1873644658954`, 5.048557748213156}}]}, 
     {Hue[0.67, 0.6, 0.6], Thickness[0.00201836636368156], StrokeForm[
      RGBColor[0.843137, 0, 0]], EdgeForm[RGBColor[0., 0., 0.]], EdgeForm[
      None], LineBox[{{3163.516453685512, 220.62806053080152`}, {
       3163.516453685512, -1.1108566170041811`}}]}, 
     StyleBox[InsetBox[Cell["3217",
        GeneratedCell->False,
        CellAutoOverwrite->False,
        CellBaseline->Baseline,
        TextAlignment->Left], {3218.0281270259543`, 131.31655535087336`}, {
       Left, Baseline},
       Alignment->{Left, Top}],
      FontSize->14,
      FontWeight->Bold,
      FontColor->Hue[0.005555555555555556, 1., 1.],
      Background->RGBColor[1., 1., 1., 0]], 
     StyleBox[InsetBox[Cell["3193",
        GeneratedCell->False,
        CellAutoOverwrite->False,
        CellBaseline->Baseline,
        TextAlignment->Left], {3193.6186277502334`, 131.31655535087336`}, {
       Left, Baseline},
       Alignment->{Left, Top}],
      FontSize->14,
      FontWeight->Bold,
      FontColor->Hue[0.005555555555555556, 1., 1.],
      Background->RGBColor[1., 1., 1., 0]], 
     InsetBox["", {3197.6725021882503`, 162.11362717695735`}, {Left, Baseline},
      Alignment->{Left, Top}], 
     StyleBox[InsetBox[Cell["3164",
        GeneratedCell->False,
        CellAutoOverwrite->False,
        CellBaseline->Baseline,
        TextAlignment->Left], {3159.462579293745, 254.5048426552093}, {
       Left, Baseline},
       Alignment->{Left, Top}],
      FontSize->14,
      FontWeight->Bold,
      FontColor->Hue[0.005555555555555556, 1., 1.],
      Background->RGBColor[1., 1., 1., 0]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesLabel->{
     FormBox["\"Energie\\n(Kanal)\"", TraditionalForm], 
     FormBox["\"Ereignisse\\n(Anzahl)\"", TraditionalForm]},
   AxesOrigin->{3120., 0},
   AxesStyle->Arrowheads[0.03],
   Epilog->{FontSize -> 16, {
      RGBColor[1, 0, 0], 
      LineBox[{{0, 0}, {0, 3000}}]}, {
      RGBColor[0, 0, 1], 
      LineBox[{{0, 1350}, {0, 1350}}]}, 
     InsetBox[
      BoxData[
       FormBox["0", TraditionalForm]], {0, 270}, BaseStyle -> 
      RGBColor[1, 0, 0]], 
     InsetBox[
      BoxData[
       FormBox["0", TraditionalForm]], {0, 1173.913043478261}, BaseStyle -> 
      RGBColor[0, 0, 1]], 
     InsetBox[
      BoxData[
       FormBox[
        FrameBox[
        "\"Messung\\nohne Folie\"", RoundingRadius -> 5, StripOnInput -> 
         False], TraditionalForm]], 
      NCache[{
        Rational[12545, 4], 2250.}, {3136.25, 2250.}], BaseStyle -> 
      GrayLevel[0]]},
   ImagePadding->{{23., 39.}, {9.349954, 34.}},
   ImageSize->600,
   PlotRange->{{3120., 3250.}, {-60.393140592719504`, 2959.2638890432554`}},
   PlotRangeClipping->True,
   PlotRangePadding->Automatic]}]], "Input",
 CellChangeTimes->{{3.550659463203125*^9, 3.5506594781875*^9}, {
  3.550671038140625*^9, 3.55067103828125*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"gdata", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5105", ",", "2997"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5143", ",", "3018"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5156", ",", "3026"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"5388", ",", "3164"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5443", ",", "3197"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5486", ",", "3222"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"5763", ",", "3385"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5805", ",", "3410"}], "}"}]}], "}"}]}], ";", 
  RowBox[{"gdata", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"gdata", "[", 
       RowBox[{"[", 
        RowBox[{"All", ",", "2"}], "]"}], "]"}], ",", 
      RowBox[{"gdata", "[", 
       RowBox[{"[", 
        RowBox[{"All", ",", "1"}], "]"}], "]"}]}], "}"}], "//", 
    "Transpose"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"g", "=", 
  RowBox[{"Fit", "[", 
   RowBox[{"gdata", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1"}], "}"}], ",", "x"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"\[CapitalDelta]y", "=", 
  RowBox[{"Max", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"gdata", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "2"}], "]"}], "]"}], "-", "g"}], "/.", 
      RowBox[{"x", "->", 
       RowBox[{"gdata", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "1"}], "]"}], "]"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "gdata", "]"}]}], "}"}]}], "]"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Max", "[", 
  RowBox[{"gdata", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", "2"}], "]"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Min", "[", 
  RowBox[{"gdata", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", "2"}], "]"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"(", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"g", "/.", 
     RowBox[{"x", "\[Rule]", "1"}]}], ")"}], "-", 
   RowBox[{"(", 
    RowBox[{"g", "/.", 
     RowBox[{"x", "\[Rule]", "0"}]}], ")"}]}], ")"}], "\[IndentingNewLine]", 
 RowBox[{"\[CapitalDelta]SS", "=", 
  FractionBox[
   RowBox[{"2", "\[CapitalDelta]y"}], 
   RowBox[{
    RowBox[{"Max", "[", 
     RowBox[{"gdata", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "2"}], "]"}], "]"}], "]"}], "-", 
    RowBox[{"Min", "[", 
     RowBox[{"gdata", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "2"}], "]"}], "]"}], 
     "]"}]}]]}], "\[IndentingNewLine]", 
 RowBox[{"\[CapitalDelta]S", "=", 
  RowBox[{"\[CapitalDelta]SS", "*", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"g", "/.", 
       RowBox[{"x", "\[Rule]", "1"}]}], ")"}], "-", 
     RowBox[{"(", 
      RowBox[{"g", "/.", 
       RowBox[{"x", "\[Rule]", "0"}]}], ")"}]}], 
    ")"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"Max", "[", 
  RowBox[{"gdata", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", "1"}], "]"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Min", "[", 
  RowBox[{"gdata", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", "1"}], "]"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"\[CapitalDelta]Ay", "=", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"Max", "[", 
      RowBox[{"gdata", "[", 
       RowBox[{"[", 
        RowBox[{"All", ",", "1"}], "]"}], "]"}], "]"}], "+", 
     RowBox[{"Min", "[", 
      RowBox[{"gdata", "[", 
       RowBox[{"[", 
        RowBox[{"All", ",", "1"}], "]"}], "]"}], "]"}]}], "2"], "*", 
   "\[CapitalDelta]S"}]}]}], "Input",
 CellChangeTimes->{{3.55067123809375*^9, 3.5506713570625*^9}, {
   3.550671434203125*^9, 3.550671510140625*^9}, {3.550671565375*^9, 
   3.550671698265625*^9}, {3.550671816125*^9, 3.550671913578125*^9}, {
   3.550671944578125*^9, 3.550671970296875*^9}, 3.55067201484375*^9, {
   3.550672059015625*^9, 3.550672103921875*^9}, {3.550672156375*^9, 
   3.550672195*^9}, {3.550674355515625*^9, 3.55067436321875*^9}, {
   3.550746427078125*^9, 3.550746591078125*^9}, {3.55074664784375*^9, 
   3.55074664853125*^9}, {3.550746682609375*^9, 3.55074684975*^9}, {
   3.55074695665625*^9, 3.5507469801875*^9}, 3.550747031875*^9, {
   3.550747145375*^9, 3.5507471750625*^9}, {3.550747236609375*^9, 
   3.550747246734375*^9}, {3.5507492169375*^9, 3.550749219640625*^9}}],

Cell[BoxData[
 RowBox[{"36.65544562266964`", "\[VeryThinSpace]", "+", 
  RowBox[{"1.691481035249957`", " ", "x"}]}]], "Output",
 CellChangeTimes->{
  3.550746684328125*^9, {3.550746798640625*^9, 3.55074680471875*^9}, {
   3.55074684265625*^9, 3.55074685071875*^9}, {3.550746958296875*^9, 
   3.550746980734375*^9}, 3.55074703253125*^9, {3.550747157078125*^9, 
   3.550747176703125*^9}, 3.550747248734375*^9, 3.550749220015625*^9}],

Cell[BoxData["1.4547899929602863`"], "Output",
 CellChangeTimes->{
  3.550746684328125*^9, {3.550746798640625*^9, 3.55074680471875*^9}, {
   3.55074684265625*^9, 3.55074685071875*^9}, {3.550746958296875*^9, 
   3.550746980734375*^9}, 3.55074703253125*^9, {3.550747157078125*^9, 
   3.550747176703125*^9}, 3.550747248734375*^9, 3.550749220015625*^9}],

Cell[BoxData["5805"], "Output",
 CellChangeTimes->{
  3.550746684328125*^9, {3.550746798640625*^9, 3.55074680471875*^9}, {
   3.55074684265625*^9, 3.55074685071875*^9}, {3.550746958296875*^9, 
   3.550746980734375*^9}, 3.55074703253125*^9, {3.550747157078125*^9, 
   3.550747176703125*^9}, 3.550747248734375*^9, 3.550749220015625*^9}],

Cell[BoxData["5105"], "Output",
 CellChangeTimes->{
  3.550746684328125*^9, {3.550746798640625*^9, 3.55074680471875*^9}, {
   3.55074684265625*^9, 3.55074685071875*^9}, {3.550746958296875*^9, 
   3.550746980734375*^9}, 3.55074703253125*^9, {3.550747157078125*^9, 
   3.550747176703125*^9}, 3.550747248734375*^9, 3.550749220015625*^9}],

Cell[BoxData["1.6914810352499572`"], "Output",
 CellChangeTimes->{
  3.550746684328125*^9, {3.550746798640625*^9, 3.55074680471875*^9}, {
   3.55074684265625*^9, 3.55074685071875*^9}, {3.550746958296875*^9, 
   3.550746980734375*^9}, 3.55074703253125*^9, {3.550747157078125*^9, 
   3.550747176703125*^9}, 3.550747248734375*^9, 3.550749220015625*^9}],

Cell[BoxData["0.004156542837029389`"], "Output",
 CellChangeTimes->{
  3.550746684328125*^9, {3.550746798640625*^9, 3.55074680471875*^9}, {
   3.55074684265625*^9, 3.55074685071875*^9}, {3.550746958296875*^9, 
   3.550746980734375*^9}, 3.55074703253125*^9, {3.550747157078125*^9, 
   3.550747176703125*^9}, 3.550747248734375*^9, 3.55074922003125*^9}],

Cell[BoxData["0.007030713381039265`"], "Output",
 CellChangeTimes->{
  3.550746684328125*^9, {3.550746798640625*^9, 3.55074680471875*^9}, {
   3.55074684265625*^9, 3.55074685071875*^9}, {3.550746958296875*^9, 
   3.550746980734375*^9}, 3.55074703253125*^9, {3.550747157078125*^9, 
   3.550747176703125*^9}, 3.550747248734375*^9, 3.55074922003125*^9}],

Cell[BoxData["3410"], "Output",
 CellChangeTimes->{
  3.550746684328125*^9, {3.550746798640625*^9, 3.55074680471875*^9}, {
   3.55074684265625*^9, 3.55074685071875*^9}, {3.550746958296875*^9, 
   3.550746980734375*^9}, 3.55074703253125*^9, {3.550747157078125*^9, 
   3.550747176703125*^9}, 3.550747248734375*^9, 3.55074922003125*^9}],

Cell[BoxData["2997"], "Output",
 CellChangeTimes->{
  3.550746684328125*^9, {3.550746798640625*^9, 3.55074680471875*^9}, {
   3.55074684265625*^9, 3.55074685071875*^9}, {3.550746958296875*^9, 
   3.550746980734375*^9}, 3.55074703253125*^9, {3.550747157078125*^9, 
   3.550747176703125*^9}, 3.550747248734375*^9, 3.55074922003125*^9}],

Cell[BoxData["22.522890316159287`"], "Output",
 CellChangeTimes->{
  3.550746684328125*^9, {3.550746798640625*^9, 3.55074680471875*^9}, {
   3.55074684265625*^9, 3.55074685071875*^9}, {3.550746958296875*^9, 
   3.550746980734375*^9}, 3.55074703253125*^9, {3.550747157078125*^9, 
   3.550747176703125*^9}, 3.550747248734375*^9, 3.55074922003125*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"asd", "=", 
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"ListPlot", "[", 
     RowBox[{"gdata", ",", 
      RowBox[{"PlotMarkers", "\[Rule]", 
       RowBox[{"{", "Automatic", "}"}]}]}], "]"}], ",", 
    RowBox[{"Plot", "[", 
     RowBox[{"g", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"Min", "[", 
         RowBox[{"gdata", "[", 
          RowBox[{"[", 
           RowBox[{"All", ",", "1"}], "]"}], "]"}], "]"}], ",", 
        RowBox[{"Max", "[", 
         RowBox[{"gdata", "[", 
          RowBox[{"[", 
           RowBox[{"All", ",", "1"}], "]"}], "]"}], "]"}]}], "}"}]}], "]"}], 
    ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Kanal\>\"", ",", "\"\<Energie\\nin keV\>\""}], "}"}]}], 
    ",", 
    RowBox[{"AxesStyle", "\[Rule]", 
     RowBox[{"Arrowheads", "[", "0.03", "]"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "600"}], ",", 
    RowBox[{"TextStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"FontSize", "\[Rule]", "15"}], "}"}]}], ",", 
    RowBox[{"Epilog", "\[Rule]", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"Red", ",", 
       RowBox[{"Inset", "[", 
        RowBox[{
         RowBox[{"Framed", "[", 
          RowBox[{
          "\"\<\!\(\*SubsuperscriptBox[\(\\\ \), \(94\), \(239\)]\)Pu\>\"", 
           ",", 
           RowBox[{"RoundingRadius", "\[Rule]", "5"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"3020", ",", "5200"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Darker", "[", "Green", "]"}], ",", 
       RowBox[{"Inset", "[", 
        RowBox[{
         RowBox[{"Framed", "[", 
          RowBox[{
          "\"\<\!\(\*SubsuperscriptBox[\(\\\ \), \(95\), \(241\)]\)Am\>\"", 
           ",", 
           RowBox[{"RoundingRadius", "\[Rule]", "5"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"3170", ",", "5460"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", "Blue", ",", 
       RowBox[{"Inset", "[", 
        RowBox[{
         RowBox[{"Framed", "[", " ", 
          RowBox[{
          "\"\<\!\(\*SubsuperscriptBox[\(\\\ \), \(96\), \(244\)]\)Cm\>\"", 
           ",", 
           RowBox[{"RoundingRadius", "\[Rule]", "5"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"3360", ",", "5780"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", "Black", ",", 
       RowBox[{"Inset", "[", 
        RowBox[{
         RowBox[{"Framed", "[", 
          RowBox[{
           RowBox[{
           "\"\<E(K) = \!\(\*SubscriptBox[\(A\), \(y\)]\)+S\[CenterDot]K = \>\
\"", "<>", 
            RowBox[{"ToString", "[", 
             RowBox[{"g", "/.", 
              RowBox[{"x", "\[Rule]", "\"\<K\>\""}]}], "]"}]}], ",", 
           RowBox[{"RoundingRadius", "\[Rule]", "5"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"3300", ",", "5400"}], "}"}]}], "]"}]}], 
      "\[IndentingNewLine]", "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{"\"\<Eichkurve.pdf\>\"", ",", "asd"}], "]"}]}], "Input",
 CellChangeTimes->{{3.550671708328125*^9, 3.55067180990625*^9}, {
  3.550671928640625*^9, 3.550671928703125*^9}, {3.550671984390625*^9, 
  3.55067199984375*^9}, {3.550673247484375*^9, 3.55067332453125*^9}, {
  3.55067336184375*^9, 3.550673386515625*^9}, {3.550673423484375*^9, 
  3.5506740538125*^9}, {3.550674095234375*^9, 3.550674131015625*^9}, {
  3.55067420953125*^9, 3.550674448609375*^9}, {3.550747937890625*^9, 
  3.550747954828125*^9}}],

Cell[BoxData[
 GraphicsBox[{
   GraphicsComplexBox[{{2997., 5105.}, {3018., 5143.}, {3026., 5156.}, {3164.,
     5388.}, {3197., 5443.}, {3222., 5486.}, {3385., 5763.}, {3410., 5805.}, {
    2997., 5105.}, {3018., 5143.}, {3026., 5156.}, {3164., 5388.}, {3197., 
    5443.}, {3222., 5486.}, {3385., 5763.}, {3410., 5805.}}, {
     {Hue[0.67, 0.6, 0.6], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 9], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 10], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 11], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 12], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 13], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 14], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 15], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 16]}, {}}], {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV0G00VHkABvBBmVLUtq2XJpvSOktEw7ZlU0/T1KoVh9LLVsfQ68ayEUkO
g/Set4yWUZnEvfdvPsTcexOVbKeGVraVRLKVZk9UtBnZbXvb/354znN+X54P
z/SouLCtlhKJZCXN//349hQLyU4Gzc0mT+shA8SXKd2gllrIrQOoj9h1CxnU
S+elP0yglgdpd1pFM2iodCp4TJ1plLVbxzAQsoL/vmQ2YOaVqYxtLANdQG1j
wmsDtlV9vlIWz2Bv9dE1j/8x4Hn2jOK5KQy+LJarL300IHjtd6E3jzLoHMly
LLHjURfg0uVbyiBcJ1Pvm8pjOM95ZIWeQYtVjq+DB4+DkgW+DZcZnBi28rw/
j8eMbGuMbaV78qvmsmU87N2GYs4/ZGD7IV2SG86j09fae/QrBs8zpqz/eguP
8jU3rnpbsDgZ9lb9ZBcPo4aJvzCJRWH1wwFRzcPc7zc82ZXFpk02Hjk5PAbI
MxsXXxYujRNqppXywKHGxYeULPwMjumdhEdpijLwxmoWnw1tl2lqeYQe7ouN
3Mbi24a6d8lGHu2jBA+yh0WCss/doYNHhMZLbDrIItp+o9vFJzyWKIyRymIW
fNKd7ZlDPHxG2fZoOBa/uuYnh0gEJPUmJCvrWcgjwlqXTBBwxMuKK2thcSJs
MG7IWQBzfCHX9oBFY8HtR+dmCXC20TZHDrJApFiU5i9Aqy2/eOMDi+OpvbKN
gQKeFrcv7LLj0BbS/8IcLuAY72YKdOGwo9psadgiwN80c32OD4eWCGVfYryA
xT7KQR8FB3Xpz5NUGQLs+486ZqziMDvfeGhUngCzmD6J2cyBa1vQqj8lwF1X
6OmRyGH3WWFdql7AjrJw+6xsDrYNu2tC6gQkjl+kOazhcOaE3boeo4DuwuV+
A5UcskaqFAUdApbLJeVuFzjIK3PfrTAJmPji3pzLTRx8TUlvPcwCHtVtyHPv
4mAZd67ZzkJE2oh0/5J+Ds3V+id6OxGJwXdP1v3LoTezVhHvTF0fvE86jqCp
zGbXN7NEtCr706qnEnwMUplm+Yt47a93GDubwLs6r7wjUMTMZTL13IUEnlFS
efYaEfofq8Y0hhCk6DJGb9gqIoA8VU1XERR5KVi/BBGlq4KCvX8iILt6iprU
IlY7tW0oySCYqEy9mZUrYvKw1fzufALF5shbilMiJHtlLa4FhP6SPFtN/eK9
PCKGOrcnN/cy9XVpVPZ76gdrr4TOOy0iSXb192mFBIlBsg6vMyLuKVJ3biki
YL66+4ejTkRJ/rB2oIRg3Jjlfw2eE3HAfrz3XC3BnKWqUM8KEfFa11/SqNdm
7qn5gXpFRVjfhFKC8ncVu03Ub2vP+8lPEQS8snzTVSli46OYW0lnCGLvX7K4
zooI3Lpf1UCtcWiPsuRE+D3TmqVlBPWrn19bRG07fNOpmHrMb04H6qivSN23
1esIdNeSbM4TEeQY3lidJTBKcqIHqIs+WXcsiHogoKLFo0pErOxgTQ/1/No7
ORXU35edXupWTqB6/exlL/WyL8TOWOoDcstQF70IObkVfYFaH+dUs4l6mvef
Hz5S39H7fKql/g/F3FkT
      "]]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"Kanal\"", TraditionalForm], 
    FormBox["\"Energie\\nin keV\"", TraditionalForm]},
  AxesOrigin->{3000., 5100.},
  AxesStyle->Arrowheads[0.03],
  BaseStyle->{FontSize -> 15},
  Epilog->{
    RGBColor[1, 0, 0], 
    InsetBox[
     BoxData[
      FormBox[
       FrameBox[
       "\"\\!\\(\\*SubsuperscriptBox[\\(\\\\ \\), \\(94\\), \
\\(239\\)]\\)Pu\"", RoundingRadius -> 5, StripOnInput -> False], 
       TraditionalForm]], {3020, 5200}], 
    RGBColor[0, 
     NCache[
      Rational[2, 3], 0.6666666666666666], 0], 
    InsetBox[
     BoxData[
      FormBox[
       FrameBox[
       "\"\\!\\(\\*SubsuperscriptBox[\\(\\\\ \\), \\(95\\), \
\\(241\\)]\\)Am\"", RoundingRadius -> 5, StripOnInput -> False], 
       TraditionalForm]], {3170, 5460}], 
    RGBColor[0, 0, 1], 
    InsetBox[
     BoxData[
      FormBox[
       FrameBox[
       "\"\\!\\(\\*SubsuperscriptBox[\\(\\\\ \\), \\(96\\), \
\\(244\\)]\\)Cm\"", RoundingRadius -> 5, StripOnInput -> False], 
       TraditionalForm]], {3360, 5780}], 
    GrayLevel[0], 
    InsetBox[
     BoxData[
      FormBox[
       FrameBox[
       "\"E(K) = \\!\\(\\*SubscriptBox[\\(A\\), \\(y\\)]\\)+S\[CenterDot]K = \
36.6554 + 1.69148 K\"", RoundingRadius -> 5, StripOnInput -> False], 
       TraditionalForm]], {3300, 5400}]},
  ImageSize->600,
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.550673948203125*^9, {3.550674035234375*^9, 3.55067405475*^9}, {
   3.550674096515625*^9, 3.5506741176875*^9}, {3.55067422428125*^9, 
   3.5506743308125*^9}, {3.55067437475*^9, 3.550674401296875*^9}, 
   3.550674449109375*^9, 3.55074795696875*^9}],

Cell[BoxData["\<\"Eichkurve.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.550673948203125*^9, {3.550674035234375*^9, 3.55067405475*^9}, {
   3.550674096515625*^9, 3.5506741176875*^9}, {3.55067422428125*^9, 
   3.5506743308125*^9}, {3.55067437475*^9, 3.550674401296875*^9}, 
   3.550674449109375*^9, 3.5507479615*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"datplot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "kali1", ",", "kali1gaus1", ",", "kali1gaus2", ",", "kali1gaus3"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1500"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2900", ",", "3500"}], "}"}], ",", 
   "\"\<1. Kallibrierungs-\\nmessung\\nmit Gau\[SZ]fits\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "Blue", " ", "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Red", ",", "Dashed", ",", "Thick"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Green", "//", "Darker"}], ",", "Dashed", ",", "Thick"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Brown", ",", "Dashed", ",", "Thick"}], "}"}]}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.550599699671875*^9, 3.55059992721875*^9}, {
  3.550599959421875*^9, 3.550600069921875*^9}, {3.550600137875*^9, 
  3.550600139875*^9}, {3.55067304284375*^9, 3.550673045234375*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<1_Kallibrierungsmessung_mit_Gau\[SZ]fits.pdf\>\"", ",", 
   GraphicsBox[{{{}, {}, 
      {RGBColor[0, 0, 1], LineBox[CompressedData["
1:eJxt3X9oVP9+5/GDBAkSZJAgQYLMhiBBgkxtaqc29U5taqc2653aXDv15nqn
3lw79eZ6pza1Uzf1Tr2pndqsO2uzdtZm3Vk3a2fdrDtIkEGCHCTIIEEGCTJI
kEGCDBJkkCCDBNllz/s1y3my88/h8X3/+Lw/58zv5Gv+1fmfnf7xDuf/3AKO
83+P/99b8zv4DxE/O+EA3A33wL1wEO6D++ED8AB8EB6ED8Eh+Jfgw/Avw0Pw
r8BH4F+Fw/CvwUfhX4eH4d+Aj8HfgSN+Z2DnNxGHneOIw85vIQ47I4jDzm8j
DjsnEIed30EcdqKIw87vIg47JxGX9Tj6PcW9Y0bW42gU8VHE/zXisvqfMtvj
LiPrcfldf7/MdxGP+eMRWevBrqz1f9/viKx55D6rR75zWv1tlbatHnZl1f+B
f73IH/jzM7Ltz5VVP4b127b6MX++K+v6fM+Odj4j3/PnZ77nz3cRd874HZHt
loFd2PlD/7wROCNrfcSdONaXtX7cn+/Czh/5+0dk1cs6f8h3zqL+rD8/A7uy
bt/H/LL2/31/vot8Z9ys6zfuj2dk1cua/wf+eOQH/ngGcRd2zvnzI7LWl3X+
27bbD1H/Q388A7uwk/CvF0z44xHEE3AG+QXEXcTrsPPHfgdlXY923DsmkJ+B
C7AL12Vd//N+B8/78yNwAs607R0LiLtwHes5PzLbfoM/8udH4AScgQtte0dX
tvXqiDsT/nhwwh+PtG3rI56BC8h34Trs/Bjry7o/I56Q7ZaBC8h3ZXt9qLfz
7XgB61/wxyOIJ2Q9vuEC7Mp2feuw8ydYH47IdksgnpFtfwXE3Xa9rY+4k/TP
G4Qjsh5/stZHvIB6V9b+ke/8Kdb/U388AieQn4EL7Xzv5sq6/6Ofc9GOdv6C
F/3xiGzzJ2StDxeQ77b7ebc64s5P/PXBn/jzI7LNl0B+Bi7IWh/xOvo5k3a0
z2FBWfuX7XNbQtb1l7U+7MJ1Wfv/qR3tc2JQ1vu5n/rzE7LdMsgvIN9FvA47
l/z7Ccp6/ZG1f1nnX9b9X7b+LvrVYedn/vrgz/zxCJyAM7LOP+KurP3L+hye
8juQ8ucHZZsvhPyIbOvHZLueCdnuXynZPtdnsF4OLsAlWfuDq5i3jvom7PyZ
f96ArOsh2/5Csu6fqI/Jul6Ip1CfQX5OtvtjAfOUZPsexEW/KuatI97Ees5l
O+r6y3o8ynb9QrL2j/oY4gk4hfyMrP3Luj8jXoJdzFvFenXEm4g7f+6fJyDb
+Q0iHpLtfERk6xdDPIF4Cs7Ifd4xh/ULsj1eSrL2L9v3YFXMW0e/pqzv5ab8
Dsg2TxAOydq/bP1jsl6vZfseLoV+GVnXH/MU0L8k2/d2LvKrsq6/bOevKev5
7y/89QHZ5g3KNm9I1vMf6mOyrj/yU7Jdrwzyc1ivgPqSbPtxZTs/VcTrsn0v
2sT6zhV//4Cs/cu2vxDiEdTHkJ+Q7XvXlGzzZuCcbOejgHgJ67uIV2XbXx3z
NeU+O/6lHe18BWTtHw7Jtl5Etnljsq2fQH4K+RnZ5snJdr4Kst3fS5jHhauy
Hv/o35T1+E/78wOyXv9lmz8kW31Etv4x2c5nAvkp9M+gPod5CoiXYBf5Vaxf
x/xNrO/8lT8/AAdlu54h2daPyHr+l+16JWS9/4Ez6JeT7XoWEC/Jdv9wsV4V
/etwE/2cq3bU/mU7n0HEQ7Ke/5Efk+18J2SbLyXr+U+2eXJwAS7J9nzmYr2q
bOevjvmbiDv/xt8vINv5Dcp6/yPr+V+2/cRk7V+2nyulZNtPBs7J9npYwPol
5LuyXv8QryPeRD9n2o7av6zHv6zHv6znf9THZL3+IZ5Cv4xs5zMn2/ksIL8k
235c5Fexfl3u845NrOf8td8BOCjb/CFZ739lu3/FZFsvIevxj/qMrPc/svYv
a/+y9o95q+hfx/pN2Lnmnz8ga/+yXv/hiGyP75is+7+s93+ynv+wfg71BaxX
gl3MW5X7vGNd1ucf9Hd+7o8Hfu6PB2U9/8vWPyLr9V/W9wXon0L/DPJzcAH9
S7ALV2W9/sl6/KO/k/HHO2XbX0C2/j2IB2Xb3wAckm2/YdnOZ0S2eaKyHk9Y
P471E4gn0S8l2+M3jfwMnEV+Ducnj/0UsF4R/UqIl3F+XORXsF4V9TW4DjfQ
r4n1Wujv/I0d7fuGTtnqA7I9P/XIfd4xKNv6A3BIts/zYVnPn+gXRX0M8Tj6
JWTbTxLxFNZLy3Z9M4hnsX5Otuudx3oFuIjzVcL8ZcRdnP8K5qnCNdTX4Qb2
30R9C3au29Gud6ds8wZkezz2yHp9gAdkPf7hMNaLyHb+orK+T0Q8jn4JzJtE
PIV+aVnfn2L+LObLoT4PFzBfEfUlrFfGvK6s64/8KvrVZL2+y/Z9SwP9mqhv
yXr9+4V/vc5f+PMDsq3XI+vnFbKuP/JDsp2fMByRbZ6orOd/9I9jvgTmTyI/
hXha1s8vkZ/FfDnk55FfwH6LOD8lzFtGvYv1KsivynY9a9hPHfM10L+J+Vqw
M+Pv1ynb/AG4R9bnA9nmHZBt3hDqw7J+voR+UcRjmC+OfglZz/+oT6F/GvUZ
5Gcxfw71eaxXwHxFxEtwGeu56F+R7f5flfu8Yw31dazfwHpNxFuIO3/r798p
6/Ev6/Vf1vVH/oCsn5egPgxHZNtPVNbrP+Jx9E9gniTiKayXRv8MnJV1/dE/
j34FnL8i1i+hvoz1XORXcD6rst0farJdvzr6NTBfE/ktrOfc8M/XecOfH4B7
ZP2+CjwAh1AflvX+X7Z5orKuP+Jx9EvIdv9Ioj6FedKoz6B/Fs7h/OQRL8h2
fYqy3X9KcBnzuIhXsJ8q8muYp479NDBfE/kt9HP+zp/fKds8AVmv/7Kuv6zH
P+pDqA/DEawflfXzFKwXR35Ctluybe+YQn4azsBZWe//4TzmKcBF5Jew3zLO
j4v1K5i/ivNbQ34d6zXgJvJbWN/J+uOdsh7/sq4/HJSt3wDqQ3KfdwzLev5H
fRTxGByHE5g/iflScBrzZVCfle3851Cfx7wF1BfRv4R+ZdhFvwr2V0W/Gtar
ww3M20S/Fvo5f++v75RtvgDcg/ygrOd/xENwGPkRWe//kB+D47K+X0M8if4p
OA1nsL8snMN8eaxXQL8i4iVZ7/8Qd1FfQbwK1+A65msg3sR+Wjh/zk076vuf
m/78gKz3f3BQtvUG4BDyw1gvgvwo4jHE4+iXgJNwCvtJy3r8Y70s8nNwXtbv
JyFeRL8S4mXUu9hfBa6iXw3xOvo34CbORwt2/sHvTlnXH+6R9ftysj7/Iz8k
6/GPeATrR9E/hvo44gnUJxFPoT4NZzBPFvFcO+7d8sgvIF7EPCXkl9HfRbyC
flXk1xCvI97A/pvo35L1/D/rj3fKNn8A7pF1/eEBWd//oH8Y8Yisxz/6xWR9
/4d4Ak7CKfRPY54M4lnU5xDPo74AF1Ffgsuw2673bhX0q8I1uI75GnAT16+F
9Z1/6+/XKev7n3bcu/UgHkT9APJDyA8jHkE8Kuv6o38c9QnUJ5GfgtPon0E8
i3455OcRL8j6/g/xElxGPxeuoF8V8Rr61eEG3ER9C/t1bslWJuv9v2z1PXBQ
1us/4qF2f+8YhiNwFP1icBz5CayXRDyFeBr9MsjPIj8n2+Mnj3gB8SL6leAy
6l1Z3/8hv4r8GuavY/0Grl8T9S30d/6dbG1lPf7hHjgID8i6/oiH2+t5xwgc
lfX5H/Vx9E8gnoRTst7/Y78ZrJ9Ffg7OI78AF+ESXMb6LuatYH9V1NfgOvo1
EG/K+v4H59fJ+dfrgDtl69cFB2SbvxvugXtRH8R6/YgPwINwCPVD7bh3C8PD
st5/yHZ9R5AfRXwU68eQP4b8OPY/jvoE4hPYTxL9J1GfQnwK8TQ8jfwM1ptB
fhaehXPoN4d4Hp6HC1h/AdenCC/ifJWw/hLOfxn9l1HvIr6CeAXzriJeRf0a
XEP+OuJ1eAP5DcQ3MU8T+91CvIV+27Dz7/3ukPV+ULb1uxAPwN1wD9wLB9G/
H/MMID4Ih9BvCPEw4sNt239F/gjiUVmPf/SLoX4M8Tj2Mw4nUD+B+iTik4in
MN8U8tNYbxr5GeTPoH8WnkW/HOJzcB6ehwtYfwEuIn8R85eQv4T5yqhfRr6L
+Apcwf1hFetXEV9DfQ3568ivy/Z6vIH5GtjPJtyEt+AW+m1jHue2P94h6/EP
d8EB1HfDPbI9f/ciHkS/flmPf8QH2/ZuIXgI9WF4GPNEMM8I+kWx/ijyY/AY
6uNYbxzzJNB/Ak4ifxL9U+g/hXnS8DT6Z+AZ9M8iPgvnZLs/zcF55M9jPwV4
AS5i/kXES4gvIV7GPMuYx0X9CuoryF9FfhVeQ30N9euI11G/gevZwPXYRL8m
6rfgFvK3Yecf/fkd/+iPd8o2bxfiAbgb7kH/3nbcuwUR75f18yTEB+EQPASH
4WHMF8E8I7J+HoX8UcRj6D+G/Dj6jyOeQP0EzncS+ZPol0L9FJyGp+EMPANn
Mc8s1s8hPod4Hv3m4QL2t4B4Ef0WES/BS+hXxnzLiLuIr6BfBfmrcBX1a6iv
wevYT13W6z/yG3g8bGL9JtbfQryFftvo58z56ztkPf4R75L1+yFwN+p7EO9F
vyDcj/wB9BtEPIT6IcTDqB+GI8gfgaPwKOpjsl2/MeTHkT+OeALxCewnKdv1
mkR9Cp5Cfhr9p9v2bhmsN4P8LPrPIp5DfA7OI38e8QLmWYCL8CLqS+i/BJex
v2X0cxFfgSvwKtavYr015NfgdaxfR78NxBvovynr9ztQvwW34G30c/6Df70O
uLNt79gl6/EPd8v6/g/9euEg8vvRbwAeRH0IHpL1+wboP4z8CDyC/UZlO9+j
mCeG+jHUx5E/jnhCtp+fT2DeJDyJfimsPwWnkT+N9TPwDPKziM+ifw7new7x
PDyPfgV4AesXsf9FuIT8JbiM9Zexnov8FbiC+lW4in5rmK+GfutwHf02EG+g
/ybym4hvob6F/G3kO3f87pD1/T/c1c73bgHEu2U9/hHvxXpBuB8egAdlu7+F
EB/CemHMO4x4BB5Bv6isxz/2F0P9GOaLo9846hOon8C8SfSbRH4KnkJ+GutP
o38G9TPIzyI+i/oc4nOI5xGfhwvIX0C8iHkW4RK8hPoy4suwi/wVuAKv4vpV
4TXsp4b6dcTr8AbyG/Am1mvi/rmF/bWQv42480/+/h2yfh8M8S7ZbgG4u23v
2IP6XsSDiPej3wA8iPwQPIT5w1hvWLbzEUH9CPKj8CjyY+g3hnnjyB9HPIH+
E8hPIn8STqF+CvE04tM4PxnZ7j8zWD+LfrOI5+A5OI/6ecQLmG8B+UXkLyJe
QnwJ/cq4Psuy/v0A1K+gfwX9VtGvivw19Kshfx396sjfgBuo30S8ifW34BbW
20a9k/e7A+6U7daFeADuRn4P3Cvr83877h37ZX3/h/6DyA/BQ8gPIz6MeATx
ETiK/FHEY4iPwXHsfxzxBDyB/ScRn8T6KeRPwWmc72nUZ+AZOIv1ZxHPIT6H
/eax/jzyC+i3gHgR9YvIL8FLqC+jfhn5LryC+griq+hXhdew/5psz6/r6F9H
/w30ayB/E/GmbM9nW+jXwjzbqHf+o98dsh7/iHfJ+v4f+d3tuI0l2/2xF/lB
5PdjvQGsN4j6EDyE+jDiw1gvgvgI1osiPor9xNBvDPlxeFzWv1+A9SbgJDyJ
9VPoP4V50lhvGvkZ9J9BPIt+s1g/h/w5xPPoP4/8AuILiBfhRVzfEryEfmV4
GftxUb+CeAX1q8ivYr41uAav4/zU0W8D16uB+CbcRP8tzNvCfraR79z153fc
9cc7ZT3+kR9AfjfcA/e2671bEP36ER9A/SAcQv0Q4mHMP4z8CDyC9aOIj8Ix
9B/D+nF4HPUJrDeB/CTyJ7FeCvEp9Euj3zTyM+g3g/ws8mfRPwfPoT6P+Lys
/39KtsfDAuqLWH8R8RLmX8J6ZdQvwy68gv4VeBWuon4N69fgddTXUb+BeAP1
m4g3Ub+F/Bbyt2Hnn/31Hf/sj3e2496tC/EA3A33oL5X1v8/iPx+5A/Ag7Jd
7xDqh7CfMPKHEY/AI+gXhUcxTwz9x9AvjvxxOIH+E6hPIn8S66VQP4V4GvXT
6J9BfAb9sojPoj4Hz8F51M/DBcy7gPtHEfmLmK+E9ZbgMryMfi68gv4VeBX5
VXgNrmH9dbiO/A3EG1h/E/EmvIX8Fvpv43w78/76Drizbe/WJevxL+v3/2X9
ewGI98p6/CPej/4D8CDmC8FDmDeM+mGsF0H+CPKj8CjWi8FjyI+j/zjiCdRP
ID+J+CTmT6HfFJxGv2nEM+g/g+uTRf4snIPn4Dw8j/4FzLeA/CLii4iXcD6W
EC9jf8vo5yK+gvoK5l1FvAqvoV8N860jv478DbiB/E24ifwtrNeCt2HnP/nd
IdutU7b9d7Xj3jEg6/Uf/XrQrxcOon8/+g+g/yAcQv4Q4mGsN4z5IsgfgaPw
KByDx9A/jvXHkZ+AJ7CfJOKTiKfgKeSn4WnkZzDvDPKzyJ9FPIf9zSGeR3xe
1vt/eAH1Ray/iH4l5C8hXoaX0c9F/QpcQf4q4lWcvzW4hvp1uA5voH8D3oSb
WG8L/VrI30bcueePd8Cdst264EDb3rEb9T3I70V+EPF+1A/Itr9B5IfQbwjx
MOLD6B9BfASOYv1RWd//od8Y8uOIj8MJrDeB+ZPIn8T6KeRPwWl4Gs7AM5g/
i/VnkZ9DfA77yWPeecQLqF+Ai8hfRLwEL2H+MuqXEXdRv4L8CuKr2E8V/dZQ
X8P5Wke/OuIbqG8gvon6JubZQn4L+dvo7/xnf7xDtlsn4l1woJ3vHbtlvf6j
Xy/qg6jvl/XzP/QbRH0I+UOIh+Fh9Itg/RH0i6J+FI6h3xj2G0e/cayXQL8J
1CcRn0R9CvlTmCeN/Gn0y6B+BvEsPIv95LDeHPrlsf488gvIX8B6RdQvIl6C
l+Ay+i+jnwuvoL6C+CriVcTXsL8a8tcRr6N+A/kNxDdR30R8C/ttIb6N/k7B
32+HbO/HOuCdyO+Urf+utr1bl2zr7UZ9APE9qO+G96K+B/X7EO+V7f66H/lB
5PdhvX7s7wDOxwD6H0T/QfgQ1gshfhjrDSH/CNYLw0dRP4z4McQjWP844iOI
n8D5iSJ+EvFR+BTyY4ifxvpjiJ9BPI74WZyvcVyvc6hPIP88PIF5L8BJ+CL6
TyJ+CU4h/zI8hfwrmC8NX8X5mEb9NVn//jHWu45+M4jfQL8sfBPrzyJ+C/Ec
4rdxf53D+nfgPOa9i/g81ruH9QqI30f9Avo/QLyIeR+i/yL8CPUlxB+j3xL8
BPll+Cn6LyP+DI8HF/nPcT5WUP8CriD/JeKrOH+vkF/FPK9Rv4b4G8Rr6PcW
663D77DfOvwe+RuIf0C8AX9E/ibm/YR4E/6M/C30/wK3UP8V8W3EvyHu/Bc7
2v1rh6zPA/BOWa//st12Id7VjnvH3cgPIL4H8W6svxf9e1C/D/W9iO+Hg+jX
h/X64QOoH4APot8g6g8hPwQfhofgI9hfGD6K/GFc32OIRxA/jvgIfAL7i2J/
J+FR+BTmjWH901hvDPVn4DjmOQuPY71zqE8g/zziE/AFOIn6i5h/EvmX4BTq
L8NTyL+C/aQRv4r6acxzDc6g/jo8g343UJ+Fb8KzqL+FeA7x2/Ac8u8gnkf8
rmyvF/PIv4fzV0D+ffRbwP3zAc5PEX6I+kXUP0J+CfM8xrxL8BP0L6P+KfKX
4Wewi37PMd8K/AKuYP2X2O8q+r9CfRV+Da+h/xvEa9jPW6y3juv7DvE66t8j
voH1PmB/DcQ/Yt5NxD+hfxPrf8a8W6j/Arcwz1f030b/b6h37vu9Q7b6Dtnq
dyLeCe+Sbf4u9N+NfgHU70F+dzvu3fYi3gPvk/X7xphnv2y/Lx3EPH3o14/5
DiB/AD6IeQcxzyHkh9D/MPKHMM8R1Ifho1h/GP2PoX8E8ePwCPqfQH0U8ZPw
qGzn+xTmi2G90/CYrNd/OI5+Z1E/jvxzyE/Idv84L+vzP/IvoH9StvNxEetN
Iv+SrL9Pg/zLyJ9C/hXkpzHfVcw/jX7XEM/Idn2uo/+MbPu7Idv5yqL/TdTP
Yr1biOdQfxvxOdTfQX4e+XcRn4fvwQXU38d6C8h/ABdlff5HfLFt7/YI8ZJs
5/Mx+i1hnidwGX4KL2O9Z5jHRfw54iuIv8B8FeS/lG0/q6h/hfwq5n2N+Brq
38A12a7fW8TXEX+H+eqIv4c34A+Yt4H1PiJ/U7bz9Qluov4z6reQ/6Wd791a
su3nK+q3kf8Ndv6rWd//wx2yzbcT8U7Z1t+F/C5Zr/+y7SeA+B7Ud6P/Xqzf
A+9Dfi/67YeDWL8P7kf/A+g/gPyDyB+ED8EhnI/D8BDyjyAelu35+yj2N4z6
Y3AEPt6u924j6HcC+VHETyI+ivgpnK8Y9nMa+WPwGeTHsf+zyB9H/ByuXwL7
PY/+E9jPBTiJ/VzE+pPodwnrp5B/GflTiF/BvGnEr6J+GvFrcAb51zHfDPJv
YP9ZxG8iPgvfQn4O5+828ucQvwPnMe9dxOfhe1i/gP3fR/4C8h/AReQ/RHwR
+3mEeAnX8zHmWUL/J6gvo/9T1C/j/v8M/Vycv+fwCvq9wPoV9HsJr6L+FVxF
/mvMu4Z53qC+hv2/RXwd875D/zry32OeDfT/ADeQ/xHxTfgT1m9ivs+Ib2H/
X7BeC/Gv2M824t+wnrPg77dD1uu/bP12wp2yPv8j3oV+u7FeQLb59qC+G/l7
0a8H3gf3Yr79cBD5fVivH/kHkD8AH0T9oGzX8xDyQ/Bh7H8I/Y7gfIUx31HE
h7H+MawXQf1xrDeC/BNwFD6J+lH0P4X5YvBp9BtD/AwcR/5ZrDeOec7BCdSf
x/mfQP4F9E/CF+FJ+BLmT8n2+f4y4lPteu92BfE0fBWexvrXsL8M9ncd95cZ
xG+gXxa+if3M4vzewnw51N/GfHOY5w7y8+h/F57HevfQr4D17uN8L6DfA/Qr
wg+Rv4jz8Qjns4T8x/AS8p9g/2XkP8V+ljHfM9hF/XPEV+AXyK9gnpeYdxX1
r3D+q6h/jfnXsN4bnM8a6t+i/zr8Dv3qmO89+m/AH5DfgD9i/k3M9wnnp4n+
n9FvC/N/Qf8W/BXeRv9viDv/zd9/h6zf/4N3ynr9h3fBXei/G/0C8B456B27
Zbtee9G/R9bP/5HfK9v+9yMeRLwP7kf+Aaw3gPhBxAexv0M4HyH4MPY3hPoj
iIdRf1Tu847DiB9DvwjmPY79jyB+AutHkX8SHsX6p1AfQ//TyB/DvGfguHzA
O57F/sdxfc7BCcx7HutP4P54oT2vd0si/yL6TWKeS+iXwjyXsb8pxK+gPo34
Vaw3jfN9DfkZ+DryZ7DeDewvi/ybuJ6z2M8trJdD/W1Z3/+j/g7q85jnLuad
R/49rFfA/ec+4gvo9wDxIvo/RHwR8z/C+Slh/sfwEvwE65Vx/3sKL2P9Z5jP
Rb/niK8g/gLXp4L8l1h/Feu/Qn4V+3uN+jXE32CeGvwW+evo9w7Xs47r8R71
G4h/kPu9YwP9PmKeTfT7hHgT5+MzvIX6LzifLfgrvI31vmFe54Ed9fov6/Vf
tvV3ylbfKdvjZxfyu+DdqA9gvT3o14359qJfj2zna5/c5x17kb8f+UH078M8
/YgfgAfQ7yDig/Ah7D+E9Q4jPiTb/e0I9hPGfo8ifxj5x9A/gvzj8oB3HIFP
oD6K/Z3EPKPY3ymsF0P+afQbQ/0Z2e7PcXnQO55F/jj6ncN6CfmgdzyP8zWB
+guoT8IXcf+dRP0lOIX7z2WsP4XzdQVOw1dxfabR/xriGdRfh2ewvxs4X1nc
P24ifxbX4xbOTw77vY34nHzYO97B9c5jvbvwPOa7h3gBvo95F+Rf8Y4PcH6K
mOch+i3ifD2CS5jvMeqXcL2eIF6Wh7zjU/mXvOMy+j9DvYv9PIdXMO8LuCIf
8o4vsd4q8l/helcx72vkr8FvcP+oYb23uB7rcsg7vsP5quP+9R75G+j/AfM0
4I/wpvzL3vET1mti/58R38I8X5DfQv+viG/j/vsN18v5F3/9DvnXvWPHv/jz
d8q2v07Zzs8u+de8Y5f8q95xN+IBrL9HPuoduzHPXvmId+yR7XruQ79e9NuP
+iDm6ZN/0zv2o/6A/FvecUD+De94EB6Uj3nHQ+aM9Q8pftw7HpaHveOQ8iPe
8QjmCyN+VPGodxxW/He84zH5hHeMwMflk95xRP5d73hCtv5Rs/v73vGk/Afe
cVT5Y97xlPyH3jFmjlj8tOrPescx7ecH3vGM8v/YO8bV78fe8aw5eN47jqtf
0jueU/5F75hQ/595x/Pm+iXvOKH1/tw7XlD9n3nHpDk15R0vqv6yd5w0J8yX
zCWrT6H/ZXPA8qfMoZR3vKL+5rT2Z76qfOs/jf1cMzctP4P1rytunjEX/sI7
3lD/v/KOWeX/tXe8KWe846w59wvveMsc/1v77+aem97xtuaZ9Y5zcs473jHr
78jmNY/9XaO7Zv3dnHmz/u7DPbP+HdyCro/9u8j3zfp3QBfM+nd0H5j17/4W
zfp3kh+a9XcIFs36uy+PzPo7eyVdb9vfY13Pf/COS+bo33nHJ7q/2fks6/zY
+X+q+1fa9q392fV8psfHT20dxX/kHZ8rnvCOK3h8vtDj5fe8Y0WPh9/2ji/x
fLeK57NXsr1+V/F8/VrW53/4DV5vauj3Vu7zjuuof4d4Xbb3I+9le/+3gfoP
sr0fa6D+o6zv/2X9/B/5Tcz/Getvod8XzNNC/Vf034a/yfb+zinasc877pDt
/HbI+vwv23qdsn0ftEu2/l3ov1u2+QPwHrgb3ot5euB9cK+sn//Ldv2Csn7+
L+vfI4MPYJ4B2a7XQaw/iPUOIT+E/MOIDyF+BP3C8FHkD+N6HsP1i+D6HEf9
CPJPYP9R5J+U7f33KPqfwjwx2d5fnka/Max/Rrb3w3Hs/yz6j+P6nkN9AvOd
x/4mcH++gHmTWO8i+k1iP5cwbwr5l7HfKfgK5knjfF+V7f35NPpfgzOY57ps
nx9mZHt+voH+Wdk+r9yU7fPGLM7XLeTnZHs/fhv1c9jfHcyTl8Pe8a5snwfm
ZXt/fw/rF7Defdk+byzI9n7+AfoVZXu9eyh/xzsuyse94yPZ3r+XZHv9fGzW
++0l2eJPlD/qHcuyvR4/lb/rHZcRf2Z2Y3ZEv+eyvf9f0frmF7J9nqgg/lL1
9vlgFft7pXyLV3E+XiO+hv2/Ub6tX1PcPr+8Vdw+j6zL9nnknWzvZ+qqt/h7
c8Q+n2wo//ve8YNsnz8a8nnv+FH19n5qU+fbPp98Mtft80dT+ebPyrfPI1vm
qr2f/2Iu2Pv3lvLNX81By9/WfOZvWs/6O//dOwbs/eEOc8LyO8wF805zxNbr
NGes3y64y1y1/N3mkH2+CZhz5j3qf8U7dpvdv/SOezXPz71jjzllnzf2mTtn
vGOvOWzvn/ebg/Z5I2geuOUd+8zT9n6839yyzxsHzPq70wNm/R3Xg2b9naZB
s/6u3yGz/i5VyKy/G3jYrL8zOqTzYesdMSdtnrD2b5+XjpqLf+8dh7Wefd46
Znb+xvrqfNrnueOy3R9GtD/7vHBC58/uz1H1s/v7SdkeL6OyPd+cgmO6v9jj
+7Ti9nwwJtvz7RnZXi/isr1enZXt9WZctteDc7K9niZkez09L+v1X7bXuwuy
vX9Iyvb6dBGelPX6j34pzHNZ7vOOU6i/gnga819F/2nEr8EZ2d5vXpf1839Z
v/8n2/upLOpvon4WviXbLYf+txGfa9s73sH6ecTvot88fA/1BdTfR/4C/AD1
RdQ/xPyL8CO4hPP3GP2XkP8E65Xhp/Ay+j1DPxf5z5G/gvgLxCvo9xLxVVz/
VzifVfg17u9rWP8N8mvwW+Svw+8wXx3x95h3A9fnA+INzPsR/TbhT1i/Kdv7
789Ybwv1X+AW/BXzbaPfN8Sdh/76HbLN1yHr8z/yO+FdqO+Sbf3dsj3fBWSb
Zw/6dcv6/X/Ee7DePqzXi/774SDy++B+9D8g6/M/zs9B1A/Ch2R7/g0hfhj9
hzDvEVmf/1F/VLbn/2HEj8l93jGCfsexnxHET8j2+heV7fX2JPY3ivVOIR6T
7fX8tGw/LxrDemdk+7wWl+37xbOyfT4cl+3z2Tmz3m8kFB/xjucVt89DE7J9
frpg1uenpDkS944XFT/jHSfV336ecUn+I++Ykse942WtZ/VT6mc//7ii/B96
x7TWt/5X4WnZ1rum/uaM+n/PO15Xvn0+mkH8BuJZ7Pem5rPzMYt5binf5s9p
Hvs8dVv1573jnLlgviP/iXfMmxM/8Y53zfp5x7w5ZZ9f7mkee39bMAfs5zf3
NZ95wZyzzx8P1N/iRfW3zysPzVWLL2peW/+RWZ/PSprf5n2sfPs8uKR82+8T
nL+y9mP3j6c438s6n3Z/fabzbT+/dPH4eC7b++UVPP5fyPZ9VwXPVy/xfLOK
589XeD6vtp/PvdtreA1+A9fgt/A6/A6uw+/hDfgD3IA/wpvwJ7gJf4a34C9w
C/4Kb8PfYOd/+L0D7oB3wp3wLrhL1v//j3gA3gN3w3vhHngf3Avvh4NwH9wP
H4AH4IPwIHwIDsGH4SH4CByGj8LD8DE4Ah+HR+ATcBQ+CY/Cp+AYfBoeg8/A
cfgsPA6fgxPweXgCvgAn4YvwJHwJTsGX4Sn4CpyGr8LT8DU4A1+HZ+AbcBaP
75uIz8K34Bx8G56D78B5+C48D9+DC/B9eAF+ABfhh/Ai/AguwY/hJfgJXIaf
wsvwM9iFn8Mr8Au4Ar+EV+FXcBV+Da/Bb+Aa/BZeh9/Bdfg9vAF/gBvwR3gT
/gQ34c/wFvwFbsFf4W34G+ws+r0D7oB3wp3wLrgL3g0H4D1wN7wX7pH17/8h
3gvvh4NwH9wPH4AHsP5BxAfhQ3AIPox+Q4gfgcPwUXgYPgZH4OPwCHwCjsIn
4VH4FByDT8Nj8Bk4Dp+Fx+FzcAI+D0/AF+AkfBGehC/BKfgyPAVfgdPwVXga
vgZn4OvwDHwDzsI34Vn4FpyDb8Nz8B04D9+F5+F7cAG+Dy/AD+Ai/BBehB/B
JfgxvAQ/gcvwU3gZfga78HN4BX4BV+CX8Cr8Cq7Cr+E1+A1cg9/C6/A7uA6/
hzfgD3AD/ghvwp/gJvwZ3oK/wC34K7wNf4Od/+n3DrgD3gl3wrvgLng3HID3
wN3wXrgH3gf3wvvhINwH98v69/8RH4APwoPwITgEH4aH4CNwGD4KD8PH4Ah8
HB6BT8BR+CQ8Cp+CY/BpeAw+A8fhs/A4fA5OwOfhCfgCnIQvwpPwJTgFX4an
4CtwGr4KT8PX4Ax8HZ6Bb8BZ+CY8C9+Cc/BteA6+A+fhu/A8fA8uwPfhBfgB
XIQfwovwI7gEP4aX4CdwGX4KL8PPYBd+Dq/AL+AK/BJehV/BVfg1vAa/gWvw
W3gdfgfX4ffwBvwBbsAf4U34E9yEP8Nb8Be4BX+Ft+FvsPPI7x1wB7wT7oR3
wV3wbjgA74G74b1wD7wP7oX3w0G4D+6HD8AD8EF4ED4Eh+DD8BB8BA7DR+Fh
+BgcgY/DI/AJOAqfhEfhU3AMPg2PwWfgOHwWHofPwQn4PDwBX4CT8EV4Er4E
p+DL8BR8BU7DV+Fp+Bqcga/DM/ANOAvfhGfhW3AOvg3PwXfgPHwXnofvwQX4
PrwAP4CL8EN4EX4El+DH8BL8BC7DT+Fl+Bnsws/hFfgFXIFfwqvwK7gKv4bX
4DdwDX4Lr8Pv4Dr8Ht6AP8AN+CO8CX+Cm/BneAv+Arfgr/A2/A12/pffO+AO
eCfcCe+Cu+DdcADeA3fDe+EeeB/cC++Hg3Af3A8fgAfgg/AgfAgOwYfhIfgI
HIaPwsPwMTgCH4dH4BNwFD4Jj8Kn4Bh8Gh6Dz8Bx+Cw8Dp+DE/B5eAK+ACfh
i/AkfAlOwZfhKfgKnIavwtPwNTgDX4dn4BtwFr4Jz8K34Bx8G56D78B5+C48
D9+DC/B9eAF+ABfhh/Ai/AguwY/hJfgJXIafwsvwM9iFn8Mr8Au4Ar+EV+FX
cBV+Da/Bb+Aa/BZeh9/Bdfg9vAF/gBvwR3gT/gQ34c/wFvwFbsFf4W342//z
/wY8RaKU
        "]]}, 
      {RGBColor[1, 0, 0], Thickness[Large], Dashing[{Small, Small}], 
       LineBox[CompressedData["
1:eJw0nXtcVFUXhsnIyMzITMlMycjIyI/MjMx0a2h4SdHIyMxQUVFRUVFREbnf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        "]]}, 
      {RGBColor[0, 
        NCache[
         Rational[2, 3], 0.6666666666666666], 0], Thickness[Large], 
       Dashing[{Small, Small}], LineBox[CompressedData["
1:eJw03X18jfUfx/ElSZKWpCVpSVqSJEkSV5KWpJG0JI2G5XYYhmHYnZnZ/f3N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        "]]}, 
      {RGBColor[0.6, 0.4, 0.2], Thickness[Large], Dashing[{Small, Small}], 
       LineBox[CompressedData["
1:eJxd1XF01OtZJ/Cxy7IRI6YY74mYslOMGDHSKaY00kh/xZSmNJdOMcUUUzql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        "]]}}, 
     {Hue[0.67, 0.6, 0.6], Thickness[0.00201836636368156], StrokeForm[Hue[
      0.3277777777777778, 1., 0.5383186348055663]], EdgeForm[GrayLevel[0]], 
      EdgeForm[None], 
      LineBox[{{3221.890169818125, 1511.5109493391576`}, {3221.890169818124, 
       4.59093338065577}}]}, 
     {Hue[0.67, 0.6, 0.6], Thickness[0.00201836636368156], StrokeForm[Hue[
      0.3388888888888889, 1., 0.8968210694173822]], EdgeForm[GrayLevel[0]], 
      EdgeForm[None], 
      LineBox[{{3196.8727989971294`, 264.54479379295344`}, {
       3196.8727989971294`, 4.590936592564958}}]}, 
     {Hue[0.67, 0.6, 0.6], Thickness[0.00201836636368156], StrokeForm[Hue[
      0.31666666666666665`, 0.7297297297297297, 1.]], EdgeForm[GrayLevel[0]], 
      EdgeForm[None], 
      LineBox[{{3164.2112316848397`, 110.19719108022264`}, {
       3164.2112316848397`, 12.714494630076842`}}]}, 
     {Hue[0.67, 0.6, 0.6], Thickness[0.00201836636368156], StrokeForm[Hue[
      0.5611111111111111, 0.8918918918918919, 1.]], EdgeForm[GrayLevel[0]], 
      EdgeForm[None], 
      LineBox[{{3385.1980062658668`, 146.75320224902725`}, {
       3385.1980062658663`, 4.590936592564958}}]}, 
     {Hue[0.67, 0.6, 0.6], Thickness[0.00201836636368156], StrokeForm[Hue[
      0.6611111111111111, 1., 0.8968210694173822]], EdgeForm[GrayLevel[0]], 
      EdgeForm[None], 
      LineBox[{{3410.215376973152, 402.64528043065957`}, {3410.215376973152, 
       4.590936592564958}}]}, 
     {Hue[0.67, 0.6, 0.6], Thickness[0.00201836636368156], StrokeForm[
      RGBColor[0.843137, 0, 0]], EdgeForm[GrayLevel[0]], EdgeForm[None], 
      LineBox[{{3024.5309119024932`, 1673.9821133013104`}, {
       3024.5309119024932`, 16.77627364883392}}]}, 
     {Hue[0.67, 0.6, 0.6], Thickness[0.00201836636368156], StrokeForm[Hue[
      0.07222222222222222, 0.40540540540540543`, 1.]], EdgeForm[GrayLevel[0]],
       EdgeForm[None], 
      LineBox[{{2995.343979410659, 325.4714790742946}, {2995.343979410659, 
       4.590936592564958}}]}, 
     {Hue[0.67, 0.6, 0.6], Thickness[0.00201836636368156], StrokeForm[Hue[
      0.06111111111111111, 0.8918918918918919, 1.]], EdgeForm[GrayLevel[0]], 
      EdgeForm[None], 
      LineBox[{{3016.8867152974917`, 963.1707850189966}, {3016.8867152974917`,
        16.776273648833012`}}]}, 
     StyleBox[InsetBox[
       StyleBox[Cell["2997",
         GeneratedCell->False,
         CellAutoOverwrite->False,
         CellBaseline->Baseline,
         TextAlignment->Left],
        Magnification->1.], {2975.191097452012, 357.9657112243426}, {
       Left, Baseline},
       Alignment->{Left, Top}],
      FontSize->19,
      FontWeight->Bold,
      FontColor->Hue[0.05, 0.5135135135135135, 1.],
      Background->RGBColor[1., 1., 1., 0]], 
     StyleBox[InsetBox[
       StyleBox[Cell["3018",
         GeneratedCell->False,
         CellAutoOverwrite->False,
         CellBaseline->Baseline,
         TextAlignment->Left],
        Magnification->1.], {2985.962465395427, 743.8347180061696}, {
       Left, Baseline},
       Alignment->{Left, Top}],
      FontSize->19,
      FontWeight->Bold,
      FontColor->Hue[0.027777777777777776`, 0.7837837837837838, 1.],
      Background->RGBColor[1., 1., 1., 0]], 
     StyleBox[InsetBox[
       StyleBox[Cell["3026",
         GeneratedCell->False,
         CellAutoOverwrite->False,
         CellBaseline->Baseline,
         TextAlignment->Left],
        Magnification->1.], {3029.742864133177, 1617.1172070387256`}, {
       Left, Baseline},
       Alignment->{Left, Top}],
      FontSize->19,
      FontWeight->Bold,
      FontColor->Hue[0.005555555555555556, 1., 1.],
      Background->RGBColor[1., 1., 1., 0]], 
     StyleBox[InsetBox[
       StyleBox[Cell["3164",
         GeneratedCell->False,
         CellAutoOverwrite->False,
         CellBaseline->Baseline,
         TextAlignment->Left],
        Magnification->1.], {3147.8804480286944`, 130.50608617400349`}, {
       Left, Baseline},
       Alignment->{Left, Top}],
      FontSize->19,
      FontWeight->Bold,
      FontColor->Hue[0.35, 0.5675675675675675, 1.],
      Background->RGBColor[1., 1., 1., 0]], 
     StyleBox[InsetBox[
       StyleBox[Cell["3197",
         GeneratedCell->False,
         CellAutoOverwrite->False,
         CellBaseline->Baseline,
         TextAlignment->Left],
        Magnification->1.], {3171.507964807797, 313.2861420180261}, {
       Left, Baseline},
       Alignment->{Left, Top}],
      FontSize->19,
      FontWeight->Bold,
      FontColor->Hue[0.35, 1., 0.9486727155643735],
      Background->RGBColor[1., 1., 1., 0]], 
     StyleBox[InsetBox[
       StyleBox[Cell["3222",
         GeneratedCell->False,
         CellAutoOverwrite->False,
         CellBaseline->Baseline,
         TextAlignment->Left],
        Magnification->1.], {3189.5760658741706`, 1483.0784994197743`}, {
       Left, Baseline},
       Alignment->{Left, Top}],
      FontSize->19,
      FontWeight->Bold,
      FontColor->Hue[0.3277777777777778, 1., 0.6916998428445305],
      Background->RGBColor[1., 1., 1., 0]], 
     StyleBox[InsetBox[
       StyleBox[Cell["3385",
         GeneratedCell->False,
         CellAutoOverwrite->False,
         CellBaseline->Baseline,
         TextAlignment->Left],
        Magnification->1.], {3368.86722260972, 167.06209734280787`}, {
       Left, Baseline},
       Alignment->{Left, Top}],
      FontSize->19,
      FontWeight->Bold,
      FontColor->Hue[0.5611111111111111, 0.6756756756756757, 1.],
      Background->RGBColor[1., 1., 1., 0]], 
     StyleBox[InsetBox[
       StyleBox[Cell["3410",
         GeneratedCell->False,
         CellAutoOverwrite->False,
         CellBaseline->Baseline,
         TextAlignment->Left],
        Magnification->1.], {3391.7998124247324`, 422.95417552444064`}, {
       Left, Baseline},
       Alignment->{Left, Top}],
      FontSize->19,
      FontWeight->Bold,
      FontColor->Hue[0.6611111111111111, 0.8378378378378378, 1.],
      Background->RGBColor[1., 1., 1., 0]]},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesLabel->{
      FormBox["\"Energie\\n(Kanal)\"", TraditionalForm], 
      FormBox["\"Ereignisse\\n(Anzahl)\"", TraditionalForm]},
    AxesOrigin->{2900., 0},
    AxesStyle->Arrowheads[0.03],
    Epilog->{FontSize -> 16, {
       RGBColor[1, 0, 0], 
       LineBox[{{0, 0}, {0, 3000}}]}, {
       RGBColor[0, 0, 1], 
       LineBox[{{0, 750}, {0, 750}}]}, 
      InsetBox[
       BoxData[
        FormBox["0", TraditionalForm]], {0, 150}, BaseStyle -> 
       RGBColor[1, 0, 0]], 
      InsetBox[
       BoxData[
        FormBox["0", TraditionalForm]], {0, 652.1739130434784}, BaseStyle -> 
       RGBColor[0, 0, 1]], 
      InsetBox[
       BoxData[
        FormBox[
         FrameBox[
         "\"1. Kallibrierungs-\\nmessung\\nmit Gau\[SZ]fits\"", 
          RoundingRadius -> 5, StripOnInput -> False], TraditionalForm]], {
       2975, 1250.}, BaseStyle -> GrayLevel[0]]},
    ImagePadding->{{22.999998, 37.374997}, {0.725, 33.499998}},
    ImageSize->600,
    PlotRange->{{2900., 3500.}, {-443.06016666666665`, 1724.3481666666667`}},
    PlotRangeClipping->True,
    PlotRangePadding->Automatic]}], "]"}]], "Input",
 CellChangeTimes->{{3.550671090609375*^9, 3.5506711185625*^9}, {
  3.550671218125*^9, 3.550671220703125*^9}, {3.55067138128125*^9, 
  3.550671427109375*^9}, {3.55067203453125*^9, 3.55067204275*^9}, {
  3.5506721150625*^9, 3.550672122625*^9}, {3.550672211171875*^9, 
  3.550672465265625*^9}, {3.55067305203125*^9, 3.550673089046875*^9}, {
  3.55067311915625*^9, 3.55067313103125*^9}}],

Cell[BoxData["\<\"1_Kallibrierungsmessung_mit_Gau\[SZ]fits.pdf\"\>"], "Output",
 CellChangeTimes->{3.55067313428125*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"datplot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "kali2", ",", "kali2gaus1", ",", "kali2gaus2", ",", "kali2gaus3"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1500"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2900", ",", "3500"}], "}"}], ",", 
   "\"\<2. Kallibrierungs-\\nmessung\\n mit Gaussfits\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "Blue", " ", "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Red", ",", "Dashed", ",", "Thick"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Green", "//", "Darker"}], ",", "Dashed", ",", "Thick"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Brown", ",", "Dashed", ",", "Thick"}], "}"}]}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.550599946171875*^9, 3.550599951109375*^9}, {
   3.5505999981875*^9, 3.550599998625*^9}, 3.55060008340625*^9, {
   3.550600129390625*^9, 3.55060013259375*^9}, {3.550695679046875*^9, 
   3.55069567984375*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<2_Kallibrierungsmessung_mit_Gaussfits.pdf\>\"", ",", 
   GraphicsBox[{{{}, {}, 
      {RGBColor[0, 0, 1], LineBox[CompressedData["
1:eJxt3X9ok39/7/ELKVKkSJAiRYpkpUiQIpnrXOY676zrXG7vzmWuc7m9O5f1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        "]]}, 
      {RGBColor[1, 0, 0], Thickness[Large], Dashing[{Small, Small}], 
       LineBox[CompressedData["
1:eJw03X18zfX/x/ElSSUtSSNJkiRJWkLSmyRJQtKSJEZyOdfDMDMMw66vzHa2
cy1JpZJ8tSRJ0pKQJJUkSSpJkn7n/J6P1++f7+3+2/P08d7rvD/n8/yc47hp
2IT+I2rERP4vNibm//+X//u44qE3//h1rpNOPVD2a3Dbo7+YY9z67dM2lx83
13b/n//RHOu+nVl/7cM/mOu7s09871/5nTnO1b3jtVW/fmNurPzX5qbKHzA3
U36fubm7pda8/Ae/MLdw933z+LLC3eaWrv+GJgt+/tTcyo3K/iXlgU/MrZXf
YW6j/Ifmtsp/YL7LzR29aUruFnM7V/Dg0rE/vmu+261pPCjxvv+Z45XfaL5H
+bfM7ZV/w3yve//PloNXvGbu4L7c9dcT379i7uhORX79975s7qT8avN9ygfN
nZX3m+930V/X0kpzF3dD5PDflJsfcHdH/2+V2bledWrcvqgEpzrlC+3nXZXP
t593VT7Hft7NDf2hutlXK+zn3dz0zeWN7lxmP3/QLSscX2/+Evv5g8ovsp93
V36B/by78mn284ecL+n+y/fNtZ8/5DY+EvkDzLaf93CfNfvq7zkz7ec9lJ9u
P39Y+an284eVn2Q/7+l+/Cf82+4J9vOe7sKe5J9ajLOfP+Iiz9ZvZ462nz/i
bl/U4MtdL9jPeyk/wn7eS/lh9vNHlX/Ofv6o6xb9BTxrP+/tEjpGdtgg+3lv
N6He/KodT9nPH1P+Sfv5Y8r3t5/3Uf5x+3kft+DnfhuaPGY/f9yVbm26blIv
+/njLrK7gtsetp/3Vf4h7Poq383yfZV/AFf1dR9FTgeN7rfH93PR7TW+kz2+
nzsTebpuudce30/5e+zx5NvZ4/srf6c9vr+LPr0a3GGP7+9ujoxrdCt7fH8X
Xf7mW+3xT7i+0SfMLfb4J5RvZo9/Qvkb7fHkb7DHD3Ajo//XyB4/wM1+4J4h
G6+zxw9wuXE1B9a91h5Pvp49/knlr7LHP6n8lfb4J93q33Y/Nuxye/yT7r0d
kRPopfb4gW6fN/KEvcQeP1D5Gvb4gcr/N4fHk/8XxzzlTqZE/gDnsHvKRY5+
x2t/4dSn3PV3ft281p/2+KfcXbUjZ6Tf7fEJyv9qj09Q/hd7fILyx+3xCa5n
9AT+oz3+aTckusF+sMc/7aZGfwHf2eOfVv4bezz5r+3xg5Q/YI8f5CJnz3/C
++zxg1xl5OXm3z32+EEuevrut9se/4zyn9rjn1F+pz3+GeV32OOfcZ9GTp/+
D+3xg130dPT3Vnv8YHc+cjp4bIs9frCLbq+Kd+3x5DfZ459VfqM9/lnl37LH
P+tuizy9/1xvj3/WRZ8uj7xmjx/ior/+Va/Y44cov8YeP0T51fZ48kF7/HNu
XPQE5rPHP+eih3+o0h7/nCspjvxfuT2efKk9fqjyJbjpUOUL7b831K2bFHmF
zMNDh7oPH713cdcc++8PdZFny7z8Fdgz1J3+N3JCzLTjkV+CD5NfZMd/Xvl0
O/7z7vLoEzzNjv+8uyn6B5hrx3/eRf5rQ39IseOTn2nHJz/djk9+ih3/eddn
WGxCx0l2/GEuMXqBMMGOP8zNip7Ax9rxhyk/2o5P/gU7PvlEO/4wF72cuGeY
HX+YC0Venhc/Z8cf5qIvd18PtuMPd19EXj7uGmTHH678U3b84coPsOOT72/H
H+5ORE7fCx634w930dPnl73t+MNdw+gG72XHJ/+wHT9R+e52/ETlu9nxE130
dDDvATt+ousR3Y6d7fiJLvp0bdnJjk/+Xjs++Xg7Pvl2dvwRbnL0AuxOO/4I
Fx1XdWs7/gjniSy/eSs7/ggX/c8l32rHJ9/cjk++mR2f/I12/BHuk52R/2ts
xx/pIlefW5s2suOPdOfmRC7orrPjj1S+vh2ffD07Pvmr7PgjXWz0BbqOHX+k
uzV6Ar3cjj/S3R99wl5qx39B+Zp2/BeUr2HHf0H5/2Zz/BfcgOgf4DxOfcFF
Lz/jzmHPCy56+Tf2L1z1giuKXE5VncaHyf+OY0Yp/ytuOkr5E9iNctHLmfrH
7fij3AeRy4NRP9rxR7noy+2mI3Z88t/Z8cl/Y8cnf9CO/6L7PfJyF3vAjv+i
i77cJO6z47/oboxeoOyx45Pfbccn/6kdn/xOO/6LLnr6rLPDjv+i6x09IXxo
xx/tott7/VY7/mg3I7K9am+x449W/l07PvlNdnzyG+34o1306T34LTv+aBeI
PF3Wrbfjj3bRX3/N1+z4Y5R/xY4/Rvk1dvwxyq+2449xn0eWnxC0449x0cOv
8dnxx+h/K+345Mvt+ORL7fhj9b8ldvyx7rpowSi044910ToWzLPjj3Xdoy+4
2Xb8sS5aFx5fYccnn2nHJ7/Yjk9+kR1/nJsYfYKn2/HHuejl8l/z7Pjj3P/3
0bl2fPIpdnzyM+z45Kfb8cepv06x449Tf51oxx+vPjrBjj9e+bF2/PHKv2jH
J/+CHX+8+muiHX+8+uvzdvzx6q/P2fHHq48OtuNPUP5pO/4E5Z+y409QfoAd
f4L6az87/gT118ft+BPUR3vb8ck/Yscn/7AdP0n57jg2Sf21q/15ktRfH8Bt
k9RHO9ufj3xH3Jf8vfbnJR+Pk5LUX++yP3+S+uudOCtJ/bW1rSdJffQ2vI78
rbY+8s1xNfmbbL1J6q834lNJ6q+Nbf0T1Ucb2vonKn+drX+i8vVt/eSvtvVP
VH+9ytY/Uf21jq1/ovroZbZ+8pfa+snXtPWTv8jWP1H99b8U1j9R/fU8rpqo
/vo3rib/Fz5M/jQ+Rf43HDNJ/fVXHDtJ/fUEbjpJ/fUn3HaS+uiP2JE/gvuS
/xYPJf8NTpqk/noQp05Sf/0SZ01SH92HPeT32PrJf2brJ/+prX+S+utOW/8k
9dePbP2T1Ec/tPVPVn6rrX+y8u/Z+icr/66tf7L66yZb/2T117dt/ZPVX9+y
9U9WH11v6yf/qq2f/Cu2fvJrbP2T1V/Dtv7J6q9BW/9k9VGfrZ98ha2ffLmt
n3yprX+K+muxrX+K+muhrX+K+mierZ98tq2f/ApbP/lMW/8U9dfFtv4p6q+L
bP1T1F/Tbf1T1Efn2frJz7X1k0+x9ZOfYeufov463dY/Rf11iq1/ivroRFv/
VOUn2PqnKj/W1j9V+Rdt/VPVX1+w9U9Vf0209U9VH33e1k/+OVs/+cG2fvJP
2/qnqr8OtPVPVX8dYOufqv7az9Y/VX20j62ffG9bP/lHbP3ke9j6p6m/drf1
T1N/7Wrrn6Y+2sXWT76zrZ98R1s/+fa2/mnqr/G2/mnqr3fZ+qepj7ax9ZNv
besnf5utn3wLW/809dfmtv5p6q832fqnqb82sfVPUx9tbOufrnxDW/905RvY
+qcrX9/WP1399Wpb/3T117q2/unqo3Vs/eQvs/WTr2XrJ1/T1j9d/fUiW/90
9dcLs1j/dPXR87iK/N+4mvwZfJj8aXxquvrrbzgmWf31JI5NVn89gZsmq4/+
hNuSP4od+SO4L/lv8dBk9ddDOClZ/fUgTk1WH/0SZ5Hfiz3k99j6yX9m609W
f91l609Wf91p609WH/3I1k9+m61/hvJbbf0zlH/P1j9D/XWzrX+G+usmW/8M
9de3bf0z1EfftPWTX2/rJ/+qrZ/8Wlv/DPXXNbb+GeqvYVv/DPXRgK2fvM/W
T77C1k++zNY/Q/211NY/U/212NY/U320wNY/U/k8Wz/5bFs/+eW2/pnqr5m2
/pnqr4tt/TPVXxfa+meqj6bb+snPs/WTn2PrJ59i65+p/jrD1j9T/XWarX+m
+ugUWz/5ibb+WcqPt/XPUn6srX+W+uuLtv5Z6q8jbf2z1EcTbf3kn7f1kx9i
6yc/2NY/S/31aVv/LPXXgbb+WeqvA2z9s9RH+9n6yfex9ZPvbesn/4itf5b6
aw9bf4r6a3dbf4r6aFdbf4ryXWz95Dvb+sl3tPWnqL+2t/WnqL/G2/pT1Efv
svWTb2PrJ9/a1k/+Nlt/ivprC1s/58nmtv4U9debbP0p6qNNbP3kG9v6Zyvf
0NY/W/kGtv7Z6q/X2Ppnq79ebeufrT5a19ZP/gpbP/nLbP3ka9n6Z6u/Xmzr
n63+epGtf7b66IWZrJ/8P7iK/N+4mvwZfHi2+usf+NRs9dffcMwc9deTOHaO
+ujPuOkc5X/CbckfxY7897jvHPXXb/HQOeqvh3DSHPXRr3Aq+S9xFvm92EP+
c1v/HPXXz2z9c9Rfd9n656iPfmzrJ/+RrZ/8Nlv/XOXft/XPVX99z9Y/V/11
s61/rvrrO7Z+8m/b+sm/aesn/7qtf67666u2/rnqr2tt/XPVX1+y9c9VHw3b
+skHbP3kvbZ+8hW2/rnqr2W2/rnqrytt/anqo8W4dqryBfb7SFU+F8eRz7bf
T6r663LcMlX9dan9vlLVRxfjDuQX2u+P/Hzck/w8+32mqr/OwQmp6q+z7Peb
qv46A49KVR+dZr9v8pNxMvmJ9vsnPx5npKq/jrF5pKq/voiLUtVHR9p8yA/H
IfLP27zID8EbUtVfn7H5paq/Po23p6qPDrR5kn8C7yffz+ZLvg8+lqr++qjN
O1X99RF8NlX9tYfNf5766IM2/3nKd7X5z1O+i82f/H02/3nqrx1t/vPUX9vb
/Oepj95t8yd/l82ffBubP/nbbf7z1F9vs/nPU39tYfOfpz56s82f/E02f/JN
bP7kr7f5z1N/bWjzn6f+2sDmP0/99Rqb/zz10att/uTr2vzJX2HzJ3+ZzX+e
+mstm/889deLbf7z1EcvsvmTvzBD3k/+H3yY/N/42Dz11zP41Dz11z/w2Xnq
o7/hmDTlT+Laacr/jGPTlP8Jx6Wpvx7FTdPUX7/HLdPUXw/jtmnqo4dwB/Jf
YUd+P+5Jfi/um6b++jlOSFN/rcZD09RHd+FR5D/GSeS342Ty23Bqmvrr+zgj
Tf21CmelqY9uxkXk38Ee8htwiPybeF2a+uvreEOa+us6XJWm/roWb09TH30J
V5MP2fzJB2z+5L02/zT1V4/NP039tczmn6Y+utLmP1/5Ipv/fOULbP7zlc+1
+c9Xf82y+c9Xf11u85+vPrrU5k8+w+ZPfqHNn/x8m/989ddUm/989dc5Nv/5
6q+zbP7z1UeTbf7kp9n8yU+2+ZNPsvnPV38db/Ofr/46xuY/X310lM2f/Eib
P/nhNn/yQ23+89Vfh9j856u/PmPzn68+mmDzJz/Q5k/+CZs/+b42//nqr31s
/vPVXx+1+c9Xf+1p85+vPtrD5p+u/IM2/3Tlnc0/XfkuNv909df7bP7p6q8d
bP7p6qPtbf7k77b5k29r8yffxuafrv56u80/Xf21pc0/XX20hc2f/M02f/JN
bf7km9j809Vfr7f5p6u/xtn809VfG9j809VHr7H5k4+1+ZOva/Mnf4XNP139
tbbNP139tZbNP1199GKbP/kYmz/5C8nyfvL/4MPp6q9n8bF09dcz+FS6+ugf
+Cz5UzhmgfInce0Fyv+MYxeovx7DcQvUX4/ipgvUX7/HLReojx7Gbckfwh3I
f4Ud+f245wL117247wL1189xwgL10Wo8lPwuPIr8xziJ/HacvED9dRtOXaD+
+j7OWKA+WoWzyG/GReTfwR7yG3Bogfrrm3jdAvXX1/GGBeqv63DVAv3vWryd
/Eu4mnzI5k8+YPNfoP7qtfkvUH/12PwXqI+usvmTX2nzX6h8kc1/ofL5Nv+F
6q+5Nv+F6q9ZNv+F6qPLbP7kl9r8yWfY/MkvsPkvVH+db/NfqP6aavNfqP46
2+ZPfpbNn3yyzZ/8VJv/QvXXyTb/heqvSTb/heqv42z+C9VHx9j8yY+y+ZMf
YfMnP9zmv1D9dajNf6H667M2/4Xqo8/Y/Mkn2PzJP2nzJ/+EzX+h+mtfm/9C
9dfHbP4L1UcftfmT72nzJ/+QzX+R8g/a/Bepvzqb/yL11/tt/ovUX++z+S9S
H+1g8yd/j82f/N02f/Jtbf6L1F/vsPkvUn+93ea/SH20pc2f/C02f/I32/zJ
N7X5L1J/vcHmv0j99Xqb/yL10TibP/lrbf7kr7H5k4+1+S9Sf73S5r9I/fUK
m/8i9dfaNv9F6qOX2PzJX2zzJx9j8yf/73R5/yL113/w4UXqr2fxsUXqo3/i
U+T/wGfJn8IxGcr/gmtnqL/+jGMz1F+P4bgM9dEfcFPy3+OW5A/jtuS/xh0y
1F+/wi5D/XU/7pmh/voF7puhPvo5TiBfjYeS/wSPIv8xTspQf92OkzPUXz/A
qRnqo+/jDPJVOIv8/3AR+XewJ0P9dQMOZai/voHXZaiPvo43kF+Hq8i/jLeT
fwlXZ6i/hmz+Geqvfpt/hvqr1+afoT7qsfmTX2XzJ7/S5r9Y+SKb/2L113yb
/2L111yb/2L10SybP/llNn/yS23+5DNs/ovVXxfY/Berv863+S9WH021+ZOf
bfMnP8vmTz7Z5r9Y/XWqzX+x+utkm/9i9dckm/9i9dFxNn/yY2z+5EfZ/MmP
sPkvVn8dZvNfrP461Oa/WH30WZs/+UE2f/IJNn/yT9r8F6u/9rf5L1Z/7Wvz
X6w++pjNn3wvmz/5njZ/8g/Z/Jeov3az+S9Rf3U2/yXqr/fb/Jeoj3ay+ZPv
YPMnf4/Nn3w7m/8S9de2Nv8l6q932PyXqI+2svmTb2nzJ3+LzZ98M5v/EvXX
pjb/JeqvN9j8l6iPNrL5k4+z+ZO/1uZPvp7Nf4n6a6zNf4n665U2/yXqr5fb
/Jeoj9a2+ZO/xOZPvobNn3yMzX+J+uu/0+T9S9Rfz+HDS9RHz+Jj5P/Ep8j/
js+SP4Vjlqq//oJrL1V/PY5jl6qPHsNx5H/ATcl/h1uSP4zbLlV//Rp3WKr+
egC7peqv+3HPpeqjX+C+5HfjBPLVeCj5T/CopeqvO3DSUvXX7Th5qfroBziV
/BacQb4KZ5H/Hy5aqv66EXuWqr9uwKGl6qNv4HXkX8MbyK/DVeRfxtuXqr+u
xtVL1V9DNv+l6q9+m/9S9dFKmz95j82f/CqbP/kSm3+m+muRzT9T/TXf5p+p
Pppj8yefZfMnv8zmT36JzT9T/TXD5p+p/rrA5p+pPppm8yefavMnP9vmT36m
zT9T/TXZ5p+p/jrV5p+p/jrJ5p+pPppk8yc/zuZPfrTNn/wom3+m+usIm3+m
+uswm3+m+uhQmz/5Z23+5AfZ/Mkn2Pwz1V+ftPlnqr/2t/lnqo/2tfmTf8zm
T76XzZ98T5t/pvrrQzb/Zeqv3Wz+y9Rfnc1/mfL32/zJd7L5k+9g81+m/nqP
zX+Z+ms7m/8y/v82/2Xqo3fY/Mm3svmTb2nzJ3+LzX+Z+mszm/8y9dcbbf7L
1EdvsPmTb2TzJ3+dzZ/8tTb/Zeqv9Wz+y9Rfr7L5L1MfvdLmT/5ymz/5S23+
5C+x+S9Tf61h81+m/vrfVLl6mfrrv3j/MvXRc/gw+b/wMfJ/4lPkf8dnl6m/
/opjlqu//oJrL1cfPY5jlyv/I44j/wNuSv473HK5+us3uO1y9devcYfl6qMH
sCO/D/ck/wXuS343Tliu/vopHrpc/fUTPGq5+usOnLRcffRDnEz+A5xKfgvO
IP8uzlqu/vo/XLRc/XUj9ixXH30Lh8i/gdeRfw1vIP8Krlqu/voy3r5c/XW1
zX+5+mjQ5k/eb/MnX2nzJ19u81+u/rrK5r9c/bXE5r9C/bXQ5r9CfTTf5r9C
+RybP/kVNn/yy2z+K9Rfl9j8V6i/LrL5r1AfXWDzJ59m8yc/1+ZPfrbNf4X6
60yb/wr11+k2/xXqo1Nt/uQn2fzJT7D5kx9n81+h/jra5r9C/fUFm/8K9dcR
Nv8V6qPDbP7kn7P5k3/W5k9+kM1/hfrrUzb/FeqvT9r8V6iP9rf5k3/c5k/+
MZs/+V42/xXqrw/b/Feovz5k889SH+2Ga2Yp/4A9H7KUvx/XId/Jnh9Z6q/3
4vpZ6q/32PMlS/21HW6cpT56pz1/yN+Bm5NvZc8n8rfi1lnqr7fY8ytL/bUZ
js9SH73Rnm/kb8CdyTey5x/563D3LPXXa+35mKX+Wg/3zlIfvcqen+SvxAPI
X27PV/KX4sFZ6q+X2PM3S/21Bk7MUn/9b4o8Kkt99F88lvw5nET+LzyF/J84
OUv99XeckqX++itOzVIfPYHTyR/HGeR/xJnkj+CsLPXX73BelvrrN7goS330
IC4lfwB7yO/DPvJ7cChL/XU3XpOl/vopXpel/roTr89SH92BN5D/EG8ivxVX
kd+Ct2apv76Lt2epv27CO7PURzfiavJv4T3k1+P95F/DB7PUX1/Bh7PUX9fg
I1nqo6vxMfJBfIK8D58iX4lPZ6m/luOzWeqvpfh8lvprCY7JVh8txDWzlc/D
tbOVz8F1yK/Asdnqr5m4frb66xIcl60+ugg3Jp+Om5JPw83Jz8Uts9VfU3Dr
bPXXmbhttvrodBxPfgruQH4S7kx+AnbZ6q9jcfds9dfRuGe2+usLuHe2+mgi
7kt+GB5A/jmcQH4wHpyt/joID81Wf30KJ2arjw6w/U++v+1/8o/b/iff2/Z/
tvprL9v/2eqvD9v+z1Yf7W77n3w32//kH7D9T76z7f9s9ddOtv+z1V/vtf2f
rf4ab/s/W320ne1/8nfa/iff2vY/+Va2/7PVX2+1/Z+t/trc9n+2+mgz2//k
b7T9T76x7X/yjWz/Z6u/Xmf7P1v9tb7t/2z10Xq2/8lfZfuffB3b/+Qvt/2f
rf56qe3/bPXXmrb/s9Vfa9j+J//fZPkY+fP4BPlz+FS2+utf+HS2+utpfDZb
/fV3fD5bffRXHJOj/AlcM0f547h2jvI/4jo56q9HcGyO+ut3uH6O+ug3OI78
QdyY/AHclPw+3DxH/XUPbpmj/robt85RH/0UtyW/E8eT34E7kP8Qd85Rf92K
XY766xbcPUf99V3cM0d9dBPuTX4j7kv+LTyA/HqckKP/fQ0PzlF/fQUPzVEf
XYMTya/Go8gH8VjyPpyUo/5agafkqL+W4+Qc9dFSnEK+GKeSL8Tp5PNwRo76
azbOzFF/XYGzctRfM3FejvroYlxEfhEuJZ+OPeTnYV+O+utcHMpRf03Ba3LU
R2fgdeSn4/Xkp+AN5CfiTTnqrxNwVY7661i8NUd99EW8nfwLeCf5RFxN/nm8
J0f99Tm8P0f9dTA+mKP++jQ+nKM++hQ+Qn6A7X/y/Wz/k3/c9n+O+mtv2/85
6q+P2P7PUR992PY/+e62/3OV72r7P1f5B2z/56q/drb9n6v+2tH2f6766L22
/8nH2/4nf5ftf/J32v7PVX9tbfs/V/31Ntv/ueqvt9r+z1UfbW77n/xNtv/J
32j7n3xj2/+56q8Nbf/nqr9eZ/s/V320vu1/8lfb/id/le1/8nVs/+eqv15m
+z9X/fVS2/+56qM1bf+Tv8j2P/n/JsmjyJ/HY3PVX//GSbnqr3/hKbnqr6dx
cq766G84hfyvOJX8CZxO/ieckav++iPOzFV/PYKzctVHv8V55L/BReQP4lLy
X2JPrvrrPuzLVX/dg0O56qOf4TXkP8XryO/E68l/hDfkqr9+iDflqr9uxVW5
6q/v4a256qPv4u3kN+Gd5N/G1eTfwnty1V/X4/256q+v4oO56qOv4MPk1+Aj
5MP4GPkgPpGr/urDp3LVXyvw6Vz10XJ8lnwpPk++GMfkKV+Ia+apv+bh2nnq
r9m4Tp766wocm6c+monrk1+M48gvwo3Jp+Omeeqv83DzPPXXubhlnvpoCm5N
fgZuS346jic/BXfIU3+diDvnqb+Oxy5PfXQs7k7+RdyT/Ejcm3wi7pun/vo8
HpCn/joEJ+Spvw7Gg/PUR5/GQ8kPxInkB9j+J9/P9n+e+msf2/956q+9bf/n
qY8+YvuffA/b/+S72/4n39X2f576axfb/3nqr51t/+epj3a0/U++ve1/8vG2
/8nfZfs/T/21je3/PPXX1rb/89Rfb7P9n6c+2sL2P/nmtv/J32T7n3wT2/95
6q+Nbf/nqb82tP2fpz7awPY/+fq2/8lfbfuffF3b/3nqr3Vs/+epv15m+z9P
fbSW7X/yNW3/k7/I9j/5CxPlY3nqr+fxiTz117/xqTz11zP4dJ766Gl8lvxv
+Dz5kzgmX/kTuGa++utPuHa++utRXCdfffQIjiX/La5P/hCOI38QN85Xf/0S
N81Xf92Lm+erj+7BLcl/hluT34Xbkt+J4/PVXz/CHfLVX7fhzvnqr1uxI/8e
7k5+M+5JfhPuna/++jbum6/++iYekK/+uh4n5KuPvooHk1+Lh5JfgxPJh/Go
fPXXAB6br/7qw0n56qMVeAr5MpxMvhSnkC/GqfnqrwU4PV/9NQ9n5KuPZuNM
8stxFvlMnEd+MS7KV39diEvz1V/TsSdf/XUe9uWrj87BIfIpeA35GXgd+Wl4
fb766xS8IV/9dSLelK8+Oh5XkR+Lt5J/EW8nPxLvzFd/TcTV+eqvz+M9+eqj
Q/B+8oPxQfJP48PkB+Ij+eqvA2z/56u/9rP9n6/+2sf2f776aG/b/+Qfsf1P
voftf/Ldbf8XqL92tf1foP7axfZ/gf63s+1/8h1t/5Nvb/uffLzt/wL117ts
/xeov7ax/V+gPnq77X/yt9n+J9/C9j/5m23/F6i/3mT7v0D9tYnt/wL11+tt
/xeojza0/U++ge1/8tfY/id/te3/AvXXurb/C9Rfr7D9X6A+epntf/K1bP+T
v9j2P/mLbP8XqL9eSJJHFai//oPHFqiP/o2TyJ/BU8j/gZPJ/4ZTCtRfT+LU
AvXXn3F6gfrrTzijQH30KM4k/z3OIv8tziN/CBcVqL9+hUsL1F+/xJ4C9dG9
2Ef+cxwi/xleQ34XXleg/voxXl+g/voR3lCgProNbyL/Pq4i/x7eSn4z3l6g
/voO3lmg/vo2ri5Qf30T7ylQH30d7yf/Kj5Ifi0+TP4lfKRA/TWMjxWovwbw
iQL1US8+Rb4CnyZfhs+SX4nPF6i/FuOYQvXXAlyzUH00F9cuVD4b1yG/HMeS
X4rrF6q/LsZxheqvC3HjQvXX+bhpofroPNyc/Bzckvws3Jr8DNy2UP11Go4v
VH+djDsUqo9OxJ3Jj8eO/BjcnfyLuGeh+utI3LtQ/XU47luoPvo8HkB+CE4g
/wweTP5pPLRQ/XUgTixUf33C9n+h+ms/2/+F6qN9bP+Tf9T2P/lHbP+T72H7
v1D99UHb/4Xqr11t/xeqj3ax/U/+Ptv/5Dva/iff3vZ/ofrr3bb/C9Vf77L9
X6g+2sb2P/nbbf+Tv832P/kWtv8L1V9vtv1fqP56k+3/QvXXJrb/C9VHr7f9
T76h7X/yDWz/k7/G9n+h+uvVtv8L1V/r2v4vVB+9wvY/+cts/5OvZfuf/MW2
/wvVXy+y/V+o19PzE+RjhXo9/AufKNTr9+/4FPkT+DT5H/HZQr1efovPF+r1
7iCOKdLr2z5cs0ivT5/h2kXK78R1yH+IY8m/h+sX6fVoE44r0uvPW7hxkV4/
XsVNya/BzckHcUvyFbh1kV5fSnHbIr0+FOL4Ip3fs3EH8pm4M/lF2JGfh7sX
6fyfgnsW6fw9Hfcu0vl6Iu5bpPPtWDyA/As4gfzzeDD5wXhokc6vT+HEIp1P
++FRRTof9sZjyT+Mk8h3xVPId8bJRTpf3otTinS+uwunFul81Rqnk78VZ5C/
CWeSb4yzinQ+uw7nFel8dDUuKtL5pw4uJX8p9pC/CPvInx8vh4p0vvkLrynS
+eI3vK5I54cTeH2R9vePeAP5b/Em8gdxFfl9eGuR9v9neHuR9u9OvLNI+/VD
XE3+PbyH/Ca8n/xb+GCR7i+9ig8X6X7SGnykSPeDAvgY+Qp8gnwpPkW+AJ8u
0v2ibHy2SPd7MvH5It2vWYhjinV/Zh6uWax8Cq5drPw0XIf8RBxbrPsxY3H9
Yt1/GYnjinX/5HncmPxg3JT8QNycfD/cslj3S3rj1sW6P9IDty3W/Y2uOJ58
Z9yBfHvcmfxd2BXr/kdr3L1Y9y9a4J7Fuv9wE+5drPsNjXFf8g3wAPJX4wTy
dfDgYt1fqIWHFut+wkU4sVj3A86Pk0eRP4PHkv8NJ5E/gacUq/8fxcnF6vvf
4pRi9fWDOJX8XpxO/jOcQX4nzixWn9+Gs4rVx9/DecXq05twUbH685u4lPyr
2EN+DfaRD+BQsfpyBV5TrH5citcVq98W4PXks/EG8pl4E/mFuKpYfXYe3lrM
7wlvL1b/nIZ3kp+Iq8mPxXvIj8T7i9VPn8cHi9Uvn8GHi9UPB+IjxeqD/fAx
8o/iE+R74FPku+LTxep/9+Gzxep77fH5YvW1u3BMifK345olyrfAtUuUvwnX
KVE/ux7HlqiPNcD1S9SnrsZx5K/AjcnXwk3JX4Sbl6hv/cP3UrcsUV86g1uX
qO/8htuWqN/8jOPJH8UdyH+LO5P/CrsS9Zm9uHuJ+stnuGeJ+sfHuDf5bbgv
+ffwAPLv4IQS9Y038eAS9YtX8dAS9YOXcCL5AB5FvgKPJb8SJ5WoPxTgKSW6
/s/GySW6fl+KU0p0vb4Qp5Kfh9PJz8IZ5KfhzBJdn0/EWSW6Hh+D80p0PT0S
F5F/HpeSfwZ7yA/EvhJdP/fDoRJdLz+K15To/Z0eeB35rng9+fvwBvLt8aYS
vZ/TFleV6P2b2/HWEr3/0gJvL9H7J03xTvLX42ryDfAe8rF4f4neX7kCHyzR
+yO18OESvR9i38N+hPw/fI/7MfJn8Anyp/CpEr3/8TM+XaL3L47isyV6v+Iw
Pk/+KxyzUvm9uOZK5atx7ZV6f+JjXGel3o/YhmNX6v2EKlx/pd4PeAfHkX8T
Nya/Djcl/xJuvlLvFwRwy5W632/fa996pe7Xr8RtyRfgePJZuAP5pbjzSt3P
X4jdSt2PT8XdV+r++yzck/w03Jt8Eu5LfgwesFL320fihJW6Xz4UD16p++PP
4KErdX97IE4k3xePIv8oHku+B05aqfvfDk9ZqfvX9+Hklbr/3B6nkG+LU8nf
jtPJt8AZK3V/uinOXKn7y9fjrJXqow1wHvlYXET+ClxKvhb2rFR/jcG+leqv
/4yWQyvVX//Ea1aqj57C68j/jNeT/wFvIH8Yb1qp/voVrlqp/voF3rpSfbQa
byf/Md5J/gNcTb4K71mp/voO3r9S/fUNfHCl+ug6fJj8S/gIeT8+Rt6DT6xU
f12JT61Uf83Hp1eqv2bhs+SX4vPkF+CYUuVTcc1S9ddZuHap+utUXKdU/TUJ
x5aqj47B9cmPwHHkh+LG5J/BTUvVX5/EzUvVX/vilqXqo4/i1uQfwm3JOxxP
/j7coVT99R7cuVT9tS12peqjt+Pu5G/BPck3xb3JX4/7lqq/XosHlKq/xuKE
UvXXK/DgUvXRS/BQ8jE4kfw/L8qjyP+Jx5aqv57CSaXqrz/jKaXqoz/gZPKH
cQr5r3Aq+S9weqn6azXOKFV//RhnlqqPfoCzyFfhPPLv4CLyb+DSUvXXddhT
qv66GvtK1V/9OFSqPurBa8iX4HXk8/F68ll4Q6n66xK8qVT9dQGuKlUfTcVb
yc/E28lPxTvJJ+HqUvXX0XhPqfrrCLy/VH10KD5IfhA+TP5JfIR8X3ysVP21
Fz5Rqv76ED5Vqv7q8OlS9dFO+Cz5e/B58m1xzCrlW+Gaq9Rfb8G1V6m/NsV1
VqmPNsKx5K/F9cnH4jjyl+PGq9RfL8FNV6m/xuDmq9RHz42SW5L/E7cmfwq3
JX8cx69Sf/0Bd1il/noYd16l/noAu1Xqo1/g7uSrcU/yO3Bv8h/gvqvUX6vw
gFXqrxtxwir10TfwYPLr8FDyq3EieT8etUr91YPHrlJ/LcFJq9RH8/EU8lk4
mfwSnEJ+AU5dxf/i9FXqrzNxxir116k4c5X66AScRX40ziM/AheRfw6XrlJ/
HYQ9q9Rfn8S+Veqjj+MQ+V54DfmH8DryD+D1q9RfO+ENq9Rf78GbVqmP3omr
yLfCW8nfgreTvxHvXKX+2ghXr1J/vRbvWaX+ehXev0p99HJ8kPwl+DD5/16Q
j5A/h4+tUn/9E59Ypf76Kz61Sn30OD5N/gd8lvw3+Dz5AzimTP31C1yzTP31
U1y7TH10B65D/gMcS/5dXJ/8RhxXpv76Bm5cpv76Cm5apv66GjcvUx/145bk
y3Fr8iW4Lfl8HF+m/roCdyhTf12CO5epjy7Ajvxc3J38TNyT/FTcu0z9dQLu
W6b+OhoPKFMfHYETyD+HB5MfhIeSfxInlqm/Po5Hlam/9sJjy9Rfu+OkMvXR
B/AU8p1wMvl4nEL+Tpxapv7aCqeXqb82xxll6qM34kzyjXAW+fo4j/xVuKhM
/fVyXFqm/loTe8rUR/8bKfvIn8Mh8qfxGvK/4nVl6q/H8foy9dcjeEOZ+us3
eFOZ+ugBXEV+D95K/lO8nfwOvLNM/XUrri5Tf30X7ylTH92I95Nfjw+SfwUf
Jr8aHylTf/XhY2Xqr+X4RJn6aAk+RT4Pnya/Ap8lvwSfL1N/Tccx5eqvc3HN
cvXXmbh2ufroFFyH/AQcS340rk8+EceVq78+hxuXq78Owk3L1UcH4ObkH8ct
yffCrcl3x23L1V8fwPHl6q+dcIdy9dF43Jn8ndiRb4W7k2+Oe5arv96Ie5er
vzbCfcvVX+vjAeSvwgnkL8eDydfEQ8vVX/8bISeWq7/+jUeVq7+exmPL1Ud/
xUnkf8JTyB/ByeS/wSnl6q9f4tRy9dc9OL1cffRTnEH+I5xJfivOIv8uzitX
f30bF5Wrv67HpeXqo69gD/kw9pH34RD5crymXP21GK8rV3/Nw+vL1V9X4A3l
6qOL8Sby6biK/Fy8lfwMvL1c/XUK3lmu/joBV5erj76I95BPxPvJP4cPkn8a
Hy5Xfx2Aj5Srvz6Oj5Wrjz6CT5Dvjk+RfwCfJt8Rny1Xf43H58vVX+/EMR71
19twDY/6aHNc06P8jbgW+Ya4Nvn6+HKP+utVuI5H/fUyXNejPloTx5L/L1Gu
R/5vXJ/8adzAo/76K47zqL/+hBt51EeP4Mbkv8FNyH+Jm5Lfg5t51F8/xc09
6q8f4RYe9detuKVHfXQzbkX+bdya/Hrchvxa3Naj/hrG7Tzqrz4c71EfLcPt
yRfjDuTzcCfyy3Fnj/rrYtzFo/6ajp1HfXQO7kZ+Bu5OfgruQX487ulRf30R
9/Kovybi3h711yG4j0d99Gncl/wA3J98HzyA/CN4oEf9tTtO8Ki/dsGDPOqj
HfFg8vF4CPk2eCj52/Awj/prc5zoUX9tgkd61Ecb4lHk6+PR5OviseQvw+M9
6q81cZJH/fXCcHmSR/31bzzFoz56Gk8jfxInk/8JzyR/BKd41F8P4Tke9dcv
capHfXQPTiO/C6eT/wgvJL8VZ3jUXzfjJR7117dxpkd9dD1eTn4tziIfxjnk
fTjPo/5ahgs86q/FuMhDDpd41EeX41Lyi3EZ+XTsIT8HV3rUX2dgn0f9dTIO
eNRHx+MQ+RfxavLD8RryQ/Baj/rr03idR/31CfyaR320D15P/hH8JvkH8Qby
XfBGj/prR7zJo/56N97sUX9tg6s86qO34S3kb8ZbyTfB28g3xNs96q/X4B0e
9de6eKdHffQyvIv8xbia/IVh8m7yf+M9HvXXP/Bej/rrSbzfoz76Ez5A/nt8
kPwhfIj8l/iwR/31c/ydR/11Fz7iUX/9CB/1qI++j4+R34yPk38bnyD/Oj7p
UX9di0951F/D+HeP+qgXnyZfhs+QL8Znyeficx711+X4vEf9dTG+4FEfnY9j
KpSfg2tUKD8D16xQfjKuVaH+Oh7XrlB/fRFfXqH+OhzXqVAfHYLrkn8ax5J/
Atcj3wfXr1B/7YkbVKi/PojjKtRHu+BG5DvgxuTvxk3It8FNK9RfW+JmFeqv
N+PmFeqjTXAL8nG4JflrcCvydXHrCvXX2rhNhfrrxbhthfrrhefldhXqo2dx
PPk/cHvyJ3EH8sdwpwr11+9x5wr110O4S4X66H7syH+Ou5HfhbuT3457VKi/
vo97Vqi/bsa9KtRHN+De5F/HfcivxX3Jh3D/CvVXLx5Qof5ahgdWqL8W4QTy
uXgQ+eV4MPkMPKRC/XU+Hlqh/joHD6tQf03GiRXqo5PxSPLj8Sjyo/Bo8sPx
2Ar11yF4fIX6awJOqlAffQJPIt8HTyHfE08j/yBOrlB/7YJnVqi/dsApFeqj
d+M55NvgVPItcRr5m3F6hfprE7ywQv01DmdUqL9eg5dUqI9eiTPJ18bLyV+M
s8j/O1TOqVB/PYvzKtRf/8AFFeqjv+Ai8sdwCfnvcSn5r3FZhfrrfuypUH/9
HFdWqI9+gn3kt+MA+fdxiPz/8OoK9dcNeE2F+uvreG2F+uvLeF2F+mgIv0be
i9eTX4XfJF+EN1Sov+bijRXqr8vwpgr10Qy8mfx8XEV+Nt5CPhlvrVB/nYy3
Vai/jsPbK9RHR+Ed5IfjneSfxbvIJ+DqCvXXJ/DuCvXXx/CeCvXXnnhvhfro
g3g/+fvxAfId8EHyd+NDFeqvd+DDFeqvLfF3FeqjN+Mj5G/AR8nH4WPkr8HH
K9Rfr8QnKtRfa+OTFeqjF+NTnI/+eU7+nfPJKXya88FRfIb9/xU+y/6txufY
r9vwefbbO/gC+XU4plL5AK5Ryb8PgmtW8u994FqV2k8LcO1K7YdZ+HLySbgO
+RG4LvlncGwl/54Frlep5/tDuH6lnq/34Qbk2+I48rfgRuSvx40r+fcacJNK
/v0F3LRSz79/hsjNKvX8OYWbk/8BtyD/FW5Jvhq3quTfF8CtK/X8eAe3qdTz
YR1uS96P25FfiePJZ+H2lXx/Pu5QqfsVs3CnSt1vSMKdyY/AXcg/gx35vrhb
Jd8Pj7tX8n3vuEel7ge0xT0r1f9vwb3IN8K9ycfiPuQvwX0r+T7zZ+X+lerr
p/CASvXzH/BA8gdwAvlqPIj8B3hwJd/XjYdUqn+vw0Mr1Z/9eBj5EpxIPguP
JL8Aj6rk+6jx6Eq+XxqPrVS/HYHHV6rPDsJJ5PviSeQfwlPId8LTKvW/bXFy
pfrnLXhmpfpmI5xCPhbPIX8JTiV/brCcVsn3A+P0SvXJH/DCSvXBAziD/Kd4
CfkPcCb5jXh5Jd9/i7Mq1ff8OKdSfa0E51Wqn63ABeQX4CLyM3EJ+Qm4tJLv
a8VllepTg7CnUv3pcVxJ/iHsI98JB8jfiUOVfB8pXl2pftQIr6lUv7kKryV/
CV5H/twz8mvkf8XrK/m+TfxmpfrLAbyhUv3jU7yxUn1jK95EfiPeTP4VXEXe
h7dU8v2QeGul+sEKvK1SfSAdbyc/E+8gPwHvJJ+Id1Xy/Ye4ulLX74/j3ZW6
Xu+O95DvhPeSvxPvJ98cH6jk+/3wwUpdj1+FD1XqeromPlyp6+Fzg+TvyP+K
j5A/go+SP4CPVfJ9dPh4pa53t+ITlbq+fRufJP8KPkXeh38nX4xPV/J9a/hM
pa5H0/HZSl1/zsDnyE/A58kn4gvkn8YxXr5PDNfw6vqyO67p1fVhR1yL/J24
Nvnm+HLyDXEdL9+Xhet6+f4rHOvV9dvfT8v1vLpe+xXXJ38ENyD/JY4j/ylu
5OX7nXBjr67H3sZNvLr+egU3Je/DzcgX4+bkV+AWXr6/CLf06n7/DNzKq/v7
43Fr8om4DfmncVvyfXA7L9/Pg+O9fN8Obu/V/fc2uINX98+b407kG+LO5Ovi
LuRrYud1g/58+8CSvxPkbl43MmP4swdP4u6R30+vWfPvPIJ7eN23V+SG077E
Pb3ul7LOrffswr28bvXQAf1v3Yp7e/m+FNzH66a8ce0/H6/Ffb2u3fQ7brrR
h/t7+X4SPMDr/vn45EfvL8cDve7S54p6X5uOE7x8Hwge5HXVrz/959vj8WCv
Wz514vVXJuIhXr5/Aw/1uoQd7ba+2gcP87prM3sdr9kdJ3rdTTeeHjuwIx7p
dd8cjvwC2uBRXldaefPb52/Go70udM8n9/VpiMdGfp9/HXm+oi4e73WTliw/
8vvFOMnr2vYOXN7j76fkSV6+nwFP8bq/PS+8fvx7PM3r3ho298v7v8TJXr4P
Ac/0utS3XNp37+MUr4suJ/5tPMfL9w/gVK8bWP7Sy/u9OM3rrnn+/c9vL8bp
Xv6+P17odV+/kZ5SPR9nRJ5v0yO/gRl4iddFVnPL1PE40+sSdz776PbheLnX
NYsO5Gmc5XV3RH/BfXCO1/38XftGVQ/iPK/7a+rh0qs74gKve+Pes1sS2+Ai
L38fHJd43ZzMt8dc1hCXel3nPp9lD66Ly7z8/Wvs8bpLvDmdLvp7oFzpdVe3
7/y//iexz6v7h9/jQOT3GfnP/70fh7wu8mzM7LULr/bq9fV9vMbrhlXsjf91
A17rdU2HnxzUbS1e53W3nyn8OteLX/O6n9565eIfi/B6rwvO+PC2Tsvxm173
ep2Ja5bOxxu8LmlXxu5DyXij16U83+7JtuPxJq/rFN3Aw/HmyO8z8nTcm4Cr
vO7i5Cuat+yDt0R+nx0jD3gQb/Xq9bUD3uZ10afvjW3wdq8ruCky0JvxDq/6
axze6XX1/P9777q6eJfX3dDhhe4vXoyrvXp9PfukvNvrfsxs+cuVJ/Eer/P3
iTwlv8d7ve7Vb3/Kf20/3u91470XbbpkFz7gda1HNPwu4X180Os6RJ4uqzfg
Q14XPd39+zI+7HUXPZZ+5eNe/J3XvVu39O7KInwk8noQPaEsw0e9Lnp67DEf
H/O6yLO9RkkyPu7V6+s4fMLrYme2f6nLcHzS666/8vAdWQn4lFf99TH8u9cV
Zl01s/2D+LTXeSOnl0Ud8BleX+/AZ71ubPJMf+ub8Tmva9Up5+O5cfi8V/31
SnzB6/5Y/sSU5hfjGJ97te+YkulnB8g1fO5/39e/4aNfcE2fi/zXH2z8Pa7l
cws77P1g3H5c2+e6n/vl56pP8OU+V2PTJfXqv4/r+Fzdx1/JG7EB1/W5j2M/
3LjhZRzr0+urF9fzufwRkd9wEa7vc/1v9Sxetww38Km/zsdxPtc4+oRPxo18
ruVVV7wRGIcb+/T6Ogw38bnfhkdOSAm4qc+9csuR+WWP4WY+9dduuLnPRX+9
D3bALXwuenoouAO39Llun4784sdmuJXPxWTP+adTHG7tc5HdNSfzStzG5z76
4QHfNzVwW59bFHxqR7uzT8jtfC63U+QZ+QuO97m+5+Mm7/sOt/fp/eb9uIPP
Nep34PqUT3CnyO+z3u9dP92CO/vUXzfgLj5XEXk5mfwydj738rnB4z6oxN18
ev+4CHf3uWmPN2kwehnu4XPx0RNkGu7pU39Nxr187sKIyBlmHO7tc+/cGhnI
MNzH5yLTX1YrAff1uQUpkQ32GO4f+X12Ofblmm54gM9FT98X7sUDfa5O5PKj
3x04wefiWjxxibcZHuRzX/w4+vYz1+HBPr1/eiUe4nPlkcuVkhp4qM89e+HB
c7/81V8e5lN//QUn+lz0P5/zHR7pc+2Orr3lyD48yqf3Qz/BoyO/zxcPTVyy
BY/1ucjuPf3VW3i8T/31ZZzkc/P7PbIqtRJP8rn/fwEuxFN8Lnp5cMsyPM3n
Lh/VbGxyGk6O/D5vi2z46Ximz32+KbKBx+EUn4s+HZOG4Tk+t+rqyAn5KZzq
c89EH/AYTvPp/cBuON3nok/ft+/FC33uu8jpt84dOMOn/toML/G5l7o89cyr
1+FMn3vrs5hDNa7Ey316f68Gzor8Pp9s2yr8Vz85x+ei4z93Auf51F+/wwU+
V/v+lU+W78NFPvfBhddm/b4Tl/hc9Ony4BZc6nMrIqe7wrdwmc89Fr3AW4M9
PpcQvWCrxJU+12D0Y38sL8Q+n2v275mphzNxwOcOb468QKThUOT3mdpiy8Lp
eLXPha+p7r5/LF7jcy9En5DD8Fqf+utTeJ3PRVZ/TXVv/JrPRU8vN3XD6326
P3wvftPnNkQu7z5sjTf4XORqbUTDZnijT/31OrzJ55ZFXk4318Gbfe7RyOXg
1TVwlU/3k//qK2/xufoPbDv4xgm81ed2R8Z32Xd4m88dyl20YNA+vN3nItN4
6eWdeIfPBY/1bPPfe3inz42IFoK38K7I7zP6grUGV/tcm/9u+vdMBd7tcyeq
IhcghXiPT/01E+/1uWh9ODkP7/e590K+Pm46PuDT/eGx+KDP3R/Z7kefx4d8
rue7s2/o8BQ+7FN/7Y2/87l60V9AV3zE56q/GHjiznvxUZ/uJ7fGx3yuuFVc
/p6b8HGfe+rEne/ceh0+4XPDI5frM+rgkz7XtGvkFegifIrn38nH5d99bk9k
nN/tx6d9LvrymfE+PsPzaS0+G9mPCde99VkRPsfzZT4+H9lvNUpqXz8eX4ic
rxZ8NOC9BBzj5/1EXMPv5t8ZOeO0wTX9mm8cruXn/Ttc26/5/dJHvtzvVqdF
Tmj7cR0/75fhun7N42Uc63cbIpe7mUW4nl+/7/m4vt89+nTkimMcbuB3kWdn
ekoCjvO7yLNzyY0P4kZ+F41/cAdu7HeRq+WvRsXhJn4XHc9VF+Omft0f/+Ux
uZnfRceVsB8397t/Ii+PF7bgFn7dH38Zt/S75bVONehZhFv5XfRy6ec03Nqv
+93jcBu/6xi5fIpPwG39bn2krh7ohtv5df/6Dhzvdw9HL9DjcHu/27IwcsFQ
A3fwuwNrIi/gv/SWO/ld9HR6zX7c2a8+vAV38bvo6XXwy9j5XWLkcvbiItzN
72ZFnwBpuLvf/VUrUrjH4R5+3e99Cvf0uyXrIhfk3XAvv7skeoFwB+7t1/3e
63Afvyv6OnICqYH7+t26i6NX/I/K/f26f7sPD/CrT27BA/1uc9vIjnsZJ/h1
P7YQD/K76OXQ82l4sN9F6+el4/AQv4tc7X2y+ik81O+eu3RXw37d8DC/+2rJ
vyP+ao0T/e73dZEL5OvwSL8bHx9p2DXwKL9bOCjyAnqilzza7y6KPiH34bF+
9bEteLzf5UVOn5+vwUl+F71cnVGIJ/l1/zINT/G7yvWRwjsWT/O7jZH6MuIp
nOzX/chueKZf/ag1TvG77ZdGXjCvw3P8ur94EU71u2deffdE2YlH5DS/2xf/
a4eH9uF0v4u01S7H3sML/W505PJm+Rqc4Xc/ROpkfCFe4nf/Ri539s3DmX4X
rZdzxuLlfpd11/Q7bnoKZ/lddPkfdsU5fvWL1jjP78qG3PZx7HW4wO8aRk94
F+Eiv+6vnegpl/hddLvH7MOlfrf11Tbjve/hMr/ur63BHr97J3I5eqoAV/rd
54cOX5E7D/v8ul82Fgf8uj82EIf8uh/WFa/26/q8NV7j1/2uBnit30V+uw9P
ugiv8+t+1omH5df80Vf3onf24vV+Fzl7lw15D7/p1/2pNXiD32VH6uJLBXij
X/ef5uFNftc8egE6Bm/26/7SQFzl1/2krniLX9e3t+Otft0vaoC3+d0HKyID
vAhv9+t+0M895B1+fR5uL97pd0nRDfYe3uXX/Z2XcLVf15sFeLdf92/m4T1+
9/dVP731yhi816/7MwPxfr/uxzh8wO9830Qu0G7HB/2639IAH4q8nh29IXgs
Bh/2637Kzw/J30Vez7I8Z+/ai4/49fmkKnzUr/sjL+Fjfl2vFeDjft3/SMUn
/C5aD0ePwSf9ur8xEJ/y6/14h3/3u+jtgqdux6f9ul9xLT7j1/vrMfisX/cj
fu4un4u8nkUP8AU+79f9hip8wa/7Cy/hmICud/JxjYDuH6TimgEXvX3TYgyu
FdD9gSdx7YCL3s6Z4PDlAb1/fTuuE1DfvxbXDbgeeWdqPReDYwPq8z8/KNcL
uOjLb+gLXD+gvl6FGwTUz1fjuIA7Fql7hfm4UUD9OxU3Duj94tG4SUD9+knc
NODqRl9QHG4WcC2iLxCtcPOA+vK1uEXANY4+gWNwy4D68PFucquAi16uDf8C
tw6o71bhNgH129W4bUDvx+bjdgH117k4PuD6jSmZXjoatw+onz6JOwTckcg4
fngAdwq4SNvbldEKdw6ob16LuwTc710jz8j/usouoD55HHcL6P3PL3D3gPri
u7hHwEWudi8btRr3DLi20YKfj3sF1P/m4t4Bd2v0gmU07hNQvxuA+wbcxsj2
9TyA+wfU31rhAQH1tfp4YMBtL3qnIOs/JycE1MeO40EB90z0F7wHDw6ob72L
hwTcyZ8jBWM1HhpwtaIbIA8PC6g/zcWJARe9/VJvNB4ZUD8agEcF9H7eA3h0
QP3nNjw2oL5TH48P6Px74QE5KeDGRG8Af44nBdzz/1+I8ZSA+vscPC3gMiKX
D5uewMkB9evb8MyAW7v/uWmPX+gipwR0PvwczwmoX4RwasBF3/5oMwenBdQf
nsDpAfWFlnhhwDXdPeG5Sy/cL2cE1Ac+x0sCLnq68YRwZkDX+7Px8oA+n/ME
zgqoH7XEOQFdv//bWc7jfPI5Lgjo+jyEiwJu2uHSq/2zcUlA19/9cWnAld4d
uYJqicsCbufcSAP89z7ZE9D19G5cGXBvRy4HGoSwL6Dr5dk4END7P/1xKKDr
4Vvx6oCuf//tJK9hP+7GawO6vg3idQG9HzIbvxbQ9Wt/vD6g9ytuxW9G9nP0
DZPzHeUNAV2P7sYbA3r/PYg3BXS9mYI3B3T/vj+uCuh68la8JaDrx/Md5K08
nz/D2wK6Pgzi7QEXudr4LDsF7wjo+q8f3hnQ/eZb8a4A3+95r1wd0PXcZ3h3
wMVG3wAJ4j0Bvo8S7w3o/ms/vD+g67EW+EBA11/n28sHAy4zcjk44TN8KKDr
qwA+HNDfN0nB3wV0/dQPHwnofmELfDTgom+3HP7nHvlYQNdDn+HjAbepIPIC
G8AnArremYVPBnT/rB8+FXD7T53u9XQL/HtA97f+iZdPB1z09uTP1fhM5L9/
SeSEFcBnA25m9AbgLHyOfF983v77+ELARevOgX/ulmOCbsK8mh+s+AzXCPL8
wTWD2u9zcK2g+uCTuHaQvo0vD+r1tDauE1Q//aGdXDeo6+1tODao8+FaXC/o
mkRvwJXh+kHdP1iJGwTd3oGRBh/EcUE3e+2bw+Z+hBsFdb1ai+M3DrqKs3cd
XTsCNwm6HyOXfz1P4qZBvT8Z5PfTLKjzbzHzaB7U58u2M/8WQZ3fOvB8bsmf
72f2T6ug6xI5O93zNeeD1kHdb7qU82eboHskesOwDa8HbYO6PhjF61u7oIte
Ti73d5Pjg+pPB7neaB/U+0sXcf3XIeiit/Pa1+F6tlPQPRbdcKdx56Duz2/g
er1L0N0TLSCD6B/O5oO7BV3VM027/jaGftU96G6LXsDVpi/2CGp/foN7BnU/
vqH1/6C7KnrC/ZH7E72D7uroArtwv6tPUO93XcL9375Bvh+K90P6B120jnYe
yvuzA3g+2ud3Bgb5+7d8fjMhqM/HdhomDwpyf4q/Xzo4qOvrGL5vY0hQ11sN
7fvXgvo85518/+qwoPpkln0fe1DvL//Av88wkrz9e26jgvr85FE8Oqj7j8n2
77Xy59uAxwf19/fs3+9NCur69yE8KajPb/jt33MM6vMo9u+lTQvq81bn7N93
CerzVc3xzKD+fo19X35KUJ8PaIrn8OftZN//HtTn207gNOaRYP8eVFD3u1by
51sY1Od5P54uZwR1Pj8zS14S1N9PWp4qZwb192GK5svL+e9dsUjO4s//2RI5
J6jPU+5cLucF9fdHxmTLBUFdnw7PlYv4eft8uYTf96f8OySlQV3/X1cklwV1
vfYf9gT1+dtkvse1kv/+bOxjv12BA/z3b+fxoaA+r3KU463m992HP88a/nzT
+fOuDer9zumsZx3exnpfC6o/lvP7WM9+KVsov8nxD6fJG5jnqTnyxqDe7zuW
LG8K6v17+/dHNwd1/2eVff81+2k438exJai/H5fN38/Yys//4vNC24J6v/QH
9u/2oNs/b3KPvCbcD9vB86cD56udQV3/n+P6ZVdQ/1vN+bo66J6IfoDgrlby
7sjP1yZ+2KNvM3lPUJ9fOtpQ3hv58/fzPH4kXE/eH3Rb4uvceHXuFfKBoOsz
85uzB/6oKR+MPD+v3dYgbXCMfCjoorc35jc598D/+3DQXdwi6efxTf6Uv4uc
7z9duWRA3G/ykUj+4yvWrejzs3w06P64KdTof41+kI9FXq/GvvrVC/mH5OOR
8+mkNh88OeJz+UTQxd/+1aJNP1TJJyNu36rFLX9Uvvv/PhU5P/U+N+u2zjvk
3yPnl8vLuq3ds08+HXSNC2rNGfDgt/KZoMt+87dbW608Kp8Nuh/qfHDDhN9/
ls8F3dllr9z/uu+UfD7oOr79TUXLvn/IF4KudtM3Fuf+86ccE3Ijttz55x+B
s3KNkHs/MfqGzT9yzZDL+Thywfzvv3KtkDvb/t8vVwyIqfp/1w65WzM2XuVW
XyRfHnJPfjn9oVP/1ZDrhFx6q3tmeZ6sKdcNuRNf3/jrky9dIseGdL666FK5
Xsg9kloy6M2BteX6IZf82VNZI9dcJjcIuWCzyEBrXCHHhdzeybv/2fZUHblR
yN1/6/8mpLx8pdw4pM9HXHyV3CTkPjmyctz41rFy08j6l83M6LEPNwu58/c8
7W2SdrXcPOQiw3/279b15BYh93CHO5I/24dbhtQH0q6RW4XctMXHX553R325
dcjVbffR9qf34zYh997SzWnx86+V24bc0/GrVtVp00BuF3KnDs7acGQ/jg+p
782/Tm4fcje26Xgyr02c3CHk3tx73WXjvsSdQm502yvffzi9odw55Gp8+fPX
N97ZSO4ScsXzdpz960vsQnr/Mf16uVvIbd+9qE3ozsZy95BLaT37WNoB3CPk
rvnimYufWXCD3DPkVs/u1OTutk3kXiHXrUXDjld8hXuH+L7JG+U+IbfhvjFv
PRvXVO4beX4dG1H/43G4f8gd6vzFTfe+jweEXKvs7nd6426SB4bc1B9e73zV
eJwQ0v249/GgkO7vxTWTB4fcj52WrR8wHg8JuXYrzr9X9T4eGnJzvh/zaeuG
N8vDQm7HvV8dLBqPE0POd+SLjrW24pEh3b9t2FweFdL3CYzHo0Mu+nGyx7bi
sZH5pKdUv97wFnl8SO8PTsBJId1P34onhfR5o4Yt5CkhfV5qAp7GvLbi5JDu
lzS6VZ4Z0vsbE3BKSK9nH+A5Ib3/0qilnBpyL336xcATE3BaSJ+P/ACnh9xz
0QvARrfJC0O6v5aEM0J6Pf8ALwm5149PfuPa61vJmSG9X5eEl/N8+ABnhXS/
8/rb5ZyQ3q9Ownkh3Y/dhgtCrmu0wF3fWi4KuQFTmhf+l4RLQu7Pr/bNm7wN
l4bUd66/Qy4Lqd9NxJ6QPp+yDVeG+H7/NrIvpH40EQdCLi3ycndmGw6FdP3T
+E55dci1jxbiiXhNSH35Q7w2pM8/1G0rrwvpfndH/FrIPR79AMhwvD6k++nL
8Zshd1vk19P2bbwhpPv13+ONkedj9A2DunfJm0K6Pu+IN4f0/kEirgq5ow/4
vtm8HG/h+f023hpyVZHL8dZH8LaQPr9Ut528PaT3SzriHTz/E/HOkN6PWYF3
hfg8Nq4O6f2eI3g3++Oqu+U9IT5/jveyXxLx/pCL3q7uuQIfCPF5e3wwpPt1
R/Ah9tNV8fLhkO4HdsLfhfT5yER8JKT381bgo+y3jfhYSO8XHsHHQ7r/edU9
8omQPq/aCZ8M6f3LEfhUyK048vuNu1fg39mfG/HpEH//Bp8J6fPDV7WXz4Z0
P7kTPsf+HYHPh/R+cBa+ENL97Y04Jszfr8I1wtrfsffKNcPusiU3Dj/ZCdcK
a7+PwLXD7vv2jaqeycKXh/X++ju4TljvF/yA64Z1PojtIMeG9X7Efbhe2HkW
r/v2pxG4flifJ8jCDcI6X7yD48L6vMJR3Cis6+fYjnLjsIu+vZ18H24S1ucn
RuKmYf39+SzcLKzzyzu4eVjvNx3FLcL8e1Cd5JZh3d+5D7cK6/wzErcOcz2N
24R1/+gd3Das6+ejuF1Y56er75Pjw+61NuO9F3XG7cO6fzUSdwjr/lY27hR2
0dvzzTbhzmHdHzuKu4R1Pru6s+zCur/WGXcLu0eiH+gYibuH9fnLbNwjzL+H
jXuGXfT27g0/4l5h3f+7+n65d5h/Px73Cet8+ALuG3bR2ylns3H/sP4+zCY8
IKz7kz/igWF93qleFzkhrPubnfGgsD6P9QIeHNbnp3PwkLDun27CQ8NuXiQe
/BEPC+v+a70H5MSwPh93Px4Z1v3bF/CosIvefk3LwaPDuv/zPzw2rPvDP+Lx
YZ2PL3NyUtidHjtw9tomeFJY9yPj8ZSwPk/5CJ4W1vl6CE4O6/OaU/DMsPrU
YpwS1udBy/CcsM7n63Fq2EUuLk4t+AinhXV+P4TTw7ofcxovDOv+62Vd5Yyw
7tc1wUvCOv/H48yw/r7LI3h5WPePnsNZYX3edwrOCev1YTHOC+vzxOW4IOyO
579WZ+J6XBTW3wf6CJeEdb/5G1wadgcj22PeaVwW1uvJZd1kT1j3527ElWHd
z47HvrA+b/YIDoT1evMcDoX1efEpeHVY98sX4zVhfR69HK8N6/VoPV4XdsXv
/F9LdxzUZbXncdxcrxmSa2as4yVEx2tGjqOG5BjZk9eLimSKSl4jRNbUzHXM
kBwzIsc1Ra5DRKxrpuR4zd8553keMyTHzLiOa4TkmiHjNVJ0XDNzHCMkr3lx
f78+77+c18xnJucJec73e77nPFXl/9qA90b0fjqHayLan2rHtRH17+P+KO+P
aH9rAD4Q0fsrFR+MaH8sEx+KqJ82F9dFdN6gEB+O6P1Wio9EdJ5hOz4a0f5d
Da6PqF5swA0R7Vecw40R7Q/ewMcjeh/GTZBPRLS/OACfjGg/ZDRuimh/MhM3
R/S+nItPR3ReZQU+E9F+Syluieg8zHZ8NqL36T7cGvFiy6n/bsAXItp/PYcv
RtQvvIEvRVTvxf1JvhxR/zYZX4no/TsaX41ofzgTX4tofykfX4+of7QCt0X0
fi7F7RGdp6rGHRHtX+/DNyPev8U2ABvwLd7frfh2xFt77zNh5Q3cyfs8LkPu
YrS/noy7Gu2njcbdjPqTU3B3o/d9Pu5hvEWxBf8KHGe0X7cRxxvvVPR1tKQa
9zJaD+zDvY36qcdwH6P5g1bc13ix9v7fb+AEo/3DnhPlfkbzDcm4v9H6YTRO
NJqPmIKTjPr3+TjZeBXRH/dbK/Ago/XFRjzYeHf2vta2pxoPMZrfqMVDjbfk
nn9ULzyGU4zWH614mPH+PrfomaQOPNxoPdJzkjzCaL4kGY8y2o9Nw6lG8ylT
cJrReiUfjzGabynCY432ezfidKP7iqrxOKP1TC32jFcV/XXqjuHxRvXIeTzB
eP8S+4HpwBlG/Yiek+VJRvM9A3Gm0fonDWcZzQdNwVON9lfm4WlG+zVFONto
fbQRzzRebPx+7Ac4x2i/qBbPNtqvOIbnGK2fzuNco/vdOnCe0XoqPlPON5qv
GogLjO6nS8PzjeazsvACo/XWPLzIaL6rCC823j9GRguyMrzEaH/qA7zUaD1W
i5cZ7d804uVG9dR5XGi8Z2MDeh24yHgt0cebET9FXmk03zYQrzJav6Xh1Ub7
GVm42KgfMQ+XGM3XvYrXGK3vyvDa6PN8NvoT+QFeZzS/9wleb3Q+txGXGq3/
zuMy48WWmyN/wZuM6rf4LLncaL5wIK4w3iuxBctjuNJoPjELVxmtF+fhzUbz
ja/iLcaLHecKy/BWo/n1HXib0XryE1xtvCdjD7gR7zCav7yAdxrP+afnFv2C
dxmtN+OflncbnU8fhI3R+vMx7IzmQ7NwYLR/U4D3GM2Xvor3Gq1Py3CN0fmH
HbjWqL/zCd5vvBejy5tuX+EDRuvXC/ig0X7pL/iQUf1571S5znh/jB1YGYQP
G50neQwfMZrPfRofNVrvFuB6o/neV3GD8WLHHcf8BTcanZ/ZgY8brYc/wSeM
F1sOT/4KnzSaP76Am4z32583cbPRPMa9z8injfcf0eVz7SB8xmi/cwxuMdrf
fBqfNepnFeBWo/nqlfiC0XzIX/BFo/nsHfiS0fz2fnzZaL/2K3zFaP7kAr4a
fZ/FDoTcxNcM33+cJl/nv3cfbjPaP0/E7YbvUeIOo/X6SHyTv086vmX4Pia+
bVTvTcedRuv5XNzF8r1O3NVqnu5l3M3q778ad7da76/DPaw3L7Y8eRvHWa3/
t+J46/3XnfLiX3fhXlbzfR/h3tY7bv73VM5B3MeqPvgC97V8jxUnWM0PtuB+
1tsQfV30/B73t3wfFidaL7a8X3gbJ1n1J++eLidbvleLB1nNMybiwVb17UN4
iOX7uXio1fxSOk6xmpeciIdZnQ+Zjodb1SO5eET0ecYKhoV4lNU85ss41Xqx
x7thNU6zqlfewmOstzHWfnobj7V8HxmnW52P+RCPs5oP/Qh7lu814/FW9c0X
eILV+Y6vcYbl+9F4UvR5RpdH077HmVb1z084y/I9azzV6vzQ3dnyNKv5kj44
26o+SsQzrRf7513wEM6xqpdG4dlW/eJ0PMdq3nYizrXqF2TjPKt6KhfnR59n
7IDlQlxgNc+7HM+PPs9YQbEaL7Cqt97Ci6wXG19/uAIvtjr/tRUvsdr//RAv
tepn78XLrM6XHcTLreqzL3Ch1fmgk7jIan+jBa+0uh/ye7zKqn5rw6ujzzP6
17l+GxdbzRfdPUMusV7seoesPniNVX2XiNda9Ucewuus6r1ReL3V/OETuNRq
XnsiLrM6H5iNN1nVg8/jcqvzhQtxhdU8+HJcGX2e0R/f+1/HVVb14lt4s9X8
QgXeYnX+8X281XoJsQskPsTbrPrpe3G11fnKz/AOq/ryC7zT6nzmSbzLat7r
O7zb6nzn99hY1Z9t2Fn1g/6JA6t+/d0z5T3Wi21flPfBe63q0wdxjdX+zEO4
1qpeHYX3W51vfQIfsJr3n4gPWp2PzcaHrOrZ53Gd1fnahfiw1XmC5fiI1f3J
r+OjVvXuelxvvVj583EFbrDqV72PG633W0GyGx+36l/uxSeszhd/hk9a1cf1
uMnqfPJJ3Gy1P/EdPm2Zd8BnrOrnNtwSfZ6xAdx/4rNW+zs9Zsmt1tv+VfQF
1AdfsKqvH8QXrea/huJLVv2xUfiy1fnuJ/AVq/Mik/BVq/Ph2fiaVT3+PL5u
db58EW6zmo9bjtutF/v1sPV13GFVr6/HN62XGjsgVIFvWZ1/fx/ftl7sOOuM
3bjTqp7/GHdxmo/7DHd1qu/rcTen+ZRvcHenec3vcA+n8/2XcZxT/f8zjnfM
D+BeTvs9PXLk3k7399yP+zj1Bx7EfZ0Xe/2sGIoTnPp7j+J+TvttT+D+TvNy
k3Ci0/7/DJzk1E94Hic73a+wCA9yOs/0Ch7svFj7+/zreIhTv2E9Huq8vCnR
CuQdnOI0L/Q+Hua82HJl82483Kkf8TEe4TRP9Rke5dSfqMepTvdTfIPTnPa3
vsNjnO63uIzHOvUvfsbpTvdjdOJxTvO9PZ6VvejzHBB9Ad+Pxzv1N5LwBKf5
v6E4w6k/+Sie5Lz82D/gcTjT6bzaJJzldD/IDDzVqR+Sh6c5zSctwtlO5+Fe
wTOd7icpxjlO/ZL1eHb0ecaOm72D5zidt9uGc53my3bjPKd+ysc433k3Mv+8
bswhXODUX6nH853uZ/kGL3Catz6LFznd73IZL3bqv/yMlzjdD9OJlzrtF/aY
LS+LPs/YL5T78XKn/kwSLnTa3x6Ki5z6q4/ilc6LtfPmjMOrnM47TsarneYX
Z+Bip35OHi5xul/nRbzG6TzlK3it0/08xXidU79nA17vdL/5O7jU6bzmNlzm
vB+iy8GBEbzJqR/0MS53Xux6pdcP4Qqnfu6XuNLpfqJvcJXT/uhZvNnpfqMf
8Ban/tHPeKvTPF4n3uZ0X8M9f5arne67vx/vcOovJeGdTu/Xh/Eup/v9H8W7
nfpL47AhPxk78jNwQD4P73F6v76I9zrt/xTiGqd+VDGuJb8B7ydfiQ+Q34YP
Ot2PFcGHnPaLanCd0zzqIXyY/Jf4CPkmfJT8WVzvdL/XD7jB6f3ajhud6tdO
fNzpex73zJFPkO+LT5JPwk3kH8bNTu/XVHzaqX4dh884zc9Oxi3kZ+Kz5PNw
K/kX8QWn/dBCfNHp/phifMlpP2sDvky+El8hvw1fJR/B15z6cTX4Ou/Xz3Gb
U/36JW536sc14Q7y5/BN8j/gW+Tb8W3er3dwp1P9es9zchdf/bu+uKvP935w
N1/5h3F38qm4h6/50CdxnK/9tck43tf+70zci/xc3Jv8i7gP+ULc19d9g2/g
BF/v1w24n6/6tRL3J78dJ5KP4CTyNTjZ132Jn+NBvt6vX+LBvurXJjzE1/zw
OTyU/A84hXw7Hkb+Dh7u67x2XK48wtf9V33xKF/nzwbgVPIpOI18Kh5D/kk8
1lf/MhOn+3q/zsTjfNWvc7FHfjEeT74QTyD/Bs7w1e8sxZN8vV8rcaav+nU7
zvLV7zR4KvkaPI385zibfAOe6et+0iac42s/8hye7as/egXPId+Oc8nfwXnk
456X833dr9oXF/h6vw7A833Vryl4AflUvIj8k3gx+Uy8xNd9r7PwUl/v17l4
ma/6dTFe7mtebwUuJP8GLiJfileSfxev8jWfsB2v9nV/n8HFvs6D7sMl5D/H
a8g34LXkT+F1vvq95/B6X+/XK7jUV/16A5eRv4M3kY/Lk8vJP4ArfPWHB+BK
X/cTp+AqX/XraLzZ937708NbyGfireRn4W3k83G1r/uVF+MdvvZvV+CdvvrJ
JXgX+VK8m/y72JCvxs7XeQaDA1/7vfvwHl/1ax3eS74B15A/hWvJt+L9vvrJ
V/ABX/NcN/BBX/Vrl7nyIV/94ThcR/4BfJh8Mj5CPgUf9XWfyWhc7+t+bw83
+DqfnYkbyc/Cx8nn4xPkF+OTvubLVuAmX+cbSnCzr/p1Iz5N/l18hnw1biFv
8Vlf/eR9uNXX/ep1+IKv+vUYvuirP3wKXyLfii+T/xFfIX8DX/W1/uiSL1/j
efwOX/e1HonDbeR743byD+AO8v3xTZ5nMr7laz3zB3yb55uCO8mPwF0C5Ufj
rgH3veNugdY3Hu4ecD887hFovZOJ4wLuk8fx5GfhXuTn4N7k83GfQOulF3Df
QP//XsIJgdZPy3A/8itwf/Kv4UTyJTgp4P58nBxoPbURDwq4bx8PJv8uHkL+
PTyUfDVOCbQe+yseFujnw+LhgdZne/CIQD8v+/Ao8p/iVPJ1OI38/+AxgdZr
x/DYgO8R4PRA67dTeBz5b7FHvhWPJ/9/eEKg+YwfcUag9d91PCnQ/ZI3cCb5
X3EW+S7z5Knkf4enBVoP9sTZAd9rwDMDrQ8fwDkB33fAs8kn4znk/4BzyT+C
8wKtL0fg/EDz6KNxQaD14+N4PnkPLyD/J7yI/BS8OOB7FnhJoPXnLLw04PsX
eBn5fLyc/Au4kPxLuCjQ+nUZXhmof7QCrwq0nn0Nrw60X1OCi8n/Jy4hvxGv
IV+O1wZa376L1wV8HwSvD7Tercal5P+Ky8hbvIn8Hlwe6Psjtbgi0Hr5U1wZ
6PxmHa4ifxRvJn8MbyF/Am8NtH5uxtsCvp+CqwOtp1vxjoDvreCd5H/Eu8hf
x7vJd2ATaD3+K3aB5oG6FMhBoPV2d7yHfE+8l3xvXEM+AdcGup/h93h/oPV6
Mj4Q6PtXQ/BB8o/gQ+RH4DryafhwoPX+4/hIoH6bh48GWv9n4HryU3AD+Wm4
kXwOPh5oP+w5fCJQPZCPTwb6/tgC3BSoPngJN5Nfhk+TL8JnyL+GWwL180rw
2UD1xTrcGmj/bCO+QL4cXyRfhS+Rfw9fDlRvVOMrgc677sJXA9UfFl8jvwdf
J1+L28h/itsDzW/V4Y5A9ctRfDPQ/dTH8K1A9ckJfJt8M+4k/y3uEirfiruG
Op9yCXcLVd/8iLuHmn//Cfcg34HjyP+K48nf9e9yr1D1UXfcO1R/sifuE6pe
ug/3JZ+AE8j/HvcjPxD3D7V/OAQnhqqfHsFJoc4nj8TJoeqpNDyI/ON4MPmn
8BDyGXhoqP7nFJwSqh6bjoeF2m/MwcPJP4dHkJ+HR5FfgFND1Wcv4bRQ5wle
xmNC1WtFeCz513A6+TfxOPLrsBfqe5kb8fhQ9d7beEKo+bwqnBGqnnsPTyL/
Ac4kvwtnkbd4aqj+60d4Wqh6sBZnh+rHfopnkv8bziF/FM8mfwzPCVVPfo1z
Q/Vzm3FeqPryW5xP/jwuIH8Jzyf/I14Qqr/7E14Uqt7swItD9Xt/xUtC1Z93
zZeXku+Ol5HviZeTvw8XhuoXJ+Ci0Pvtz0S8MlQ/eCBeRX4IXk1+GC4mPxKX
hKpn0/CaUP3kdLw2VH37FF5HPgOvJ5+FS8lPx2Wh+tE5eFOo+jgXl4fqN8/D
FaHq3wW4kvwSXEX+ZbyZfBHeEqpfvRpvDVU/v4m3hepfr8PV5MvwDvJv453k
q/CuUPX3Vrw7VP/7A2xC1eO7sCPvcED+I7yHfC3eG6offhDXhKrP/4ZrQ/XH
j+L9oer1RnyA/Nf4IPlmfIh8C64L1V8/jw+Hqvcv4SOh6tGr+Cj5n3A9+Q7c
QP42bgxVv971gnw8VP3aHZ8IVY/G45Pk78NN5BNwM/lEfDpU/ToQnwlVvw7B
LaHq12H4bKh6dCRuJZ+GL5BPxxfJP4UvhapfM/DlUPVrFr4Sqh6djq+Sz8HX
yOfi6+Tn4bZQ9etC3B6qfl2CO0LVoy/jm+RfxbfIr8a3yb+JO0PVr2+9UPf/
MgoNcg==
        "]]}, 
      {RGBColor[0, 
        NCache[
         Rational[2, 3], 0.6666666666666666], 0], Thickness[Large], 
       Dashing[{Small, Small}], LineBox[CompressedData["
1:eJw0nX98zdUfx5fQkrS0tCQtSUvS0tJicUhaEsNoNAzDMAwzw8x+//5xd+/d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        "]]}, 
      {RGBColor[0.6, 0.4, 0.2], Thickness[Large], Dashing[{Small, Small}], 
       LineBox[CompressedData["
1:eJxd1XF0lO1VIPDZipilkUaMX7MYccSIEbM4xUhTmuIrppjFiCOmGGmKU4wY
MaVTjDTSSKeYYoopTmnESCOdYqTpkNIRszTSLI40spFGdkojRow4B1OMbBan
NIvxK3I2bZJvz/ebf3J+5+aZ+973Pnfu9xx8995fek1o8VMSCn3j7/LnrZ9b
8wM/+qn1wZIKP/pqh4JXuwiX4FJchstxGG/EFXgTrsSbcRXegiP4DXgr/mFc
jX8Eb8NvxDX4TXg7fjOuxW/BO/CP4uDVTuDQjxHHoZ3EcejHieNQHXEceitx
HNpFHId+gjgO1RPHof9GHId2E8ehnySOQw3EceiniOPQHuI49NPEcSj6agc4
gbM49DOcxwmcxaG9nMcJnMWhn+U8TuAsDjVyHidwFofexnmcwFkc2sd5nMBZ
HPo5zuMEzuJQE+dxAmdx6Oc5jxM4i0P7OY8TOItDb+c8TuAsDjVzHidwFofe
wXmcwFkcOsB5nMBZHPoFzuMEzuJQ7NUO4wDHcAKncBbnceid5McBjuEETuEs
zuPQQfLjAMdwAqdwFudx6BfJjwMcwwmcwlmcx6EW8uMAx3ACp3AW53Hol8iP
AxzDCZzCWZzHoUPkxwGO4QRO4SzO49Avkx8HOIYTOIWzOI9DreTHAY7hBE7h
LM7j0K+QHwc4hhM4hbM4j0OHyY8DHMMJnMJZnMehXyU/DnAMJ3AKZ3Eeh9rI
jwMcwwmcwlmcx6F3kR8HOIYTOIWzOI9DR8iPAxzDCZzCWZzHoXeTHwc4hhM4
hbM4j0PxV7sEh3EEBziKYziOEziJUziDsziH87iAQ++hfhzGERzgKI7hOE7g
JE7hDM7iHM7jAg4dpX4cxhEc4CiO4ThO4CRO4QzO4hzO4wIO/Rr14zCO4ABH
cQzHcQIncQpncBbncB4XcKid+nEYR3CAoziG4ziBkziFMziLcziPCzj069SP
wziCAxzFMRzHCZzEKZzBWZzDeVzAoWPUj8M4ggMcxTEcxwmcxCmcwVmcw3lc
wKH3Uj8O4wgOcBTHcBwncBKncAZncQ7ncQGHOqgfh3EEBziKYziOEziJUziD
sziH87iAQ79B/TiMIzjAURzDcZzASZzCGZzFOZzHBRw6Tv04jCM4wFEcw3Gc
wEmcwhmcxTmcxwUceh/14zCO4ABHcQzHcQIncQpncBbncB4XcKiT+nEYR3CA
oziG4ziBkziFMziLcziPCzj0m9SPwziCAxzFMRzHCZzEKZzBWZzDeVzAoRPU
j8M4ggMcxTEcxwmcxCmcwVmcw3lcwKH3Uz8O4wgOcBTHcBwncBKncAZncQ7n
cQGHEq92ES7BZTiMK3EE1+AA1+MobsIx3IrjuAMncDdO4j6cwoM4g0dwFo/j
HJ7CeTyLC3gBhz5A/3EJLsNhXIkjuAYHuB5HcROO4VYcxx04gbtxEvfhFB7E
GTyCs3gc5/AUzuNZXMALOHSS/uMSXIbDuBJHcA0OcD2O4iYcw604jjtwAnfj
JO7DKTyIM3gEZ/E4zuEpnMezuIAXcOi36D8uwWU4jCtxBNfgANfjKG7CMdyK
47gDJ3A3TuI+nMKDOINHcBaP4xyewnk8iwt4AYe66D8uwWU4jCtxBNfgANfj
KG7CMdyK47gDJ3A3TuI+nMKDOINHcBaP4xyewnk8iwt4AYc+SP9xCS7DYVyJ
I7gGB7geR3ETjuFWHMcdOIG7cRL34RQexBk8grN4HOfwFM7jWVzACzh0iv7j
ElyGw7gSR3ANDnA9juImHMOtOI47cAJ34yTuwyk8iDN4BGfxOM7hKZzHs7iA
F3Dot+k/LsFlOIwrcQTX4ADX4yhuwjHciuO4AydwN07iPpzCgziDR3AWj+Mc
nsJ5PIsLeAGHuuk/LsFlOIwrcQTX4ADX4yhuwjHciuO4AydwN07iPpzCgziD
R3AWj+McnsJ5PIsLeAGHPkT/cQkuw2FciSO4Bge4HkdxE47hVhzHHTiBu3ES
9+EUHsQZPIKzeBzn8BTO41lcwAs4dJr+4xJchsO4EkdwDQ5wPY7iJhzDrTiO
O3ACd+Mk7sMpPIgzeARn8TjO4Smcx7O4gBdw6HfoPy7BZTiMK3EE1+AA1+Mo
bsIx3IrjuAMncDdO4j6cwoM4g0dwFo/jHJ7CeTyLC3gBh3roPy7BZTiMK3EE
1+AA1+MobsIx3IrjuAMncDdO4j6cwoM4g0dwFo/jHJ7CeTyLC3gBhz5M/3EJ
LsNhXIkjuAYHuB5HcROO4VYcxx04gbtxEvfhFB7EGTyCs3gc5/AUzuNZXMAL
OHSG/uMSXIbDuBJHcA0OcD2O4iYcw604jjtwAnfjJO7DKTyIM3gEZ/E4zuEp
nMezuIAXcOh36T8uwWU4jCtxBNfgANfjKG7CMdyK47gDJ3A3TuI+nMKDOINH
cBaP4xyewnk8iwt4AYeSr/YqXISLcQkuxWW4HIdxBa7EVTiCq3ENrsUBrsP1
uAFHcSNuws04hltwK27DcdyOO3AnTuAu3I17cBL34j7cj1N4AA/iIZzBw3gE
j+IsHsPjeALn8CSewtM4j2fwLJ7DBTyPF/BzHPoI84+LcDEuwaW4DJfjMK7A
lbgKR3A1rsG1OMB1uB434ChuxE24GcdwC27FbTiO23EH7sQJ3IW7cQ9O4l7c
h/txCg/gQTyEM3gYj+BRnMVjeBxP4ByexFN4GufxDJ7Fc7iA5/ECfo5DZ5l/
XISLcQkuxWW4HIdxBa7EVTiCq3ENrsUBrsP1uAFHcSNuws04hltwK27DcdyO
O3AnTuAu3I17cBL34j7cj1N4AA/iIZzBw3gEj+IsHsPjeALn8CSewtM4j2fw
LJ7DBTyPF/BzHPoo84+LcDEuwaW4DJfjMK7AlbgKR3A1rsG1OMB1uB434Chu
xE24GcdwC27FbTiO23EH7sQJ3IW7cQ9O4l7ch/txCg/gQTyEM3gYj+BRnMVj
eBxP4ByexFN4GufxDJ7Fc7iA5/ECfo5Dvcw/LsLFuASX4jJcjsO4AlfiKhzB
1bgG1+IA1+F63ICjuBE34WYcwy24FbfhOG7HHbgTJ3AX7sY9OIl7cR/uxyk8
gAfxEM7gYTyCR3EWj+FxPIFzeBJP4WmcxzN4Fs/hAp7HC/g5Dv0e84+LcDEu
waW4DJfjMK7AlbgKR3A1rsG1OMB1uB434ChuxE24GcdwC27FbTiO23EH7sQJ
3IW7cQ9O4l7ch/txCg/gQTyEM3gYj+BRnMVjeBxP4ByexFN4GufxDJ7Fc7iA
5/ECfo5D55h/XISLcQkuxWW4HIdxBa7EVTiCq3ENrsUBrsP1uAFHcSNuws04
hltwK27DcdyOO3AnTuAu3I17cBL34j7cj1N4AA/iIZzBw3gEj+IsHsPjeALn
8CSewtM4j2fwLJ7DBTyPF/BzHPp95h8X4WJcgktxGS7HYVyBK3EVjuBqXINr
cYDrcD1uwFHciJtwM47hFtyK23Act+MO3IkTuAt34x6cxL24D/fjFB7Ag3gI
Z/AwHsGjOIvH8DiewDk8iafwNM7jGTyL53ABz+MF/ByH+ph/XISLcQkuxWW4
HIdxBa7EVTiCq3ENrsUBrsP1uAFHcSNuws04hltwK27DcdyOO3AnTuAu3I17
cBL34j7cj1N4AA/iIZzBw3gEj+IsHsPjeALn8CSewtM4j2fwLJ7DBTyPF/Bz
HPoD5h8X4WJcgktxGS7HYVyBK3EVjuBqXINrcYDrcD1uwFHciJtwM47hFtyK
23Act+MO3IkTuAt34x6cxL24D/fjFB7Ag3gIZ/AwHsGjOIvH8DiewDk8iafw
NM7jGTyL53ABz+MF/ByHzjP/uAgX4xJcistwOQ7jClyJq3AEV+MaXIsDXIfr
cQOO4kbchJtxDLfgVtyG47gdd+BOnMBduBv34CTuxX24H6fwAB7EQziDh/EI
HsVZPIbH8QTO4Uk8hadxHs/gWTyHC3geL+DnOPQx5h8X4WJcgktxGS7HYVyB
K3EVjuBqXINrcYDrcD1uwFHciJtwM47hFtyK23Act+MO3IkTuAt34x6cxL24
D/fjFB7Ag3gIZ/AwHsGjOIvH8DiewDk8iafwNM7jGTyL53ABz+MF/ByH+pl/
XISLcQkuxWW4HIdxBa7EVTiCq3ENrsUBrsP1uAFHcSNuws04hltwK27DcdyO
O3AnTuAu3I17cBL34j7cj1N4AA/iIZzBw3gEj+IsHsPjeALn8CSewtM4j2fw
LJ7DBTyPF/BzHPpD5h8X4WJcgktxGS7HYVyBK3EVjuBqXINrcYDrcD1uwFHc
iJtwM47hFtyK23Act+MO3IkTuAt34x6cxL24D/fjFB7Ag3gIZ/AwHsGjOIvH
8DiewDk8iafwNM7jGTyL53ABz+MF/ByHLjD/uAgX4xJcistwOQ7jClyJq3AE
V+MaXIsDXIfrcQOO4kbchJtxDLfgVtyG47gdd+BOnMBduBv34CTuxX24H6fw
AB7EQziDh/EIHsVZPIbH8QTO4Uk8hadxHs/gWTyHC3geL+DnOPRx5h8X4WJc
gktxGS7HYVyBK3EVjuBqXINrcYDrcD1uwFHciJtwM47hFtyK23Act+MO3IkT
uAt34x6cxL24D/fjFB7Ag3gIZ/AwHsGjOIvH8DiewDk8iafwNM7jGTyL53AB
z+MF/ByHUq/2a/AqvBoX4TW4GK/FJXgdLsUv4TK8HpfjDTiMN+IKvAlX4s24
Cm/BEbwVV+NtuAZvx7V4Bw7wTlyHd+F6vBs34D04ivfiRrwPN+H9uBkfwDF8
ELfgQ7gVH8Zt+AiO46O4HR/DHfg47sQncAKfxF34FO7Gp3EPPoOT+Czuxedw
Hz6P+/EFnMIX8QC+hAdxGg/hKziDr+JhfA2P4Ot4FN/AWXwTj+FbeBzfxhP4
Ds7hu3gS38NT+D6exg9wHj/EM/gRnsWP8Rx+ggv4KZ7Hz/ACfhk/xy9w6BPs
f7wKr8ZFeA0uxmtxCV6HS/FLuAyvx+V4Aw7jjbgCb8KVeDOuwltwBG/F1Xgb
rsHbcS3egQO8E9fhXbge78YNeA+O4r24Ee/DTXg/bsYHcAwfxC34EG7Fh3Eb
PoLj+Chux8dwBz6OO/EJnMAncRc+hbvxadyDz+AkPot78Tnch8/jfnwBp/BF
PIAv4UGcxkP4Cs7gq3gYX8Mj+DoexTdwFt/EY/gWHse38QS+g3P4Lp7E9/AU
vo+n8QOcxw/xDH6EZ/FjPIef4AJ+iufxM7yAX8bP8Qscusj+x6vwalyE1+Bi
vBaX4HW4FL+Ey/B6XI434DDeiCvwJlyJN+MqvAVH8FZcjbfhGrwd1+IdOMA7
cR3ehevxbtyA9+Ao3osb8T7chPfjZnwAx/BB3IIP4VZ8GLfhIziOj+J2fAx3
4OO4E5/ACXwSd+FTuBufxj34DE7is7gXn8N9+DzuxxdwCl/EA/gSHsRpPISv
4Ay+iofxNTyCr+NRfANn8U08hm/hcXwbT+A7OIfv4kl8D0/h+3gaP8B5/BDP
4Ed4Fj/Gc/gJLuCneB4/wwv4Zfwcv8ChP2L/41V4NS7Ca3AxXotL8Dpcil/C
ZXg9LscbcBhvxBV4E67Em3EV3oIjeCuuxttwDd6Oa/EOHOCduA7vwvV4N27A
e3AU78WNeB9uwvtxMz6AY/ggbsGHcCs+jNvwERzHR3E7PoY78HHciU/gBD6J
u/Ap3I1P4x58BifxWdyLz+E+fB734ws4hS/iAXwJD+I0HsJXcAZfxcP4Gh7B
1/EovoGz+CYew7fwOL6NJ/AdnMN38SS+h6fwfTyNH+A8fohn8CM8ix/jOfwE
F/BTPI+f4QX8Mn6OX+DQAPsfr8KrcRFeg4vxWlyC1+FS/BIuw+txOd6Aw3gj
rsCbcCXejKvwFhzBW3E13oZr8HZci3fgAO/EdXgXrse7cQPeg6N4L27E+3AT
3o+b8QEcwwdxCz6EW/Fh3IaP4Dg+itvxMdyBj+NOfAIn8EnchU/hbnwa9+Az
OInP4l58Dvfh87gfX8ApfBEP4Et4EKfxEL6CM/gqHsbX8Ai+jkfxDZzFN/EY
voXH8W08ge/gHL6LJ/E9PIXv42n8AOfxQzyDH+FZ/BjP4Se4gJ/iefwML+CX
8XP8Aof+mP2PV+HVuAivwcV4LS7B63ApfgmX4fW4HG/AYbwRV+BNuBJvxlV4
C47grbgab8M1eDuuxTtwgHfiOrwL1+PduAHvwVG8FzfifbgJ78fN+ACO4YO4
BR/CrfgwbsNHcBwfxe34GO7Ax3EnPoET+CTuwqdwNz6Ne/AZnMRncS8+h/vw
edyPL+AUvogH8CU8iNN4CF/BGXwVD+NreARfx6P4Bs7im3gM38Lj+DaewHdw
Dt/Fk/gensL38TR+gPP4IZ7Bj/Asfozn8BNcwE/xPH6GF/DL+Dl+gUOX2P94
FV6Ni/AaXIzX4hK8Dpfil3AZXo/L8QYcxhtxBd6EK/FmXIW34AjeiqvxNlyD
t+NavAMHeCeuw7twPd6NG/AeHMV7cSPeh5vwftyMD+AYPohb8CHcig/jNnwE
x/FR3I6P4Q58HHfiEziBT+IufAp349O4B5/BSXwW9+JzuA+fx/34Ak7hi3gA
X8KDOI2H8BWcwVfxML6GR/B1PIpv4Cy+icfwLTyOb+MJfAfn8F08ie/hKXwf
T+MHOI8f4hn8CM/ix3gOP8EF/BTP42d4Ab+Mn+MXOPRJ9j9ehVfjIrwGF+O1
uASvw6X4JVyG1+NyvAGH8UZcgTfhSrwZV+EtOIK34mq8Ddfg7bgW78AB3onr
8C5cj3fjBrwHR/Fe3Ij34Sa8HzfjAziGD+IWfAi34sO4DR/BcXwUt+NjuAMf
x534BE7gk7gLn8Ld+DTuwWdwEp/Fvfgc7sPncT++gFP4Ih7Al/AgTuMhfAVn
8FU8jK/hEXwdj+IbOItv4jF8C4/j23gC38E5fBdP4nt4Ct/H0/gBzuOHeAY/
wrP4MZ7DT3ABP8Xz+BlewC/j5/gFDg2y//EqvBoX4TW4GK/FJXgdLsUv4TK8
HpfjDTiMN+IKvAlX4s24Cm/BEbwVV+NtuAZvx7V4Bw7wTlyHd+F6vBs34D04
ivfiRrwPN+H9uBkfwDF8ELfgQ7gVH8Zt+AiO46O4HR/DHfg47sQncAKfxF34
FO7Gp3EPPoOT+CzuxedwHz6P+/EFnMIX8QC+hAdxGg/hKziDr+JhfA2P4Ot4
FN/AWXwTj+FbeBzfxhP4Ds7hu3gS38NT+D6exg9wHj/EM/gRnsWP8Rx+ggv4
KZ7Hz/ACfhk/xy9w6FPsf7wKr8ZFeA0uxmtxCV6HS/FLuAyvx+V4Aw7jjbgC
b8KVeDOuwltwBG/F1XgbrsHbcS3egQO8E9fhXbge78YNeA+O4r24Ee/DTXg/
bsYHcAwfxC34EG7Fh3EbPoLj+Chux8dwBz6OO/EJnMAncRc+hbvxadyDz+Ak
Pot78Tnch8/jfnwBp/BFPIAv4UGcxkP4Cs7gq3gYX8Mj+DoexTdwFt/EY/gW
Hse38QS+g3P4Lp7E9/AUvo+n8QOcxw/xDH70qaByzfyHal/Z//gxnsNPcAE/
xfOfCop//h8ev+mV/Y8X8MufCgqfvPWTb3xl/+MXnwq+9OwzQ9Wv7P908Nm3
/sG3bn1l/+NV6eB878kjP/TK/k8H79z6tsjmV/Z/OnjrB3Z85Ptf2f/poPi7
v+1nN76y/9PBl0b/qfS7Xtn/6eDEpz7+xu94Zf+ngx849/b93/rK/k8Hkydf
/5vf/Mr+TwcHb4yGvja4sv8X4/U/+eX/s+KydLDrS3/3V/kVr08HHxv6mdd9
ccXl6aDwwb9q/IsVb1j8vpKmNw2vOLyY/8rmr11Z8cZ08P6/ODJ1bcUVi/GN
n9/8YMWb0q/uT2U6qPudtn/+2iv7Px0c/9mPrPnFyyv7Px285XVP7tz/9Mr+
Twc/8r7Ud5RdXdn/i+/j1ge/6Xv+bGX/p4PDD95z+szYyv5PB4fe8Cf/PnJv
Zf+ng9fXR5+XfXVl/6eDR7Nfed/HNnznkreng7f99nTxG2PLrk0H217zlesn
/mLZO9LBvq839KfLlxykg+/7l/N/9cbv/K4l71x8/pvrXlf55g1LrksHFcNf
bj79he9e8q500PKZ975/9N/CS65ffN9v+/jlT7duXPLudPDuD6z6y9/9mYol
N6SDZGrhDY/ubFrynnTwpnt/+a7q0OYlR9NByb989jPf9C1blrw3Hfxj/rUf
/dTJNyy5MR2c/cL76//8w9VL3pcO3rX4tr+ytWbJTemg97c/uP9LnbVL3p8O
+sfCmaMjwZKb08HnRj68unDqx5d8IB2898bH1//QH+9acmzx/fz1m/d88T/v
XvLBdPDpX1lswKWfWnJLOpje9U0drx2OLvlQOvjT9z3NRD+2d8mt6eBvq/+1
5q3va1zy4eXnqdu35LbF+/R3b/mNptmfW/KRdPDmf/zpD//+vp9fcjwdfOP6
fGD/ko+mg9H2j5atOvD2Jbeng6Kh8v0t/7TsY+lg3W9lb3/iW5uX3LF4v9b8
7R/F/2E5fnzxvjb/7s3/27TsznTwdVb2LH//iXTwYrLjXzZ9aDl/Ih38SfRX
z7+3tWnJJ9PBX08sfuqXn7crHXyt+V1/+WLPcj2n0sH97+x859Y/ftuSu9PB
ta/+x2THbyz7dDr4wWe//w8f/dqye9LBaysqT/T8/PL3nUkHP/z1z+eW8yfT
wd//+4nDo7XvWPLZdPCGrxc8H1tyb3rp9+vvfnHJ5xbn/esJa355yX3p4MO/
f2TdbxUOL/l8Orj6h//6yVv/68iS+xfv69df+E+9Z8kX0sEXNy5mLPq1JafS
wRc+8dZrX31v+5IvLt7HxZ+H8RO/vuSB5edbfWzJl9LBztiXcxu/admD6SD9
lbs/dfDo8v+n08HTRZYcWP6+oXSwat/a/3r1744u+Uo6SK3/oX+oCC0/T2a5
X/l3LflqOsgcbf3I/+n9lSUPLz/Pvl9a8rV08PXr8Oafe+eSR9LB9379AduX
+3198b68ZXEif3D5/Y+mg8e/d7X4PRM/veQb6WDwRxYv/I/9xJKz6WBxeqd+
4czyvNxMB2d+/T3f+a2FbUseSwefuLd4wb+8PJ+30kH1t22r/R9bl+d7PB38
7MYPHdj1kf+y5Nvp4Fv+oGWmqup1S55IB7WpttvfseE1S76zeJ+++XPv/PuL
X/3RbziXDj5/cPK/P7vxcMl3F+t9+/Hqv/noXy15cvG+/+53f3DXaz/259/w
vXSw90tbLv3Bk88veWpxX23+0NxvVf31ku8v9uMP33n4J7/ri0ueXtxX//Hx
z3f+xt0lP0gH//MrP/7H3/bDX1pyfvH36E/f8YnXnVv2w3QwEn77uc98Ydkz
i+/j2HThc/+y7Efp4N+u/NgvHP/asmfTwcaaLf90afXkkh+ngysf+PS6qrXL
nlvM9+0/1v/b377sJ+mg71JR/Pjrl11IB8fe/daDJ9cv++li/2v6//1vypc9
nw5+Zearpz+5YdnP0sGDL/zm0dLwshcW79t7/3XwDd+z7JcXf0/e82JT6cZl
P08H/+lDm6JjK36xeP7YJ/5sz/cuO3Q56Hzt/771uRW/5nLwxte//++/vWLZ
qy4Hrzv/jn/bt+LVl4MDLa858eEVF10Ovu/Yu9792RWvuRx85LPN/zG14uLL
wcXK3Pc/XfHay8EH/+SD4W/5vmWXXA7evPc3//n1K153ORhb89nOihWXXg4a
Pl/4tjes+KXLwSc/2vbrb1px2eXgb963+ZNvWfH6y0Gk4dKaXSsuvxy8o7ql
dveKN+Dw5eB0+cYje1a8EVdcDkZW5T++d8WbcCXejKsuB1+e+8Mv7lvxFhzB
W3E13oZr8HZci3fgAO/EdXgXrse7cQPeg6N4L27E+3AT3o+b8QEcwwdxCz6E
W/Fh3IaP4Dg+itvxMdyBj+NOfAIn8EnchU/hbnwa9+AzOInP4l58Dvfh87gf
X8ApfBEP4Et4EKfxEL6CM/gqHsbX8Ai+jkfxDZzFN/EYvoXH8W08ge/gHL6L
J/E9PIXv42n8AOfxQzyDH+FZ/BjP4Se4gJ/iefwML+CX8XP8AoeGXu3X4FV4
NS7Ca3AxXotL8Dpcil/CZXg9LscbcBhvxBV4E67Em3EV3oIjeCuuxttwDd6O
a/EOHOCduA7vwvV4N27Ae3AU78WNeB9uwvtxMz6AY/ggbsGHcCs+jNvwERzH
R3E7PoY78HHciU/gBD6Ju/Ap3I1P4x58BifxWdyLz+E+fB734ws4hS/iAXwJ
D+I0HsJXcAZfxcP4Gh7B1/EovoGz+CYew7fwOL6NJ/AdnMN38SS+h6fwfTyN
H+A8fohn8CM8ix/jOfwEF/BTPI+f4QX8Mn6OX+DQp9n/eBVejYvwGlyM1+IS
vA6X4pdwGV6Py/EGHMYbcQXehCvxZlyFt+AI3oqr8TZcg7fjWrwDB3gnrsO7
cD3ejRvwHhzFe3Ej3oeb8H7cjA/gGD6IW/Ah3IoP4zZ8BMfxUdyOj+EOfBx3
4hM4gU/iLnwKd+PTuAefwUl8Fvfic7gPn8f9+AJO4Yt4AF/CgziNh/AVnMFX
8TC+hkfwdTyKb+AsvonH8C08jm/jCXwH5/BdPInv4Sl8H0/jBziPH+IZ/AjP
4sd4Dj/BBfwUz+NneAG/jJ/jFzh0hf2PV+HVuAivwcV4LS7B63ApfgmX4fW4
HG/AYbwRV+BNuBJvxlV4C47grbgab8M1eDuuxTtwgHfiOrwL1+PduAHvwVG8
FzfifbgJ78fN+ACO4YO4BR/CrfgwbsNHcBwfxe34GO7Ax3EnPoET+CTuwqdw
Nz6Ne/AZnMRncS8+h/vwedyPL+AUvogH8CU8iNN4CF/BGXwVD+NreARfx6P4
Bs7im3gM38Lj+DaewHdwDt/Fk/gensL38TR+gPP4IZ7Bj/Asfozn8BNcwE/x
PH6GF/DL+Dl+gUOfYf/jVXg1LsJrcDFei0vwOlyKX8JleD0uxxtwGG/EFXgT
rsSbcRXegiN4K67G23AN3o5r8Q4c4J24Du/C9Xg3bsB7cBTvxY14H27C+3Ez
PoBj+CBuwYdwKz6M2/ARHMdHcTs+hjvwcdyJT+AEPom78CncjU/jHnwGJ/FZ
3IvP4T58HvfjCziFL+IBfAkP4jQewldwBl/Fw/gaHsHX8Si+gbP4Jh7Dt/A4
vo0n8B2cw3fxJL6Hp/B9PI0f4Dx+iGfwIzyLH+M5/AQX8FM8j5/hBfwyfo5f
/H//P5kRLSs=
        "]]}}, {
      {Hue[0.67, 0.6, 0.6], Thickness[0.00201836636368156], StrokeForm[Hue[
       0.3277777777777778, 1., 0.5383186348055663]], EdgeForm[GrayLevel[0.]], 
       EdgeForm[None], 
       LineBox[{{3221.7164381602697`, 1414.4891940019415`}, {
        3221.7164381602697`, -9.18239624861144}}]}, 
      {Hue[0.67, 0.6, 0.6], Thickness[0.00201836636368156], StrokeForm[Hue[
       0.3388888888888889, 1., 0.8968210694173822]], EdgeForm[GrayLevel[0.]], 
       EdgeForm[None], 
       LineBox[{{3196.6990673392747`, 286.9664318627947}, {
        3196.6990673392747`, -9.182393036702251}}]}, 
      {Hue[0.67, 0.6, 0.6], Thickness[0.00201836636368156], StrokeForm[Hue[
       0.31666666666666665`, 0.7297297297297297, 1.]], EdgeForm[GrayLevel[
       0.]], EdgeForm[None], 
       LineBox[{{3164.0375000269855`, 96.42386145095543}, {
        3164.0375000269855`, -1.058834999190367}}]}, 
      {Hue[0.67, 0.6, 0.6], Thickness[0.00201836636368156], StrokeForm[Hue[
       0.5611111111111111, 0.8918918918918919, 1.]], EdgeForm[GrayLevel[0.]], 
       EdgeForm[None], 
       LineBox[{{3385.719201572103, 132.9798726197596}, {
        3385.7192015721025`, -9.182393036702706}}]}, 
      {Hue[0.67, 0.6, 0.6], Thickness[0.00201836636368156], StrokeForm[Hue[
       0.6611111111111111, 1., 0.8968210694173822]], EdgeForm[GrayLevel[0.]], 
       EdgeForm[None], 
       LineBox[{{3410.041645315298, 388.87195080139236`}, {
        3410.041645315298, -9.182393036702251}}]}, 
      {Hue[0.67, 0.6, 0.6], Thickness[0.00201836636368156], StrokeForm[
       RGBColor[0.843137, 0, 0]], EdgeForm[GrayLevel[0.]], EdgeForm[None], 
       LineBox[{{3024.357180244638, 1660.2087836720432`}, {3024.357180244638, 
        3.002944019566712}}]}, 
      {Hue[0.67, 0.6, 0.6], Thickness[0.00201836636368156], StrokeForm[Hue[
       0.07222222222222222, 0.40540540540540543`, 1.]], EdgeForm[GrayLevel[
       0.]], EdgeForm[None], 
       LineBox[{{2997.949955609169, 311.69814944502696`}, {
        2997.949955609169, -9.182393036702706}}]}, 
      {Hue[0.67, 0.6, 0.6], Thickness[0.00201836636368156], StrokeForm[Hue[
       0.06111111111111111, 0.8918918918918919, 1.]], EdgeForm[GrayLevel[0.]],
        EdgeForm[None], 
       LineBox[{{3016.7129836396375`, 949.3974553897294}, {
        3016.7129836396375`, 3.0029440195658026`}}]}, 
      StyleBox[InsetBox[
        StyleBox[Cell["2999",
          GeneratedCell->False,
          CellAutoOverwrite->False,
          CellBaseline->Baseline,
          TextAlignment->Left],
         Magnification->1.], {2975.0173657941577`, 344.1923815950754}, {
        Left, Baseline},
        Alignment->{Left, Top}],
       FontSize->19,
       FontWeight->Bold,
       FontColor->Hue[0.05, 0.5135135135135135, 1.],
       Background->RGBColor[1., 1., 1., 0]], 
      StyleBox[InsetBox[
        StyleBox[Cell["3018",
          GeneratedCell->False,
          CellAutoOverwrite->False,
          CellBaseline->Baseline,
          TextAlignment->Left],
         Magnification->1.], {2985.788733737573, 730.0613883769024}, {
        Left, Baseline},
        Alignment->{Left, Top}],
       FontSize->19,
       FontWeight->Bold,
       FontColor->Hue[0.027777777777777776`, 0.7837837837837838, 1.],
       Background->RGBColor[1., 1., 1., 0]], 
      StyleBox[InsetBox[
        StyleBox[Cell["3026",
          GeneratedCell->False,
          CellAutoOverwrite->False,
          CellBaseline->Baseline,
          TextAlignment->Left],
         Magnification->1.], {3029.569132475323, 1603.3438774094584`}, {
        Left, Baseline},
        Alignment->{Left, Top}],
       FontSize->19,
       FontWeight->Bold,
       FontColor->Hue[0.005555555555555556, 1., 1.],
       Background->RGBColor[1., 1., 1., 0]], 
      StyleBox[InsetBox[
        StyleBox[Cell["3164",
          GeneratedCell->False,
          CellAutoOverwrite->False,
          CellBaseline->Baseline,
          TextAlignment->Left],
         Magnification->1.], {3147.7067163708402`, 116.73275654473628`}, {
        Left, Baseline},
        Alignment->{Left, Top}],
       FontSize->19,
       FontWeight->Bold,
       FontColor->Hue[0.35, 0.5675675675675675, 1.],
       Background->RGBColor[1., 1., 1., 0]], 
      StyleBox[InsetBox[
        StyleBox[Cell["3197",
          GeneratedCell->False,
          CellAutoOverwrite->False,
          CellBaseline->Baseline,
          TextAlignment->Left],
         Magnification->1.], {3171.334233149943, 299.5128123887589}, {
        Left, Baseline},
        Alignment->{Left, Top}],
       FontSize->19,
       FontWeight->Bold,
       FontColor->Hue[0.35, 1., 0.9486727155643735],
       Background->RGBColor[1., 1., 1., 0]], 
      StyleBox[InsetBox[
        StyleBox[Cell["3222",
          GeneratedCell->False,
          CellAutoOverwrite->False,
          CellBaseline->Baseline,
          TextAlignment->Left],
         Magnification->1.], {3189.4023342163164`, 1469.305169790507}, {
        Left, Baseline},
        Alignment->{Left, Top}],
       FontSize->19,
       FontWeight->Bold,
       FontColor->Hue[0.3277777777777778, 1., 0.6916998428445305],
       Background->RGBColor[1., 1., 1., 0]], 
      StyleBox[InsetBox[
        StyleBox[Cell["3387",
          GeneratedCell->False,
          CellAutoOverwrite->False,
          CellBaseline->Baseline,
          TextAlignment->Left],
         Magnification->1.], {3368.693490951866, 153.28876771354066`}, {
        Left, Baseline},
        Alignment->{Left, Top}],
       FontSize->19,
       FontWeight->Bold,
       FontColor->Hue[0.5611111111111111, 0.6756756756756757, 1.],
       Background->RGBColor[1., 1., 1., 0]], 
      StyleBox[InsetBox[
        StyleBox[Cell["3410",
          GeneratedCell->False,
          CellAutoOverwrite->False,
          CellBaseline->Baseline,
          TextAlignment->Left],
         Magnification->1.], {3391.626080766878, 409.18084589517343`}, {
        Left, Baseline},
        Alignment->{Left, Top}],
       FontSize->19,
       FontWeight->Bold,
       FontColor->Hue[0.6611111111111111, 0.8378378378378378, 1.],
       Background->RGBColor[1., 1., 1., 0]]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesLabel->{
      FormBox["\"Energie\\n(Kanal)\"", TraditionalForm], 
      FormBox["\"Ereignisse\\n(Anzahl)\"", TraditionalForm]},
    AxesOrigin->{2900., 0},
    AxesStyle->Arrowheads[0.03],
    Epilog->{FontSize -> 16, {
       RGBColor[1, 0, 0], 
       LineBox[{{0, 0}, {0, 3000}}]}, {
       RGBColor[0, 0, 1], 
       LineBox[{{0, 750}, {0, 750}}]}, 
      InsetBox[
       BoxData[
        FormBox["0", TraditionalForm]], {0, 150}, BaseStyle -> 
       RGBColor[1, 0, 0]], 
      InsetBox[
       BoxData[
        FormBox["0", TraditionalForm]], {0, 652.1739130434784}, BaseStyle -> 
       RGBColor[0, 0, 1]], 
      InsetBox[
       BoxData[
        FormBox[
         FrameBox[
         "\"2. Kallibrierungs-\\nmessung\\n mit Gau\[SZ]fits\"", 
          RoundingRadius -> 5, StripOnInput -> False], TraditionalForm]], {
       2975, 1250.}, BaseStyle -> GrayLevel[0]]},
    ImagePadding->{{22.999998, 37.374997}, {0.725, 33.499998}},
    ImageSize->600,
    PlotRange->{{2900., 3500.}, {-210.8480367560731, 1720.5538010475814`}},
    PlotRangeClipping->True,
    PlotRangePadding->Automatic,
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "]"}]], "Input",
 CellChangeTimes->{{3.55067250259375*^9, 3.5506725731875*^9}, {
  3.55067314025*^9, 3.550673143890625*^9}, {3.55069568340625*^9, 
  3.550695688078125*^9}}],

Cell[BoxData["\<\"2_Kallibrierungsmessung_mit_Gau\[SZ]fits.pdf\"\>"], "Output",
 CellChangeTimes->{3.5506731451875*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"dat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "\"\<Mylar D1\>\"", ",", "2386", ",", "0", ",", "60", ",", "0"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Mylar D2\>\"", ",", "1269", ",", "0", ",", "102", ",", "0"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Mylar F1\>\"", ",", "3083", ",", "0", ",", "26", ",", "0"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Mylar F2\>\"", ",", "2931", ",", "0", ",", "36", ",", "0"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Mylar F3\>\"", ",", "2788", ",", "0", ",", "34", ",", "0"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Mylar F4\>\"", ",", "2643", ",", "0", ",", "44", ",", "0"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Mylar D2F1\>\"", ",", "1048", ",", "0", ",", "132", ",", "0"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Alimunium\>\"", ",", "2547", ",", "0", ",", "98", ",", "0"}], 
      "}"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.550738808515625*^9, 3.550738812296875*^9}, {
   3.55075001878125*^9, 3.550750024921875*^9}, {3.550751179796875*^9, 
   3.550751214015625*^9}, {3.550751260375*^9, 3.550751261015625*^9}, {
   3.550752805015625*^9, 3.55075280509375*^9}, {3.550753158296875*^9, 
   3.55075315840625*^9}, {3.55075327153125*^9, 3.550753300953125*^9}, {
   3.55075365403125*^9, 3.55075367809375*^9}, 3.550753891375*^9, 
   3.55075442621875*^9, {3.550764944578125*^9, 3.550764945078125*^9}, {
   3.550765114921875*^9, 3.550765115046875*^9}, {3.5507651535625*^9, 
   3.55076515375*^9}, {3.55076528709375*^9, 3.55076528721875*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"datluf", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<Torr500\>\"", ",", "1566", ",", "0", ",", "0", ",", "0"}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<Torr650\>\"", ",", "788", ",", "0", ",", "0", ",", "0"}], 
     "}"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.5507672545625*^9, 3.5507672974375*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"Torr500\"\>", ",", "1566", ",", "0", ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Torr650\"\>", ",", "788", ",", "0", ",", "0", ",", "0"}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.55076729859375*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"mdat", "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"dat", "[", 
       RowBox[{"[", 
        RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
      RowBox[{"dat", "[", 
       RowBox[{"[", 
        RowBox[{"All", ",", "2"}], "]"}], "]"}], ",", 
      RowBox[{"g", "/.", 
       RowBox[{"x", "->", 
        RowBox[{"dat", "[", 
         RowBox[{"[", 
          RowBox[{"All", ",", "2"}], "]"}], "]"}]}]}], ",", 
      RowBox[{"dat", "[", 
       RowBox[{"[", 
        RowBox[{"All", ",", "4"}], "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"g", "/.", 
         RowBox[{"x", "->", 
          RowBox[{"dat", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "4"}], "]"}], "]"}]}]}], ")"}], "-", 
       RowBox[{"(", 
        RowBox[{"g", "/.", 
         RowBox[{"x", "\[Rule]", "0"}]}], ")"}]}]}], "}"}], "]"}]}], ";", 
  RowBox[{"mdatluft", "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"datluf", "[", 
       RowBox[{"[", 
        RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
      RowBox[{"datluf", "[", 
       RowBox[{"[", 
        RowBox[{"All", ",", "2"}], "]"}], "]"}], ",", 
      RowBox[{"g", "/.", 
       RowBox[{"x", "->", 
        RowBox[{"datluf", "[", 
         RowBox[{"[", 
          RowBox[{"All", ",", "2"}], "]"}], "]"}]}]}], ",", 
      RowBox[{"datluf", "[", 
       RowBox[{"[", 
        RowBox[{"All", ",", "4"}], "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"g", "/.", 
         RowBox[{"x", "->", 
          RowBox[{"datluf", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "4"}], "]"}], "]"}]}]}], ")"}], "-", 
       RowBox[{"(", 
        RowBox[{"g", "/.", 
         RowBox[{"x", "\[Rule]", "0"}]}], ")"}]}]}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.5507388155*^9, 3.550738972140625*^9}, {
   3.550739356984375*^9, 3.55073935975*^9}, {3.550746866265625*^9, 
   3.5507468708125*^9}, {3.550749128375*^9, 3.550749134796875*^9}, 
   3.550751269375*^9, 3.550751402390625*^9, 3.550754423890625*^9, {
   3.550767301953125*^9, 3.550767313109375*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"mdat", "//", "TeXForm"}], "\[IndentingNewLine]", 
 RowBox[{"mdatluft", "//", "TeXForm"}]}], "Input",
 CellChangeTimes->{{3.550752812578125*^9, 3.5507528183125*^9}, {
  3.550767317984375*^9, 3.550767329046875*^9}}],

Cell["\<\
\\left(
\\begin{array}{ccccc}
 \\text{Torr500} & 1566 & 2685.51 & 0 & 0. \\\\
 \\text{Torr650} & 788 & 1369.54 & 0 & 0.
\\end{array}
\\right)\
\>", "Output",
 CellChangeTimes->{
  3.550752818640625*^9, 3.55075316578125*^9, {3.55075327625*^9, 
   3.550753305015625*^9}, {3.550753658328125*^9, 3.550753681859375*^9}, 
   3.5507538938125*^9, 3.550754615625*^9, 3.55076494925*^9, 
   3.550765118984375*^9, 3.550765158359375*^9, 3.55076529159375*^9, {
   3.550767323*^9, 3.550767328015625*^9}}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"gaus", "[", "E_", "]"}], ":=", 
   SqrtBox[
    RowBox[{
     SuperscriptBox["\[CapitalDelta]Ay", "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"\[CapitalDelta]S", " ", "E"}], ")"}], "2"], " "}]]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.550749178796875*^9, 3.5507492508125*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"err", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4108.3", ",", "26.76"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2279.8", ",", "37.83"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5253.3", ",", "11.43"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5014.1", ",", "16.17"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4766.4", ",", "4509.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4509.1", ",", "22.86"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1833.9", ",", "39.52"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.550754256671875*^9, 3.5507542624375*^9}, {
  3.550754295625*^9, 3.550754430640625*^9}, {3.550754514515625*^9, 
  3.550754516296875*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"exdatluft", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Transpose", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"mdatluft", "[", 
        RowBox[{"[", 
         RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"mdatluft", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "3"}], "]"}], "]"}], "\[PlusMinus]", 
          RowBox[{"gaus", "[", 
           RowBox[{"mdatluft", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "3"}], "]"}], "]"}], "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "mdatluft", "]"}]}], "}"}]}], "]"}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"mdatluft", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "5"}], "]"}], "]"}], "\[PlusMinus]", 
          RowBox[{"2", 
           RowBox[{"mdatluft", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "5"}], "]"}], "]"}], "*", 
           "\[CapitalDelta]S"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "mdatluft", "]"}]}], "}"}]}], "]"}]}], 
      "}"}], "]"}], "//", "TableForm"}], "//", "TeXForm"}]}]], "Input",
 CellChangeTimes->{{3.55076735821875*^9, 3.550767383421875*^9}}],

Cell["\<\
\\begin{array}{ccc}
 \\text{Torr500} & 2685.51\\pm 29.3901 & 0.\\pm 0. \\\\
 \\text{Torr650} & 1369.54\\pm 24.4948 & 0.\\pm 0.
\\end{array}\
\>", "Output",
 CellChangeTimes->{{3.550767379578125*^9, 3.55076738471875*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"luft", "=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2685.51", ",", " ", "29.3901"}], "}"}], ",", 
     RowBox[{"{", " ", 
      RowBox[{"1369.54", ",", "24.4948"}], " ", "}"}]}], "}"}], "/", 
   "1000"}]}]], "Input",
 CellChangeTimes->{{3.550767867234375*^9, 3.5507678906875*^9}, {
   3.55076795046875*^9, 3.55076795303125*^9}, {3.550768372125*^9, 
   3.550768378171875*^9}, {3.550768447578125*^9, 3.55076845484375*^9}, {
   3.550768620015625*^9, 3.550768645203125*^9}, {3.550770021046875*^9, 
   3.550770024*^9}, 3.5507700786875*^9, 3.55077014009375*^9, {
   3.55077091896875*^9, 3.55077092128125*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2.6855100000000003`", ",", "0.029390100000000002`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.36954`", ",", "0.0244948`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.5507679534375*^9, {3.5507685941875*^9, 3.55076864996875*^9}, 
   3.550770024890625*^9, 3.55077007921875*^9, 3.55077014065625*^9, {
   3.550770919453125*^9, 3.5507709219375*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"luft", "[", 
  RowBox[{"[", 
   RowBox[{"All", ",", "1"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.5507700345*^9, 3.550770067078125*^9}, 
   3.550770125109375*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.6855100000000003`", ",", "1.36954`"}], "}"}]], "Output",
 CellChangeTimes->{{3.5507700434375*^9, 3.550770082328125*^9}, 
   3.550770925796875*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"0.981", ",", "1.228"}], "}"}], "*", "287.058", "*", 
  "295"}]], "Input",
 CellChangeTimes->{{3.55076946515625*^9, 3.55076948053125*^9}, {
  3.550769519453125*^9, 3.55076955859375*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"83073.14991`", ",", "103989.63107999999`"}], "}"}]], "Output",
 CellChangeTimes->{{3.550769516734375*^9, 3.550769522953125*^9}, 
   3.550769559109375*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"83073.14991`", ",", "103989.63107999999`"}], "}"}], "*", 
  RowBox[{"(", 
   RowBox[{"760", "/", "101325"}], ")"}]}]], "Input",
 CellChangeTimes->{{3.55076939953125*^9, 3.550769455953125*^9}, {
  3.5507696530625*^9, 3.55076966028125*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"623.0998660903034`", ",", "779.9863767165062`"}], "}"}]], "Output",
 CellChangeTimes->{{3.550769430015625*^9, 3.550769439515625*^9}, {
   3.5507696536875*^9, 3.550769660640625*^9}, 3.55077014134375*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"7.122", "*", 
    RowBox[{"10", "^", "2"}]}]], 
  RowBox[{"luft", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", "1"}], "]"}], "]"}], "*", "2156.85", "*", 
  "295"}]], "Input",
 CellChangeTimes->{{3.550767955765625*^9, 3.5507679718125*^9}, {
  3.550768008359375*^9, 3.55076803690625*^9}, {3.55076849471875*^9, 
  3.550768503*^9}, {3.550768630796875*^9, 3.55076869046875*^9}, {
  3.55077011640625*^9, 3.550770126734375*^9}, {3.55077072015625*^9, 
  3.550770720375*^9}, {3.550770886953125*^9, 3.550770890015625*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"599.8004288937448`", ",", "305.8825621156276`"}], "}"}]], "Output",
 CellChangeTimes->{{3.550770110828125*^9, 3.5507701444375*^9}, 
   3.550770721484375*^9, 3.55077089340625*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"exdat", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Transpose", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"mdat", "[", 
        RowBox[{"[", 
         RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"mdat", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "3"}], "]"}], "]"}], "\[PlusMinus]", 
          RowBox[{"gaus", "[", 
           RowBox[{"mdat", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "3"}], "]"}], "]"}], "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "mdat", "]"}]}], "}"}]}], "]"}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"mdat", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "5"}], "]"}], "]"}], "\[PlusMinus]", 
          RowBox[{"2", 
           RowBox[{"mdat", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "5"}], "]"}], "]"}], "*", 
           "\[CapitalDelta]S"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "mdat", "]"}]}], "}"}]}], "]"}], ",", 
       RowBox[{"err", "[", 
        RowBox[{"[", 
         RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
       RowBox[{"err", "[", 
        RowBox[{"[", 
         RowBox[{"All", ",", "2"}], "]"}], "]"}]}], "}"}], "]"}], "//", 
    "TableForm"}], "//", "TeXForm"}]}]], "Input",
 CellChangeTimes->{{3.55074914675*^9, 3.550749167875*^9}, {
  3.550749254203125*^9, 3.55074945540625*^9}, {3.55075444221875*^9, 
  3.5507544589375*^9}}],

Cell["\<\
\\begin{array}{ccccc}
 \\text{Mylar D1} & 4072.53\\pm 36.4296 & 101.489\\pm 1.42708 & 4108.3 & \
26.76 \\\\
 \\text{Mylar D2} & 2183.14\\pm 27.2557 & 172.531\\pm 2.42603 & 2279.8 & \
37.83 \\\\
 \\text{Mylar F1} & 5251.49\\pm 43.2492 & 43.9785\\pm 0.618401 & 5253.3 & \
11.43 \\\\
 \\text{Mylar F2} & 4994.39\\pm 41.7167 & 60.8933\\pm 0.856247 & 5014.1 & \
16.17 \\\\
 \\text{Mylar F3} & 4752.5\\pm 40.2957 & 57.5104\\pm 0.808678 & 4766.4 & \
4509.1 \\\\
 \\text{Mylar F4} & 4507.24\\pm 38.8778 & 74.4252\\pm 1.04652 & 4509.1 & \
22.86 \\\\
 \\text{Mylar D2F1} & 1809.33\\pm 25.867 & 223.275\\pm 3.13957 & 1833.9 & \
39.52 \\\\
 \\text{Alimunium} & 4344.86\\pm 37.953 & 165.765\\pm 2.33089 & 0 & 0
\\end{array}\
\>", "Output",
 CellChangeTimes->{{3.5507492715*^9, 3.5507492865*^9}, 3.5507493249375*^9, {
   3.5507493736875*^9, 3.550749456015625*^9}, 3.550750051875*^9, {
   3.55075139934375*^9, 3.550751405125*^9}, 3.550752848796875*^9, 
   3.550753167109375*^9, {3.55075328309375*^9, 3.550753307234375*^9}, {
   3.550753658390625*^9, 3.550753681921875*^9}, 3.550753893875*^9, 
   3.550754459515625*^9, 3.5507545189375*^9, 3.550764952890625*^9, 
   3.550765119078125*^9, 3.550765158453125*^9, {3.5507652916875*^9, 
   3.55076530403125*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindFit", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5"}], "}"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"a", " ", "x"}], "+", "b"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "223"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "2"}], "}"}]}], "}"}], ",", "x"}], "]"}]], "Input",
 CellChangeTimes->{{3.550758286859375*^9, 3.55075832684375*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "\[Rule]", "1.2857142857142858`"}], ",", 
   RowBox[{"b", "\[Rule]", "2.5639502485114184`*^-16"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.55075832371875*^9, 3.5507583276875*^9}}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.55075988940625*^9, 3.550759890140625*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5"}], "}"}]}], "}"}], "[", 
  RowBox[{"[", 
   RowBox[{"2", ";;", "3"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.550759895984375*^9, 3.55075991821875*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.550759901953125*^9, 3.550759918625*^9}}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"bragg", "[", 
   RowBox[{
    RowBox[{"abbruchenergie_:", "0.15"}], ",", 
    RowBox[{"dichte_:", "1.395"}]}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"sw", "=", "0.000001"}], ";", 
    RowBox[{"schritte", "=", "0"}], ";", 
    RowBox[{"me", "=", "0.511"}], ";", 
    RowBox[{"ma", "=", "3727.379"}], ";", 
    RowBox[{"energie", "=", "5.486"}], ";", "\[IndentingNewLine]", 
    RowBox[{"enlist", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"deltalist", "=", 
     RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"puffer", "=", "0"}], ";", "\[IndentingNewLine]", 
    RowBox[{"While", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"energie", ">", "abbruchenergie"}], "||", 
       RowBox[{"puffer", "\[Equal]", "0"}]}], ",", 
      RowBox[{"(", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"energie", "<", "abbruchenergie"}], ",", 
          RowBox[{"puffer", "=", "1"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"gamm", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"energie", "+", "ma"}], ")"}], "/", "ma"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"beta2", "=", 
         RowBox[{"1", "-", 
          RowBox[{"1", "/", 
           RowBox[{"gamm", "^", "2"}]}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"delta4", "=", 
         RowBox[{"sw", "*", "0.85653", "*", 
          RowBox[{
           RowBox[{"(", 
            FractionBox["dichte", "1.395"], ")"}], "/", "beta2"}], " ", "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Log", "[", 
             RowBox[{"12937", "*", "beta2", "*", 
              RowBox[{"gamm", "^", "2"}]}], "]"}], "-", "beta2"}], ")"}]}]}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"energie", "=", 
         RowBox[{"energie", "-", "delta4"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"enlist", "=", 
         RowBox[{"Append", "[", 
          RowBox[{"enlist", ",", 
           RowBox[{"{", 
            RowBox[{"schritte", ",", "energie"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"deltalist", "=", 
         RowBox[{"Append", "[", 
          RowBox[{"deltalist", ",", 
           RowBox[{"{", 
            RowBox[{"schritte", ",", "delta4"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"schritte", "=", 
         RowBox[{"schritte", "+", "1"}]}], ";"}], "\[IndentingNewLine]", 
       ")"}]}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"tiefe", "=", 
     RowBox[{"schritte", "*", "sw", "*", "0.01"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"enlist", ",", "deltalist", ",", "tiefe"}], "}"}]}], 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 CellChangeTimes->{{3.550761519390625*^9, 3.550761814359375*^9}, {
   3.550761891796875*^9, 3.550761892875*^9}, {3.550762202953125*^9, 
   3.550762210578125*^9}, {3.55076224075*^9, 3.5507622485*^9}, {
   3.550762542640625*^9, 3.550762604625*^9}, {3.55076316971875*^9, 
   3.550763201453125*^9}, {3.55076590821875*^9, 3.55076596528125*^9}, 
   3.550766011328125*^9, {3.550766329828125*^9, 3.5507663569375*^9}, {
   3.55076651365625*^9, 3.55076651403125*^9}, {3.55076838840625*^9, 
   3.550768422671875*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"braggstand", "=", 
  RowBox[{"bragg", "[", "]"}]}]], "Input",
 CellChangeTimes->{{3.5507617860625*^9, 3.5507617878125*^9}, {
  3.55076181925*^9, 3.550761823671875*^9}, {3.55076260815625*^9, 
  3.550762615328125*^9}, {3.5507626758125*^9, 3.550762676390625*^9}}],

Cell[BoxData[
 InterpretationBox[
  TagBox[
   PanelBox[GridBox[{
      {
       StyleBox[
        StyleBox[
         DynamicBox[ToBoxes[
           FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"], 
           StandardForm],
          ImageSizeCache->{410., {3., 13.}}],
         StripOnInput->False,
         DynamicUpdating->True], "Panel",
        StripOnInput->False,
        Background->None]},
      {
       ItemBox[
        TagBox[
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "5.4849392206989815`"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "5.48387829297756`"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"2", ",", "5.482817216768402`"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"3", ",", "5.481755992004124`"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"4", ",", "5.48069461861729`"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"5", ",", "5.479633096540411`"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"6", ",", "5.4785714257059475`"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"7", ",", "5.477509606046309`"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"8", ",", "5.476447637493849`"}], "}"}], ",", 
             RowBox[{"\[LeftSkeleton]", "3137", "\[RightSkeleton]"}], ",", 
             RowBox[{"{", 
              RowBox[{"3146", ",", "0.15383288981230797`"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"3147", ",", "0.15315230054238976`"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"3148", ",", "0.15251490285691888`"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"3149", ",", "0.1519184926800459`"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"3150", ",", "0.1513609119735035`"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"3151", ",", "0.15084005648046642`"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"3152", ",", "0.15035388226413912`"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"3153", ",", "0.14990041108731822`"}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{"\[LeftSkeleton]", "1", "\[RightSkeleton]"}], "}"}], ",", 
           "0.00003154`"}], "}"}],
         Short[#, 5]& ],
        Background->GrayLevel[1],
        BaseStyle->{Deployed -> False},
        Frame->True,
        FrameStyle->GrayLevel[0, 0.2],
        StripOnInput->False]},
      {
       RowBox[{
        ButtonBox[
         StyleBox[
          StyleBox[
           DynamicBox[ToBoxes[
             FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
             StandardForm],
            ImageSizeCache->{74., {1., 13.}}],
           StripOnInput->False,
           DynamicUpdating->True], "Panel",
          StripOnInput->False,
          Background->None],
         Appearance->Automatic,
         ButtonFunction:>OutputSizeLimit`ButtonFunction[
          Identity, 1476, 23269722583375025884, 5/2],
         Enabled->True,
         Evaluator->Automatic,
         Method->"Queued"], "\[ThinSpace]", 
        ButtonBox[
         StyleBox[
          StyleBox[
           DynamicBox[ToBoxes[
             FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
             StandardForm],
            ImageSizeCache->{79., {1., 13.}}],
           StripOnInput->False,
           DynamicUpdating->True], "Panel",
          StripOnInput->False,
          Background->None],
         Appearance->Automatic,
         ButtonFunction:>OutputSizeLimit`ButtonFunction[
          Identity, 1476, 23269722583375025884, 5 2],
         Enabled->True,
         Evaluator->Automatic,
         Method->"Queued"], "\[ThinSpace]", 
        ButtonBox[
         StyleBox[
          StyleBox[
           DynamicBox[ToBoxes[
             FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
             StandardForm],
            ImageSizeCache->{123., {3., 13.}}],
           StripOnInput->False,
           DynamicUpdating->True], "Panel",
          StripOnInput->False,
          Background->None],
         Appearance->Automatic,
         ButtonFunction:>OutputSizeLimit`ButtonFunction[
          Identity, 1476, 23269722583375025884, Infinity],
         Enabled->True,
         Evaluator->Automatic,
         Method->"Queued"], "\[ThinSpace]", 
        ButtonBox[
         StyleBox[
          StyleBox[
           DynamicBox[ToBoxes[
             FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
             StandardForm],
            ImageSizeCache->{110., {1., 12.}}],
           StripOnInput->False,
           DynamicUpdating->True], "Panel",
          StripOnInput->False,
          Background->None],
         Appearance->Automatic,
         ButtonFunction:>FrontEndExecute[{
            FrontEnd`SetOptions[
            FrontEnd`$FrontEnd, 
             FrontEnd`PreferencesSettings -> {"Page" -> "Evaluation"}], 
            FrontEnd`FrontEndToken["PreferencesDialog"]}],
         Evaluator->None,
         Method->"Preemptive"]}]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxDividers->{
      "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
       "RowsIndexed" -> {}},
     GridBoxItemSize->{
      "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[1.2]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    DefaultBaseStyle->{},
    FrameMargins->5],
   Deploy,
   DefaultBaseStyle->{Deployed -> True}],
  Out[1476]]], "Output",
 CellChangeTimes->{
  3.55076254684375*^9, {3.55076259684375*^9, 3.55076261590625*^9}, {
   3.550762671109375*^9, 3.550762677125*^9}, 3.550763205953125*^9}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.550762424828125*^9, 3.550762425515625*^9}, {
  3.550762597421875*^9, 3.550762598890625*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"braggstand", "[", 
  RowBox[{"[", "3", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.550762618453125*^9, 3.55076262559375*^9}}],

Cell[BoxData["0.00003154`"], "Output",
 CellChangeTimes->{{3.550762622265625*^9, 3.550762626359375*^9}, 
   3.55076267825*^9, 3.550765967953125*^9, 3.550766019890625*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"bragg1", "=", 
  RowBox[{"ListLinePlot", "[", 
   RowBox[{
    RowBox[{"braggstand", "[", 
     RowBox[{"[", "1", "]"}], "]"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"TextStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"FontSize", "\[Rule]", "15"}], "}"}]}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Eindringtiefe\\n \!\(\*SuperscriptBox[\(10\), \(-8\)]\)m\>\"", 
       ",", "\"\<Energie\\nMeV\>\""}], "}"}]}], ",", 
    RowBox[{"AxesStyle", "\[Rule]", 
     RowBox[{"Arrowheads", "[", "0.03", "]"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.550764148390625*^9, 3.550764150890625*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw0l3lYjevbhovMRQhFEUIIUSmEK0qp0EgSQnPRrHme5zW2VoMUUQiZQxGK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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox[
    "\"Eindringtiefe\\n \\!\\(\\*SuperscriptBox[\\(10\\), \\(-8\\)]\\)m\"", 
     TraditionalForm], 
    FormBox["\"Energie\\nMeV\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  AxesStyle->Arrowheads[0.03],
  BaseStyle->{FontSize -> 15},
  ImageSize->600,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.550764151328125*^9, 3.5507659698125*^9, 
  3.550766020890625*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<bragg_energie.pdf\>\"", ",", "bragg1"}], "]"}]], "Input",
 CellChangeTimes->{{3.55076268103125*^9, 3.55076271046875*^9}, {
   3.550762741953125*^9, 3.550762787*^9}, {3.55076342396875*^9, 
   3.550763534421875*^9}, 3.550763566265625*^9, {3.550763620171875*^9, 
   3.550763621828125*^9}, {3.550764116609375*^9, 3.550764155078125*^9}}],

Cell[BoxData["\<\"bragg_energie.pdf\"\>"], "Output",
 CellChangeTimes->{{3.550762693078125*^9, 3.5507627004375*^9}, {
   3.55076275475*^9, 3.55076278728125*^9}, 3.550763515453125*^9, 
   3.550763567796875*^9, 3.55076368528125*^9, {3.550764136328125*^9, 
   3.5507641558125*^9}, 3.550765972703125*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"bragg2", "=", 
  RowBox[{"ListLinePlot", "[", 
   RowBox[{
    RowBox[{"braggstand", "[", 
     RowBox[{"[", "2", "]"}], "]"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"TextStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"FontSize", "\[Rule]", "15"}], "}"}]}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Eindringtiefe\\n \!\(\*SuperscriptBox[\(10\), \(-8\)]\)m\>\"", 
       ",", "\"\<Bremsverm\[ODoubleDot]gen\\n\!\(\*FractionBox[\(MeV\), \(\
\[Mu]m\)]\)\>\""}], "}"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.550763697234375*^9, 3.55076370934375*^9}, {
  3.55076375434375*^9, 3.55076385934375*^9}, {3.550763937953125*^9, 
  3.550763946203125*^9}, {3.550763988984375*^9, 3.5507640844375*^9}, {
  3.550764158375*^9, 3.55076417034375*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw8mHlUTuv/vzvGEEoZMmYOEcqU4kWGVJIGklKSJqmkudTTPNczjyFzUmQs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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox[
    "\"Eindringtiefe\\n \\!\\(\\*SuperscriptBox[\\(10\\), \\(-8\\)]\\)m\"", 
     TraditionalForm], 
    FormBox[
    "\"Bremsverm\[ODoubleDot]gen\\n\\!\\(\\*FractionBox[\\(MeV\\), \
\\(\[Mu]m\\)]\\)\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  BaseStyle->{FontSize -> 15},
  ImageSize->600,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.550764170890625*^9, 3.5507659749375*^9, 3.550766023*^9}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.55076385640625*^9, 3.55076385825*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<bragg_delta.pdf\>\"", ",", "bragg2"}], "]"}]], "Input",
 CellChangeTimes->{{3.55076417784375*^9, 3.5507641841875*^9}}],

Cell[BoxData["\<\"bragg_delta.pdf\"\>"], "Output",
 CellChangeTimes->{3.5507659768125*^9, 3.5507660245625*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"alubragg", "=", 
  RowBox[{
   RowBox[{"bragg", "[", 
    RowBox[{"4.344", ",", "2.7"}], "]"}], "[", 
   RowBox[{"[", "3", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.550764364453125*^9, 3.550764418125*^9}, {
  3.55076487546875*^9, 3.55076491740625*^9}, {3.550764963890625*^9, 
  3.55076496915625*^9}, {3.550765081609375*^9, 3.55076509784375*^9}, {
  3.550765313671875*^9, 3.550765341125*^9}, {3.55076544965625*^9, 
  3.550765455375*^9}, {3.550765650421875*^9, 3.550765652078125*^9}, {
  3.550766604078125*^9, 3.550766605796875*^9}, {3.550766702296875*^9, 
  3.55076674259375*^9}, {3.550768432421875*^9, 3.5507684416875*^9}}],

Cell[BoxData["5.15`*^-6"], "Output",
 CellChangeTimes->{
  3.550765652421875*^9, 3.55076597778125*^9, 3.550766024921875*^9, 
   3.5507664154375*^9, 3.55076652003125*^9, 3.550766606734375*^9, {
   3.550766724828125*^9, 3.55076674321875*^9}, {3.550768433859375*^9, 
   3.550768442*^9}}]
}, Open  ]],

Cell[BoxData["5.31`*^-6"], "Input"],

Cell[BoxData["5.15`*^-6"], "Input"],

Cell[BoxData["5.`*^-6"], "Input"]
},
WindowSize->{927, 913},
WindowMargins->{{6, Automatic}, {Automatic, -40}},
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 164, 3, 31, "Input"],
Cell[724, 25, 328, 7, 52, "Input"],
Cell[1055, 34, 3795, 108, 412, "Input"],
Cell[4853, 144, 604, 12, 31, "Input"],
Cell[5460, 158, 4172, 101, 272, "Input"],
Cell[CellGroupData[{
Cell[9657, 263, 5263, 146, 412, "Input"],
Cell[14923, 411, 1320, 21, 30, "Output"],
Cell[16246, 434, 1322, 21, 30, "Output"],
Cell[17571, 457, 1319, 21, 30, "Output"],
Cell[18893, 480, 1317, 21, 30, "Output"],
Cell[20213, 503, 1321, 21, 30, "Output"],
Cell[21537, 526, 1320, 21, 30, "Output"],
Cell[22860, 549, 1322, 21, 30, "Output"],
Cell[24185, 572, 1320, 21, 30, "Output"],
Cell[25508, 595, 1319, 21, 30, "Output"],
Cell[26830, 618, 1322, 21, 30, "Output"],
Cell[28155, 641, 1319, 21, 30, "Output"],
Cell[29477, 664, 1320, 21, 30, "Output"],
Cell[30800, 687, 1315, 21, 30, "Output"],
Cell[32118, 710, 1316, 21, 30, "Output"],
Cell[33437, 733, 1323, 21, 30, "Output"],
Cell[34763, 756, 1323, 21, 30, "Output"],
Cell[36089, 779, 1327, 21, 30, "Output"],
Cell[37419, 802, 1326, 21, 30, "Output"]
}, Open  ]],
Cell[38760, 826, 6747, 152, 252, "Input"],
Cell[CellGroupData[{
Cell[45532, 982, 3694, 82, 292, "Input"],
Cell[49229, 1066, 14517, 254, 392, "Output"],
Cell[63749, 1322, 13598, 239, 392, "Output"],
Cell[77350, 1563, 15252, 266, 391, "Output"],
Cell[92605, 1831, 14504, 255, 392, "Output"],
Cell[107112, 2088, 15492, 271, 391, "Output"],
Cell[122607, 2361, 15672, 272, 391, "Output"],
Cell[138282, 2635, 15719, 275, 391, "Output"],
Cell[154004, 2912, 15835, 276, 391, "Output"],
Cell[169842, 3190, 13924, 244, 392, "Output"],
Cell[183769, 3436, 15483, 270, 392, "Output"],
Cell[199255, 3708, 15197, 264, 391, "Output"],
Cell[214455, 3974, 14266, 250, 391, "Output"],
Cell[228724, 4226, 15297, 269, 391, "Output"],
Cell[244024, 4497, 15405, 268, 391, "Output"],
Cell[259432, 4767, 25910, 444, 391, 15273, 267, "CachedBoxData", "BoxData", \
"Output"],
Cell[285345, 5213, 15568, 272, 391, "Output"],
Cell[300916, 5487, 13656, 240, 392, "Output"],
Cell[314575, 5729, 15205, 265, 392, "Output"]
}, Open  ]],
Cell[329795, 5997, 397, 10, 31, "Input"],
Cell[330195, 6009, 29855, 520, 393, "Input"],
Cell[CellGroupData[{
Cell[360075, 6533, 4421, 126, 305, "Input"],
Cell[364499, 6661, 430, 7, 30, "Output"],
Cell[364932, 6670, 349, 5, 30, "Output"],
Cell[365284, 6677, 334, 5, 30, "Output"],
Cell[365621, 6684, 334, 5, 30, "Output"],
Cell[365958, 6691, 349, 5, 30, "Output"],
Cell[366310, 6698, 350, 5, 30, "Output"],
Cell[366663, 6705, 350, 5, 30, "Output"],
Cell[367016, 6712, 333, 5, 30, "Output"],
Cell[367352, 6719, 333, 5, 30, "Output"],
Cell[367688, 6726, 348, 5, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[368073, 6736, 3540, 88, 206, "Input"],
Cell[371616, 6826, 4723, 113, 409, "Output"],
Cell[376342, 6941, 315, 5, 30, "Output"]
}, Open  ]],
Cell[376672, 6949, 1079, 28, 72, "Input"],
Cell[CellGroupData[{
Cell[377776, 6981, 101976, 1737, 425, "Input"],
Cell[479755, 8720, 120, 1, 30, "Output"]
}, Open  ]],
Cell[479890, 8724, 1105, 29, 72, "Input"],
Cell[CellGroupData[{
Cell[481020, 8757, 130077, 2198, 425, "Input"],
Cell[611100, 10957, 119, 1, 30, "Output"]
}, Open  ]],
Cell[611234, 10961, 1733, 45, 72, "Input"],
Cell[CellGroupData[{
Cell[612992, 11010, 370, 10, 31, "Input"],
Cell[613365, 11022, 315, 9, 30, "Output"]
}, Open  ]],
Cell[613695, 11034, 2179, 63, 92, "Input"],
Cell[CellGroupData[{
Cell[615899, 11101, 238, 4, 52, "Input"],
Cell[616140, 11107, 499, 13, 124, "Output"]
}, Open  ]],
Cell[616654, 11123, 351, 11, 39, "Input"],
Cell[617008, 11136, 825, 23, 52, "Input"],
Cell[CellGroupData[{
Cell[617858, 11163, 1388, 38, 72, "Input"],
Cell[619249, 11203, 230, 6, 92, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[619516, 11214, 663, 15, 31, "Input"],
Cell[620182, 11231, 427, 10, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[620646, 11246, 193, 5, 31, "Input"],
Cell[620842, 11253, 188, 4, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[621067, 11262, 237, 6, 31, "Input"],
Cell[621307, 11270, 194, 4, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[621538, 11279, 290, 7, 31, "Input"],
Cell[621831, 11288, 242, 4, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[622110, 11297, 570, 13, 47, "Input"],
Cell[622683, 11312, 218, 4, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[622938, 11321, 1654, 46, 92, "Input"],
Cell[624595, 11369, 1250, 26, 188, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[625882, 11400, 592, 19, 31, "Input"],
Cell[626477, 11421, 237, 5, 33, "Output"]
}, Open  ]],
Cell[626729, 11429, 91, 1, 31, "Input"],
Cell[CellGroupData[{
Cell[626845, 11434, 377, 12, 31, "Input"],
Cell[627225, 11448, 234, 7, 30, "Output"]
}, Open  ]],
Cell[627474, 11458, 3307, 79, 399, "Input"],
Cell[CellGroupData[{
Cell[630806, 11541, 284, 5, 31, "Input"],
Cell[631093, 11548, 6185, 163, 162, "Output"]
}, Open  ]],
Cell[637293, 11714, 141, 2, 31, InheritFromParent],
Cell[CellGroupData[{
Cell[637459, 11720, 151, 3, 31, "Input"],
Cell[637613, 11725, 170, 2, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[637820, 11732, 748, 18, 55, "Input"],
Cell[638571, 11752, 41454, 688, 385, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[680062, 12445, 386, 6, 31, "Input"],
Cell[680451, 12453, 300, 4, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[680788, 12462, 897, 20, 76, "Input"],
Cell[681688, 12484, 41196, 684, 391, "Output"]
}, Open  ]],
Cell[722899, 13171, 87, 1, 31, "Input"],
Cell[CellGroupData[{
Cell[723011, 13176, 172, 3, 31, "Input"],
Cell[723186, 13181, 110, 1, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[723333, 13187, 653, 12, 31, "Input"],
Cell[723989, 13201, 284, 5, 30, "Output"]
}, Open  ]],
Cell[724288, 13209, 35, 0, 31, "Input"],
Cell[724326, 13211, 35, 0, 31, "Input"],
Cell[724364, 13213, 33, 0, 31, "Input"]
}
]
*)

(* End of internal cache information *)
