﻿program Fachbuecher;
Type verlagstyp = Record
 Verlagsname:String;
 Verlagsort:String;end; {Typ-Verbund Verlagsname und ort}
Fachbuch = Record
 Autor:Array[1..10] of String; {maximal 10 Autoren}
 Titel:String;
 Erschienen:Integer;
 Verlag:verlagstyp;
 Klasse:(Informatik, Mathematik, Physik, Geographie, Didaktik); {5 Klassen zur Auswahl}
 Seiten:Integer;
 Gewicht:Integer;
 Hoehe:Integer;
 Breite:Integer;
 Kommentar:String;
 Benutzt:Integer;
 Schwerpunkte:String;
 Taschenbuch:Boolean; {Einige Eigenschaften der Bücher, die ausgegeben werden}
end;
var Buecher:Array[1..1000]of Fachbuch;Buchanzahl:Integer=0;
procedure rein; {Voreingegebene Beispielbücher}
 begin
 Buecher[1].Titel:='Taschenbuch der Mathematik'; {Eigenschaften von 2 Beispielbüchern} 
 Buecher[1].Autor[1]:='Bronstein';               {werden Beispielwerte zugeordnet}
 Buecher[1].Autor[2]:='Semendjajew';
 Buecher[1].Autor[3]:='Musiol';
 Buecher[1].Autor[4]:='Muehling';
 Buecher[1].Erschienen:=2008;
 Buecher[1].Verlag.Verlagsname:='Verlag Harri Deutsch';
 Buecher[1].Verlag.Verlagsort:='Graefstraße 47, Frankfurt am Main';
 Buecher[1].Klasse:=Mathematik;
 Buecher[1].Seiten:=1221;
 Buecher[1].Gewicht:=2500;
 Buecher[1].Hoehe:=20;
 Buecher[1].Breite:=15;
 Buecher[1].Benutzt:=23;
 Buecher[1].Kommentar:='Formelsammlung Mathe/Physik';
 Buecher[1].Schwerpunkte:='Themenerklärungen, Formeldetails';
 Buecher[1].Taschenbuch:=True;

 Buecher[2].Titel:='Formelsammlung bis zum Abitur';
 Buecher[2].Autor[1]:='Becker';
 Buecher[2].Autor[2]:='Bossek';
 Buecher[2].Autor[3]:='Engelmann';
 Buecher[2].Autor[4]:='Ernst';
 Buecher[2].Autor[5]:='Liesenberg';
 Buecher[2].Autor[6]:='Meyer';
 Buecher[2].Autor[7]:='Pews-Hocke';
 Buecher[2].Autor[8]:='Seidel';
 Buecher[2].Autor[9]:='Simon';
 Buecher[2].Autor[10]:='Wheser';
 Buecher[2].Erschienen:=2009;
 Buecher[2].Verlag.Verlagsname:='Duden Paetec';
 Buecher[2].Verlag.Verlagsort:='Berlin';
 Buecher[2].Klasse:=Physik;
 Buecher[2].Seiten:=167;
 Buecher[2].Gewicht:=700;
 Buecher[2].Hoehe:=25;
 Buecher[2].Breite:=17;
 Buecher[2].Benutzt:=105;
 Buecher[2].Kommentar:='Formelsammlung Mathe/Physik/Biologie/Chemie/Astronomie/Informatik';
 Buecher[2].Schwerpunkte:='Formelueberblick, Datensammlung';
 Buecher[2].Taschenbuch:=False;

 Buchanzahl:=2; {Anzahl der von den 1000 möglichen Speicherstellen belegten}
 end;
function autoraus(index:Integer):String; {gibt Autoren schön formatiert aus}
 var i:Integer;ausgabe:String;
 begin
 ausgabe:= Buecher[index].autor[1]; {erster Autor (auch leer) immer vorhanden, da kein Trennzeichen}
 for i:=2 to 10 do
  begin
   if not(Buecher[index].autor[i]='') then ausgabe := ausgabe + ', ' + Buecher[index].autor[i] {Autoren mit Komma trennen}
  end;
 autoraus:=ausgabe
 end;
procedure raus; {zeigt dem Benutzer die Bücher auf der Oberfläche}
 var i:Integer;
 begin
 for i:=1 to Buchanzahl do
  begin
  writeln(); {freizeile am Anfang}
  writeln('Titel:        ',Buecher[i].Titel); {Titel: Wert mit Werten passend eingezogen}
  if Buecher[i].Autor[2]='' then write('Autor:        ') else write('Autoren:      ');
  writeln(autoraus(i)); {bei einem Autor, Autor; bei mehreren, Autoren}
  writeln('Verlag:       ',Buecher[i].verlag.Verlagsname);
  writeln('Verlagsort:   ',Buecher[i].verlag.Verlagsort);
  writeln('Erschienen:   ',Buecher[i].Erschienen);
  writeln('Seitenanzahl: ',Buecher[i].Seiten);
  writeln('Gewicht:      ',Buecher[i].Gewicht,'g');
  writeln('Hoehe:        ',Buecher[i].Hoehe,'cm');
  writeln('Breite:       ',Buecher[i].Breite,'cm');
  writeln('Benutzungen:  ',Buecher[i].Benutzt,' mal');
  writeln('Kommentar:    ',Buecher[i].Kommentar);
  writeln('Schwerpunkte: ',Buecher[i].Schwerpunkte);
  if Buecher[i].Taschenbuch then writeln('Taschenbuch:  Ja') else writeln('Taschenbuch:  Nein') ;
  write('Klasse:       ');
  case Buecher[i].Klasse of {Übersetzung, Bezeichner->String}
   Mathematik: writeln('Mathematik');
   Physik: writeln('Physik');
   Geographie: writeln('Geographie');
   Didaktik: writeln('Didaktik');
   Informatik: writeln('Informatik')
  end;
  writeln;
  if i < Buchanzahl then writeln('###-------*****-------###'); {auffälliges Trennzeichen zwischen Büchern}
  writeln
  end;
 end;
begin
writeln('Hier sehen Sie eine Liste meiner Fachbuecher!'); {Begrüßung}
rein;
raus;
writeln('Druecken Sie Enter zum Beenden!'); {Abschied}
readln
end.

